/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.analyser.checkers;

import com.intellij.charts.analyser.checkers.SeriesChecker;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.PieSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/charts/analyser/checkers/PieSeriesChecker;", "Lcom/intellij/charts/analyser/checkers/SeriesChecker;", "<init>", "()V", "check", "", "Lcom/intellij/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "Companion", "intellij.charts"})
public final class PieSeriesChecker
implements SeriesChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<SeriesSettings> check(@NotNull DataFrame dataFrame) {
        List list;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (dataFrame.getRowsCount() > 20) {
            return CollectionsKt.emptyList();
        }
        List<Column<Number>> numericalColumns = SeriesChecker.Companion.getNumericalColumns(dataFrame);
        if (numericalColumns.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ColumnId columnId = dataFrame.getColumnId((Column)CollectionsKt.first(numericalColumns));
        if (columnId == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId columnId2 = columnId;
        Column<?> otherColumn = Companion.getAnyColumnExceptOf(dataFrame, columnId2);
        if (otherColumn != null && !otherColumn.isNumerical() && !otherColumn.getType().isArray()) {
            List list2 = CollectionsKt.listOf((Object)new ColumnSettings(columnId2, ColumnModifier.Mean));
            ColumnId columnId3 = dataFrame.getColumnId(otherColumn);
            Intrinsics.checkNotNull((Object)columnId3);
            list = CollectionsKt.listOf((Object)new PieSeriesSettings(list2, null, CollectionsKt.listOf((Object)new ColumnSettings(columnId3, ColumnModifier.GroupAndSort)), true, false, 18, null));
        } else {
            list = CollectionsKt.listOf((Object)new PieSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(columnId2, null, 2, null)), null, null, false, false, 30, null));
        }
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/charts/analyser/checkers/PieSeriesChecker$Companion;", "", "<init>", "()V", "getAnyColumnExceptOf", "Lcom/intellij/charts/dataframe/columns/Column;", "Lcom/intellij/charts/dataframe/DataFrame;", "exception", "Lcom/intellij/charts/dataframe/columns/ColumnId;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Column<?> getAnyColumnExceptOf(@NotNull DataFrame $this$getAnyColumnExceptOf, @NotNull ColumnId exception) {
            Intrinsics.checkNotNullParameter((Object)$this$getAnyColumnExceptOf, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            int n = $this$getAnyColumnExceptOf.getColumnsCount();
            for (int i = 0; i < n; ++i) {
                if (i == exception.getIndex()) continue;
                return $this$getAnyColumnExceptOf.get(i);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

