/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.core;

import com.intellij.charts.analyser.SeriesSuggester;
import com.intellij.charts.core.ChartPageKt;
import com.intellij.charts.core.ChartPlotPanel;
import com.intellij.charts.core.axes.settings.AxesSettings;
import com.intellij.charts.core.settings.ChartSettings;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.settings.SeriesSettingsPanel;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.statistics.ChartsUsagesCollector;
import com.intellij.charts.style.ChartConfig;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.BeanProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.awt.plot.component.PlotComponentProvider;
import org.jetbrains.letsPlot.batik.plot.component.DefaultPlotComponentProviderBatik;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.intern.layer.geom.PieAesthetics;
import org.jetbrains.letsPlot.themes.ThemeKt;
import org.jetbrains.letsPlot.themes.ThemeSetKt;
import org.jetbrains.letsPlot.themes.theme;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 H2\u00020\u0001:\u0002GHB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u0003H\u0002J\b\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u00020\u00142\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u000202H\u0007J\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\"J\u000e\u00108\u001a\u00020$2\u0006\u00107\u001a\u00020\"J\b\u00109\u001a\u00020$H\u0002J\u000e\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020>0)H\u0016J\u0006\u0010?\u001a\u00020\u0003J\u0018\u0010@\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010A\u001a\u00020\u000fJ\b\u0010B\u001a\u00020CH\u0014J\b\u0010D\u001a\u00020EH\u0002J\u000e\u0010F\u001a\u00020$2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/charts/core/ChartPage;", "Lcom/intellij/openapi/Disposable;", "chartSettings", "Lcom/intellij/charts/core/settings/ChartSettings;", "mode", "Lcom/intellij/charts/settings/SeriesSettingsPanel$Mode;", "<init>", "(Lcom/intellij/charts/core/settings/ChartSettings;Lcom/intellij/charts/settings/SeriesSettingsPanel$Mode;)V", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getDataFrame", "()Lcom/intellij/charts/dataframe/DataFrame;", "setDataFrame", "(Lcom/intellij/charts/dataframe/DataFrame;)V", "isEmpty", "", "()Z", "settingsShown", "getSettingsShown", "plot", "Lcom/intellij/charts/core/ChartPlotPanel;", "getPlot", "()Lcom/intellij/charts/core/ChartPlotPanel;", "setPlot", "(Lcom/intellij/charts/core/ChartPlotPanel;)V", "isPlotInitialized", "chartSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "listeners", "", "Ljavax/swing/event/ChangeListener;", "showSeriesSettings", "", "recreate", "verticalSplit", "(ZLjava/lang/Boolean;)V", "createSettings", "", "Lorg/jetbrains/letsPlot/intern/Feature;", "settings", "dispose", "createLetsPlotTheme", "Lorg/jetbrains/letsPlot/themes/theme;", "createPlot", "processedSpec", "", "", "", "addToolbar", "alignment", "addChangeListener", "listener", "removeChangeListener", "fireChangeEvent", "saveAsImage", "project", "Lcom/intellij/openapi/project/Project;", "createActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "getSettings", "applySettings", "checkModified", "createSeriesSettingsPanel", "Lcom/intellij/charts/settings/SeriesSettingsPanel;", "createEmptyPage", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "assignDataFrame", "ChartPlotComponentProviderBatik", "Companion", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nChartPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPage.kt\ncom/intellij/charts/core/ChartPage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1869#2,2:350\n1869#2,2:352\n1869#2,2:354\n1563#2:357\n1634#2,3:358\n1#3:356\n*S KotlinDebug\n*F\n+ 1 ChartPage.kt\ncom/intellij/charts/core/ChartPage\n*L\n117#1:350,2\n230#1:352,2\n256#1:354,2\n299#1:357\n299#1:358,3\n*E\n"})
public class ChartPage
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ChartSettings chartSettings;
    @NotNull
    private final SeriesSettingsPanel.Mode mode;
    protected DataFrame dataFrame;
    protected ChartPlotPanel plot;
    @NotNull
    private final OnePixelSplitter chartSplitter;
    @NotNull
    private final JPanel component;
    @NotNull
    private final List<ChangeListener> listeners;
    @NotNull
    private static final Function1<Function0<Unit>, Unit> IDEA_EDT_EXECUTOR = ChartPage::IDEA_EDT_EXECUTOR$lambda$0;

    /*
     * WARNING - void declaration
     */
    public ChartPage(@NotNull ChartSettings chartSettings, @NotNull SeriesSettingsPanel.Mode mode) {
        void $this$component_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)chartSettings, (String)"chartSettings");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.chartSettings = chartSettings;
        this.mode = mode;
        this.chartSplitter = new OnePixelSplitter(false, 0.75f);
        BorderLayout borderLayout = new BorderLayout();
        BorderLayout borderLayout2 = borderLayout = new UiDataProvider(this, borderLayout){
            final /* synthetic */ ChartPage this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void updateUI() {
                super.updateUI();
                this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                sink.set(ChartPageKt.getCHART_PAGE_DATA_KEY(), (Object)this.this$0);
            }
        };
        ChartPage chartPage = this;
        boolean bl = false;
        $this$component_u24lambda_u240.add((Component)this.chartSplitter, "Center");
        chartPage.component = (JPanel)((Object)borderLayout);
        this.listeners = new ArrayList();
    }

    public /* synthetic */ ChartPage(ChartSettings chartSettings, SeriesSettingsPanel.Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chartSettings = new ChartSettings(new AxesSettings(false, false, 3, null), CollectionsKt.emptyList());
        }
        this(chartSettings, mode);
    }

    @NotNull
    protected final DataFrame getDataFrame() {
        DataFrame dataFrame = this.dataFrame;
        if (dataFrame != null) {
            return dataFrame;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dataFrame");
        return null;
    }

    protected final void setDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"<set-?>");
        this.dataFrame = dataFrame;
    }

    public final boolean isEmpty() {
        return this.chartSettings.getSeriesSettings().isEmpty() || this.chartSplitter.getFirstComponent() instanceof JBPanelWithEmptyText;
    }

    public final boolean getSettingsShown() {
        return this.chartSplitter.getSecondComponent() != null;
    }

    @NotNull
    protected final ChartPlotPanel getPlot() {
        ChartPlotPanel chartPlotPanel = this.plot;
        if (chartPlotPanel != null) {
            return chartPlotPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"plot");
        return null;
    }

    protected final void setPlot(@NotNull ChartPlotPanel chartPlotPanel) {
        Intrinsics.checkNotNullParameter((Object)chartPlotPanel, (String)"<set-?>");
        this.plot = chartPlotPanel;
    }

    private final boolean isPlotInitialized() {
        return this.plot != null;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    public final void showSeriesSettings(boolean recreate, @Nullable Boolean verticalSplit) {
        if (this.chartSplitter.getSecondComponent() != null) {
            JComponent jComponent = this.chartSplitter.getSecondComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.charts.settings.SeriesSettingsPanel");
            SeriesSettingsPanel seriesSettingsPanel = (SeriesSettingsPanel)jComponent;
            Disposer.dispose((Disposable)seriesSettingsPanel);
            this.chartSplitter.setSecondComponent(null);
            if (!recreate) {
                return;
            }
        }
        SeriesSettingsPanel panelMain = this.createSeriesSettingsPanel();
        panelMain.setOnChange((Function0<Unit>)((Function0)() -> ChartPage.showSeriesSettings$lambda$0(this, panelMain)));
        Disposer.register((Disposable)this, (Disposable)panelMain);
        if (verticalSplit != null) {
            this.chartSplitter.setOrientation(verticalSplit.booleanValue());
        }
        this.chartSplitter.setSecondComponent((JComponent)panelMain);
    }

    public static /* synthetic */ void showSeriesSettings$default(ChartPage chartPage, boolean bl, Boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showSeriesSettings");
        }
        if ((n & 2) != 0) {
            bl2 = null;
        }
        chartPage.showSeriesSettings(bl, bl2);
    }

    private final List<Feature> createSettings(ChartSettings settings) {
        List result = new ArrayList();
        Iterable $this$forEach$iv = settings.getSeriesSettings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SeriesSettings it = (SeriesSettings)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)result, (Iterable)it.getLetsPlotLayer(this.getDataFrame(), result.size()));
        }
        return result;
    }

    public void dispose() {
        if (this.isPlotInitialized()) {
            this.getPlot().dispose();
        }
    }

    private final theme createLetsPlotTheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme editorGlobalScheme = editorColorsScheme;
        ChartConfig settings = ChartsConfig.Companion.getInstance().getSettings();
        Map map = ThemeKt.elementRect$default((Object)editorGlobalScheme.getDefaultBackground(), null, null, null, (boolean)false, (int)30, null);
        Map map2 = ThemeKt.elementText$default((Object)settings.getAxesFont().getColor().getColor(), null, null, null, null, null, null, null, (boolean)false, (int)510, null);
        Map map3 = ThemeKt.elementRect$default((Object)editorGlobalScheme.getDefaultBackground(), null, null, null, (boolean)false, (int)30, null);
        Map map4 = ThemeKt.elementLine$default((Object)settings.getAxesColor().getColor(), null, null, (boolean)false, (int)14, null);
        int n = editorGlobalScheme.getEditorFontSize();
        Map map5 = ThemeKt.elementText$default((Object)settings.getAxesFont().getColor().getColor(), null, null, (Number)n, null, null, null, null, (boolean)false, (int)502, null);
        return new theme(null, null, null, null, null, null, null, null, null, null, null, null, (Object)map5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)map, (Object)map2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)map4, null, null, null, null, null, null, null, null, null, null, (Object)map3, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -402657281, -67141633, 0x3FFFFFF, null).legendPositionRight();
    }

    @NotNull
    public final ChartPlotPanel createPlot(@NotNull Map<String, Object> processedSpec) {
        Intrinsics.checkNotNullParameter(processedSpec, (String)"processedSpec");
        ChartPlotComponentProviderBatik chartPlotComponentProviderBatik = new ChartPlotComponentProviderBatik(processedSpec);
        return new ChartPlotPanel(this, chartPlotComponentProviderBatik){
            final /* synthetic */ ChartPage this$0;
            {
                this.this$0 = $receiver;
                super((PlotComponentProvider)$super_call_param$1);
            }

            public void updateUI() {
                boolean updateChart = this.ui != null;
                super.updateUI();
                if (updateChart && this.this$0.dataFrame != null) {
                    this.this$0.assignDataFrame(this.this$0.getDataFrame());
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(10, super.getPreferredSize().height);
            }
        };
    }

    @BeanProperty(visualUpdate=true, description="The alignment of the toolbar.", enumerationValues={"BorderLayout.EAST", "BorderLayout.WEST", "BorderLayout.NORTH", "BorderLayout.SOUTH"})
    public final void addToolbar(@NotNull String alignment) {
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        boolean horizontal = Intrinsics.areEqual((Object)alignment, (Object)"North") || Intrinsics.areEqual((Object)alignment, (Object)"South");
        ActionToolbar $this$addToolbar_u24lambda_u240 = actionToolbar = ActionManager.getInstance().createActionToolbar("BDTChartToolbar", (ActionGroup)new DefaultActionGroup(this.createActions()), horizontal);
        boolean bl = false;
        $this$addToolbar_u24lambda_u240.getComponent().setOpaque(false);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar chartToolbar = actionToolbar2;
        chartToolbar.setTargetComponent((JComponent)this.component);
        this.component.add((Component)chartToolbar.getComponent(), alignment);
    }

    public final void addChangeListener(@NotNull ChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.listeners).add(listener);
    }

    public final void removeChangeListener(@NotNull ChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.listeners).remove(listener);
    }

    private final void fireChangeEvent() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeListener it = (ChangeListener)element$iv;
            boolean bl = false;
            it.stateChanged(null);
        }
    }

    public final void saveAsImage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isPlotInitialized()) {
            Companion.saveAsImage(project, this.getPlot());
        }
    }

    @NotNull
    public List<AnAction> createActions() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("LetsPlot.Charts.Toolbar.Actions");
        Object actions = anAction instanceof DefaultActionGroup ? (Object)anAction : null;
        Object object = actions;
        if (object == null || (object = object.getChildren(actionManager)) == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final ChartSettings getSettings() {
        return this.chartSettings;
    }

    public final void applySettings(@NotNull ChartSettings settings, boolean checkModified) {
        Feature feature;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (checkModified && Intrinsics.areEqual((Object)settings, (Object)this.chartSettings)) {
            return;
        }
        this.chartSettings = settings;
        Plot data = null;
        data = GgplotKt.letsPlot$default(null, null, (int)3, null);
        boolean emptyTheme = false;
        Iterable $this$forEach$iv = this.createSettings(settings);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Feature it = (Feature)element$iv;
            boolean bl = false;
            if (it instanceof PieAesthetics) {
                emptyTheme = true;
            }
            data = data.plus(it);
        }
        if (data.getFeatures().isEmpty()) {
            this.chartSplitter.setFirstComponent((JComponent)this.createEmptyPage());
            ChartPage.showSeriesSettings$default(this, true, null, 2, null);
            return;
        }
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        Color editorBackground = color;
        if (emptyTheme) {
            Map $i$f$forEach2 = ThemeKt.elementText$default((Object)ChartsConfig.Companion.getInstance().getSettings().getAxesFont().getColor().getColor(), null, null, null, null, null, null, null, (boolean)false, (int)510, null);
            Map map = ThemeKt.elementRect$default((Object)editorBackground, null, null, null, (boolean)false, (int)30, null);
            Map map2 = ThemeKt.elementRect$default((Object)editorBackground, null, null, null, (boolean)false, (int)30, null);
            feature = ThemeSetKt.themeClassic().plus((Feature)new theme(null, null, null, null, null, (Object)"blank", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)map, (Object)$i$f$forEach2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)map2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -402653217, -67108865, 0x3FFFFFF, null));
        } else {
            feature = (Feature)this.createLetsPlotTheme();
        }
        data = data.plus(feature);
        Map processedSpec = MonolithicCommon.INSTANCE.processRawSpecs(ToSpecConvertersKt.toSpec((Plot)data), false);
        this.setPlot(this.createPlot(processedSpec));
        this.chartSplitter.setFirstComponent((JComponent)this.getPlot());
    }

    public static /* synthetic */ void applySettings$default(ChartPage chartPage, ChartSettings chartSettings, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applySettings");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        chartPage.applySettings(chartSettings, bl);
    }

    @NotNull
    protected SeriesSettingsPanel createSeriesSettingsPanel() {
        SeriesSettingsPanel seriesSettingsPanel;
        SeriesSettingsPanel $this$createSeriesSettingsPanel_u24lambda_u240 = seriesSettingsPanel = new SeriesSettingsPanel(this.getDataFrame(), this.getSettings(), this.mode);
        boolean bl = false;
        $this$createSeriesSettingsPanel_u24lambda_u240.init();
        return seriesSettingsPanel;
    }

    private final JBPanelWithEmptyText createEmptyPage() {
        JBPanelWithEmptyText jBPanelWithEmptyText;
        JBPanelWithEmptyText $this$createEmptyPage_u24lambda_u240 = jBPanelWithEmptyText = new JBPanelWithEmptyText();
        boolean bl = false;
        $this$createEmptyPage_u24lambda_u240.setOpaque(false);
        $this$createEmptyPage_u24lambda_u240.getEmptyText().appendText(ChartMessagesBundle.message("series.empty", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
        $this$createEmptyPage_u24lambda_u240.getEmptyText().appendSecondaryText(ChartMessagesBundle.message("series.open.settings", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> ChartPage.createEmptyPage$lambda$0$0(this, arg_0));
        return jBPanelWithEmptyText;
    }

    /*
     * WARNING - void declaration
     */
    public final void assignDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.setDataFrame(dataFrame);
        ChartSettings currentSettings = this.getSettings();
        if (!currentSettings.isSeriesSettingsEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = currentSettings.getSeriesSettings();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SeriesSettings seriesSettings = (SeriesSettings)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.filterByNewDataFrame(dataFrame));
            }
            List newSeriesSettings = (List)destination$iv$iv;
            this.applySettings(new ChartSettings(currentSettings.getAxesSettings(), newSeriesSettings), false);
        } else {
            ChartPage.applySettings$default(this, new ChartSettings(new AxesSettings(false, false, 3, null), SeriesSuggester.INSTANCE.getSingleSuggestion(dataFrame)), false, 2, null);
        }
        if (this.getSettings().isSeriesSettingsEmpty()) {
            this.chartSplitter.setFirstComponent((JComponent)this.createEmptyPage());
            ChartPage.showSeriesSettings$default(this, true, null, 2, null);
        }
    }

    private static final Unit showSeriesSettings$lambda$0(ChartPage this$0, SeriesSettingsPanel $panelMain) {
        ChartPage.applySettings$default(this$0, $panelMain.getSettings(), false, 2, null);
        this$0.fireChangeEvent();
        return Unit.INSTANCE;
    }

    private static final void createEmptyPage$lambda$0$0(ChartPage this$0, ActionEvent it) {
        ChartPage.showSeriesSettings$default(this$0, true, null, 2, null);
        ChartsUsagesCollector.INSTANCE.getSettingsOpened().log();
    }

    private static final Unit IDEA_EDT_EXECUTOR$lambda$0(Function0 action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        ApplicationManager.getApplication().invokeLater(() -> ChartPage.IDEA_EDT_EXECUTOR$lambda$0$0(action2));
        return Unit.INSTANCE;
    }

    private static final void IDEA_EDT_EXECUTOR$lambda$0$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/charts/core/ChartPage$ChartPlotComponentProviderBatik;", "Lorg/jetbrains/letsPlot/batik/plot/component/DefaultPlotComponentProviderBatik;", "processedSpec", "", "", "", "<init>", "(Ljava/util/Map;)V", "createErrorMessageComponent", "Ljavax/swing/JComponent;", "message", "Lorg/jetbrains/annotations/Nls;", "intellij.charts"})
    @SourceDebugExtension(value={"SMAP\nChartPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPage.kt\ncom/intellij/charts/core/ChartPage$ChartPlotComponentProviderBatik\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,349:1\n23#2:350\n*S KotlinDebug\n*F\n+ 1 ChartPage.kt\ncom/intellij/charts/core/ChartPage$ChartPlotComponentProviderBatik\n*L\n148#1:350\n*E\n"})
    public static final class ChartPlotComponentProviderBatik
    extends DefaultPlotComponentProviderBatik {
        public ChartPlotComponentProviderBatik(@NotNull Map<String, Object> processedSpec) {
            Intrinsics.checkNotNullParameter(processedSpec, (String)"processedSpec");
            super(processedSpec, Companion.getIDEA_EDT_EXECUTOR(), ChartPlotComponentProviderBatik::_init_$lambda$0);
        }

        @NotNull
        protected JComponent createErrorMessageComponent(@NotNull String message) {
            DialogPanel dialogPanel;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            DialogPanel $this$createErrorMessageComponent_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$0(message, arg_0));
            boolean bl = false;
            $this$createErrorMessageComponent_u24lambda_u241.setOpaque(false);
            DialogPanel inner = dialogPanel;
            DialogPanel $this$createErrorMessageComponent_u24lambda_u243 = dialogPanel = BuilderKt.panel(arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$2(message, inner, arg_0));
            boolean bl2 = false;
            $this$createErrorMessageComponent_u24lambda_u243.setOpaque(false);
            $this$createErrorMessageComponent_u24lambda_u243.setBorder(JBUI.Borders.empty((int)10));
            $this$createErrorMessageComponent_u24lambda_u243.setMinimumSize(new Dimension(1, 1));
            return (JComponent)dialogPanel;
        }

        private static final Unit _init_$lambda$0(List messages) {
            Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
            for (String message : messages) {
                DefaultPlotComponentProviderBatik.Companion $this$thisLogger$iv = DefaultPlotComponentProviderBatik.Companion;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DefaultPlotComponentProviderBatik.Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("[LetsPlot:] " + message);
            }
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$0(String $message, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$0$0($message, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$0$0(String $message, Row $this$row) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            int firstNewline = StringsKt.indexOf$default((CharSequence)$message, (String)"\n", (int)0, (boolean)false, (int)6, null);
            if (firstNewline != -1) {
                String string2 = $message.substring(0, firstNewline);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = $message;
            }
            String firstMessageLine = string;
            Object[] objectArray = new Object[]{firstMessageLine};
            Row.comment$default((Row)$this$row, (String)ChartMessagesBundle.message("series.error.reason", objectArray), (int)0, null, (int)6, null).resizableColumn();
            if (firstNewline != -1) {
                $this$row.link(ChartMessagesBundle.message("series.error.details", new Object[0]), arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$0$0$0($message, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$0$0$0(String $message, ActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("<html>" + StringsKt.replace$default((String)$message, (String)"\n", (String)"<br>", (boolean)false, (int)4, null) + "</html>", MessageType.INFO, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true);
            Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnClickOutside(...)");
            BalloonBuilder balloonBuilder2 = balloonBuilder;
            Balloon balloon = balloonBuilder2.createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            Balloon balloon2 = balloon;
            Object object = event.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            balloon2.showInCenterOf((JComponent)object);
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$2(String $message, DialogPanel $inner, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$2$0($message, $inner, arg_0), (int)1, null).resizableRow();
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$2$0(String $message, DialogPanel $inner, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.panel(arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$2$0$0($message, $inner, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$2$0$0(String $message, DialogPanel $inner, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, ChartPlotComponentProviderBatik::createErrorMessageComponent$lambda$2$0$0$0, (int)1, null);
            if (!StringsKt.isBlank((CharSequence)$message)) {
                Panel.row$default((Panel)$this$panel, null, arg_0 -> ChartPlotComponentProviderBatik.createErrorMessageComponent$lambda$2$0$0$1($inner, arg_0), (int)1, null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$2$0$0$0(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Row.text$default((Row)$this$row, (String)ChartMessagesBundle.message("series.error", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.CENTER.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createErrorMessageComponent$lambda$2$0$0$1(DialogPanel $inner, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)$inner).align((Align)AlignX.CENTER.INSTANCE);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR#\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/charts/core/ChartPage$Companion;", "", "<init>", "()V", "IDEA_EDT_EXECUTOR", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "getIDEA_EDT_EXECUTOR", "()Lkotlin/jvm/functions/Function1;", "saveAsImage", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljavax/swing/JComponent;", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Function0<Unit>, Unit> getIDEA_EDT_EXECUTOR() {
            return IDEA_EDT_EXECUTOR;
        }

        public final void saveAsImage(@NotNull Project project, @NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            FileSaverDescriptor descriptor = new FileSaverDescriptor(ChartMessagesBundle.message("action.Charts.ExportChartToPng.text", new Object[0]), "", "png");
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
            FileSaverDialog chooser = fileSaverDialog;
            VirtualFileWrapper virtualFileWrapper = chooser.save(null, "chart");
            if (virtualFileWrapper == null) {
                return;
            }
            VirtualFileWrapper fileWrapper = virtualFileWrapper;
            ApplicationManager.getApplication().runWriteAction(() -> Companion.saveAsImage$lambda$0(component2, fileWrapper, project));
        }

        private static final void saveAsImage$lambda$0(JComponent $component, VirtualFileWrapper $fileWrapper, Project $project) {
            try {
                File file;
                BufferedImage bufferedImage = ImageUtil.createImage((int)$component.getWidth(), (int)$component.getHeight(), (int)5);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
                BufferedImage paintImage = bufferedImage;
                Graphics2D g = paintImage.createGraphics();
                $component.paint(g);
                g.dispose();
                File file2 = $fileWrapper.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"png")) {
                    file = new File($fileWrapper.getFile().getPath() + ".png");
                } else {
                    File file3 = $fileWrapper.getFile();
                    Intrinsics.checkNotNull((Object)file3);
                    file = file3;
                }
                File targetFile = file;
                ImageIO.write((RenderedImage)paintImage, "PNG", targetFile);
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.saveAsImage$lambda$0$0($project, e));
            }
        }

        private static final void saveAsImage$lambda$0$0(Project $project, Exception $e) {
            Messages.showErrorDialog((Project)$project, (String)$e.getMessage(), (String)ChartMessagesBundle.message("chart.exportFailed", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

