/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.aggregation;

import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.aggregation.Aggregator;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.dataframe.columns.DoubleArrayType;
import com.intellij.charts.dataframe.columns.DoubleColumn;
import com.intellij.charts.dataframe.columns.IntArrayType;
import com.intellij.charts.dataframe.columns.IntegerType;
import com.intellij.charts.dataframe.columns.LongArrayType;
import com.intellij.charts.dataframe.columns.LongType;
import com.intellij.charts.dataframe.columns.RealType;
import com.intellij.charts.dataframe.columns.StringArrayType;
import com.intellij.charts.dataframe.columns.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/charts/dataframe/aggregation/Var;", "Lcom/intellij/charts/dataframe/aggregation/Aggregator;", "columnId", "Lcom/intellij/charts/dataframe/columns/ColumnId;", "<init>", "(Lcom/intellij/charts/dataframe/columns/ColumnId;)V", "process", "Lcom/intellij/charts/dataframe/columns/Column;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "Companion", "intellij.charts"})
public final class Var
extends Aggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Var(@NotNull ColumnId columnId) {
        Intrinsics.checkNotNullParameter((Object)columnId, (String)"columnId");
        super(columnId);
    }

    @Override
    @NotNull
    public Column<?> process(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return Companion.process(dataFrame.get(this.getColumnId()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J'\u0010\b\u001a\u0004\u0018\u00010\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\n0\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001d\u0010\b\u001a\u00020\u0012\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000b*\u0006\u0012\u0002\b\u00030\u0007H\u0082\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/charts/dataframe/aggregation/Var$Companion;", "", "<init>", "()V", "supports", "", "column", "Lcom/intellij/charts/dataframe/columns/Column;", "variance", "", "T", "", "array", "", "(Ljava/util/List;)Ljava/lang/Double;", "columnVariance", "(Lcom/intellij/charts/dataframe/columns/Column;)Ljava/lang/Double;", "process", "Lcom/intellij/charts/dataframe/columns/DoubleColumn;", "intellij.charts"})
    @SourceDebugExtension(value={"SMAP\nVar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Var.kt\ncom/intellij/charts/dataframe/aggregation/Var$Companion\n*L\n1#1,74:1\n60#1,8:75\n60#1,8:83\n60#1,8:91\n*S KotlinDebug\n*F\n+ 1 Var.kt\ncom/intellij/charts/dataframe/aggregation/Var$Companion\n*L\n52#1:75,8\n53#1:83,8\n54#1:91,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean supports(@NotNull Column<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return !(column.getType() instanceof StringArrayType);
        }

        @Nullable
        public final <T extends Number> Double variance(@NotNull List<? extends T> array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            double average = 0.0;
            int notNullCount = 0;
            for (Number p : array) {
                if (p == null) continue;
                average += p.doubleValue();
                ++notNullCount;
            }
            if (notNullCount == 0) {
                return null;
            }
            average /= (double)notNullCount;
            double variance = 0.0;
            for (Number p : array) {
                if (p == null) continue;
                variance += (p.doubleValue() - average) * (p.doubleValue() - average);
            }
            return variance / (double)notNullCount;
        }

        @Nullable
        public final Double columnVariance(@NotNull Column<?> column) {
            Double d;
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Type<?> type = column.getType();
            if (type instanceof IntegerType) {
                List<?> list = column.toList();
                Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int?>");
                d = this.variance(list);
            } else if (type instanceof LongType) {
                List<?> list = column.toList();
                Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Long?>");
                d = this.variance(list);
            } else if (type instanceof RealType) {
                List<?> list = column.toList();
                Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double?>");
                d = this.variance(list);
            } else {
                d = null;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Column<?> process(@NotNull Column<?> column) {
            Column column2;
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Type<?> type = column.getType();
            if (type instanceof StringArrayType) {
                throw new Exception("Cannot apply Var to string-typed column " + column.getName());
            }
            if (type instanceof IntArrayType) {
                Companion companion = this;
                Column $this$variance$iv = column;
                boolean $i$f$variance = false;
                ArrayList result$iv = new ArrayList($this$variance$iv.getSize());
                for (Object row$iv : $this$variance$iv) {
                    void this_$iv;
                    Collection collection = result$iv;
                    Intrinsics.checkNotNull(row$iv, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.charts.dataframe.aggregation.Var.Companion.variance?>");
                    collection.add(this_$iv.variance((List)row$iv));
                }
                column2 = new DoubleColumn($this$variance$iv.getName() + " (var)", result$iv);
            } else if (type instanceof LongArrayType) {
                Companion this_$iv = this;
                Column $this$variance$iv = column;
                boolean $i$f$variance = false;
                ArrayList result$iv = new ArrayList($this$variance$iv.getSize());
                for (Object row$iv : $this$variance$iv) {
                    Collection collection = result$iv;
                    Intrinsics.checkNotNull(row$iv, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.charts.dataframe.aggregation.Var.Companion.variance?>");
                    collection.add(this_$iv.variance((List)row$iv));
                }
                column2 = new DoubleColumn($this$variance$iv.getName() + " (var)", result$iv);
            } else if (type instanceof DoubleArrayType) {
                Companion this_$iv = this;
                Column $this$variance$iv = column;
                boolean $i$f$variance = false;
                ArrayList result$iv = new ArrayList($this$variance$iv.getSize());
                for (Object row$iv : $this$variance$iv) {
                    Collection collection = result$iv;
                    Intrinsics.checkNotNull(row$iv, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.charts.dataframe.aggregation.Var.Companion.variance?>");
                    collection.add(this_$iv.variance((List)row$iv));
                }
                column2 = new DoubleColumn($this$variance$iv.getName() + " (var)", result$iv);
            } else {
                column2 = column;
            }
            return column2;
        }

        private final /* synthetic */ <T extends Number> DoubleColumn variance(Column<?> $this$variance) {
            boolean $i$f$variance = false;
            ArrayList result = new ArrayList($this$variance.getSize());
            for (Object row : $this$variance) {
                Collection collection = result;
                Intrinsics.checkNotNull(row, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.charts.dataframe.aggregation.Var.Companion.variance?>");
                collection.add(this.variance((List)row));
            }
            return new DoubleColumn($this$variance.getName() + " (var)", result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

