/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.analyzing;

import com.intellij.charts.dataframe.columns.DateTimeType;
import com.intellij.charts.dataframe.columns.DateType;
import com.intellij.charts.dataframe.columns.IntegerType;
import com.intellij.charts.dataframe.columns.LongType;
import com.intellij.charts.dataframe.columns.RealType;
import com.intellij.charts.dataframe.columns.StringBasedType;
import com.intellij.charts.dataframe.columns.StringType;
import com.intellij.charts.dataframe.columns.TableColumnType;
import com.intellij.charts.dataframe.columns.TimeType;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvTypeParser;", "", "<init>", "()V", "parse", "Lcom/intellij/charts/dataframe/columns/TableColumnType;", "typeString", "", "maxLengthForDouble", "", "Companion", "intellij.charts"})
public final class CsvTypeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DATE_FORMAT_LENGTH = 10;
    private static final int TIME_FORMAT_MINIMUM_LENGTH = 8;
    private static final int DATE_TIME_FORMAT_MINIMUM_LENGTH = 18;
    private static final Pattern DATE_PATTERN = Pattern.compile("([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]))");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{2}):?(\\d{2})(?::?(\\d{2})(\\.\\d+)?)?(Z|(?:([+-]\\d{2})(?::?(\\d{2}))?))?");
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("(\\d{4})-?(\\d{2})-?(\\d{2})[T\\s]?(\\d{2}):?(\\d{2})(?::?(\\d{2})(\\.\\d+)?)?(Z|(?:([+-]\\d{2})(?::?(\\d{2}))?))?");

    @NotNull
    public final TableColumnType parse(@NotNull String typeString, int maxLengthForDouble) {
        Pair patternType;
        Intrinsics.checkNotNullParameter((Object)typeString, (String)"typeString");
        if (((CharSequence)typeString).length() == 0 || Intrinsics.areEqual((Object)typeString, (Object)"null")) {
            return IntegerType.INSTANCE;
        }
        Pair pair = patternType = typeString.length() == 10 && CsvTypeParser.parse$isDateLikePrefix(typeString) ? new Pair((Object)DATE_PATTERN, (Object)DateType.INSTANCE) : (typeString.length() >= 18 && CsvTypeParser.parse$isDateLikePrefix(typeString) && CsvTypeParser.parse$isTimeLikePrefix(typeString, 11) ? new Pair((Object)DATE_TIME_PATTERN, (Object)DateTimeType.INSTANCE) : (typeString.length() >= 8 && CsvTypeParser.parse$isTimeLikePrefix(typeString, 0) ? new Pair((Object)TIME_PATTERN, (Object)TimeType.INSTANCE) : null));
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            Object object = pair2.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            Pattern pattern = (Pattern)object;
            StringBasedType tpe = (StringBasedType)pair2.component2();
            if (pattern.matcher(typeString).matches()) {
                return tpe;
            }
        }
        try {
            Integer.parseInt(typeString);
            if (StringsKt.startsWith$default((CharSequence)typeString, (char)'0', (boolean)false, (int)2, null) && typeString.length() > 1) {
                return StringType.INSTANCE;
            }
            return IntegerType.INSTANCE;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.parseLong(typeString);
                if (StringsKt.startsWith$default((CharSequence)typeString, (char)'0', (boolean)false, (int)2, null) && typeString.length() > 1) {
                    return StringType.INSTANCE;
                }
                return LongType.INSTANCE;
            }
            catch (NumberFormatException numberFormatException2) {
                int probableDigitsCount = typeString.length();
                if (maxLengthForDouble != Integer.MAX_VALUE) {
                    if (StringsKt.contains$default((CharSequence)typeString, (CharSequence)".", (boolean)false, (int)2, null)) {
                        --probableDigitsCount;
                    }
                    if (StringsKt.contains$default((CharSequence)typeString, (CharSequence)"-", (boolean)false, (int)2, null)) {
                        --probableDigitsCount;
                    }
                }
                if (probableDigitsCount <= maxLengthForDouble) {
                    try {
                        Double.parseDouble(typeString);
                        return RealType.INSTANCE;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        // empty catch block
                    }
                }
                return StringType.INSTANCE;
            }
        }
    }

    public static /* synthetic */ TableColumnType parse$default(CsvTypeParser csvTypeParser, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return csvTypeParser.parse(string, n);
    }

    private static final boolean parse$isDateLikePrefix(String $typeString) {
        return Character.isDigit($typeString.charAt(0)) && $typeString.charAt(4) == '-' && Character.isDigit($typeString.charAt(9));
    }

    private static final boolean parse$isTimeLikePrefix(String $typeString, int from) {
        return Character.isDigit($typeString.charAt(from)) && $typeString.charAt(from + 2) == ':' && Character.isDigit($typeString.charAt(from + 7));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvTypeParser$Companion;", "", "<init>", "()V", "DATE_FORMAT_LENGTH", "", "TIME_FORMAT_MINIMUM_LENGTH", "DATE_TIME_FORMAT_MINIMUM_LENGTH", "DATE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TIME_PATTERN", "DATE_TIME_PATTERN", "intellij.charts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

