/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.core.utils.GroupingUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.DoubleColumn;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.BubbleSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomPoint;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.PointMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BS\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\u0013\u0010\u001e\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/charts/settings/data/BubbleSeriesSettings;", "Lcom/intellij/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "groups", "values", "sizes", "showLegend", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "type", "Lcom/intellij/charts/settings/data/type/SeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/SeriesType;", "getKeys", "()Ljava/util/List;", "getGroups", "getValues", "getSizes", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "toJson", "isEmpty", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "hashCode", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nBubbleSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BubbleSeriesSettings.kt\ncom/intellij/charts/settings/data/BubbleSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n23#2:143\n1878#3,2:144\n1880#3:147\n1#4:146\n*S KotlinDebug\n*F\n+ 1 BubbleSeriesSettings.kt\ncom/intellij/charts/settings/data/BubbleSeriesSettings\n*L\n84#1:143\n98#1:144,2\n98#1:147\n*E\n"})
public final class BubbleSeriesSettings
extends SeriesSettings {
    @NotNull
    private final SeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    @NotNull
    private final List<ColumnSettings> sizes;
    private boolean showLegend;

    @Override
    @NotNull
    public SeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    @NotNull
    public final List<ColumnSettings> getSizes() {
        return this.sizes;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public BubbleSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups, @NotNull List<ColumnSettings> values, @NotNull List<ColumnSettings> sizes, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        this.type = BubbleSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups;
        this.values = values;
        this.sizes = sizes;
        this.showLegend = showLegend;
    }

    public /* synthetic */ BubbleSeriesSettings(List list, List list2, List list3, List list4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(list, list2, list3, list4, bl);
    }

    public BubbleSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = BubbleSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.sizes = ChartJsonUtilsKt.optColumnSettingsList(json, "sizes");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "sizes", this.sizes);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty() && this.sizes.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof BubbleSeriesSettings && Intrinsics.areEqual(((BubbleSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((BubbleSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((BubbleSeriesSettings)other).values, this.values) && Intrinsics.areEqual(((BubbleSeriesSettings)other).sizes, this.sizes) && ((BubbleSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public BubbleSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new BubbleSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.sizes, dataFrame), this.showLegend);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            BubbleSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BubbleSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Bubble series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        List result = new ArrayList();
        Iterable $this$forEachIndexed$iv = res.getYColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            Collection<geomPoint> collection;
            Column<Object> column;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Column column2 = (Column)item$iv;
            int i = n;
            boolean bl = false;
            if (this.sizes.size() == 1) {
                column = SeriesSettings.Companion.getAggregatedColumn((ColumnSettings)CollectionsKt.first(this.sizes), res.getDataFrame());
            } else {
                Column column3;
                if (this.sizes.isEmpty() || i >= this.sizes.size()) {
                    int n2 = res.getXColumn().getSize();
                    String string = this.sizes.isEmpty() ? "size" : ((ColumnSettings)CollectionsKt.first(this.sizes)).getColumnId().getName();
                    collection = new ArrayList<Double>(n2);
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4;
                        int n5 = n4 = n3++;
                        ArrayList<Double> arrayList = collection;
                        boolean bl2 = false;
                        arrayList.add(1.0);
                    }
                    List list = TypeIntrinsics.asMutableList((Object)((List)collection));
                    String string2 = string;
                    column3 = new DoubleColumn(string2, list);
                } else {
                    column3 = SeriesSettings.Companion.getAggregatedColumn(this.sizes.get(i), res.getDataFrame());
                }
                column = column3.cast();
            }
            Column<Object> sizesColumn = column;
            layerTooltips tooltips = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(it.getName() + "|@{" + it.getName() + "}");
            if (!((Collection)this.sizes).isEmpty() && i < this.sizes.size()) {
                tooltips.line(sizesColumn.getName() + "|@{" + sizesColumn.getName() + "}");
            }
            Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex + result.size());
            collection = result;
            SamplingOptions samplingOptions = new SamplingOptions[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)it.getName(), it.toList()), TuplesKt.to((Object)sizesColumn.getName(), sizesColumn.toList())};
            Map map = MapsKt.mapOf((Pair[])samplingOptions);
            samplingOptions = SeriesSettings.Companion.getSampling(res);
            collection.add(new geomPoint(map, null, null, false, null, null, samplingOptions, tooltips, null, null, null, null, null, null, null, (Object)color, null, null, null, null, null, null, null, null, arg_0 -> BubbleSeriesSettings.getLetsPlotLayer$lambda$0$1(res, (Column)it, sizesColumn, arg_0), 16744246, null));
        }
        return CollectionsKt.plus((Collection)result, (Object)LabsKt.ylab((String)SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + ((Object)this.keys).hashCode();
        result = 31 * result + ((Object)this.groups).hashCode();
        result = 31 * result + ((Object)this.values).hashCode();
        result = 31 * result + ((Object)this.sizes).hashCode();
        result = 31 * result + Boolean.hashCode(this.showLegend);
        return result;
    }

    private static final Unit getLetsPlotLayer$lambda$0$1(GroupingResult $res, Column $it, Column $sizesColumn, PointMapping $this$geomPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$geomPoint, (String)"$this$geomPoint");
        $this$geomPoint.setX((Object)$res.getXColumn().getName());
        $this$geomPoint.setY((Object)$it.getName());
        $this$geomPoint.setSize((Object)$sizesColumn.getName());
        return Unit.INSTANCE;
    }
}

