/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.charts.settings.data.ColumnSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0005\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0011\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003\u001a!\u0010\u0017\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u001a\u001a\u001c\u0010\u001b\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014\u001a \u0010\u001b\u001a\u00020\u0018*\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016\u00a8\u0006\u001d"}, d2={"getAsJsonObjectOrNull", "Lcom/google/gson/JsonObject;", "memberName", "", "asJsonObjectOrNull", "Lcom/google/gson/JsonElement;", "getAsStringOrNull", "getAsJsonArrayOrNull", "Lcom/google/gson/JsonArray;", "getOrCreateJsonObject", "getOrCreateJsonArray", "optString", "key", "optBoolean", "", "default", "optInt", "", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/Integer;", "optColumnSettings", "Lcom/intellij/charts/settings/data/ColumnSettings;", "optColumnSettingsList", "", "optSetProperty", "", "value", "(Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/lang/Boolean;)V", "optSet", "values", "intellij.charts"})
public final class ChartJsonUtilsKt {
    @Nullable
    public static final JsonObject getAsJsonObjectOrNull(@NotNull JsonObject $this$getAsJsonObjectOrNull, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsJsonObjectOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return $this$getAsJsonObjectOrNull.has(memberName) && $this$getAsJsonObjectOrNull.get(memberName).isJsonObject() ? $this$getAsJsonObjectOrNull.getAsJsonObject(memberName) : null;
    }

    @Nullable
    public static final JsonObject asJsonObjectOrNull(@NotNull JsonElement $this$asJsonObjectOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$asJsonObjectOrNull, (String)"<this>");
        return $this$asJsonObjectOrNull.isJsonObject() ? (JsonObject)$this$asJsonObjectOrNull : null;
    }

    @Nullable
    public static final String getAsStringOrNull(@NotNull JsonObject $this$getAsStringOrNull, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsStringOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return $this$getAsStringOrNull.has(memberName) && $this$getAsStringOrNull.get(memberName).isJsonPrimitive() ? $this$getAsStringOrNull.get(memberName).getAsString() : null;
    }

    @Nullable
    public static final JsonArray getAsJsonArrayOrNull(@NotNull JsonObject $this$getAsJsonArrayOrNull, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsJsonArrayOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return $this$getAsJsonArrayOrNull.has(memberName) && $this$getAsJsonArrayOrNull.get(memberName).isJsonArray() ? $this$getAsJsonArrayOrNull.getAsJsonArray(memberName) : null;
    }

    @NotNull
    public static final JsonObject getOrCreateJsonObject(@NotNull JsonObject $this$getOrCreateJsonObject, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateJsonObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        JsonObject jsonObject = ChartJsonUtilsKt.getAsJsonObjectOrNull($this$getOrCreateJsonObject, memberName);
        if (jsonObject == null) {
            jsonObject = new JsonObject();
            $this$getOrCreateJsonObject.add(memberName, (JsonElement)jsonObject);
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getOrCreateJsonArray(@NotNull JsonObject $this$getOrCreateJsonArray, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateJsonArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        JsonArray jsonArray = ChartJsonUtilsKt.getAsJsonArrayOrNull($this$getOrCreateJsonArray, memberName);
        if (jsonArray == null) {
            jsonArray = new JsonArray();
            $this$getOrCreateJsonArray.add(memberName, (JsonElement)jsonArray);
        }
        return jsonArray;
    }

    @Nullable
    public static final String optString(@NotNull JsonObject $this$optString, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$optString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonPrimitive value = (JsonPrimitive)$this$optString.get(key);
        return value != null && value.isString() ? value.getAsString() : null;
    }

    public static final boolean optBoolean(@NotNull JsonObject $this$optBoolean, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$optBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonPrimitive value = (JsonPrimitive)$this$optBoolean.get(key);
        return value != null && value.isBoolean() ? value.getAsBoolean() : false;
    }

    public static final boolean optBoolean(@NotNull JsonObject $this$optBoolean, @NotNull String key, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)$this$optBoolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonPrimitive value = (JsonPrimitive)$this$optBoolean.get(key);
        return value != null && value.isBoolean() ? value.getAsBoolean() : bl;
    }

    @Nullable
    public static final Integer optInt(@NotNull JsonObject $this$optInt, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$optInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonPrimitive value = (JsonPrimitive)$this$optInt.get(key);
        return value != null && value.isNumber() ? Integer.valueOf(value.getAsInt()) : null;
    }

    public static final int optInt(@NotNull JsonObject $this$optInt, @NotNull String key, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$optInt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonPrimitive value = (JsonPrimitive)$this$optInt.get(key);
        return value != null && value.isNumber() ? value.getAsInt() : n;
    }

    @Nullable
    public static final ColumnSettings optColumnSettings(@NotNull JsonObject $this$optColumnSettings, @NotNull String key) {
        ColumnSettings columnSettings;
        Intrinsics.checkNotNullParameter((Object)$this$optColumnSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if ($this$optColumnSettings.has(key) && $this$optColumnSettings.get(key).isJsonObject()) {
            JsonObject jsonObject = $this$optColumnSettings.get(key).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            columnSettings = new ColumnSettings(jsonObject);
        } else {
            columnSettings = null;
        }
        return columnSettings;
    }

    @NotNull
    public static final List<ColumnSettings> optColumnSettingsList(@NotNull JsonObject $this$optColumnSettingsList, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$optColumnSettingsList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!$this$optColumnSettingsList.has(key)) {
            return CollectionsKt.emptyList();
        }
        if ($this$optColumnSettingsList.get(key).isJsonObject()) {
            JsonObject jsonObject = $this$optColumnSettingsList.get(key).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            return CollectionsKt.listOf((Object)new ColumnSettings(jsonObject));
        }
        JsonArray barsJson = $this$optColumnSettingsList.get(key).getAsJsonArray();
        ArrayList<ColumnSettings> res = new ArrayList<ColumnSettings>(barsJson.size());
        Iterator iterator = barsJson.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement barJson = (JsonElement)iterator2.next();
            JsonObject jsonObject = barJson.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            res.add(new ColumnSettings(jsonObject));
        }
        return res;
    }

    public static final void optSetProperty(@NotNull JsonObject $this$optSetProperty, @NotNull String key, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$optSetProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value != null && value.booleanValue()) {
            $this$optSetProperty.addProperty(key, value);
        } else {
            $this$optSetProperty.remove(key);
        }
    }

    public static final void optSet(@NotNull JsonObject $this$optSet, @NotNull String key, @Nullable ColumnSettings value) {
        Intrinsics.checkNotNullParameter((Object)$this$optSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value != null) {
            $this$optSet.add(key, (JsonElement)value.toJson());
        } else {
            $this$optSet.remove(key);
        }
    }

    public static final void optSet(@NotNull JsonObject $this$optSet, @NotNull String key, @NotNull List<ColumnSettings> values) {
        Intrinsics.checkNotNullParameter((Object)$this$optSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.isEmpty()) {
            $this$optSet.remove(key);
            return;
        }
        JsonArray jsonArray = new JsonArray();
        for (ColumnSettings value : values) {
            jsonArray.add((JsonElement)value.toJson());
        }
        $this$optSet.add(key, (JsonElement)jsonArray);
    }
}

