/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsSyncHelper {
    @Nullable
    private final ScriptCategory myScriptCategory;
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final List<BasicElement> myElements = new ArrayList<BasicElement>();
    private boolean myAllSources;

    @Contract(value="null,!null,_->fail")
    public DetailsSyncHelper(@Nullable Project project, @Nullable LocalDataSource dataSource, @Nullable ScriptCategory scriptCategory) {
        assert (project != null || dataSource == null);
        this.myScriptCategory = scriptCategory;
        this.myProject = project;
        this.myDataSource = dataSource;
    }

    public static DetailsSyncHelper of(@Nullable DbElement element) {
        return DetailsSyncHelper.of(element, null);
    }

    public static DetailsSyncHelper of(@Nullable DbElement element, @Nullable ScriptCategory scriptCategory) {
        if (element == null) {
            return new DetailsSyncHelper(null, null, scriptCategory);
        }
        DetailsSyncHelper res = DetailsSyncHelper.of(element.getProject(), (DasDataSource)element.getDataSource(), scriptCategory);
        return res.check(element);
    }

    public static DetailsSyncHelper of(@NotNull Project project, @Nullable DasDataSource dataSource, @Nullable ScriptCategory scriptCategory) {
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(0);
        }
        if (dataSource instanceof DbDataSource) {
            dataSource = ((DbDataSource)dataSource).getDelegate();
        }
        return new DetailsSyncHelper(project, (LocalDataSource)ObjectUtils.tryCast((Object)dataSource, LocalDataSource.class), scriptCategory);
    }

    public DetailsSyncHelper check(@Nullable DbElement e) {
        return this.check(e instanceof DbDataSource ? null : DbImplUtilCore.getMaybeBasicElement((DasObject)e));
    }

    public DetailsSyncHelper check(@Nullable BasicElement e) {
        ContainerUtil.addIfNotNull(this.myElements, (Object)e);
        return this;
    }

    public DetailsSyncHelper check(@NotNull Iterable<BasicElement> elements) {
        if (elements == null) {
            DetailsSyncHelper.$$$reportNull$$$0(1);
        }
        ContainerUtil.addAll(this.myElements, elements);
        return this;
    }

    public DetailsSyncHelper withAllSources() {
        this.myAllSources = true;
        return this;
    }

    @Nullable
    public List<IntrospectionTask> prepareRecommendedTasksIfIntrospectionIsNeeded() {
        if (this.myProject == null || this.myDataSource == null || this.myElements.isEmpty() && !this.myAllSources || !DBIntrospectorFeatures.supportsMultilevelIntrospection((LocalDataSource)this.myDataSource)) {
            return null;
        }
        if (this.myAllSources) {
            boolean needsIntrospection;
            JBTreeTraverser objects = DbImplUtilCore.traverseVisibleObjects((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.myElements.isEmpty() ? this.myDataSource.getModel().getModelRoots() : this.myElements)), (TreePattern)this.myDataSource.getIntrospectionScope());
            boolean bl = needsIntrospection = objects.traverse().filter(BasicMultiLevelObject.class).find(it -> it.getDetailsLevel() != Level.L3) != null;
            if (!needsIntrospection) {
                return null;
            }
            return Collections.singletonList(IntrospectionTasks.prepareGeneralTask((String)this.myDataSource.getUniqueId()));
        }
        LevelAnalyzer analyzer = DetailsSyncHelper.createAnalyzer((DasDataSource)this.myDataSource);
        DetailsSyncHelper.giveElementsToAnalyse(analyzer, this.myElements);
        LevelAnalyzer.Recommendation recommendation = this.myScriptCategory == null ? analyzer.analyzeForAllDetailsAccessing() : analyzer.analyzeForScripting(this.myScriptCategory);
        return recommendation.tasks.isEmpty() ? null : recommendation.tasks;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public LoaderContext prepareContextIfIntrospectionIsNeeded() {
        if (this.myProject == null || this.myDataSource == null) {
            return null;
        }
        List<IntrospectionTask> tasks = this.prepareRecommendedTasksIfIntrospectionIsNeeded();
        return tasks == null ? null : LoaderContext.selectTasks((Project)this.myProject, (LocalDataSource)this.myDataSource, tasks);
    }

    private static void giveElementsToAnalyse(@NotNull LevelAnalyzer analyzer, @NotNull List<BasicElement> elements) {
        if (analyzer == null) {
            DetailsSyncHelper.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DetailsSyncHelper.$$$reportNull$$$0(3);
        }
        ArrayList<String> errors = null;
        for (BasicElement e : elements) {
            try {
                analyzer.addElementToAnalysis(e);
            }
            catch (IllegalArgumentException iae) {
                if (errors == null) {
                    errors = new ArrayList<String>();
                }
                errors.add(iae.getMessage());
            }
        }
        if (errors != null) {
            int n = errors.size();
            String message = "The following " + n + StringUtil.pluralize((String)"elements", (int)n) + (n == 1 ? " was" : " were") + " not accepted by elements level analyzer:\n\t" + StringUtil.join(errors, (String)"\n\t");
            Logger logger = Logger.getInstance(DetailsSyncHelper.class);
            logger.warn(message);
        }
    }

    public static boolean askUserForSyncOrAbort(@NotNull DbDataSource dbDataSource, @NotNull BasicElement element, @Nls String actionName) {
        if (dbDataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(4);
        }
        if (element == null) {
            DetailsSyncHelper.$$$reportNull$$$0(5);
        }
        Project project = dbDataSource.getProject();
        RawDataSource dataSourceDelegate = dbDataSource.getDelegate();
        if (!(dataSourceDelegate instanceof LocalDataSource)) {
            return false;
        }
        LocalDataSource dataSource = (LocalDataSource)dataSourceDelegate;
        return DetailsSyncHelper.askUserForSyncOrAbort(project, dataSource, element, actionName);
    }

    public static boolean askUserForSyncOrAbort(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull BasicElement element, @Nls String actionName) {
        LevelAnalyzer.Recommendation recommendation;
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(7);
        }
        if (element == null) {
            DetailsSyncHelper.$$$reportNull$$$0(8);
        }
        boolean abort = false;
        if (element.isOutdated()) {
            DatabaseUiService databaseUiService = DatabaseUiService.getInstance();
            abort = databaseUiService.askIfAbort(actionName, project, dataSource, element);
        } else if (DBIntrospectorFeatures.supportsMultilevelIntrospection((LocalDataSource)dataSource) && (recommendation = DetailsSyncHelper.analyzeWhatToIntrospect((DasDataSource)dataSource, element)).hasContent()) {
            DatabaseUiService databaseUiService = DatabaseUiService.getInstance();
            abort = databaseUiService.confirmAndRunSync(project, dataSource, actionName, recommendation);
        }
        return abort;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean askAbortIfSyncRequired(@Nls String string) {
        void actionName;
        ThreadingAssertions.assertEventDispatchThread();
        Project project = this.myProject;
        LocalDataSource dataSource = this.myDataSource;
        if (project == null || dataSource == null) {
            return false;
        }
        List<IntrospectionTask> tasks = this.prepareRecommendedTasksIfIntrospectionIsNeeded();
        if (tasks == null) {
            return false;
        }
        return DatabaseUiService.getInstance().askIfAbort(project, dataSource, (String)actionName, tasks);
    }

    public boolean askAbortIfSyncRequiredAnyThread(@Nls String actionName) {
        if (EDT.isCurrentThreadEdt()) {
            return this.askAbortIfSyncRequired(actionName);
        }
        Ref res = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> res.set((Object)this.askAbortIfSyncRequired(actionName)));
        return (Boolean)res.get();
    }

    public void notifyIfSyncRequired(@Nls String actionName) {
        Project project = this.myProject;
        LocalDataSource dataSource = this.myDataSource;
        if (project == null || dataSource == null) {
            return;
        }
        List<IntrospectionTask> tasks = this.prepareRecommendedTasksIfIntrospectionIsNeeded();
        if (tasks == null) {
            return;
        }
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message((String)"notification.title.low.introspection.level", (Object[])new Object[]{StringUtil.trimEnd((String)actionName, (String)"\u2026")}), DatabaseBundle.message((String)"notification.content.results.might.be.wrong.due.to.low.level", (Object[])new Object[0]) + String.valueOf(HtmlChunk.link((String)"sync", (String)DatabaseBundle.message((String)"notification.content.increase.introspection.level", (Object[])new Object[0]))), NotificationType.WARNING).setListener((notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RunIntrospection.runAsyncIntrospection(project, dataSource, tasks);
            }
        }).setDisplayId("DetailsSyncHelper.sync.required").notify(project);
    }

    @NotNull
    public static LevelAnalyzer.Recommendation analyzeWhatToIntrospect(@NotNull DbElement dbElement) {
        LocalDataSource dataSource;
        if (dbElement == null) {
            DetailsSyncHelper.$$$reportNull$$$0(9);
        }
        if ((dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)dbElement.getDataSource().getDelegateDataSource(), LocalDataSource.class)) == null) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(10);
            }
            return recommendation;
        }
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection((LocalDataSource)dataSource)) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(11);
            }
            return recommendation;
        }
        BasicElement element = (BasicElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicElement.class);
        if (element == null) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(12);
            }
            return recommendation;
        }
        return DetailsSyncHelper.analyzeWhatToIntrospect((DasDataSource)dataSource, element);
    }

    @NotNull
    public static LevelAnalyzer.Recommendation analyzeWhatToIntrospect(@NotNull DasDataSource dataSource, @NotNull BasicElement element) {
        if (dataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(13);
        }
        if (element == null) {
            DetailsSyncHelper.$$$reportNull$$$0(14);
        }
        LevelAnalyzer analyzer = DetailsSyncHelper.createAnalyzer(dataSource);
        analyzer.addElementToAnalysis(element);
        LevelAnalyzer.Recommendation recommendation = analyzer.analyzeForAllDetailsAccessing();
        if (recommendation == null) {
            DetailsSyncHelper.$$$reportNull$$$0(15);
        }
        return recommendation;
    }

    @NotNull
    private static LevelAnalyzer createAnalyzer(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(16);
        }
        Dbms dbms = dataSource.getDbms();
        LevelAnalyzer levelAnalyzer = ModelFacade.forDbms((Dbms)dbms).createLevelAnalyzer(dataSource.getUniqueId());
        if (levelAnalyzer == null) {
            DetailsSyncHelper.$$$reportNull$$$0(17);
        }
        return levelAnalyzer;
    }

    @Nullable
    public static LoaderContext prepareContext(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull LevelAnalyzer.Recommendation recommendation) {
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(18);
        }
        if (dataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(19);
        }
        if (recommendation == null) {
            DetailsSyncHelper.$$$reportNull$$$0(20);
        }
        if (recommendation.hasContent()) {
            return LoaderContext.selectTasks((Project)project, (LocalDataSource)dataSource, (Collection)recommendation.tasks);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DetailsSyncHelper";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommendation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DetailsSyncHelper";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeWhatToIntrospect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "giveElementsToAnalyse";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "askUserForSyncOrAbort";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeWhatToIntrospect";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAnalyzer";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 15, 17 -> new IllegalStateException(string);
        };
    }
}

