/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ColumnRefKt;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Triple;
import me.xuender.unidecode.Unidecode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class DbImplUtil
extends DbImplUtilCore {
    private static final String READ_ONLY_WARNING = "Read-only mode is not supported. Dbms: %s";
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtilCore::canConnectTo;
    private static final char ESCAPE_CHAR = '#';

    private DbImplUtil() {
    }

    @NotNull
    public static Dbms getDbms(@NotNull GridDataRequest.Context context) {
        DataRequest.Context c;
        if (context == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataRequest.Owner owner = (c = (DataRequest.Context)ObjectUtils.tryCast((Object)context, DataRequest.Context.class)) == null ? null : c.request.owner;
        Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)DbImplUtil.getDbms(owner), (Object)Dbms.UNKNOWN);
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Nullable
    public static Dbms getDbms(@Nullable DataRequest.Owner owner) {
        DbDataSource system = owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDataSource() : (owner instanceof JdbcConsoleBase ? ((JdbcConsoleBase)owner).getDataSource() : (owner instanceof DatabaseSession ? ((DatabaseConnectionPoint)((DatabaseSession)owner).getTarget()).getDataSource() : (owner instanceof DatabaseSessionClient ? ((DatabaseConnectionPoint)((DatabaseSession)((DatabaseSessionClient)owner).getSession()).getTarget()).getDataSource() : (owner instanceof DataRequest.DasDataSourceProvider ? ((DataRequest.DasDataSourceProvider)owner).getDataSource() : null))));
        return system == null ? null : system.getDbms();
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull Dbms dbms, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        if ((expression = DbSqlUtilCore.parseSqlQueryResultSetExpression((Project)project, (SqlLanguageDialect)DbSqlUtilCore.getSqlDialect((Dbms)dbms), (String)query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        Set names = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        Object result = alias;
        int index = 1;
        while (names.contains(result)) {
            result = alias + index++;
        }
        String string = result;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isConnected(@NotNull DbElement element) {
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        Object delegate = element.getDelegate();
        Project project = element.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    @Nullable
    public static Domain getDomain(@Nullable DasTypedObject column) {
        if (column == null) {
            return null;
        }
        DomainRegistry registry = BaseDomainRegistry.get((Dbms)DbImplUtilCore.getDbms((DasObject)column), null);
        return registry.getDomain((ColumnDescriptor)new TypeNameColumnDescriptor(DasTypeUtilsKt.getTypeName((DasType)column.getDasType())));
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        List<ConsoleRunConfiguration> activeConfigurations;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        return !(activeConfigurations = JdbcDriverManager.getDriverManager(project).getActiveConfigurations(dataSource)).isEmpty();
    }

    public static int getActiveConnectionCount(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(11);
        }
        int result = 0;
        for (DatabaseConnection connection2 : DatabaseConnectionManager.getInstance().getActiveConnections()) {
            if (dataSource != connection2.getConnectionPoint().getDataSource()) continue;
            ++result;
        }
        return result;
    }

    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element, @NotNull DatabaseDepartment department) throws Exception {
        RawDataSource ds;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        if (department == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        if (!((ds = element.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        LocalDataSource localDataSource = (LocalDataSource)ds;
        SearchPath path = SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)element)));
        Project project = element.getProject();
        GuardedRef<DatabaseConnection> connection2 = DatabaseSessionManager.getFacade(project, (DatabaseConnectionPoint)localDataSource, null, path, false, null, department).connect();
        JdbcNativeUtil.performSafe(() -> ((DatabaseConnection)connection2.get()).getRemoteConnection().setCatalog(DasUtil.getCatalog((DasObject)element)));
        return connection2;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e) {
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        if (ExceptionUtil.findCause((Throwable)e, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element) {
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        ModelHelper modelHelper = DbImplUtilCore.getModelHelper((BasicElement)element);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        return modelHelper;
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        ModelHelper modelHelper = DbImplUtilCore.getModelHelper((Dbms)dbms);
        if (modelHelper == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        return modelHelper;
    }

    @NotNull
    public static Dbms getDbms(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        Dbms dbms = console.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        return dbms;
    }

    public static boolean isGenericSupport(Dbms dbms) {
        if (dbms.in(Dbms.PSEUDO_SUPPORTED)) {
            return true;
        }
        DatabaseDialectEx db = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        SqlLanguageDialect sql = DbSqlUtilCore.getSqlDialect((Dbms)dbms);
        return SqlDialects.isGenericDialect((SqlLanguageDialect)sql) && DatabaseDialects.isGenericDialect((DatabaseDialect)db);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsoleBase console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(21);
        }
        return DbImplUtil.getDatabaseDialect((RawConnectionConfig)console.getDataSource());
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect((RawConnectionConfig)connectionInfo), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        return databaseDialectEx;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return DbImplUtilCore.guessDatabaseDialect((Dbms)dbms);
    }

    @Nullable
    public static Dbms guessDbms(@Nullable DasObject object) {
        Language language;
        BasicModel model;
        DasObject o;
        Object object2 = o = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Dbms dbms = o instanceof BasicElement ? ((model = ((BasicElement)o).getModel()) == null ? null : model.getDbms()) : (o instanceof SqlElement ? ((language = ((SqlElement)o).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : null) : null);
        return dbms;
    }

    public static boolean supportsDbmsOutput(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        return dbms.isOracle() || dbms == Dbms.DB2_LUW;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull DatabaseConnectionPoint dataSource) {
        DatabaseDialectEx dialect;
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect((RawConnectionConfig)dataSource)) == null || dataSource.getDbms() != Dbms.MYSQL || !dataSource.isReadOnly();
    }

    public static boolean isScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbImplUtil.isSqlScriptFile(project, file) || DbImplUtil.isJSScriptFile(project, file);
    }

    public static boolean isSqlScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        return DbSqlUtil.SQL_FILE_FILTER(project).value((Object)file);
    }

    public static boolean isJSScriptFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (!"js".equals(file.getExtension()) && !FileTypeRegistry.getInstance().getFileTypeByFile(file).getName().equals("JavaScript")) {
            return false;
        }
        for (LocalDataSource ds : DbSrcUtilsCore.getDataSources((Project)project)) {
            if (!ds.getDbms().isMongo()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtilsCore.isDbSrcFile((VirtualFile)file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        if (DbSrcUtilsCore.isDbSrcFile((VirtualFile)file)) {
            return DbSrcUtils.getKind(file.getPath());
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o, boolean refresh) {
        VirtualFile file;
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        if ((file = DbImplUtil.findVirtualFileInSourceStorage(o, false, refresh)) != null) {
            return file;
        }
        return o.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findDataVirtualFile(@NotNull DbElement o, boolean refresh) {
        ObjectKind kind;
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        if (DbImplUtil.isDataTable((ObjectKind)(kind = o.getKind()))) {
            return DatabaseElementVirtualFileImpl.findFile((DbElement)o, (boolean)false);
        }
        return DbImplUtil.findSourceVirtualFile(o, refresh);
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original, boolean refresh) {
        VirtualFile vf;
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware && (vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), (DasObject)o, refresh)) != null) {
            return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean canSwitchTo(@NotNull SearchPath to, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        if (dialect.sqlSetSearchPath(to) != null) {
            return true;
        }
        if (!DbImplUtil.isNamespace((ObjectKind)to.getCurrent().kind)) {
            return false;
        }
        return dialect.shouldSwitchThroughJdbc(to.getCurrent().kind);
    }

    @Nullable
    public static String getSearchPathSql(@NotNull SearchPath to, @NotNull DatabaseConnectionPoint dataSource, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(31);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        if (dataSource.getSchemaControl() == SchemaControl.FORBID) {
            return null;
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        if (setSchemaSql != null) {
            return setSchemaSql;
        }
        ObjectPath current = to.getCurrent();
        ObjectPath db = current.kind != ObjectKind.SCHEMA ? null : current.findParent(ObjectKind.DATABASE, true);
        return db == null ? null : dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)db));
    }

    public static boolean switchSchemaThroughJdbc(@NotNull SearchPath path, @NotNull DatabaseConnection connection2, @NotNull DatabaseConnectionPoint dataSource) throws SQLException {
        if (path == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (dataSource.getSchemaControl() == SchemaControl.FORBID) {
            return false;
        }
        if (!DbImplUtil.getDatabaseDialect((RawConnectionConfig)dataSource).shouldSwitchThroughJdbc(path.getCurrent().kind)) {
            return false;
        }
        if (dataSource.getDbms().isClickHouse()) {
            ObjectPath schema = path.getCurrent().findParent(ObjectKind.SCHEMA, false);
            if (schema == null) {
                return false;
            }
            JdbcNativeUtil.performRemote(() -> connection2.getRemoteConnection().setSchema(schema.name));
            return true;
        }
        return DbImplUtil.switchSchemaThroughJdbcImpl((ObjectPath)path.getCurrent(), (DatabaseConnectionCore)connection2);
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasObject table, @NotNull List<T> descriptors, @NotNull Dbms dbms) {
        ColumnDescriptor idColumn;
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey((DasObject)table);
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>(descriptors.size());
        if (primaryKey != null) {
            Set set = CollectionFactory.createCaseInsensitiveStringSet();
            ContainerUtil.addAll((Collection)set, (Iterable)primaryKey.getColumnsRef().names());
            result.addAll(ContainerUtil.filter(descriptors, descriptor -> set.contains(descriptor.getName())));
        } else if (dbms.is(Dbms.MONGO) && (idColumn = (ColumnDescriptor)ContainerUtil.find(descriptors, d -> "_id".equals(d.getName()))) != null) {
            result.add(idColumn);
        }
        if (!result.isEmpty()) {
            ArrayList<ColumnDescriptor> arrayList = result;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(39);
            }
            return arrayList;
        }
        result.addAll(ContainerUtil.filter(descriptors, descriptor -> DbImplUtil.isSuitable(descriptor, dbms)));
        ArrayList<ColumnDescriptor> arrayList = result;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    public static boolean supportsReadOnlyChangeOnTheFly(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        return !dbms.isSqlite() && dbms != Dbms.HIVE && dbms != Dbms.SNOWFLAKE && dbms != Dbms.COCKROACH;
    }

    public static void tryToSetReadOnly(@NotNull DatabaseConnection connection2, boolean isReadOnly) {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        try {
            connection2.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, connection2.getDbms()), t);
        }
    }

    public static void tryToSetReadOnly(@NotNull RemoteConnection remoteConnection, boolean isReadOnly, Dbms dbms) {
        if (remoteConnection == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        try {
            remoteConnection.setReadOnly(isReadOnly);
        }
        catch (Throwable t) {
            LOG.warn(String.format(READ_ONLY_WARNING, dbms), t);
        }
    }

    public static boolean supportsReadOnlyChangeDuringTx(@NotNull Dbms family) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        return family == Dbms.MYSQL;
    }

    @Nullable
    public static DbDataSource findDataSourceByFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        if (file == null) {
            return null;
        }
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            String adjusted;
            LocalDataSource d = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource);
            JdbcUrlParser parsed = JdbcUrlParserUtil.parsed((RawConnectionConfig)d);
            String path = parsed == null ? null : parsed.getParameter("file");
            if (path == null || !Objects.equals(adjusted = FileUtil.toSystemIndependentName((String)PathManager.getAbsolutePath((String)path)), file.getPath())) continue;
            return dataSource;
        }
        return null;
    }

    public static TriConsumer<DdlBuilder, List<DasColumn>, Dbms> defaultWhereCondition(@NotNull @NotNull String @NotNull [] columnNames, @NotNull List<String[]> valuesList, @Nullable Version version) {
        if (valuesList == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        return (builder, columns, dbms) -> {
            List actualColumns = ColumnRefKt.toColumnsRef((List)columns, (String[])columnNames);
            ArrayList columnsAndValuesList = new ArrayList();
            for (String[] values : valuesList) {
                ArrayList<Triple> list = new ArrayList<Triple>();
                for (int i = 0; i < actualColumns.size(); ++i) {
                    list.add(new Triple((Object)((ColumnRef)actualColumns.get(i)), (Object)ModelIndex.forColumn((GridModel)null, (int)i), (Object)values[i]));
                }
                columnsAndValuesList.add(list);
            }
            WhereClause whereClause = ExtractorsUtil.createWhereClauseTask((boolean)false, (boolean)PredicatesHelperKt.predicatesHelper((Dbms)dbms).getSupportsInOperator(), columnsAndValuesList, (column, v) -> PredicateValuesKt.predicateValue((String)v));
            WhereClauseTask task = DmlTaskKt.whereClause((WhereClause)whereClause).version(version).build(builder);
            DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task);
        };
    }

    @NotNull
    public static ModelHelper.ObjectKindVariant getTableKindVariant(@NotNull DatabaseConnection connection2, @NotNull String query) throws SQLException {
        if (connection2 == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(49);
        }
        ExecutionEnvironmentHelper helper = (ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms());
        ModelHelper.ObjectKindVariant result = (ModelHelper.ObjectKindVariant)DbImplUtil.executeAndGetResult((DatabaseConnectionCore)connection2, (String)query, arg_0 -> ((ExecutionEnvironmentHelper)helper).getTableKindVariant(arg_0));
        if (result == null) {
            throw new AssertionError((Object)"Incorrect table type query!");
        }
        ModelHelper.ObjectKindVariant objectKindVariant = result;
        if (objectKindVariant == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        return objectKindVariant;
    }

    @Nullable
    public static SqlLanguageDialect getSqlLanguageDialectForExec(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        return (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)file), (Object)SqlPsiFacade.getInstance((Project)file.getProject()).getConfiguredSqlLanguageDialect(virtualFile));
    }

    @Nullable
    public static Language getLanguageDialectForExec(@NotNull PsiFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        return ScriptModelUtilCore.isJSFile((PsiFile)file) ? MongoJSLanguage.INSTANCE : DbImplUtil.getSqlLanguageDialectForExec(file);
    }

    @Nullable
    public static DatabaseDialect getDatabaseDialectForExec(@NotNull PsiFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        if (ScriptModelUtilCore.isJSFile((PsiFile)file)) {
            return DbImplUtil.getDatabaseDialect((Dbms)Dbms.MONGO);
        }
        SqlLanguageDialect dialect = DbImplUtil.getSqlLanguageDialectForExec(file);
        if (dialect == null) {
            return null;
        }
        return dialect.getDatabaseDialect();
    }

    @Nullable
    public static DbDataSource getForcedDataSourceForExec(@NotNull PsiFile file) {
        DbDataSource forcedDataSource;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        return (forcedDataSource = DbImplUtil.getForcedDataSource((PsiFile)file)) != null && DbImplUtil.canConnectTo((DbElement)forcedDataSource) ? forcedDataSource : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSourcesForExec(@NotNull PsiFile file) {
        DatabaseDialect databaseDialect;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(55);
        }
        if ((databaseDialect = DbImplUtil.getDatabaseDialectForExec(file)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbImplUtil.$$$reportNull$$$0(56);
            }
            return jBIterable;
        }
        JBIterable appropriateDataSources = DbSqlUtilCore.getAppropriateDataSources((DatabaseDialect)databaseDialect, (VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)file), (Project)file.getProject(), (boolean)false, (boolean)false);
        JBIterable jBIterable = appropriateDataSources.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(57);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbDataSource> getAllDataSourcesForExec(@NotNull PsiFile file) {
        JBIterable appropriateDataSources;
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(58);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)file.getProject());
        JBIterable jBIterable = appropriateDataSources = JBIterable.from((Iterable)facade.getDataSources()).filter(ds -> !(ds instanceof SqlDataSource) && ds.isValid()).filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(59);
        }
        return jBIterable;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull GridColumn column, boolean isNull, @Nullable String alias, @NotNull Dbms dbms, boolean inUpdate) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(60);
        }
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(61);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        if (GridUtilCore.isRowId((GridColumn)column)) {
            builder.plain(column.getName());
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.getName());
        }
        builder.space();
        if (isNull) {
            builder.keywords(new String[]{"IS", "NULL"});
            return 0;
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper((Dbms)dbms);
        String className = column instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column).getJavaClassName() : null;
        boolean bl = useLike = DbImplUtil.getDatabaseDialect((Dbms)dbms).getLikeSupport(null).isSupported(inUpdate) && "java.lang.String".equals(className);
        if (useLike) {
            builder.keyword("LIKE");
        } else if (dbms.isPostgres() && PgBaseJdbcHelper.isCustomOperatorType((String)column.getTypeName())) {
            builder.symbol("~=");
        } else {
            builder.symbol("=");
        }
        builder.space().placeholder();
        if (useLike && helper.supportsEscape()) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        return 1;
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        if (callback == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        }, modalityState);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @NotNull ModalityState state) {
        if (state == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        DbImplUtil.setActionCallbackDone(callback, done, null, state);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(65);
        }
        EnumSet<ReservedCellValue> result = EnumSet.noneOf(ReservedCellValue.class);
        if (dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            result.add(ReservedCellValue.UNSET);
        }
        if (databaseColumn == null) {
            result.add(ReservedCellValue.NULL);
            EnumSet<ReservedCellValue> enumSet = result;
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(66);
            }
            return enumSet;
        }
        if (DasUtil.isAutoGenerated((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        return enumSet;
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable LocalDataSource dataSource, @Nullable SearchPath path) {
        SchemaControl control;
        if (path == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource == null ? SchemaControl.AUTOMATIC : dataSource.getSchemaControl();
        if (control == SchemaControl.AUTOMATIC) {
            return path;
        }
        return DbImplUtil.getDatabaseToSwitch(path);
    }

    @Nullable
    public static SearchPath getDatabaseToSwitch(@Nullable SearchPath path) {
        return DbImplUtil.getPathToSwitch(path, ObjectKind.DATABASE);
    }

    @Nullable
    public static SearchPath getSchemaToSwitch(@Nullable SearchPath path) {
        return DbImplUtil.getPathToSwitch(path, ObjectKind.SCHEMA);
    }

    @Nullable
    private static SearchPath getPathToSwitch(@Nullable SearchPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        return path == null ? null : SearchPath.of((ObjectPath)path.getCurrent().findParent(kind, false));
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor, @NotNull Dbms dbms) {
        if (descriptor == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        int type = descriptor.getType();
        String typeName = descriptor.getTypeName();
        boolean isVirtual = descriptor.getAttributes().contains(ColumnDescriptor.Attribute.VIRTUAL);
        return !(isVirtual || type == 2004 || type == 2005 || type == 2011 || !DbImplUtil.isNotTruncated(descriptor) || !DbImplUtil.isNotGeoType(dbms, typeName) || dbms.isMicrosoft() && (typeName != null && StringUtil.containsIgnoreCase((String)typeName, (String)"vector") || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"json") || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml")) || type == 2009 && (dbms.isPostgres() || dbms.isOracle()) || dbms.isPostgres() && !PgBaseJdbcHelper.canCompare((String)typeName));
    }

    private static boolean isNotTruncated(@NotNull ColumnDescriptor descriptor) {
        LobInfo.ClobInfo clobInfo;
        ColumnQueryData columnQueryData;
        Object object;
        if (descriptor == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        return !(descriptor instanceof ColumnQueryData) || !((object = (columnQueryData = (ColumnQueryData)descriptor).getObject()) instanceof LobInfo.ClobInfo) || !(clobInfo = (LobInfo.ClobInfo)object).isTruncated();
    }

    private static boolean isNotGeoType(Dbms dbms, @Nullable String typeName) {
        if (typeName == null) {
            return true;
        }
        GeoHelper geoHelper = (GeoHelper)GeoHelper.EP.forDbms(dbms);
        return !geoHelper.isGeoType(typeName);
    }

    @NotNull
    public static String searchPathPresentation(List<ObjectPath> schemas) {
        StringBuilder res = new StringBuilder();
        int pos = 0;
        while (pos < schemas.size()) {
            if (!res.isEmpty()) {
                res.append("; ");
            }
            ObjectPath cur = schemas.get(pos);
            if (++pos < schemas.size() && cur.parent != null && cur.parent.equals(schemas.get((int)pos).parent)) {
                res.append(cur.parent.getDisplayName());
                res.append(": ");
                res.append(cur.getName()).append(", ").append(schemas.get(pos).getName());
                ++pos;
                while (pos < schemas.size() && cur.parent.equals(schemas.get((int)pos).parent)) {
                    res.append(", ").append(schemas.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res.append(cur.getDisplayName());
        }
        String string = res.toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent, @NotNull DasObject child, Map<DasObject, Boolean> cache, Condition<? super DasObject> expandCondition) {
        if (child == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        if (parent == null || parent.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res = cache.get(parent);
        if (res == null) {
            res = DbImplUtil.isChildrenAccessible(parent.getDasParent(), parent, cache, expandCondition) && expandCondition.value((Object)parent);
            cache.put(parent, res);
        }
        return res;
    }

    public static boolean processCandidates(JBIterable<DasObject> candidates, Condition<? super DasObject> expandCondition, Processor<? super DasObject> processor) {
        HashMap<DasObject, Boolean> cache = new HashMap<DasObject, Boolean>();
        for (DasObject candidate : candidates) {
            if (!DbImplUtil.isChildrenAccessible(candidate.getDasParent(), candidate, cache, expandCondition) || processor.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@Nullable DasColumn dasColumn, @NotNull Dbms dbms) {
        EnumSet<ReservedCellValue> opts;
        if (dbms == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        return (opts = DbImplUtil.getSpecialValues(dasColumn, dbms)).contains(ReservedCellValue.UNSET) ? ReservedCellValue.UNSET : (opts.contains(ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains(ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (opts.contains(ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains(ReservedCellValue.NULL) ? ReservedCellValue.NULL : null))));
    }

    @NotNull
    public static String simplify(@NotNull String name) {
        if (name == null) {
            DbImplUtil.$$$reportNull$$$0(75);
        }
        return DbImplUtil.simplify(name, true);
    }

    @NotNull
    public static String simplify(@NotNull String name, boolean lowercase) {
        if (name == null) {
            DbImplUtil.$$$reportNull$$$0(76);
        }
        String ascii = Unidecode.decode((String)name);
        String lowered = lowercase ? StringUtil.toLowerCase((String)ascii) : ascii;
        String underscored = lowered.replaceAll("[^0-9a-zA-Z]", "_");
        String deduplicated = underscored.replaceAll("_+", "_");
        String string = StringUtil.trim((String)deduplicated, c -> c != '_');
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 16, 18, 20, 23, 39, 40, 50, 56, 57, 59, 66, 67, 72, 77 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 39: 
            case 40: 
            case 50: 
            case 56: 
            case 57: 
            case 59: 
            case 66: 
            case 67: 
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 2: 
            case 9: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 17: 
            case 24: 
            case 38: 
            case 41: 
            case 62: 
            case 65: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 26: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnection";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesList";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 1: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKindVariant";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSourcesForExec";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataSourcesForExec";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPathPresentation";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 39: 
            case 40: 
            case 50: 
            case 56: 
            case 57: 
            case 59: 
            case 66: 
            case 67: 
            case 72: 
            case 77: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConnectionCount";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "supportsDbmsOutput";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findDataVirtualFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchTo";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathSql";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "switchSchemaThroughJdbc";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeOnTheFly";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetReadOnly";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "supportsReadOnlyChangeDuringTx";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findDataSourceByFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "defaultWhereCondition";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTableKindVariant";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageDialectForExec";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialectForExec";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialectForExec";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getForcedDataSourceForExec";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSourcesForExec";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAllDataSourcesForExec";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setActionCallbackDone";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialValues";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPathToSwitch";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isNotTruncated";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 16, 18, 20, 23, 39, 40, 50, 56, 57, 59, 66, 67, 72, 77 -> new IllegalStateException(string);
        };
    }
}

