/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.datagrid.CoreDatabaseGridDataHookUp;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.util.Key;
import com.intellij.util.ThreeState;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridUtilCore
extends GridUtilCore {
    public static final String DISABLED_SAMPLING_SIZE = "DISABLED";
    public static final Key<String> TABLE_SAMPLING_SIZE_KEY = new Key("TABLE_SAMPLING_SIZE_KEY");

    @Nullable
    public static String getTableSamplingSize(@NotNull CoreGrid<?, ?> grid) {
        String size;
        if (grid == null) {
            DataGridUtilCore.$$$reportNull$$$0(0);
        }
        size = (size = (String)grid.getUserData(TABLE_SAMPLING_SIZE_KEY)) != null ? size : DatabaseSettings.getSettings().getTableSamplingSize();
        grid.putUserData(TABLE_SAMPLING_SIZE_KEY, (Object)size);
        return DISABLED_SAMPLING_SIZE.equals(size) ? null : size;
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@Nullable CoreGrid<GridRow, GridColumn> grid, @Nullable GridColumn column) {
        CoreDatabaseGridDataHookUp hookup = (CoreDatabaseGridDataHookUp)DataGridUtilCore.getHookUp(grid, CoreDatabaseGridDataHookUp.class);
        return hookup != null ? hookup.getDatabaseColumn(column) : null;
    }

    @Contract(value="null->null;!null->_")
    public static DasObject getDatabaseTable(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        CoreDatabaseGridDataHookUp hookup = (CoreDatabaseGridDataHookUp)DataGridUtilCore.getHookUp(grid, CoreDatabaseGridDataHookUp.class);
        return hookup != null ? hookup.getDatabaseTable() : null;
    }

    @Nullable
    public static String formatValue(@Nullable GridColumn column, @NotNull ObjectFormatter objectFormatter, @NotNull Dbms dbms, @Nullable Object value) {
        if (objectFormatter == null) {
            DataGridUtilCore.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            DataGridUtilCore.$$$reportNull$$$0(2);
        }
        return column == null ? (value == null ? null : value.toString()) : objectFormatter.objectToString(value, column, DatabaseObjectFormatterConfig.get((ObjectFormatterMode)PredicatesHelperKt.predicatesHelper(dbms).getMode()));
    }

    public static BiFunction<Object, Object, ThreeState> numberEqualsInner(@NotNull Dbms dbms) {
        if (dbms == null) {
            DataGridUtilCore.$$$reportNull$$$0(3);
        }
        return (v1, v2) -> {
            ThreeState result = GridCellEditorHelper.numberEquals((Object)v1, (Object)v2);
            return result == ThreeState.YES && dbms.is(Dbms.MONGO) ? ThreeState.NO : result;
        };
    }

    @Contract(pure=true)
    @NotNull
    public static Dbms getDbms(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        CoreDatabaseGridDataHookUp hookup = DataGridUtilCore.getDatabaseHookUp(grid);
        Dbms dbms = hookup == null ? Dbms.UNKNOWN : hookup.getDbms();
        if (dbms == null) {
            DataGridUtilCore.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @Nullable
    public static DbDataSource getDatabaseSystem(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        CoreDatabaseGridDataHookUp hookup = DataGridUtilCore.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDataSource() : null;
    }

    public static CoreDatabaseGridDataHookUp getDatabaseHookUp(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        return (CoreDatabaseGridDataHookUp)DataGridUtilCore.getHookUp(grid, CoreDatabaseGridDataHookUp.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridUtilCore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtilCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTableSamplingSize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "numberEqualsInner";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

