/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.DbmsExtension;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class GeoHelper {
    protected static final Logger LOG = Logger.getInstance(GeoHelper.class);
    public static final DbmsExtension<GeoHelper> EP = new DbmsExtension("com.intellij.database.geoHelper");

    public boolean isGeoType(@NotNull String type) {
        if (type == null) {
            GeoHelper.$$$reportNull$$$0(0);
        }
        return type.equalsIgnoreCase("geometry") || type.equalsIgnoreCase("geography");
    }

    public String extractGeometryAsWkt(Object data, @Nullable GridColumn column) {
        return (String)ObjectUtils.tryCast((Object)data, String.class);
    }

    @NotNull
    public byte[] extractBinaryFromWkt(@NotNull String data, int position) throws java.text.ParseException {
        byte[] byArray;
        if (data == null) {
            GeoHelper.$$$reportNull$$$0(1);
        }
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(data);
            WKBWriter wkbWriter = new WKBWriter();
            byArray = wkbWriter.write(geometry);
        }
        catch (Throwable e) {
            throw new java.text.ParseException(e.getMessage(), position);
        }
        if (byArray == null) {
            GeoHelper.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    @NotNull
    public String getDmlForWkt(@NotNull String wkt) {
        if (wkt == null) {
            GeoHelper.$$$reportNull$$$0(3);
        }
        String string = String.format("ST_GeomFromText('%s')", wkt);
        if (string == null) {
            GeoHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String hexWkb2Wkt(@NotNull String data) {
        if (data == null) {
            GeoHelper.$$$reportNull$$$0(5);
        }
        try {
            return GeoHelper.wkb2Wkt(WKBReader.hexToBytes((String)data));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String wkb2Wkt(byte @NotNull [] data) {
        if (data == null) {
            GeoHelper.$$$reportNull$$$0(6);
        }
        return GeoHelper.wkb2WktInner(new ByteArrayInStream(data));
    }

    public static String reProjectWkt(String src, int srid) {
        if (srid == 4326) {
            return src;
        }
        try {
            return GeoHelper.toWkt(new WKTReader(new GeometryFactory(new PrecisionModel(), srid)).read(src));
        }
        catch (Throwable th) {
            LOG.warn(th);
            return src;
        }
    }

    @Nullable
    protected static String wkb2WktInner(ByteArrayInStream stream) {
        Geometry geometry = GeoHelper.wkb2Geom(stream);
        return GeoHelper.toWkt(geometry);
    }

    @Nullable
    private static String toWkt(Geometry geometry) {
        return geometry == null ? null : new WKTWriter().write(CrsHelper.toSrid4326(geometry));
    }

    @Nullable
    protected static Geometry wkb2Geom(ByteArrayInStream stream) {
        try {
            return new WKBReader().read((InStream)stream);
        }
        catch (IOException | ParseException e) {
            LOG.warn(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/GeoHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wkt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/GeoHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBinaryFromWkt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDmlForWkt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGeoType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractBinaryFromWkt";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDmlForWkt";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hexWkb2Wkt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wkb2Wkt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static final class CrsHelper {
        private static final CoordinateReferenceSystem NULL_CRS = CoordinateReferenceSystem.CS_GEO;
        private static final Function<Geometry, Geometry> NULL_TRF = g -> g;
        private static final Map<Integer, CoordinateReferenceSystem> ourCrsCache = ConcurrentFactoryMap.create(CrsHelper::findCrs, CollectionFactory::createConcurrentSoftValueMap);
        private static final Map<Integer, Function<Geometry, Geometry>> ourTrfCache = ConcurrentFactoryMap.create(CrsHelper::findTransform, CollectionFactory::createConcurrentSoftValueMap);
        private static final GeometryFactory ourFactory = new GeometryFactory(new PrecisionModel(), 4326);

        public static Geometry toSrid4326(Geometry geom) {
            int srid = geom.getSRID();
            if (srid == 4326 || srid <= 0) {
                return geom;
            }
            Function<Geometry, Geometry> transform = ourTrfCache.get(srid);
            if (transform == NULL_TRF) {
                return geom;
            }
            try {
                return transform.apply(geom);
            }
            catch (Throwable th) {
                LOG.warn(th);
                return geom;
            }
        }

        private static CoordinateReferenceSystem findCrs(int srid) {
            CRSFactory factory = new CRSFactory();
            try {
                return factory.createFromName("epsg:" + srid);
            }
            catch (Throwable th) {
                LOG.warn(th);
                return NULL_CRS;
            }
        }

        private static Function<Geometry, Geometry> findTransform(int srid) {
            CoordinateReferenceSystem srcCrs = ourCrsCache.get(srid);
            if (srcCrs == NULL_CRS) {
                return NULL_TRF;
            }
            CoordinateReferenceSystem tgtCrs = ourCrsCache.get(4326);
            if (tgtCrs == NULL_CRS) {
                return NULL_TRF;
            }
            final CoordinateTransform transform = new CoordinateTransformFactory().createTransform(srcCrs, tgtCrs);
            return geom -> new GeometryTransformer(){

                protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
                    if (this.factory != ourFactory) {
                        this.factory = ourFactory;
                    }
                    CoordinateSequence res = this.copy(coords);
                    ProjCoordinate from = new ProjCoordinate();
                    ProjCoordinate to = new ProjCoordinate();
                    int e = res.size();
                    for (int i2 = 0; i2 < e; ++i2) {
                        from.setValue(res.getX(i2), res.getY(i2), res.getZ(i2));
                        transform.transform(from, to);
                        res.setOrdinate(i2, 0, to.x);
                        res.setOrdinate(i2, 1, to.y);
                    }
                    return res;
                }
            }.transform(geom);
        }
    }
}

