/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicIdReference
implements BasicReference {
    private final long objectId;

    private BasicIdReference(long objectId) {
        this.objectId = objectId;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicIdReference)) {
            return false;
        }
        BasicIdReference reference = (BasicIdReference)o;
        return this.objectId == reference.objectId;
    }

    public int hashCode() {
        return Objects.hash(this.objectId);
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target) {
        if (source == null) {
            BasicIdReference.$$$reportNull$$$0(0);
        }
        if (meta == null) {
            BasicIdReference.$$$reportNull$$$0(1);
        }
        if (target == null) {
            BasicIdReference.$$$reportNull$$$0(2);
        }
        return target instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)target).getObjectId() == this.objectId;
    }

    @Nullable
    public static BasicIdReference create(long objectId) {
        return BasicIdReference.isDefault(objectId) ? null : new BasicIdReference(objectId);
    }

    public static boolean isDefault(long objectId) {
        return objectId == Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        BasicElement root;
        if (source == null) {
            BasicIdReference.$$$reportNull$$$0(3);
        }
        if (meta == null) {
            BasicIdReference.$$$reportNull$$$0(4);
        }
        if (assistant == null) {
            BasicIdReference.$$$reportNull$$$0(5);
        }
        if (meta.targets.length == 0) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicIdReference.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        BasicElement base = BasicMetaUtils.getResolveBase(source, meta, assistant);
        if (base == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicIdReference.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        BasicElement basicElement = root = meta.getBaseRef() == null ? assistant.getRoot(base, meta.getScope()) : base;
        if (root == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicIdReference.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        JBIterable<T> jBIterable = assistant.findAllById(root, this.objectId, meta);
        if (jBIterable == null) {
            BasicIdReference.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicIdReference.$$$reportNull$$$0(10);
        }
        BasicIdReference.exportId(this.objectId, "Id", consumer);
    }

    @Nullable
    public static BasicIdReference importProperties(@NotNull NameValueGetter<String> properties) {
        if (properties == null) {
            BasicIdReference.$$$reportNull$$$0(11);
        }
        return BasicIdReference.create(BasicIdReference.importId("Id", properties));
    }

    public static long importId(String propName, @NotNull NameValueGetter<String> properties) {
        String id;
        if (properties == null) {
            BasicIdReference.$$$reportNull$$$0(12);
        }
        return (id = properties.get(propName)) == null ? Long.MIN_VALUE : StringUtil.parseLong((String)id, (long)Long.MIN_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static void exportId(long id, String propName, @NotNull NameValueConsumer<? super String> nameValueConsumer) {
        if (nameValueConsumer == null) {
            BasicIdReference.$$$reportNull$$$0(13);
        }
        if (!BasicIdReference.isDefault(id)) {
            void consumer;
            consumer.accept(propName, Long.toString(id));
        }
    }

    public String toString() {
        return "id=" + this.objectId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicIdReference";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicIdReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "importId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

