/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure.forest;

import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.structure.forest.DvArm;
import com.intellij.database.view.structure.forest.DvFolder;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0007J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\r\u0010'\u001a\u00070\"\u00a2\u0006\u0002\b(H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\u0012\u0010*\u001a\u00020\u001f2\b\b\u0002\u0010+\u001a\u00020\u001cH\u0007R\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006,"}, d2={"Lcom/intellij/database/view/structure/forest/DvBushRef;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "Lcom/intellij/database/view/structure/forest/DvArm;", "parent", "Lcom/intellij/database/view/structure/forest/DvFolder;", "orderId", "", "bush", "<init>", "(Lcom/intellij/database/view/structure/forest/DvFolder;ILcom/intellij/database/model/basic/BasicUniqueBush;)V", "level", "getLevel", "()I", "value", "getParent", "()Lcom/intellij/database/view/structure/forest/DvFolder;", "position", "getPosition", "setPosition$intellij_database_core_impl", "(I)V", "getOrderId", "setOrderId", "bushRef", "Ljava/lang/ref/WeakReference;", "getBush", "()Lcom/intellij/database/model/basic/BasicUniqueBush;", "isValid", "", "()Z", "assignParent", "", "newParent", "name", "", "getName", "()Ljava/lang/String;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "Lcom/intellij/openapi/util/NlsSafe;", "toString", "drop", "deregister", "intellij.database.core.impl"})
public final class DvBushRef<B extends BasicUniqueBush>
extends DvArm {
    @NotNull
    private DvFolder parent;
    private int position;
    private int orderId;
    @NotNull
    private final WeakReference<B> bushRef;

    @Override
    public int getLevel() {
        return this.getParent().getLevel() + 1;
    }

    @Override
    @NotNull
    public DvFolder getParent() {
        return this.parent;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition$intellij_database_core_impl(int n) {
        this.position = n;
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    public void setOrderId(int n) {
        this.orderId = n;
    }

    @Nullable
    public final B getBush() {
        return (B)((BasicUniqueBush)this.bushRef.get());
    }

    public final boolean isValid() {
        return this.bushRef.get() != null;
    }

    public DvBushRef(@NotNull DvFolder parent, int orderId, @NotNull B bush) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        super(parent.forest, null);
        this.position = Integer.MAX_VALUE;
        this.orderId = -1;
        this.parent = parent;
        this.setOrderId(orderId);
        this.bushRef = new WeakReference<B>(bush);
        this.forest.adjustOrderId$intellij_database_core_impl(orderId);
    }

    @ApiStatus.Internal
    public final void assignParent(@NotNull DvFolder newParent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        boolean bl2 = bl = newParent.forest == this.forest;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.forest.checkModifyingThread$intellij_database_core_impl();
        this.parent = newParent;
    }

    @Override
    @NotNull
    public String getName() {
        Object object = this.getBush();
        if (object == null || (object = ((BasicNode)object).getDisplayName()) == null) {
            object = "<none>";
        }
        return object;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        B b = this.getBush();
        return b != null ? ((BasicNode)b).getModel() : null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        Object object = this.getBush();
        if (object == null || (object = ((BasicNode)object).getDisplayName()) == null) {
            object = "<disposed bush>";
        }
        return object;
    }

    @NotNull
    public String toString() {
        BasicUniqueBush bush = (BasicUniqueBush)this.bushRef.get();
        Object object = bush;
        if (object == null || (object = object.getName()) == null) {
            object = "<disposed>";
        }
        Object bushName = object;
        int parentOrderId = this.getParent().getOrderId();
        BasicUniqueBush basicUniqueBush = bush;
        return this.getOrderId() + ":" + parentOrderId + ":BUSH(" + (basicUniqueBush != null ? basicUniqueBush.getUniqueId() : null) + ":" + (String)bushName + ")";
    }

    @TestOnly
    public final void drop(boolean deregister) {
        if (deregister) {
            this.forest.deregisterBush(this);
        }
        this.bushRef.clear();
    }

    public static /* synthetic */ void drop$default(DvBushRef dvBushRef, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        dvBushRef.drop(bl);
    }
}

