/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cloudExplorer;

import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionDataStorageImplKt;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.database.cloudExplorer.UnknownCloudConnectionData;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorageImpl;", "", "<init>", "()V", "connectionsData", "", "Lcom/intellij/database/cloudExplorer/CloudConnectionData;", "unknownConnectionData", "getConnectionData", "id", "", "removeConnectionData", "", "target", "getConnectionsData", "", "update", "updateConnectionData", "existingProvidersId", "", "getState", "Lorg/jdom/Element;", "loadState", "state", "add", "cloud", "findById", "createCloudElementContainer", "addToUnknown", "createUnknown", "existing", "copyState", "to", "from", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nCloudConnectionDataStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConnectionDataStorageImpl.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorageImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class CloudConnectionDataStorageImpl {
    @NotNull
    private List<CloudConnectionData> connectionsData;
    @NotNull
    private List<CloudConnectionData> unknownConnectionData;

    public CloudConnectionDataStorageImpl() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.connectionsData = list;
        this.unknownConnectionData = new ArrayList();
    }

    @Nullable
    public final CloudConnectionData getConnectionData(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.findById(id);
    }

    public final void removeConnectionData(@NotNull CloudConnectionData target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String targetId = target.getId();
        if (!this.connectionsData.removeIf(arg_0 -> CloudConnectionDataStorageImpl.removeConnectionData$lambda$1(arg_0 -> CloudConnectionDataStorageImpl.removeConnectionData$lambda$0(targetId, arg_0), arg_0))) {
            this.unknownConnectionData.removeIf(arg_0 -> CloudConnectionDataStorageImpl.removeConnectionData$lambda$3(arg_0 -> CloudConnectionDataStorageImpl.removeConnectionData$lambda$2(targetId, arg_0), arg_0));
        }
    }

    @NotNull
    public final List<CloudConnectionData> getConnectionsData() {
        return CollectionsKt.toList((Iterable)this.connectionsData);
    }

    public final void update(@NotNull CloudConnectionData target) {
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            CloudConnectionData existing = this.findById(target.getId());
            if (existing != null) {
                return;
            }
            Iterable iterable = this.unknownConnectionData;
            for (Object t : iterable) {
                CloudConnectionData it = (CloudConnectionData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)target.getId())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        CloudConnectionData existingInUnknown = v0;
        if (existingInUnknown == null) {
            if (target instanceof UnknownCloudConnectionData) {
                CloudConnectionDataStorageImplKt.access$getLog$p().error("Trying to add unknown cloud connection data: " + ((UnknownCloudConnectionData)target).getCloudProviderId() + ", " + ((UnknownCloudConnectionData)target).getId());
                this.addToUnknown(target);
            } else {
                this.add(target);
            }
        } else {
            existingInUnknown.load(target.save(this.createCloudElementContainer()));
        }
    }

    public final void updateConnectionData(@NotNull Set<String> existingProvidersId) {
        CloudConnectionData loadedConnectionData;
        Intrinsics.checkNotNullParameter(existingProvidersId, (String)"existingProvidersId");
        List newConnectionData = new ArrayList();
        List newUnknownConnectionData = new ArrayList();
        for (CloudConnectionData existing : this.connectionsData) {
            boolean bl;
            if (!existingProvidersId.contains(existing.getCloudProviderId())) {
                bl = newUnknownConnectionData.add(this.createUnknown(existing));
                continue;
            }
            loadedConnectionData = CloudDataSourceProvider.Companion.createConnectionData(existing.getCloudProviderId());
            if (loadedConnectionData == null) {
                newUnknownConnectionData.add(this.createUnknown(existing));
                continue;
            }
            bl = newConnectionData.add(this.copyState(loadedConnectionData, existing));
        }
        for (CloudConnectionData unknowData : this.unknownConnectionData) {
            boolean bl;
            if (existingProvidersId.contains(unknowData.getCloudProviderId())) {
                loadedConnectionData = CloudDataSourceProvider.Companion.createConnectionData(unknowData.getCloudProviderId());
                if (loadedConnectionData == null) {
                    newUnknownConnectionData.add(unknowData);
                    continue;
                }
                bl = newConnectionData.add(this.copyState(loadedConnectionData, unknowData));
                continue;
            }
            bl = newUnknownConnectionData.add(unknowData);
        }
        this.connectionsData = newConnectionData;
        this.unknownConnectionData = newUnknownConnectionData;
    }

    @NotNull
    public final Element getState() {
        Element clouds = new Element("clouds");
        for (CloudConnectionData cloud : this.connectionsData) {
            clouds.addContent(cloud.save(this.createCloudElementContainer()));
        }
        for (CloudConnectionData cloud : this.unknownConnectionData) {
            clouds.addContent(cloud.save(this.createCloudElementContainer()));
        }
        return clouds;
    }

    public final void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.connectionsData.clear();
        this.unknownConnectionData.clear();
        for (Element cloud : state.getChildren("cloud")) {
            CloudConnectionData data;
            String cloudProviderId = cloud.getAttributeValue("cloudProviderId");
            if (cloudProviderId == null) {
                CloudConnectionDataStorageImplKt.access$getLog$p().warn("Cloud provider id is not specified");
                continue;
            }
            String id = cloud.getAttributeValue("id");
            if (id == null) {
                CloudConnectionDataStorageImplKt.access$getLog$p().warn("Cloud id is not specified");
                continue;
            }
            CloudConnectionData cloudConnectionData = CloudDataSourceProvider.Companion.createConnectionData(cloudProviderId);
            if (cloudConnectionData != null) {
                Intrinsics.checkNotNull((Object)cloud);
                v1 = cloudConnectionData.load(cloud);
            } else {
                v1 = data = null;
            }
            if (data == null) {
                CloudConnectionDataStorageImplKt.access$getLog$p().warn("Failed to load cloud connection data for provider '" + cloudProviderId + "'");
                UnknownCloudConnectionData unknownCloudConnectionData = new UnknownCloudConnectionData(cloudProviderId, id);
                Intrinsics.checkNotNull((Object)cloud);
                this.addToUnknown(unknownCloudConnectionData.load(cloud));
                continue;
            }
            this.add(data);
        }
    }

    private final void add(CloudConnectionData cloud) {
        this.connectionsData.add(cloud);
    }

    private final CloudConnectionData findById(String id) {
        Object v0;
        block1: {
            Iterable iterable = this.connectionsData;
            for (Object t : iterable) {
                CloudConnectionData it = (CloudConnectionData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Element createCloudElementContainer() {
        return new Element("cloud");
    }

    private final void addToUnknown(CloudConnectionData cloud) {
        this.unknownConnectionData.add(cloud);
    }

    private final CloudConnectionData createUnknown(CloudConnectionData existing) {
        return this.copyState(new UnknownCloudConnectionData(existing.getCloudProviderId(), existing.getId()), existing);
    }

    private final CloudConnectionData copyState(CloudConnectionData to, CloudConnectionData from) {
        to.load(from.save(this.createCloudElementContainer()));
        return to;
    }

    private static final boolean removeConnectionData$lambda$0(String $targetId, CloudConnectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$targetId);
    }

    private static final boolean removeConnectionData$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeConnectionData$lambda$2(String $targetId, CloudConnectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$targetId);
    }

    private static final boolean removeConnectionData$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

