/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEditorTracker
implements Disposable {
    private final DbEditorController myController;
    private final Set<DbEditor<?, ?>> myModified;
    private String myAssertionOnModification;

    public DbEditorTracker(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbEditorTracker.$$$reportNull$$$0(0);
        }
        this.myModified = new LinkedHashSet();
        this.myController = controller;
        Disposer.register((Disposable)this.myController, (Disposable)this);
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorListener(){

            @Override
            public void created(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbEditorTracker.this.add(editor2);
            }

            @Override
            public void modified(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbEditorTracker.this.add(editor2);
            }

            @Override
            public void removed(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbEditorTracker.this.myModified.remove(editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private void add(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbEditorTracker.$$$reportNull$$$0(1);
        }
        this.myModified.add(editor2);
        if (this.myAssertionOnModification != null) {
            throw new AssertionError((Object)this.myAssertionOnModification);
        }
    }

    public void setAssertionOnModification(@Nullable String assertionOnModification) {
        this.myAssertionOnModification = assertionOnModification;
    }

    @NotNull
    public Iterable<DbEditor<?, ?>> getModified() {
        Set<DbEditor<?, ?>> set = this.myModified;
        if (set == null) {
            DbEditorTracker.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean hasModifications() {
        return !this.myModified.isEmpty();
    }

    public void clearModified() {
        this.myModified.clear();
    }

    public void modifyAll() {
        this.myModified.clear();
        ContainerUtil.addAll(this.myModified, this.myController.getAllEditors());
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbEditorTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEditorTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

