/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.common;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012J\u0015\u0010\u001f\u001a\u00020\u00042\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/database/util/common/TimeAggEntry;", "K", "", "order", "", "key", "<init>", "(ILjava/lang/Object;)V", "getOrder", "()I", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "syncLock", "Ljava/lang/Object;", "value", "count", "getCount", "", "min", "getMin", "()J", "max", "getMax", "sum", "getSum", "avg", "getAvg", "considerDuration", "", "duration", "compareTo", "other", "toString", "", "intellij.database.util"})
public final class TimeAggEntry<K>
implements Comparable<TimeAggEntry<?>> {
    private final int order;
    private final K key;
    @NotNull
    private final Object syncLock;
    private int count;
    private long min;
    private long max;
    private long sum;

    public TimeAggEntry(int order, K key) {
        this.order = order;
        this.key = key;
        this.syncLock = new Object();
    }

    public final int getOrder() {
        return this.order;
    }

    public final K getKey() {
        return this.key;
    }

    public final int getCount() {
        return this.count;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final long getSum() {
        return this.sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getAvg() {
        Object object = this.syncLock;
        synchronized (object) {
            int cnt;
            block4: {
                boolean bl = false;
                cnt = this.count;
                if (cnt != 0) break block4;
                long l = 0L;
                return l;
            }
            long l = (this.sum + (long)(cnt / 2)) / (long)cnt;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void considerDuration(long duration) {
        Object object = this.syncLock;
        synchronized (object) {
            boolean bl = false;
            if (this.count == 0) {
                int n = this.count;
                this.count = n + 1;
                this.min = duration;
                this.max = duration;
                this.sum = duration;
            } else {
                int n = this.count;
                this.count = n + 1;
                if (duration < this.min) {
                    this.min = duration;
                }
                if (duration > this.max) {
                    this.max = duration;
                }
                this.sum += duration;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public int compareTo(@NotNull TimeAggEntry<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        int z = Intrinsics.compare((int)this.order, (int)other.order);
        if (z != 0) {
            return z;
        }
        z = String.valueOf(this.key).compareTo(String.valueOf(other.key));
        if (z != 0) {
            return z;
        }
        z = Intrinsics.compare((int)this.count, (int)other.count);
        if (z != 0) {
            return z;
        }
        z = Intrinsics.compare((long)this.min, (long)other.min);
        if (z != 0) {
            return z;
        }
        z = Intrinsics.compare((long)this.max, (long)other.max);
        if (z != 0) {
            return z;
        }
        z = Intrinsics.compare((long)this.sum, (long)other.sum);
        return z;
    }

    @NotNull
    public String toString() {
        return this.key + ": (" + this.min + ".." + this.getAvg() + ".." + this.max + ")*" + this.count + "=" + this.sum;
    }
}

