/*
 * Decompiled with CFR 0.152.
 */
package andel.intervals;

import andel.text.TextRange;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\u0006\b\u0001\u0010\u0002 \u00012\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0004\b\f\u0010\rB1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0004\b\f\u0010\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\u00020\t2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0000H\u0086\u0002J\u000e\u0010\u0016\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\u000e\u0010\u001c\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017JV\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0012\u0010\u0004\u001a\u00028\u00008\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00028\u00018\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\""}, d2={"Landel/intervals/Interval;", "K", "T", "", "id", "from", "", "to", "greedyLeft", "", "greedyRight", "data", "<init>", "(Ljava/lang/Object;JJZZLjava/lang/Object;)V", "range", "Landel/text/TextRange;", "(Ljava/lang/Object;Landel/text/TextRange;ZZLjava/lang/Object;)V", "Ljava/lang/Object;", "toString", "", "contains", "other", "component1", "()Ljava/lang/Object;", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/Object;JJZZLjava/lang/Object;)Landel/intervals/Interval;", "equals", "hashCode", "", "fleet.andel"})
public final class Interval<K, T> {
    @JvmField
    public final K id;
    @JvmField
    public final long from;
    @JvmField
    public final long to;
    @JvmField
    public final boolean greedyLeft;
    @JvmField
    public final boolean greedyRight;
    @JvmField
    public final T data;

    public Interval(K id, long from, long to, boolean greedyLeft, boolean greedyRight, T data) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.greedyLeft = greedyLeft;
        this.greedyRight = greedyRight;
        this.data = data;
        if (!(this.from == -1L || this.to == -1L || this.from <= this.to)) {
            boolean bl = false;
            String string2 = "Interval to <= from: " + this.to + " <= " + this.from;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public Interval(K id, @NotNull TextRange range, boolean greedyLeft, boolean greedyRight, T data) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(id, range.getStart(), range.getEnd(), greedyLeft, greedyRight, data);
    }

    @NotNull
    public String toString() {
        return "id=" + this.id + " " + (this.greedyLeft ? "[" : "(") + this.from + ", " + this.to + (this.greedyRight ? "]" : ")") + " " + this.data;
    }

    public final boolean contains(@NotNull Interval<Long, ?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other.from >= this.from && other.to <= this.to;
    }

    public final K component1() {
        return this.id;
    }

    public final long component2() {
        return this.from;
    }

    public final long component3() {
        return this.to;
    }

    public final boolean component4() {
        return this.greedyLeft;
    }

    public final boolean component5() {
        return this.greedyRight;
    }

    public final T component6() {
        return this.data;
    }

    @NotNull
    public final Interval<K, T> copy(K id, long from, long to, boolean greedyLeft, boolean greedyRight, T data) {
        return new Interval<K, T>(id, from, to, greedyLeft, greedyRight, data);
    }

    public static /* synthetic */ Interval copy$default(Interval interval, Object object, long l, long l2, boolean bl, boolean bl2, Object object2, int n, Object object3) {
        if ((n & 1) != 0) {
            object = interval.id;
        }
        if ((n & 2) != 0) {
            l = interval.from;
        }
        if ((n & 4) != 0) {
            l2 = interval.to;
        }
        if ((n & 8) != 0) {
            bl = interval.greedyLeft;
        }
        if ((n & 0x10) != 0) {
            bl2 = interval.greedyRight;
        }
        if ((n & 0x20) != 0) {
            object2 = interval.data;
        }
        return interval.copy(object, l, l2, bl, bl2, object2);
    }

    public int hashCode() {
        int result = this.id == null ? 0 : this.id.hashCode();
        result = result * 31 + Long.hashCode(this.from);
        result = result * 31 + Long.hashCode(this.to);
        result = result * 31 + Boolean.hashCode(this.greedyLeft);
        result = result * 31 + Boolean.hashCode(this.greedyRight);
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)other;
        if (!Intrinsics.areEqual(this.id, interval.id)) {
            return false;
        }
        if (this.from != interval.from) {
            return false;
        }
        if (this.to != interval.to) {
            return false;
        }
        if (this.greedyLeft != interval.greedyLeft) {
            return false;
        }
        if (this.greedyRight != interval.greedyRight) {
            return false;
        }
        return Intrinsics.areEqual(this.data, interval.data);
    }
}

