// GENERATED BY fleet.codepoints.test.CodepointRangesGeneratorKt
package fleet.codepoints

/**
 * Codepoints are derived from https://unicode.org/Public/UNIDATA/UnicodeData.txt
 */
internal val spaceCharRanges = intArrayOf(
  0x20,0x20,0xA0,0xA0,0x1680,0x1680,0x2000,0x200A,0x2028,0x2029,
  0x202F,0x202F,0x205F,0x205F,0x3000,0x3000,
)
/**
 * Codepoints are derived from https://www.unicode.org/Public/UCD/latest/ucd/DerivedCoreProperties.txt
 * DerivedCoreProperties-17.0.0.txt
 * Date: 2025-07-30, 23:55:08 GMT
 * © 2025 Unicode®, Inc.
 * Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * For terms of use and license, see https://www.unicode.org/terms_of_use.html
 * 
 * Unicode Character Database
 * For documentation, see https://www.unicode.org/reports/tr44/
 */
internal val unicodeIdStartRanges = intArrayOf(
  0x41, 0x5A, // L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
  0x61, 0x7A, // L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
  0xAA, 0xAA, // Lo       FEMININE ORDINAL INDICATOR
  0xB5, 0xB5, // L&       MICRO SIGN
  0xBA, 0xBA, // Lo       MASCULINE ORDINAL INDICATOR
  0xC0, 0xD6, // L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
  0xD8, 0xF6, // L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
  0xF8, 0x1BA, // L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
  0x1BB, 0x1BB, // Lo       LATIN LETTER TWO WITH STROKE
  0x1BC, 0x1BF, // L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
  0x1C0, 0x1C3, // Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
  0x1C4, 0x293, // L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
  0x294, 0x295, // Lo   [2] LATIN LETTER GLOTTAL STOP..LATIN LETTER PHARYNGEAL VOICED FRICATIVE
  0x296, 0x2AF, // L&  [26] LATIN LETTER INVERTED GLOTTAL STOP..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
  0x2B0, 0x2C1, // Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
  0x2C6, 0x2D1, // Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
  0x2E0, 0x2E4, // Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
  0x2EC, 0x2EC, // Lm       MODIFIER LETTER VOICING
  0x2EE, 0x2EE, // Lm       MODIFIER LETTER DOUBLE APOSTROPHE
  0x370, 0x373, // L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
  0x374, 0x374, // Lm       GREEK NUMERAL SIGN
  0x376, 0x377, // L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
  0x37A, 0x37A, // Lm       GREEK YPOGEGRAMMENI
  0x37B, 0x37D, // L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
  0x37F, 0x37F, // L&       GREEK CAPITAL LETTER YOT
  0x386, 0x386, // L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
  0x388, 0x38A, // L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
  0x38C, 0x38C, // L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
  0x38E, 0x3A1, // L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
  0x3A3, 0x3F5, // L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
  0x3F7, 0x481, // L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
  0x48A, 0x52F, // L& [166] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER EL WITH DESCENDER
  0x531, 0x556, // L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
  0x559, 0x559, // Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
  0x560, 0x588, // L&  [41] ARMENIAN SMALL LETTER TURNED AYB..ARMENIAN SMALL LETTER YI WITH STROKE
  0x5D0, 0x5EA, // Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
  0x5EF, 0x5F2, // Lo   [4] HEBREW YOD TRIANGLE..HEBREW LIGATURE YIDDISH DOUBLE YOD
  0x620, 0x63F, // Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
  0x640, 0x640, // Lm       ARABIC TATWEEL
  0x641, 0x64A, // Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
  0x66E, 0x66F, // Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
  0x671, 0x6D3, // Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
  0x6D5, 0x6D5, // Lo       ARABIC LETTER AE
  0x6E5, 0x6E6, // Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
  0x6EE, 0x6EF, // Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
  0x6FA, 0x6FC, // Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
  0x6FF, 0x6FF, // Lo       ARABIC LETTER HEH WITH INVERTED V
  0x710, 0x710, // Lo       SYRIAC LETTER ALAPH
  0x712, 0x72F, // Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
  0x74D, 0x7A5, // Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
  0x7B1, 0x7B1, // Lo       THAANA LETTER NAA
  0x7CA, 0x7EA, // Lo  [33] NKO LETTER A..NKO LETTER JONA RA
  0x7F4, 0x7F5, // Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
  0x7FA, 0x7FA, // Lm       NKO LAJANYALAN
  0x800, 0x815, // Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
  0x81A, 0x81A, // Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
  0x824, 0x824, // Lm       SAMARITAN MODIFIER LETTER SHORT A
  0x828, 0x828, // Lm       SAMARITAN MODIFIER LETTER I
  0x840, 0x858, // Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
  0x860, 0x86A, // Lo  [11] SYRIAC LETTER MALAYALAM NGA..SYRIAC LETTER MALAYALAM SSA
  0x870, 0x887, // Lo  [24] ARABIC LETTER ALEF WITH ATTACHED FATHA..ARABIC BASELINE ROUND DOT
  0x889, 0x88F, // Lo   [7] ARABIC LETTER NOON WITH INVERTED SMALL V..ARABIC LETTER NOON WITH RING ABOVE
  0x8A0, 0x8C8, // Lo  [41] ARABIC LETTER BEH WITH SMALL V BELOW..ARABIC LETTER GRAF
  0x8C9, 0x8C9, // Lm       ARABIC SMALL FARSI YEH
  0x904, 0x939, // Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
  0x93D, 0x93D, // Lo       DEVANAGARI SIGN AVAGRAHA
  0x950, 0x950, // Lo       DEVANAGARI OM
  0x958, 0x961, // Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
  0x971, 0x971, // Lm       DEVANAGARI SIGN HIGH SPACING DOT
  0x972, 0x980, // Lo  [15] DEVANAGARI LETTER CANDRA A..BENGALI ANJI
  0x985, 0x98C, // Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
  0x98F, 0x990, // Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
  0x993, 0x9A8, // Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
  0x9AA, 0x9B0, // Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
  0x9B2, 0x9B2, // Lo       BENGALI LETTER LA
  0x9B6, 0x9B9, // Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
  0x9BD, 0x9BD, // Lo       BENGALI SIGN AVAGRAHA
  0x9CE, 0x9CE, // Lo       BENGALI LETTER KHANDA TA
  0x9DC, 0x9DD, // Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
  0x9DF, 0x9E1, // Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
  0x9F0, 0x9F1, // Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
  0x9FC, 0x9FC, // Lo       BENGALI LETTER VEDIC ANUSVARA
  0xA05, 0xA0A, // Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
  0xA0F, 0xA10, // Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
  0xA13, 0xA28, // Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
  0xA2A, 0xA30, // Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
  0xA32, 0xA33, // Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
  0xA35, 0xA36, // Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
  0xA38, 0xA39, // Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
  0xA59, 0xA5C, // Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
  0xA5E, 0xA5E, // Lo       GURMUKHI LETTER FA
  0xA72, 0xA74, // Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
  0xA85, 0xA8D, // Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
  0xA8F, 0xA91, // Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
  0xA93, 0xAA8, // Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
  0xAAA, 0xAB0, // Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
  0xAB2, 0xAB3, // Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
  0xAB5, 0xAB9, // Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
  0xABD, 0xABD, // Lo       GUJARATI SIGN AVAGRAHA
  0xAD0, 0xAD0, // Lo       GUJARATI OM
  0xAE0, 0xAE1, // Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
  0xAF9, 0xAF9, // Lo       GUJARATI LETTER ZHA
  0xB05, 0xB0C, // Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
  0xB0F, 0xB10, // Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
  0xB13, 0xB28, // Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
  0xB2A, 0xB30, // Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
  0xB32, 0xB33, // Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
  0xB35, 0xB39, // Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
  0xB3D, 0xB3D, // Lo       ORIYA SIGN AVAGRAHA
  0xB5C, 0xB5D, // Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
  0xB5F, 0xB61, // Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
  0xB71, 0xB71, // Lo       ORIYA LETTER WA
  0xB83, 0xB83, // Lo       TAMIL SIGN VISARGA
  0xB85, 0xB8A, // Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
  0xB8E, 0xB90, // Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
  0xB92, 0xB95, // Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
  0xB99, 0xB9A, // Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
  0xB9C, 0xB9C, // Lo       TAMIL LETTER JA
  0xB9E, 0xB9F, // Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
  0xBA3, 0xBA4, // Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
  0xBA8, 0xBAA, // Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
  0xBAE, 0xBB9, // Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
  0xBD0, 0xBD0, // Lo       TAMIL OM
  0xC05, 0xC0C, // Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
  0xC0E, 0xC10, // Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
  0xC12, 0xC28, // Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
  0xC2A, 0xC39, // Lo  [16] TELUGU LETTER PA..TELUGU LETTER HA
  0xC3D, 0xC3D, // Lo       TELUGU SIGN AVAGRAHA
  0xC58, 0xC5A, // Lo   [3] TELUGU LETTER TSA..TELUGU LETTER RRRA
  0xC5C, 0xC5D, // Lo   [2] TELUGU ARCHAIC SHRII..TELUGU LETTER NAKAARA POLLU
  0xC60, 0xC61, // Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
  0xC80, 0xC80, // Lo       KANNADA SIGN SPACING CANDRABINDU
  0xC85, 0xC8C, // Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
  0xC8E, 0xC90, // Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
  0xC92, 0xCA8, // Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
  0xCAA, 0xCB3, // Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
  0xCB5, 0xCB9, // Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
  0xCBD, 0xCBD, // Lo       KANNADA SIGN AVAGRAHA
  0xCDC, 0xCDE, // Lo   [3] KANNADA ARCHAIC SHRII..KANNADA LETTER FA
  0xCE0, 0xCE1, // Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
  0xCF1, 0xCF2, // Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
  0xD04, 0xD0C, // Lo   [9] MALAYALAM LETTER VEDIC ANUSVARA..MALAYALAM LETTER VOCALIC L
  0xD0E, 0xD10, // Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
  0xD12, 0xD3A, // Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
  0xD3D, 0xD3D, // Lo       MALAYALAM SIGN AVAGRAHA
  0xD4E, 0xD4E, // Lo       MALAYALAM LETTER DOT REPH
  0xD54, 0xD56, // Lo   [3] MALAYALAM LETTER CHILLU M..MALAYALAM LETTER CHILLU LLL
  0xD5F, 0xD61, // Lo   [3] MALAYALAM LETTER ARCHAIC II..MALAYALAM LETTER VOCALIC LL
  0xD7A, 0xD7F, // Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
  0xD85, 0xD96, // Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
  0xD9A, 0xDB1, // Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
  0xDB3, 0xDBB, // Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
  0xDBD, 0xDBD, // Lo       SINHALA LETTER DANTAJA LAYANNA
  0xDC0, 0xDC6, // Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
  0xE01, 0xE30, // Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
  0xE32, 0xE33, // Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
  0xE40, 0xE45, // Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
  0xE46, 0xE46, // Lm       THAI CHARACTER MAIYAMOK
  0xE81, 0xE82, // Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
  0xE84, 0xE84, // Lo       LAO LETTER KHO TAM
  0xE86, 0xE8A, // Lo   [5] LAO LETTER PALI GHA..LAO LETTER SO TAM
  0xE8C, 0xEA3, // Lo  [24] LAO LETTER PALI JHA..LAO LETTER LO LING
  0xEA5, 0xEA5, // Lo       LAO LETTER LO LOOT
  0xEA7, 0xEB0, // Lo  [10] LAO LETTER WO..LAO VOWEL SIGN A
  0xEB2, 0xEB3, // Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
  0xEBD, 0xEBD, // Lo       LAO SEMIVOWEL SIGN NYO
  0xEC0, 0xEC4, // Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
  0xEC6, 0xEC6, // Lm       LAO KO LA
  0xEDC, 0xEDF, // Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
  0xF00, 0xF00, // Lo       TIBETAN SYLLABLE OM
  0xF40, 0xF47, // Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
  0xF49, 0xF6C, // Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
  0xF88, 0xF8C, // Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
  0x1000, 0x102A, // Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
  0x103F, 0x103F, // Lo       MYANMAR LETTER GREAT SA
  0x1050, 0x1055, // Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
  0x105A, 0x105D, // Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
  0x1061, 0x1061, // Lo       MYANMAR LETTER SGAW KAREN SHA
  0x1065, 0x1066, // Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
  0x106E, 0x1070, // Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
  0x1075, 0x1081, // Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
  0x108E, 0x108E, // Lo       MYANMAR LETTER RUMAI PALAUNG FA
  0x10A0, 0x10C5, // L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
  0x10C7, 0x10C7, // L&       GEORGIAN CAPITAL LETTER YN
  0x10CD, 0x10CD, // L&       GEORGIAN CAPITAL LETTER AEN
  0x10D0, 0x10FA, // L&  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
  0x10FC, 0x10FC, // Lm       MODIFIER LETTER GEORGIAN NAR
  0x10FD, 0x10FF, // L&   [3] GEORGIAN LETTER AEN..GEORGIAN LETTER LABIAL SIGN
  0x1100, 0x1248, // Lo [329] HANGUL CHOSEONG KIYEOK..ETHIOPIC SYLLABLE QWA
  0x124A, 0x124D, // Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
  0x1250, 0x1256, // Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
  0x1258, 0x1258, // Lo       ETHIOPIC SYLLABLE QHWA
  0x125A, 0x125D, // Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
  0x1260, 0x1288, // Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
  0x128A, 0x128D, // Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
  0x1290, 0x12B0, // Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
  0x12B2, 0x12B5, // Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
  0x12B8, 0x12BE, // Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
  0x12C0, 0x12C0, // Lo       ETHIOPIC SYLLABLE KXWA
  0x12C2, 0x12C5, // Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
  0x12C8, 0x12D6, // Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
  0x12D8, 0x1310, // Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
  0x1312, 0x1315, // Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
  0x1318, 0x135A, // Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
  0x1380, 0x138F, // Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
  0x13A0, 0x13F5, // L&  [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
  0x13F8, 0x13FD, // L&   [6] CHEROKEE SMALL LETTER YE..CHEROKEE SMALL LETTER MV
  0x1401, 0x166C, // Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
  0x166F, 0x167F, // Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
  0x1681, 0x169A, // Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
  0x16A0, 0x16EA, // Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
  0x16EE, 0x16F0, // Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
  0x16F1, 0x16F8, // Lo   [8] RUNIC LETTER K..RUNIC LETTER FRANKS CASKET AESC
  0x1700, 0x1711, // Lo  [18] TAGALOG LETTER A..TAGALOG LETTER HA
  0x171F, 0x1731, // Lo  [19] TAGALOG LETTER ARCHAIC RA..HANUNOO LETTER HA
  0x1740, 0x1751, // Lo  [18] BUHID LETTER A..BUHID LETTER HA
  0x1760, 0x176C, // Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
  0x176E, 0x1770, // Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
  0x1780, 0x17B3, // Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
  0x17D7, 0x17D7, // Lm       KHMER SIGN LEK TOO
  0x17DC, 0x17DC, // Lo       KHMER SIGN AVAKRAHASANYA
  0x1820, 0x1842, // Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
  0x1843, 0x1843, // Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
  0x1844, 0x1878, // Lo  [53] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER CHA WITH TWO DOTS
  0x1880, 0x1884, // Lo   [5] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
  0x1885, 0x1886, // Mn   [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
  0x1887, 0x18A8, // Lo  [34] MONGOLIAN LETTER ALI GALI A..MONGOLIAN LETTER MANCHU ALI GALI BHA
  0x18AA, 0x18AA, // Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
  0x18B0, 0x18F5, // Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
  0x1900, 0x191E, // Lo  [31] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER TRA
  0x1950, 0x196D, // Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
  0x1970, 0x1974, // Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
  0x1980, 0x19AB, // Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
  0x19B0, 0x19C9, // Lo  [26] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE TONE MARK-2
  0x1A00, 0x1A16, // Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
  0x1A20, 0x1A54, // Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
  0x1AA7, 0x1AA7, // Lm       TAI THAM SIGN MAI YAMOK
  0x1B05, 0x1B33, // Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
  0x1B45, 0x1B4C, // Lo   [8] BALINESE LETTER KAF SASAK..BALINESE LETTER ARCHAIC JNYA
  0x1B83, 0x1BA0, // Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
  0x1BAE, 0x1BAF, // Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
  0x1BBA, 0x1BE5, // Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
  0x1C00, 0x1C23, // Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
  0x1C4D, 0x1C4F, // Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
  0x1C5A, 0x1C77, // Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
  0x1C78, 0x1C7D, // Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
  0x1C80, 0x1C8A, // L&  [11] CYRILLIC SMALL LETTER ROUNDED VE..CYRILLIC SMALL LETTER TJE
  0x1C90, 0x1CBA, // L&  [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
  0x1CBD, 0x1CBF, // L&   [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
  0x1CE9, 0x1CEC, // Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
  0x1CEE, 0x1CF3, // Lo   [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
  0x1CF5, 0x1CF6, // Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
  0x1CFA, 0x1CFA, // Lo       VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
  0x1D00, 0x1D2B, // L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
  0x1D2C, 0x1D6A, // Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
  0x1D6B, 0x1D77, // L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
  0x1D78, 0x1D78, // Lm       MODIFIER LETTER CYRILLIC EN
  0x1D79, 0x1D9A, // L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
  0x1D9B, 0x1DBF, // Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
  0x1E00, 0x1F15, // L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
  0x1F18, 0x1F1D, // L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  0x1F20, 0x1F45, // L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
  0x1F48, 0x1F4D, // L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  0x1F50, 0x1F57, // L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
  0x1F59, 0x1F59, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
  0x1F5B, 0x1F5B, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  0x1F5D, 0x1F5D, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  0x1F5F, 0x1F7D, // L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
  0x1F80, 0x1FB4, // L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
  0x1FB6, 0x1FBC, // L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
  0x1FBE, 0x1FBE, // L&       GREEK PROSGEGRAMMENI
  0x1FC2, 0x1FC4, // L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
  0x1FC6, 0x1FCC, // L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
  0x1FD0, 0x1FD3, // L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
  0x1FD6, 0x1FDB, // L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
  0x1FE0, 0x1FEC, // L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
  0x1FF2, 0x1FF4, // L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
  0x1FF6, 0x1FFC, // L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
  0x2071, 0x2071, // Lm       SUPERSCRIPT LATIN SMALL LETTER I
  0x207F, 0x207F, // Lm       SUPERSCRIPT LATIN SMALL LETTER N
  0x2090, 0x209C, // Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
  0x2102, 0x2102, // L&       DOUBLE-STRUCK CAPITAL C
  0x2107, 0x2107, // L&       EULER CONSTANT
  0x210A, 0x2113, // L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
  0x2115, 0x2115, // L&       DOUBLE-STRUCK CAPITAL N
  0x2118, 0x2118, // Sm       SCRIPT CAPITAL P
  0x2119, 0x211D, // L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
  0x2124, 0x2124, // L&       DOUBLE-STRUCK CAPITAL Z
  0x2126, 0x2126, // L&       OHM SIGN
  0x2128, 0x2128, // L&       BLACK-LETTER CAPITAL Z
  0x212A, 0x212D, // L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
  0x212E, 0x212E, // So       ESTIMATED SYMBOL
  0x212F, 0x2134, // L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
  0x2135, 0x2138, // Lo   [4] ALEF SYMBOL..DALET SYMBOL
  0x2139, 0x2139, // L&       INFORMATION SOURCE
  0x213C, 0x213F, // L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
  0x2145, 0x2149, // L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
  0x214E, 0x214E, // L&       TURNED SMALL F
  0x2160, 0x2182, // Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
  0x2183, 0x2184, // L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
  0x2185, 0x2188, // Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
  0x2C00, 0x2C7B, // L& [124] GLAGOLITIC CAPITAL LETTER AZU..LATIN LETTER SMALL CAPITAL TURNED E
  0x2C7C, 0x2C7D, // Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
  0x2C7E, 0x2CE4, // L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
  0x2CEB, 0x2CEE, // L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
  0x2CF2, 0x2CF3, // L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
  0x2D00, 0x2D25, // L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
  0x2D27, 0x2D27, // L&       GEORGIAN SMALL LETTER YN
  0x2D2D, 0x2D2D, // L&       GEORGIAN SMALL LETTER AEN
  0x2D30, 0x2D67, // Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
  0x2D6F, 0x2D6F, // Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
  0x2D80, 0x2D96, // Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
  0x2DA0, 0x2DA6, // Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
  0x2DA8, 0x2DAE, // Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
  0x2DB0, 0x2DB6, // Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
  0x2DB8, 0x2DBE, // Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
  0x2DC0, 0x2DC6, // Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
  0x2DC8, 0x2DCE, // Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
  0x2DD0, 0x2DD6, // Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
  0x2DD8, 0x2DDE, // Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
  0x3005, 0x3005, // Lm       IDEOGRAPHIC ITERATION MARK
  0x3006, 0x3006, // Lo       IDEOGRAPHIC CLOSING MARK
  0x3007, 0x3007, // Nl       IDEOGRAPHIC NUMBER ZERO
  0x3021, 0x3029, // Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
  0x3031, 0x3035, // Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
  0x3038, 0x303A, // Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
  0x303B, 0x303B, // Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
  0x303C, 0x303C, // Lo       MASU MARK
  0x3041, 0x3096, // Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
  0x309B, 0x309C, // Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  0x309D, 0x309E, // Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
  0x309F, 0x309F, // Lo       HIRAGANA DIGRAPH YORI
  0x30A1, 0x30FA, // Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
  0x30FC, 0x30FE, // Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
  0x30FF, 0x30FF, // Lo       KATAKANA DIGRAPH KOTO
  0x3105, 0x312F, // Lo  [43] BOPOMOFO LETTER B..BOPOMOFO LETTER NN
  0x3131, 0x318E, // Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
  0x31A0, 0x31BF, // Lo  [32] BOPOMOFO LETTER BU..BOPOMOFO LETTER AH
  0x31F0, 0x31FF, // Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
  0x3400, 0x4DBF, // Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
  0x4E00, 0xA014, // Lo [21013] CJK UNIFIED IDEOGRAPH-4E00..YI SYLLABLE E
  0xA015, 0xA015, // Lm       YI SYLLABLE WU
  0xA016, 0xA48C, // Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
  0xA4D0, 0xA4F7, // Lo  [40] LISU LETTER BA..LISU LETTER OE
  0xA4F8, 0xA4FD, // Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
  0xA500, 0xA60B, // Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
  0xA60C, 0xA60C, // Lm       VAI SYLLABLE LENGTHENER
  0xA610, 0xA61F, // Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
  0xA62A, 0xA62B, // Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
  0xA640, 0xA66D, // L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
  0xA66E, 0xA66E, // Lo       CYRILLIC LETTER MULTIOCULAR O
  0xA67F, 0xA67F, // Lm       CYRILLIC PAYEROK
  0xA680, 0xA69B, // L&  [28] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER CROSSED O
  0xA69C, 0xA69D, // Lm   [2] MODIFIER LETTER CYRILLIC HARD SIGN..MODIFIER LETTER CYRILLIC SOFT SIGN
  0xA6A0, 0xA6E5, // Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
  0xA6E6, 0xA6EF, // Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
  0xA717, 0xA71F, // Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
  0xA722, 0xA76F, // L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
  0xA770, 0xA770, // Lm       MODIFIER LETTER US
  0xA771, 0xA787, // L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
  0xA788, 0xA788, // Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
  0xA78B, 0xA78E, // L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
  0xA78F, 0xA78F, // Lo       LATIN LETTER SINOLOGICAL DOT
  0xA790, 0xA7DC, // L&  [77] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN CAPITAL LETTER LAMBDA WITH STROKE
  0xA7F1, 0xA7F4, // Lm   [4] MODIFIER LETTER CAPITAL S..MODIFIER LETTER CAPITAL Q
  0xA7F5, 0xA7F6, // L&   [2] LATIN CAPITAL LETTER REVERSED HALF H..LATIN SMALL LETTER REVERSED HALF H
  0xA7F7, 0xA7F7, // Lo       LATIN EPIGRAPHIC LETTER SIDEWAYS I
  0xA7F8, 0xA7F9, // Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
  0xA7FA, 0xA7FA, // L&       LATIN LETTER SMALL CAPITAL TURNED M
  0xA7FB, 0xA801, // Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
  0xA803, 0xA805, // Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
  0xA807, 0xA80A, // Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
  0xA80C, 0xA822, // Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
  0xA840, 0xA873, // Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
  0xA882, 0xA8B3, // Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
  0xA8F2, 0xA8F7, // Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
  0xA8FB, 0xA8FB, // Lo       DEVANAGARI HEADSTROKE
  0xA8FD, 0xA8FE, // Lo   [2] DEVANAGARI JAIN OM..DEVANAGARI LETTER AY
  0xA90A, 0xA925, // Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
  0xA930, 0xA946, // Lo  [23] REJANG LETTER KA..REJANG LETTER A
  0xA960, 0xA97C, // Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
  0xA984, 0xA9B2, // Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
  0xA9CF, 0xA9CF, // Lm       JAVANESE PANGRANGKEP
  0xA9E0, 0xA9E4, // Lo   [5] MYANMAR LETTER SHAN GHA..MYANMAR LETTER SHAN BHA
  0xA9E6, 0xA9E6, // Lm       MYANMAR MODIFIER LETTER SHAN REDUPLICATION
  0xA9E7, 0xA9EF, // Lo   [9] MYANMAR LETTER TAI LAING NYA..MYANMAR LETTER TAI LAING NNA
  0xA9FA, 0xA9FE, // Lo   [5] MYANMAR LETTER TAI LAING LLA..MYANMAR LETTER TAI LAING BHA
  0xAA00, 0xAA28, // Lo  [41] CHAM LETTER A..CHAM LETTER HA
  0xAA40, 0xAA42, // Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
  0xAA44, 0xAA4B, // Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
  0xAA60, 0xAA6F, // Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
  0xAA70, 0xAA70, // Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
  0xAA71, 0xAA76, // Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
  0xAA7A, 0xAA7A, // Lo       MYANMAR LETTER AITON RA
  0xAA7E, 0xAAAF, // Lo  [50] MYANMAR LETTER SHWE PALAUNG CHA..TAI VIET LETTER HIGH O
  0xAAB1, 0xAAB1, // Lo       TAI VIET VOWEL AA
  0xAAB5, 0xAAB6, // Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
  0xAAB9, 0xAABD, // Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
  0xAAC0, 0xAAC0, // Lo       TAI VIET TONE MAI NUENG
  0xAAC2, 0xAAC2, // Lo       TAI VIET TONE MAI SONG
  0xAADB, 0xAADC, // Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
  0xAADD, 0xAADD, // Lm       TAI VIET SYMBOL SAM
  0xAAE0, 0xAAEA, // Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
  0xAAF2, 0xAAF2, // Lo       MEETEI MAYEK ANJI
  0xAAF3, 0xAAF4, // Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
  0xAB01, 0xAB06, // Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
  0xAB09, 0xAB0E, // Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
  0xAB11, 0xAB16, // Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
  0xAB20, 0xAB26, // Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
  0xAB28, 0xAB2E, // Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
  0xAB30, 0xAB5A, // L&  [43] LATIN SMALL LETTER BARRED ALPHA..LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
  0xAB5C, 0xAB5F, // Lm   [4] MODIFIER LETTER SMALL HENG..MODIFIER LETTER SMALL U WITH LEFT HOOK
  0xAB60, 0xAB68, // L&   [9] LATIN SMALL LETTER SAKHA YAT..LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE
  0xAB69, 0xAB69, // Lm       MODIFIER LETTER SMALL TURNED W
  0xAB70, 0xABBF, // L&  [80] CHEROKEE SMALL LETTER A..CHEROKEE SMALL LETTER YA
  0xABC0, 0xABE2, // Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
  0xAC00, 0xD7A3, // Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
  0xD7B0, 0xD7C6, // Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
  0xD7CB, 0xD7FB, // Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
  0xF900, 0xFA6D, // Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
  0xFA70, 0xFAD9, // Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
  0xFB00, 0xFB06, // L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
  0xFB13, 0xFB17, // L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
  0xFB1D, 0xFB1D, // Lo       HEBREW LETTER YOD WITH HIRIQ
  0xFB1F, 0xFB28, // Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
  0xFB2A, 0xFB36, // Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
  0xFB38, 0xFB3C, // Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
  0xFB3E, 0xFB3E, // Lo       HEBREW LETTER MEM WITH DAGESH
  0xFB40, 0xFB41, // Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
  0xFB43, 0xFB44, // Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
  0xFB46, 0xFBB1, // Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
  0xFBD3, 0xFD3D, // Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
  0xFD50, 0xFD8F, // Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
  0xFD92, 0xFDC7, // Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
  0xFDF0, 0xFDFB, // Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
  0xFE70, 0xFE74, // Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
  0xFE76, 0xFEFC, // Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
  0xFF21, 0xFF3A, // L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
  0xFF41, 0xFF5A, // L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
  0xFF66, 0xFF6F, // Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
  0xFF70, 0xFF70, // Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
  0xFF71, 0xFF9D, // Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
  0xFF9E, 0xFF9F, // Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
  0xFFA0, 0xFFBE, // Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
  0xFFC2, 0xFFC7, // Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
  0xFFCA, 0xFFCF, // Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
  0xFFD2, 0xFFD7, // Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
  0xFFDA, 0xFFDC, // Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
  0x10000, 0x1000B, // Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
  0x1000D, 0x10026, // Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
  0x10028, 0x1003A, // Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
  0x1003C, 0x1003D, // Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
  0x1003F, 0x1004D, // Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
  0x10050, 0x1005D, // Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
  0x10080, 0x100FA, // Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
  0x10140, 0x10174, // Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
  0x10280, 0x1029C, // Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
  0x102A0, 0x102D0, // Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
  0x10300, 0x1031F, // Lo  [32] OLD ITALIC LETTER A..OLD ITALIC LETTER ESS
  0x1032D, 0x10340, // Lo  [20] OLD ITALIC LETTER YE..GOTHIC LETTER PAIRTHRA
  0x10341, 0x10341, // Nl       GOTHIC LETTER NINETY
  0x10342, 0x10349, // Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
  0x1034A, 0x1034A, // Nl       GOTHIC LETTER NINE HUNDRED
  0x10350, 0x10375, // Lo  [38] OLD PERMIC LETTER AN..OLD PERMIC LETTER IA
  0x10380, 0x1039D, // Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
  0x103A0, 0x103C3, // Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
  0x103C8, 0x103CF, // Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
  0x103D1, 0x103D5, // Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
  0x10400, 0x1044F, // L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
  0x10450, 0x1049D, // Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
  0x104B0, 0x104D3, // L&  [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
  0x104D8, 0x104FB, // L&  [36] OSAGE SMALL LETTER A..OSAGE SMALL LETTER ZHA
  0x10500, 0x10527, // Lo  [40] ELBASAN LETTER A..ELBASAN LETTER KHE
  0x10530, 0x10563, // Lo  [52] CAUCASIAN ALBANIAN LETTER ALT..CAUCASIAN ALBANIAN LETTER KIW
  0x10570, 0x1057A, // L&  [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
  0x1057C, 0x1058A, // L&  [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
  0x1058C, 0x10592, // L&   [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
  0x10594, 0x10595, // L&   [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
  0x10597, 0x105A1, // L&  [11] VITHKUQI SMALL LETTER A..VITHKUQI SMALL LETTER GA
  0x105A3, 0x105B1, // L&  [15] VITHKUQI SMALL LETTER HA..VITHKUQI SMALL LETTER RE
  0x105B3, 0x105B9, // L&   [7] VITHKUQI SMALL LETTER SE..VITHKUQI SMALL LETTER XE
  0x105BB, 0x105BC, // L&   [2] VITHKUQI SMALL LETTER Y..VITHKUQI SMALL LETTER ZE
  0x105C0, 0x105F3, // Lo  [52] TODHRI LETTER A..TODHRI LETTER OO
  0x10600, 0x10736, // Lo [311] LINEAR A SIGN AB001..LINEAR A SIGN A664
  0x10740, 0x10755, // Lo  [22] LINEAR A SIGN A701 A..LINEAR A SIGN A732 JE
  0x10760, 0x10767, // Lo   [8] LINEAR A SIGN A800..LINEAR A SIGN A807
  0x10780, 0x10785, // Lm   [6] MODIFIER LETTER SMALL CAPITAL AA..MODIFIER LETTER SMALL B WITH HOOK
  0x10787, 0x107B0, // Lm  [42] MODIFIER LETTER SMALL DZ DIGRAPH..MODIFIER LETTER SMALL V WITH RIGHT HOOK
  0x107B2, 0x107BA, // Lm   [9] MODIFIER LETTER SMALL CAPITAL Y..MODIFIER LETTER SMALL S WITH CURL
  0x10800, 0x10805, // Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
  0x10808, 0x10808, // Lo       CYPRIOT SYLLABLE JO
  0x1080A, 0x10835, // Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
  0x10837, 0x10838, // Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
  0x1083C, 0x1083C, // Lo       CYPRIOT SYLLABLE ZA
  0x1083F, 0x10855, // Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
  0x10860, 0x10876, // Lo  [23] PALMYRENE LETTER ALEPH..PALMYRENE LETTER TAW
  0x10880, 0x1089E, // Lo  [31] NABATAEAN LETTER FINAL ALEPH..NABATAEAN LETTER TAW
  0x108E0, 0x108F2, // Lo  [19] HATRAN LETTER ALEPH..HATRAN LETTER QOPH
  0x108F4, 0x108F5, // Lo   [2] HATRAN LETTER SHIN..HATRAN LETTER TAW
  0x10900, 0x10915, // Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
  0x10920, 0x10939, // Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
  0x10940, 0x10959, // Lo  [26] SIDETIC LETTER N01..SIDETIC LETTER N26
  0x10980, 0x109B7, // Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
  0x109BE, 0x109BF, // Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
  0x10A00, 0x10A00, // Lo       KHAROSHTHI LETTER A
  0x10A10, 0x10A13, // Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
  0x10A15, 0x10A17, // Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
  0x10A19, 0x10A35, // Lo  [29] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER VHA
  0x10A60, 0x10A7C, // Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
  0x10A80, 0x10A9C, // Lo  [29] OLD NORTH ARABIAN LETTER HEH..OLD NORTH ARABIAN LETTER ZAH
  0x10AC0, 0x10AC7, // Lo   [8] MANICHAEAN LETTER ALEPH..MANICHAEAN LETTER WAW
  0x10AC9, 0x10AE4, // Lo  [28] MANICHAEAN LETTER ZAYIN..MANICHAEAN LETTER TAW
  0x10B00, 0x10B35, // Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
  0x10B40, 0x10B55, // Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
  0x10B60, 0x10B72, // Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
  0x10B80, 0x10B91, // Lo  [18] PSALTER PAHLAVI LETTER ALEPH..PSALTER PAHLAVI LETTER TAW
  0x10C00, 0x10C48, // Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
  0x10C80, 0x10CB2, // L&  [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
  0x10CC0, 0x10CF2, // L&  [51] OLD HUNGARIAN SMALL LETTER A..OLD HUNGARIAN SMALL LETTER US
  0x10D00, 0x10D23, // Lo  [36] HANIFI ROHINGYA LETTER A..HANIFI ROHINGYA MARK NA KHONNA
  0x10D4A, 0x10D4D, // Lo   [4] GARAY VOWEL SIGN A..GARAY VOWEL SIGN EE
  0x10D4E, 0x10D4E, // Lm       GARAY VOWEL LENGTH MARK
  0x10D4F, 0x10D4F, // Lo       GARAY SUKUN
  0x10D50, 0x10D65, // L&  [22] GARAY CAPITAL LETTER A..GARAY CAPITAL LETTER OLD NA
  0x10D6F, 0x10D6F, // Lm       GARAY REDUPLICATION MARK
  0x10D70, 0x10D85, // L&  [22] GARAY SMALL LETTER A..GARAY SMALL LETTER OLD NA
  0x10E80, 0x10EA9, // Lo  [42] YEZIDI LETTER ELIF..YEZIDI LETTER ET
  0x10EB0, 0x10EB1, // Lo   [2] YEZIDI LETTER LAM WITH DOT ABOVE..YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
  0x10EC2, 0x10EC4, // Lo   [3] ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW..ARABIC LETTER KAF WITH TWO DOTS VERTICALLY BELOW
  0x10EC5, 0x10EC5, // Lm       ARABIC SMALL YEH BARREE WITH TWO DOTS BELOW
  0x10EC6, 0x10EC7, // Lo   [2] ARABIC LETTER THIN NOON..ARABIC LETTER YEH WITH FOUR DOTS BELOW
  0x10F00, 0x10F1C, // Lo  [29] OLD SOGDIAN LETTER ALEPH..OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
  0x10F27, 0x10F27, // Lo       OLD SOGDIAN LIGATURE AYIN-DALETH
  0x10F30, 0x10F45, // Lo  [22] SOGDIAN LETTER ALEPH..SOGDIAN INDEPENDENT SHIN
  0x10F70, 0x10F81, // Lo  [18] OLD UYGHUR LETTER ALEPH..OLD UYGHUR LETTER LESH
  0x10FB0, 0x10FC4, // Lo  [21] CHORASMIAN LETTER ALEPH..CHORASMIAN LETTER TAW
  0x10FE0, 0x10FF6, // Lo  [23] ELYMAIC LETTER ALEPH..ELYMAIC LIGATURE ZAYIN-YODH
  0x11003, 0x11037, // Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
  0x11071, 0x11072, // Lo   [2] BRAHMI LETTER OLD TAMIL SHORT E..BRAHMI LETTER OLD TAMIL SHORT O
  0x11075, 0x11075, // Lo       BRAHMI LETTER OLD TAMIL LLA
  0x11083, 0x110AF, // Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
  0x110D0, 0x110E8, // Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
  0x11103, 0x11126, // Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
  0x11144, 0x11144, // Lo       CHAKMA LETTER LHAA
  0x11147, 0x11147, // Lo       CHAKMA LETTER VAA
  0x11150, 0x11172, // Lo  [35] MAHAJANI LETTER A..MAHAJANI LETTER RRA
  0x11176, 0x11176, // Lo       MAHAJANI LIGATURE SHRI
  0x11183, 0x111B2, // Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
  0x111C1, 0x111C4, // Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
  0x111DA, 0x111DA, // Lo       SHARADA EKAM
  0x111DC, 0x111DC, // Lo       SHARADA HEADSTROKE
  0x11200, 0x11211, // Lo  [18] KHOJKI LETTER A..KHOJKI LETTER JJA
  0x11213, 0x1122B, // Lo  [25] KHOJKI LETTER NYA..KHOJKI LETTER LLA
  0x1123F, 0x11240, // Lo   [2] KHOJKI LETTER QA..KHOJKI LETTER SHORT I
  0x11280, 0x11286, // Lo   [7] MULTANI LETTER A..MULTANI LETTER GA
  0x11288, 0x11288, // Lo       MULTANI LETTER GHA
  0x1128A, 0x1128D, // Lo   [4] MULTANI LETTER CA..MULTANI LETTER JJA
  0x1128F, 0x1129D, // Lo  [15] MULTANI LETTER NYA..MULTANI LETTER BA
  0x1129F, 0x112A8, // Lo  [10] MULTANI LETTER BHA..MULTANI LETTER RHA
  0x112B0, 0x112DE, // Lo  [47] KHUDAWADI LETTER A..KHUDAWADI LETTER HA
  0x11305, 0x1130C, // Lo   [8] GRANTHA LETTER A..GRANTHA LETTER VOCALIC L
  0x1130F, 0x11310, // Lo   [2] GRANTHA LETTER EE..GRANTHA LETTER AI
  0x11313, 0x11328, // Lo  [22] GRANTHA LETTER OO..GRANTHA LETTER NA
  0x1132A, 0x11330, // Lo   [7] GRANTHA LETTER PA..GRANTHA LETTER RA
  0x11332, 0x11333, // Lo   [2] GRANTHA LETTER LA..GRANTHA LETTER LLA
  0x11335, 0x11339, // Lo   [5] GRANTHA LETTER VA..GRANTHA LETTER HA
  0x1133D, 0x1133D, // Lo       GRANTHA SIGN AVAGRAHA
  0x11350, 0x11350, // Lo       GRANTHA OM
  0x1135D, 0x11361, // Lo   [5] GRANTHA SIGN PLUTA..GRANTHA LETTER VOCALIC LL
  0x11380, 0x11389, // Lo  [10] TULU-TIGALARI LETTER A..TULU-TIGALARI LETTER VOCALIC LL
  0x1138B, 0x1138B, // Lo       TULU-TIGALARI LETTER EE
  0x1138E, 0x1138E, // Lo       TULU-TIGALARI LETTER AI
  0x11390, 0x113B5, // Lo  [38] TULU-TIGALARI LETTER OO..TULU-TIGALARI LETTER LLLA
  0x113B7, 0x113B7, // Lo       TULU-TIGALARI SIGN AVAGRAHA
  0x113D1, 0x113D1, // Lo       TULU-TIGALARI REPHA
  0x113D3, 0x113D3, // Lo       TULU-TIGALARI SIGN PLUTA
  0x11400, 0x11434, // Lo  [53] NEWA LETTER A..NEWA LETTER HA
  0x11447, 0x1144A, // Lo   [4] NEWA SIGN AVAGRAHA..NEWA SIDDHI
  0x1145F, 0x11461, // Lo   [3] NEWA LETTER VEDIC ANUSVARA..NEWA SIGN UPADHMANIYA
  0x11480, 0x114AF, // Lo  [48] TIRHUTA ANJI..TIRHUTA LETTER HA
  0x114C4, 0x114C5, // Lo   [2] TIRHUTA SIGN AVAGRAHA..TIRHUTA GVANG
  0x114C7, 0x114C7, // Lo       TIRHUTA OM
  0x11580, 0x115AE, // Lo  [47] SIDDHAM LETTER A..SIDDHAM LETTER HA
  0x115D8, 0x115DB, // Lo   [4] SIDDHAM LETTER THREE-CIRCLE ALTERNATE I..SIDDHAM LETTER ALTERNATE U
  0x11600, 0x1162F, // Lo  [48] MODI LETTER A..MODI LETTER LLA
  0x11644, 0x11644, // Lo       MODI SIGN HUVA
  0x11680, 0x116AA, // Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
  0x116B8, 0x116B8, // Lo       TAKRI LETTER ARCHAIC KHA
  0x11700, 0x1171A, // Lo  [27] AHOM LETTER KA..AHOM LETTER ALTERNATE BA
  0x11740, 0x11746, // Lo   [7] AHOM LETTER CA..AHOM LETTER LLA
  0x11800, 0x1182B, // Lo  [44] DOGRA LETTER A..DOGRA LETTER RRA
  0x118A0, 0x118DF, // L&  [64] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI SMALL LETTER VIYO
  0x118FF, 0x11906, // Lo   [8] WARANG CITI OM..DIVES AKURU LETTER E
  0x11909, 0x11909, // Lo       DIVES AKURU LETTER O
  0x1190C, 0x11913, // Lo   [8] DIVES AKURU LETTER KA..DIVES AKURU LETTER JA
  0x11915, 0x11916, // Lo   [2] DIVES AKURU LETTER NYA..DIVES AKURU LETTER TTA
  0x11918, 0x1192F, // Lo  [24] DIVES AKURU LETTER DDA..DIVES AKURU LETTER ZA
  0x1193F, 0x1193F, // Lo       DIVES AKURU PREFIXED NASAL SIGN
  0x11941, 0x11941, // Lo       DIVES AKURU INITIAL RA
  0x119A0, 0x119A7, // Lo   [8] NANDINAGARI LETTER A..NANDINAGARI LETTER VOCALIC RR
  0x119AA, 0x119D0, // Lo  [39] NANDINAGARI LETTER E..NANDINAGARI LETTER RRA
  0x119E1, 0x119E1, // Lo       NANDINAGARI SIGN AVAGRAHA
  0x119E3, 0x119E3, // Lo       NANDINAGARI HEADSTROKE
  0x11A00, 0x11A00, // Lo       ZANABAZAR SQUARE LETTER A
  0x11A0B, 0x11A32, // Lo  [40] ZANABAZAR SQUARE LETTER KA..ZANABAZAR SQUARE LETTER KSSA
  0x11A3A, 0x11A3A, // Lo       ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
  0x11A50, 0x11A50, // Lo       SOYOMBO LETTER A
  0x11A5C, 0x11A89, // Lo  [46] SOYOMBO LETTER KA..SOYOMBO CLUSTER-INITIAL LETTER SA
  0x11A9D, 0x11A9D, // Lo       SOYOMBO MARK PLUTA
  0x11AB0, 0x11AF8, // Lo  [73] CANADIAN SYLLABICS NATTILIK HI..PAU CIN HAU GLOTTAL STOP FINAL
  0x11BC0, 0x11BE0, // Lo  [33] SUNUWAR LETTER DEVI..SUNUWAR LETTER KLOKO
  0x11C00, 0x11C08, // Lo   [9] BHAIKSUKI LETTER A..BHAIKSUKI LETTER VOCALIC L
  0x11C0A, 0x11C2E, // Lo  [37] BHAIKSUKI LETTER E..BHAIKSUKI LETTER HA
  0x11C40, 0x11C40, // Lo       BHAIKSUKI SIGN AVAGRAHA
  0x11C72, 0x11C8F, // Lo  [30] MARCHEN LETTER KA..MARCHEN LETTER A
  0x11D00, 0x11D06, // Lo   [7] MASARAM GONDI LETTER A..MASARAM GONDI LETTER E
  0x11D08, 0x11D09, // Lo   [2] MASARAM GONDI LETTER AI..MASARAM GONDI LETTER O
  0x11D0B, 0x11D30, // Lo  [38] MASARAM GONDI LETTER AU..MASARAM GONDI LETTER TRA
  0x11D46, 0x11D46, // Lo       MASARAM GONDI REPHA
  0x11D60, 0x11D65, // Lo   [6] GUNJALA GONDI LETTER A..GUNJALA GONDI LETTER UU
  0x11D67, 0x11D68, // Lo   [2] GUNJALA GONDI LETTER EE..GUNJALA GONDI LETTER AI
  0x11D6A, 0x11D89, // Lo  [32] GUNJALA GONDI LETTER OO..GUNJALA GONDI LETTER SA
  0x11D98, 0x11D98, // Lo       GUNJALA GONDI OM
  0x11DB0, 0x11DD8, // Lo  [41] TOLONG SIKI LETTER I..TOLONG SIKI LETTER RRH
  0x11DD9, 0x11DD9, // Lm       TOLONG SIKI SIGN SELA
  0x11DDA, 0x11DDB, // Lo   [2] TOLONG SIKI SIGN HECAKA..TOLONG SIKI UNGGA
  0x11EE0, 0x11EF2, // Lo  [19] MAKASAR LETTER KA..MAKASAR ANGKA
  0x11F02, 0x11F02, // Lo       KAWI SIGN REPHA
  0x11F04, 0x11F10, // Lo  [13] KAWI LETTER A..KAWI LETTER O
  0x11F12, 0x11F33, // Lo  [34] KAWI LETTER KA..KAWI LETTER JNYA
  0x11FB0, 0x11FB0, // Lo       LISU LETTER YHA
  0x12000, 0x12399, // Lo [922] CUNEIFORM SIGN A..CUNEIFORM SIGN U U
  0x12400, 0x1246E, // Nl [111] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
  0x12480, 0x12543, // Lo [196] CUNEIFORM SIGN AB TIMES NUN TENU..CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
  0x12F90, 0x12FF0, // Lo  [97] CYPRO-MINOAN SIGN CM001..CYPRO-MINOAN SIGN CM114
  0x13000, 0x1342F, // Lo [1072] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH V011D
  0x13441, 0x13446, // Lo   [6] EGYPTIAN HIEROGLYPH FULL BLANK..EGYPTIAN HIEROGLYPH WIDE LOST SIGN
  0x13460, 0x143FA, // Lo [3995] EGYPTIAN HIEROGLYPH-13460..EGYPTIAN HIEROGLYPH-143FA
  0x14400, 0x14646, // Lo [583] ANATOLIAN HIEROGLYPH A001..ANATOLIAN HIEROGLYPH A530
  0x16100, 0x1611D, // Lo  [30] GURUNG KHEMA LETTER A..GURUNG KHEMA LETTER SA
  0x16800, 0x16A38, // Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
  0x16A40, 0x16A5E, // Lo  [31] MRO LETTER TA..MRO LETTER TEK
  0x16A70, 0x16ABE, // Lo  [79] TANGSA LETTER OZ..TANGSA LETTER ZA
  0x16AD0, 0x16AED, // Lo  [30] BASSA VAH LETTER ENNI..BASSA VAH LETTER I
  0x16B00, 0x16B2F, // Lo  [48] PAHAWH HMONG VOWEL KEEB..PAHAWH HMONG CONSONANT CAU
  0x16B40, 0x16B43, // Lm   [4] PAHAWH HMONG SIGN VOS SEEV..PAHAWH HMONG SIGN IB YAM
  0x16B63, 0x16B77, // Lo  [21] PAHAWH HMONG SIGN VOS LUB..PAHAWH HMONG SIGN CIM NRES TOS
  0x16B7D, 0x16B8F, // Lo  [19] PAHAWH HMONG CLAN SIGN TSHEEJ..PAHAWH HMONG CLAN SIGN VWJ
  0x16D40, 0x16D42, // Lm   [3] KIRAT RAI SIGN ANUSVARA..KIRAT RAI SIGN VISARGA
  0x16D43, 0x16D6A, // Lo  [40] KIRAT RAI LETTER A..KIRAT RAI VOWEL SIGN AU
  0x16D6B, 0x16D6C, // Lm   [2] KIRAT RAI SIGN VIRAMA..KIRAT RAI SIGN SAAT
  0x16E40, 0x16E7F, // L&  [64] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN SMALL LETTER Y
  0x16EA0, 0x16EB8, // L&  [25] BERIA ERFE CAPITAL LETTER ARKAB..BERIA ERFE CAPITAL LETTER AY
  0x16EBB, 0x16ED3, // L&  [25] BERIA ERFE SMALL LETTER ARKAB..BERIA ERFE SMALL LETTER AY
  0x16F00, 0x16F4A, // Lo  [75] MIAO LETTER PA..MIAO LETTER RTE
  0x16F50, 0x16F50, // Lo       MIAO LETTER NASALIZATION
  0x16F93, 0x16F9F, // Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
  0x16FE0, 0x16FE1, // Lm   [2] TANGUT ITERATION MARK..NUSHU ITERATION MARK
  0x16FE3, 0x16FE3, // Lm       OLD CHINESE ITERATION MARK
  0x16FF2, 0x16FF3, // Lm   [2] CHINESE SMALL SIMPLIFIED ER..CHINESE SMALL TRADITIONAL ER
  0x16FF4, 0x16FF6, // Nl   [3] YANGQIN SIGN SLOW ONE BEAT..YANGQIN SIGN SLOW TWO BEATS
  0x17000, 0x18CD5, // Lo [7382] TANGUT IDEOGRAPH-17000..KHITAN SMALL SCRIPT CHARACTER-18CD5
  0x18CFF, 0x18D1E, // Lo  [32] KHITAN SMALL SCRIPT CHARACTER-18CFF..TANGUT IDEOGRAPH-18D1E
  0x18D80, 0x18DF2, // Lo [115] TANGUT COMPONENT-769..TANGUT COMPONENT-883
  0x1AFF0, 0x1AFF3, // Lm   [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
  0x1AFF5, 0x1AFFB, // Lm   [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
  0x1AFFD, 0x1AFFE, // Lm   [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
  0x1B000, 0x1B122, // Lo [291] KATAKANA LETTER ARCHAIC E..KATAKANA LETTER ARCHAIC WU
  0x1B132, 0x1B132, // Lo       HIRAGANA LETTER SMALL KO
  0x1B150, 0x1B152, // Lo   [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
  0x1B155, 0x1B155, // Lo       KATAKANA LETTER SMALL KO
  0x1B164, 0x1B167, // Lo   [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
  0x1B170, 0x1B2FB, // Lo [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
  0x1BC00, 0x1BC6A, // Lo [107] DUPLOYAN LETTER H..DUPLOYAN LETTER VOCALIC M
  0x1BC70, 0x1BC7C, // Lo  [13] DUPLOYAN AFFIX LEFT HORIZONTAL SECANT..DUPLOYAN AFFIX ATTACHED TANGENT HOOK
  0x1BC80, 0x1BC88, // Lo   [9] DUPLOYAN AFFIX HIGH ACUTE..DUPLOYAN AFFIX HIGH VERTICAL
  0x1BC90, 0x1BC99, // Lo  [10] DUPLOYAN AFFIX LOW ACUTE..DUPLOYAN AFFIX LOW ARROW
  0x1D400, 0x1D454, // L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
  0x1D456, 0x1D49C, // L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
  0x1D49E, 0x1D49F, // L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
  0x1D4A2, 0x1D4A2, // L&       MATHEMATICAL SCRIPT CAPITAL G
  0x1D4A5, 0x1D4A6, // L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
  0x1D4A9, 0x1D4AC, // L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
  0x1D4AE, 0x1D4B9, // L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
  0x1D4BB, 0x1D4BB, // L&       MATHEMATICAL SCRIPT SMALL F
  0x1D4BD, 0x1D4C3, // L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
  0x1D4C5, 0x1D505, // L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
  0x1D507, 0x1D50A, // L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
  0x1D50D, 0x1D514, // L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
  0x1D516, 0x1D51C, // L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
  0x1D51E, 0x1D539, // L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
  0x1D53B, 0x1D53E, // L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
  0x1D540, 0x1D544, // L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
  0x1D546, 0x1D546, // L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
  0x1D54A, 0x1D550, // L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
  0x1D552, 0x1D6A5, // L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
  0x1D6A8, 0x1D6C0, // L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
  0x1D6C2, 0x1D6DA, // L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
  0x1D6DC, 0x1D6FA, // L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
  0x1D6FC, 0x1D714, // L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
  0x1D716, 0x1D734, // L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
  0x1D736, 0x1D74E, // L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
  0x1D750, 0x1D76E, // L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
  0x1D770, 0x1D788, // L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
  0x1D78A, 0x1D7A8, // L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
  0x1D7AA, 0x1D7C2, // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
  0x1D7C4, 0x1D7CB, // L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
  0x1DF00, 0x1DF09, // L&  [10] LATIN SMALL LETTER FENG DIGRAPH WITH TRILL..LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK
  0x1DF0A, 0x1DF0A, // Lo       LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
  0x1DF0B, 0x1DF1E, // L&  [20] LATIN SMALL LETTER ESH WITH DOUBLE BAR..LATIN SMALL LETTER S WITH CURL
  0x1DF25, 0x1DF2A, // L&   [6] LATIN SMALL LETTER D WITH MID-HEIGHT LEFT HOOK..LATIN SMALL LETTER T WITH MID-HEIGHT LEFT HOOK
  0x1E030, 0x1E06D, // Lm  [62] MODIFIER LETTER CYRILLIC SMALL A..MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE
  0x1E100, 0x1E12C, // Lo  [45] NYIAKENG PUACHUE HMONG LETTER MA..NYIAKENG PUACHUE HMONG LETTER W
  0x1E137, 0x1E13D, // Lm   [7] NYIAKENG PUACHUE HMONG SIGN FOR PERSON..NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
  0x1E14E, 0x1E14E, // Lo       NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
  0x1E290, 0x1E2AD, // Lo  [30] TOTO LETTER PA..TOTO LETTER A
  0x1E2C0, 0x1E2EB, // Lo  [44] WANCHO LETTER AA..WANCHO LETTER YIH
  0x1E4D0, 0x1E4EA, // Lo  [27] NAG MUNDARI LETTER O..NAG MUNDARI LETTER ELL
  0x1E4EB, 0x1E4EB, // Lm       NAG MUNDARI SIGN OJOD
  0x1E5D0, 0x1E5ED, // Lo  [30] OL ONAL LETTER O..OL ONAL LETTER EG
  0x1E5F0, 0x1E5F0, // Lo       OL ONAL SIGN HODDOND
  0x1E6C0, 0x1E6DE, // Lo  [31] TAI YO LETTER LOW KO..TAI YO LETTER HIGH KVO
  0x1E6E0, 0x1E6E2, // Lo   [3] TAI YO LETTER AA..TAI YO LETTER UE
  0x1E6E4, 0x1E6E5, // Lo   [2] TAI YO LETTER U..TAI YO LETTER AE
  0x1E6E7, 0x1E6ED, // Lo   [7] TAI YO LETTER O..TAI YO LETTER AUE
  0x1E6F0, 0x1E6F4, // Lo   [5] TAI YO LETTER AN..TAI YO LETTER AP
  0x1E6FE, 0x1E6FE, // Lo       TAI YO SYMBOL MUEANG
  0x1E6FF, 0x1E6FF, // Lm       TAI YO XAM LAI
  0x1E7E0, 0x1E7E6, // Lo   [7] ETHIOPIC SYLLABLE HHYA..ETHIOPIC SYLLABLE HHYO
  0x1E7E8, 0x1E7EB, // Lo   [4] ETHIOPIC SYLLABLE GURAGE HHWA..ETHIOPIC SYLLABLE HHWE
  0x1E7ED, 0x1E7EE, // Lo   [2] ETHIOPIC SYLLABLE GURAGE MWI..ETHIOPIC SYLLABLE GURAGE MWEE
  0x1E7F0, 0x1E7FE, // Lo  [15] ETHIOPIC SYLLABLE GURAGE QWI..ETHIOPIC SYLLABLE GURAGE PWEE
  0x1E800, 0x1E8C4, // Lo [197] MENDE KIKAKUI SYLLABLE M001 KI..MENDE KIKAKUI SYLLABLE M060 NYON
  0x1E900, 0x1E943, // L&  [68] ADLAM CAPITAL LETTER ALIF..ADLAM SMALL LETTER SHA
  0x1E94B, 0x1E94B, // Lm       ADLAM NASALIZATION MARK
  0x1EE00, 0x1EE03, // Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
  0x1EE05, 0x1EE1F, // Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
  0x1EE21, 0x1EE22, // Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
  0x1EE24, 0x1EE24, // Lo       ARABIC MATHEMATICAL INITIAL HEH
  0x1EE27, 0x1EE27, // Lo       ARABIC MATHEMATICAL INITIAL HAH
  0x1EE29, 0x1EE32, // Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
  0x1EE34, 0x1EE37, // Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
  0x1EE39, 0x1EE39, // Lo       ARABIC MATHEMATICAL INITIAL DAD
  0x1EE3B, 0x1EE3B, // Lo       ARABIC MATHEMATICAL INITIAL GHAIN
  0x1EE42, 0x1EE42, // Lo       ARABIC MATHEMATICAL TAILED JEEM
  0x1EE47, 0x1EE47, // Lo       ARABIC MATHEMATICAL TAILED HAH
  0x1EE49, 0x1EE49, // Lo       ARABIC MATHEMATICAL TAILED YEH
  0x1EE4B, 0x1EE4B, // Lo       ARABIC MATHEMATICAL TAILED LAM
  0x1EE4D, 0x1EE4F, // Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
  0x1EE51, 0x1EE52, // Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
  0x1EE54, 0x1EE54, // Lo       ARABIC MATHEMATICAL TAILED SHEEN
  0x1EE57, 0x1EE57, // Lo       ARABIC MATHEMATICAL TAILED KHAH
  0x1EE59, 0x1EE59, // Lo       ARABIC MATHEMATICAL TAILED DAD
  0x1EE5B, 0x1EE5B, // Lo       ARABIC MATHEMATICAL TAILED GHAIN
  0x1EE5D, 0x1EE5D, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
  0x1EE5F, 0x1EE5F, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
  0x1EE61, 0x1EE62, // Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
  0x1EE64, 0x1EE64, // Lo       ARABIC MATHEMATICAL STRETCHED HEH
  0x1EE67, 0x1EE6A, // Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
  0x1EE6C, 0x1EE72, // Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
  0x1EE74, 0x1EE77, // Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
  0x1EE79, 0x1EE7C, // Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
  0x1EE7E, 0x1EE7E, // Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
  0x1EE80, 0x1EE89, // Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
  0x1EE8B, 0x1EE9B, // Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
  0x1EEA1, 0x1EEA3, // Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
  0x1EEA5, 0x1EEA9, // Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
  0x1EEAB, 0x1EEBB, // Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
  0x20000, 0x2A6DF, // Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
  0x2A700, 0x2B81D, // Lo [4382] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B81D
  0x2B820, 0x2CEAD, // Lo [5774] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEAD
  0x2CEB0, 0x2EBE0, // Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
  0x2EBF0, 0x2EE5D, // Lo [622] CJK UNIFIED IDEOGRAPH-2EBF0..CJK UNIFIED IDEOGRAPH-2EE5D
  0x2F800, 0x2FA1D, // Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
  0x30000, 0x3134A, // Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
  0x31350, 0x33479, // Lo [8490] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-33479
)
internal val unicodeIdContinueRanges = intArrayOf(
  0x30, 0x39, // Nd  [10] DIGIT ZERO..DIGIT NINE
  0x41, 0x5A, // L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
  0x5F, 0x5F, // Pc       LOW LINE
  0x61, 0x7A, // L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
  0xAA, 0xAA, // Lo       FEMININE ORDINAL INDICATOR
  0xB5, 0xB5, // L&       MICRO SIGN
  0xB7, 0xB7, // Po       MIDDLE DOT
  0xBA, 0xBA, // Lo       MASCULINE ORDINAL INDICATOR
  0xC0, 0xD6, // L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
  0xD8, 0xF6, // L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
  0xF8, 0x1BA, // L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
  0x1BB, 0x1BB, // Lo       LATIN LETTER TWO WITH STROKE
  0x1BC, 0x1BF, // L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
  0x1C0, 0x1C3, // Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
  0x1C4, 0x293, // L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
  0x294, 0x295, // Lo   [2] LATIN LETTER GLOTTAL STOP..LATIN LETTER PHARYNGEAL VOICED FRICATIVE
  0x296, 0x2AF, // L&  [26] LATIN LETTER INVERTED GLOTTAL STOP..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
  0x2B0, 0x2C1, // Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
  0x2C6, 0x2D1, // Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
  0x2E0, 0x2E4, // Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
  0x2EC, 0x2EC, // Lm       MODIFIER LETTER VOICING
  0x2EE, 0x2EE, // Lm       MODIFIER LETTER DOUBLE APOSTROPHE
  0x300, 0x36F, // Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
  0x370, 0x373, // L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
  0x374, 0x374, // Lm       GREEK NUMERAL SIGN
  0x376, 0x377, // L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
  0x37A, 0x37A, // Lm       GREEK YPOGEGRAMMENI
  0x37B, 0x37D, // L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
  0x37F, 0x37F, // L&       GREEK CAPITAL LETTER YOT
  0x386, 0x386, // L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
  0x387, 0x387, // Po       GREEK ANO TELEIA
  0x388, 0x38A, // L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
  0x38C, 0x38C, // L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
  0x38E, 0x3A1, // L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
  0x3A3, 0x3F5, // L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
  0x3F7, 0x481, // L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
  0x483, 0x487, // Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
  0x48A, 0x52F, // L& [166] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER EL WITH DESCENDER
  0x531, 0x556, // L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
  0x559, 0x559, // Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
  0x560, 0x588, // L&  [41] ARMENIAN SMALL LETTER TURNED AYB..ARMENIAN SMALL LETTER YI WITH STROKE
  0x591, 0x5BD, // Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
  0x5BF, 0x5BF, // Mn       HEBREW POINT RAFE
  0x5C1, 0x5C2, // Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
  0x5C4, 0x5C5, // Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
  0x5C7, 0x5C7, // Mn       HEBREW POINT QAMATS QATAN
  0x5D0, 0x5EA, // Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
  0x5EF, 0x5F2, // Lo   [4] HEBREW YOD TRIANGLE..HEBREW LIGATURE YIDDISH DOUBLE YOD
  0x610, 0x61A, // Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
  0x620, 0x63F, // Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
  0x640, 0x640, // Lm       ARABIC TATWEEL
  0x641, 0x64A, // Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
  0x64B, 0x65F, // Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
  0x660, 0x669, // Nd  [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
  0x66E, 0x66F, // Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
  0x670, 0x670, // Mn       ARABIC LETTER SUPERSCRIPT ALEF
  0x671, 0x6D3, // Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
  0x6D5, 0x6D5, // Lo       ARABIC LETTER AE
  0x6D6, 0x6DC, // Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
  0x6DF, 0x6E4, // Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
  0x6E5, 0x6E6, // Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
  0x6E7, 0x6E8, // Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
  0x6EA, 0x6ED, // Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
  0x6EE, 0x6EF, // Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
  0x6F0, 0x6F9, // Nd  [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
  0x6FA, 0x6FC, // Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
  0x6FF, 0x6FF, // Lo       ARABIC LETTER HEH WITH INVERTED V
  0x710, 0x710, // Lo       SYRIAC LETTER ALAPH
  0x711, 0x711, // Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
  0x712, 0x72F, // Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
  0x730, 0x74A, // Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
  0x74D, 0x7A5, // Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
  0x7A6, 0x7B0, // Mn  [11] THAANA ABAFILI..THAANA SUKUN
  0x7B1, 0x7B1, // Lo       THAANA LETTER NAA
  0x7C0, 0x7C9, // Nd  [10] NKO DIGIT ZERO..NKO DIGIT NINE
  0x7CA, 0x7EA, // Lo  [33] NKO LETTER A..NKO LETTER JONA RA
  0x7EB, 0x7F3, // Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
  0x7F4, 0x7F5, // Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
  0x7FA, 0x7FA, // Lm       NKO LAJANYALAN
  0x7FD, 0x7FD, // Mn       NKO DANTAYALAN
  0x800, 0x815, // Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
  0x816, 0x819, // Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
  0x81A, 0x81A, // Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
  0x81B, 0x823, // Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
  0x824, 0x824, // Lm       SAMARITAN MODIFIER LETTER SHORT A
  0x825, 0x827, // Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
  0x828, 0x828, // Lm       SAMARITAN MODIFIER LETTER I
  0x829, 0x82D, // Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
  0x840, 0x858, // Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
  0x859, 0x85B, // Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
  0x860, 0x86A, // Lo  [11] SYRIAC LETTER MALAYALAM NGA..SYRIAC LETTER MALAYALAM SSA
  0x870, 0x887, // Lo  [24] ARABIC LETTER ALEF WITH ATTACHED FATHA..ARABIC BASELINE ROUND DOT
  0x889, 0x88F, // Lo   [7] ARABIC LETTER NOON WITH INVERTED SMALL V..ARABIC LETTER NOON WITH RING ABOVE
  0x897, 0x89F, // Mn   [9] ARABIC PEPET..ARABIC HALF MADDA OVER MADDA
  0x8A0, 0x8C8, // Lo  [41] ARABIC LETTER BEH WITH SMALL V BELOW..ARABIC LETTER GRAF
  0x8C9, 0x8C9, // Lm       ARABIC SMALL FARSI YEH
  0x8CA, 0x8E1, // Mn  [24] ARABIC SMALL HIGH FARSI YEH..ARABIC SMALL HIGH SIGN SAFHA
  0x8E3, 0x902, // Mn  [32] ARABIC TURNED DAMMA BELOW..DEVANAGARI SIGN ANUSVARA
  0x903, 0x903, // Mc       DEVANAGARI SIGN VISARGA
  0x904, 0x939, // Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
  0x93A, 0x93A, // Mn       DEVANAGARI VOWEL SIGN OE
  0x93B, 0x93B, // Mc       DEVANAGARI VOWEL SIGN OOE
  0x93C, 0x93C, // Mn       DEVANAGARI SIGN NUKTA
  0x93D, 0x93D, // Lo       DEVANAGARI SIGN AVAGRAHA
  0x93E, 0x940, // Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
  0x941, 0x948, // Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
  0x949, 0x94C, // Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
  0x94D, 0x94D, // Mn       DEVANAGARI SIGN VIRAMA
  0x94E, 0x94F, // Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
  0x950, 0x950, // Lo       DEVANAGARI OM
  0x951, 0x957, // Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
  0x958, 0x961, // Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
  0x962, 0x963, // Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
  0x966, 0x96F, // Nd  [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
  0x971, 0x971, // Lm       DEVANAGARI SIGN HIGH SPACING DOT
  0x972, 0x980, // Lo  [15] DEVANAGARI LETTER CANDRA A..BENGALI ANJI
  0x981, 0x981, // Mn       BENGALI SIGN CANDRABINDU
  0x982, 0x983, // Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
  0x985, 0x98C, // Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
  0x98F, 0x990, // Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
  0x993, 0x9A8, // Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
  0x9AA, 0x9B0, // Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
  0x9B2, 0x9B2, // Lo       BENGALI LETTER LA
  0x9B6, 0x9B9, // Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
  0x9BC, 0x9BC, // Mn       BENGALI SIGN NUKTA
  0x9BD, 0x9BD, // Lo       BENGALI SIGN AVAGRAHA
  0x9BE, 0x9C0, // Mc   [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
  0x9C1, 0x9C4, // Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
  0x9C7, 0x9C8, // Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
  0x9CB, 0x9CC, // Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
  0x9CD, 0x9CD, // Mn       BENGALI SIGN VIRAMA
  0x9CE, 0x9CE, // Lo       BENGALI LETTER KHANDA TA
  0x9D7, 0x9D7, // Mc       BENGALI AU LENGTH MARK
  0x9DC, 0x9DD, // Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
  0x9DF, 0x9E1, // Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
  0x9E2, 0x9E3, // Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
  0x9E6, 0x9EF, // Nd  [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
  0x9F0, 0x9F1, // Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
  0x9FC, 0x9FC, // Lo       BENGALI LETTER VEDIC ANUSVARA
  0x9FE, 0x9FE, // Mn       BENGALI SANDHI MARK
  0xA01, 0xA02, // Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
  0xA03, 0xA03, // Mc       GURMUKHI SIGN VISARGA
  0xA05, 0xA0A, // Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
  0xA0F, 0xA10, // Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
  0xA13, 0xA28, // Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
  0xA2A, 0xA30, // Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
  0xA32, 0xA33, // Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
  0xA35, 0xA36, // Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
  0xA38, 0xA39, // Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
  0xA3C, 0xA3C, // Mn       GURMUKHI SIGN NUKTA
  0xA3E, 0xA40, // Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
  0xA41, 0xA42, // Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
  0xA47, 0xA48, // Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
  0xA4B, 0xA4D, // Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
  0xA51, 0xA51, // Mn       GURMUKHI SIGN UDAAT
  0xA59, 0xA5C, // Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
  0xA5E, 0xA5E, // Lo       GURMUKHI LETTER FA
  0xA66, 0xA6F, // Nd  [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
  0xA70, 0xA71, // Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
  0xA72, 0xA74, // Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
  0xA75, 0xA75, // Mn       GURMUKHI SIGN YAKASH
  0xA81, 0xA82, // Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
  0xA83, 0xA83, // Mc       GUJARATI SIGN VISARGA
  0xA85, 0xA8D, // Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
  0xA8F, 0xA91, // Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
  0xA93, 0xAA8, // Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
  0xAAA, 0xAB0, // Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
  0xAB2, 0xAB3, // Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
  0xAB5, 0xAB9, // Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
  0xABC, 0xABC, // Mn       GUJARATI SIGN NUKTA
  0xABD, 0xABD, // Lo       GUJARATI SIGN AVAGRAHA
  0xABE, 0xAC0, // Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
  0xAC1, 0xAC5, // Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
  0xAC7, 0xAC8, // Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
  0xAC9, 0xAC9, // Mc       GUJARATI VOWEL SIGN CANDRA O
  0xACB, 0xACC, // Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
  0xACD, 0xACD, // Mn       GUJARATI SIGN VIRAMA
  0xAD0, 0xAD0, // Lo       GUJARATI OM
  0xAE0, 0xAE1, // Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
  0xAE2, 0xAE3, // Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
  0xAE6, 0xAEF, // Nd  [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
  0xAF9, 0xAF9, // Lo       GUJARATI LETTER ZHA
  0xAFA, 0xAFF, // Mn   [6] GUJARATI SIGN SUKUN..GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE
  0xB01, 0xB01, // Mn       ORIYA SIGN CANDRABINDU
  0xB02, 0xB03, // Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
  0xB05, 0xB0C, // Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
  0xB0F, 0xB10, // Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
  0xB13, 0xB28, // Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
  0xB2A, 0xB30, // Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
  0xB32, 0xB33, // Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
  0xB35, 0xB39, // Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
  0xB3C, 0xB3C, // Mn       ORIYA SIGN NUKTA
  0xB3D, 0xB3D, // Lo       ORIYA SIGN AVAGRAHA
  0xB3E, 0xB3E, // Mc       ORIYA VOWEL SIGN AA
  0xB3F, 0xB3F, // Mn       ORIYA VOWEL SIGN I
  0xB40, 0xB40, // Mc       ORIYA VOWEL SIGN II
  0xB41, 0xB44, // Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
  0xB47, 0xB48, // Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
  0xB4B, 0xB4C, // Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
  0xB4D, 0xB4D, // Mn       ORIYA SIGN VIRAMA
  0xB55, 0xB56, // Mn   [2] ORIYA SIGN OVERLINE..ORIYA AI LENGTH MARK
  0xB57, 0xB57, // Mc       ORIYA AU LENGTH MARK
  0xB5C, 0xB5D, // Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
  0xB5F, 0xB61, // Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
  0xB62, 0xB63, // Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
  0xB66, 0xB6F, // Nd  [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
  0xB71, 0xB71, // Lo       ORIYA LETTER WA
  0xB82, 0xB82, // Mn       TAMIL SIGN ANUSVARA
  0xB83, 0xB83, // Lo       TAMIL SIGN VISARGA
  0xB85, 0xB8A, // Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
  0xB8E, 0xB90, // Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
  0xB92, 0xB95, // Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
  0xB99, 0xB9A, // Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
  0xB9C, 0xB9C, // Lo       TAMIL LETTER JA
  0xB9E, 0xB9F, // Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
  0xBA3, 0xBA4, // Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
  0xBA8, 0xBAA, // Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
  0xBAE, 0xBB9, // Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
  0xBBE, 0xBBF, // Mc   [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
  0xBC0, 0xBC0, // Mn       TAMIL VOWEL SIGN II
  0xBC1, 0xBC2, // Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
  0xBC6, 0xBC8, // Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
  0xBCA, 0xBCC, // Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
  0xBCD, 0xBCD, // Mn       TAMIL SIGN VIRAMA
  0xBD0, 0xBD0, // Lo       TAMIL OM
  0xBD7, 0xBD7, // Mc       TAMIL AU LENGTH MARK
  0xBE6, 0xBEF, // Nd  [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
  0xC00, 0xC00, // Mn       TELUGU SIGN COMBINING CANDRABINDU ABOVE
  0xC01, 0xC03, // Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
  0xC04, 0xC04, // Mn       TELUGU SIGN COMBINING ANUSVARA ABOVE
  0xC05, 0xC0C, // Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
  0xC0E, 0xC10, // Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
  0xC12, 0xC28, // Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
  0xC2A, 0xC39, // Lo  [16] TELUGU LETTER PA..TELUGU LETTER HA
  0xC3C, 0xC3C, // Mn       TELUGU SIGN NUKTA
  0xC3D, 0xC3D, // Lo       TELUGU SIGN AVAGRAHA
  0xC3E, 0xC40, // Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
  0xC41, 0xC44, // Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
  0xC46, 0xC48, // Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
  0xC4A, 0xC4D, // Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
  0xC55, 0xC56, // Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
  0xC58, 0xC5A, // Lo   [3] TELUGU LETTER TSA..TELUGU LETTER RRRA
  0xC5C, 0xC5D, // Lo   [2] TELUGU ARCHAIC SHRII..TELUGU LETTER NAKAARA POLLU
  0xC60, 0xC61, // Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
  0xC62, 0xC63, // Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
  0xC66, 0xC6F, // Nd  [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
  0xC80, 0xC80, // Lo       KANNADA SIGN SPACING CANDRABINDU
  0xC81, 0xC81, // Mn       KANNADA SIGN CANDRABINDU
  0xC82, 0xC83, // Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
  0xC85, 0xC8C, // Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
  0xC8E, 0xC90, // Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
  0xC92, 0xCA8, // Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
  0xCAA, 0xCB3, // Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
  0xCB5, 0xCB9, // Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
  0xCBC, 0xCBC, // Mn       KANNADA SIGN NUKTA
  0xCBD, 0xCBD, // Lo       KANNADA SIGN AVAGRAHA
  0xCBE, 0xCBE, // Mc       KANNADA VOWEL SIGN AA
  0xCBF, 0xCBF, // Mn       KANNADA VOWEL SIGN I
  0xCC0, 0xCC4, // Mc   [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
  0xCC6, 0xCC6, // Mn       KANNADA VOWEL SIGN E
  0xCC7, 0xCC8, // Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
  0xCCA, 0xCCB, // Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
  0xCCC, 0xCCD, // Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
  0xCD5, 0xCD6, // Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
  0xCDC, 0xCDE, // Lo   [3] KANNADA ARCHAIC SHRII..KANNADA LETTER FA
  0xCE0, 0xCE1, // Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
  0xCE2, 0xCE3, // Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
  0xCE6, 0xCEF, // Nd  [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
  0xCF1, 0xCF2, // Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
  0xCF3, 0xCF3, // Mc       KANNADA SIGN COMBINING ANUSVARA ABOVE RIGHT
  0xD00, 0xD01, // Mn   [2] MALAYALAM SIGN COMBINING ANUSVARA ABOVE..MALAYALAM SIGN CANDRABINDU
  0xD02, 0xD03, // Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
  0xD04, 0xD0C, // Lo   [9] MALAYALAM LETTER VEDIC ANUSVARA..MALAYALAM LETTER VOCALIC L
  0xD0E, 0xD10, // Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
  0xD12, 0xD3A, // Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
  0xD3B, 0xD3C, // Mn   [2] MALAYALAM SIGN VERTICAL BAR VIRAMA..MALAYALAM SIGN CIRCULAR VIRAMA
  0xD3D, 0xD3D, // Lo       MALAYALAM SIGN AVAGRAHA
  0xD3E, 0xD40, // Mc   [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
  0xD41, 0xD44, // Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
  0xD46, 0xD48, // Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
  0xD4A, 0xD4C, // Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
  0xD4D, 0xD4D, // Mn       MALAYALAM SIGN VIRAMA
  0xD4E, 0xD4E, // Lo       MALAYALAM LETTER DOT REPH
  0xD54, 0xD56, // Lo   [3] MALAYALAM LETTER CHILLU M..MALAYALAM LETTER CHILLU LLL
  0xD57, 0xD57, // Mc       MALAYALAM AU LENGTH MARK
  0xD5F, 0xD61, // Lo   [3] MALAYALAM LETTER ARCHAIC II..MALAYALAM LETTER VOCALIC LL
  0xD62, 0xD63, // Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
  0xD66, 0xD6F, // Nd  [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
  0xD7A, 0xD7F, // Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
  0xD81, 0xD81, // Mn       SINHALA SIGN CANDRABINDU
  0xD82, 0xD83, // Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
  0xD85, 0xD96, // Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
  0xD9A, 0xDB1, // Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
  0xDB3, 0xDBB, // Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
  0xDBD, 0xDBD, // Lo       SINHALA LETTER DANTAJA LAYANNA
  0xDC0, 0xDC6, // Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
  0xDCA, 0xDCA, // Mn       SINHALA SIGN AL-LAKUNA
  0xDCF, 0xDD1, // Mc   [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
  0xDD2, 0xDD4, // Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
  0xDD6, 0xDD6, // Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
  0xDD8, 0xDDF, // Mc   [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
  0xDE6, 0xDEF, // Nd  [10] SINHALA LITH DIGIT ZERO..SINHALA LITH DIGIT NINE
  0xDF2, 0xDF3, // Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
  0xE01, 0xE30, // Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
  0xE31, 0xE31, // Mn       THAI CHARACTER MAI HAN-AKAT
  0xE32, 0xE33, // Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
  0xE34, 0xE3A, // Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
  0xE40, 0xE45, // Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
  0xE46, 0xE46, // Lm       THAI CHARACTER MAIYAMOK
  0xE47, 0xE4E, // Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
  0xE50, 0xE59, // Nd  [10] THAI DIGIT ZERO..THAI DIGIT NINE
  0xE81, 0xE82, // Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
  0xE84, 0xE84, // Lo       LAO LETTER KHO TAM
  0xE86, 0xE8A, // Lo   [5] LAO LETTER PALI GHA..LAO LETTER SO TAM
  0xE8C, 0xEA3, // Lo  [24] LAO LETTER PALI JHA..LAO LETTER LO LING
  0xEA5, 0xEA5, // Lo       LAO LETTER LO LOOT
  0xEA7, 0xEB0, // Lo  [10] LAO LETTER WO..LAO VOWEL SIGN A
  0xEB1, 0xEB1, // Mn       LAO VOWEL SIGN MAI KAN
  0xEB2, 0xEB3, // Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
  0xEB4, 0xEBC, // Mn   [9] LAO VOWEL SIGN I..LAO SEMIVOWEL SIGN LO
  0xEBD, 0xEBD, // Lo       LAO SEMIVOWEL SIGN NYO
  0xEC0, 0xEC4, // Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
  0xEC6, 0xEC6, // Lm       LAO KO LA
  0xEC8, 0xECE, // Mn   [7] LAO TONE MAI EK..LAO YAMAKKAN
  0xED0, 0xED9, // Nd  [10] LAO DIGIT ZERO..LAO DIGIT NINE
  0xEDC, 0xEDF, // Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
  0xF00, 0xF00, // Lo       TIBETAN SYLLABLE OM
  0xF18, 0xF19, // Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
  0xF20, 0xF29, // Nd  [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
  0xF35, 0xF35, // Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
  0xF37, 0xF37, // Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
  0xF39, 0xF39, // Mn       TIBETAN MARK TSA -PHRU
  0xF3E, 0xF3F, // Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
  0xF40, 0xF47, // Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
  0xF49, 0xF6C, // Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
  0xF71, 0xF7E, // Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
  0xF7F, 0xF7F, // Mc       TIBETAN SIGN RNAM BCAD
  0xF80, 0xF84, // Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
  0xF86, 0xF87, // Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
  0xF88, 0xF8C, // Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
  0xF8D, 0xF97, // Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
  0xF99, 0xFBC, // Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
  0xFC6, 0xFC6, // Mn       TIBETAN SYMBOL PADMA GDAN
  0x1000, 0x102A, // Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
  0x102B, 0x102C, // Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
  0x102D, 0x1030, // Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
  0x1031, 0x1031, // Mc       MYANMAR VOWEL SIGN E
  0x1032, 0x1037, // Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
  0x1038, 0x1038, // Mc       MYANMAR SIGN VISARGA
  0x1039, 0x103A, // Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
  0x103B, 0x103C, // Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
  0x103D, 0x103E, // Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
  0x103F, 0x103F, // Lo       MYANMAR LETTER GREAT SA
  0x1040, 0x1049, // Nd  [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
  0x1050, 0x1055, // Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
  0x1056, 0x1057, // Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
  0x1058, 0x1059, // Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
  0x105A, 0x105D, // Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
  0x105E, 0x1060, // Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
  0x1061, 0x1061, // Lo       MYANMAR LETTER SGAW KAREN SHA
  0x1062, 0x1064, // Mc   [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
  0x1065, 0x1066, // Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
  0x1067, 0x106D, // Mc   [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
  0x106E, 0x1070, // Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
  0x1071, 0x1074, // Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
  0x1075, 0x1081, // Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
  0x1082, 0x1082, // Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
  0x1083, 0x1084, // Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
  0x1085, 0x1086, // Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
  0x1087, 0x108C, // Mc   [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
  0x108D, 0x108D, // Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
  0x108E, 0x108E, // Lo       MYANMAR LETTER RUMAI PALAUNG FA
  0x108F, 0x108F, // Mc       MYANMAR SIGN RUMAI PALAUNG TONE-5
  0x1090, 0x1099, // Nd  [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
  0x109A, 0x109C, // Mc   [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
  0x109D, 0x109D, // Mn       MYANMAR VOWEL SIGN AITON AI
  0x10A0, 0x10C5, // L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
  0x10C7, 0x10C7, // L&       GEORGIAN CAPITAL LETTER YN
  0x10CD, 0x10CD, // L&       GEORGIAN CAPITAL LETTER AEN
  0x10D0, 0x10FA, // L&  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
  0x10FC, 0x10FC, // Lm       MODIFIER LETTER GEORGIAN NAR
  0x10FD, 0x10FF, // L&   [3] GEORGIAN LETTER AEN..GEORGIAN LETTER LABIAL SIGN
  0x1100, 0x1248, // Lo [329] HANGUL CHOSEONG KIYEOK..ETHIOPIC SYLLABLE QWA
  0x124A, 0x124D, // Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
  0x1250, 0x1256, // Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
  0x1258, 0x1258, // Lo       ETHIOPIC SYLLABLE QHWA
  0x125A, 0x125D, // Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
  0x1260, 0x1288, // Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
  0x128A, 0x128D, // Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
  0x1290, 0x12B0, // Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
  0x12B2, 0x12B5, // Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
  0x12B8, 0x12BE, // Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
  0x12C0, 0x12C0, // Lo       ETHIOPIC SYLLABLE KXWA
  0x12C2, 0x12C5, // Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
  0x12C8, 0x12D6, // Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
  0x12D8, 0x1310, // Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
  0x1312, 0x1315, // Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
  0x1318, 0x135A, // Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
  0x135D, 0x135F, // Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
  0x1369, 0x1371, // No   [9] ETHIOPIC DIGIT ONE..ETHIOPIC DIGIT NINE
  0x1380, 0x138F, // Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
  0x13A0, 0x13F5, // L&  [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
  0x13F8, 0x13FD, // L&   [6] CHEROKEE SMALL LETTER YE..CHEROKEE SMALL LETTER MV
  0x1401, 0x166C, // Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
  0x166F, 0x167F, // Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
  0x1681, 0x169A, // Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
  0x16A0, 0x16EA, // Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
  0x16EE, 0x16F0, // Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
  0x16F1, 0x16F8, // Lo   [8] RUNIC LETTER K..RUNIC LETTER FRANKS CASKET AESC
  0x1700, 0x1711, // Lo  [18] TAGALOG LETTER A..TAGALOG LETTER HA
  0x1712, 0x1714, // Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
  0x1715, 0x1715, // Mc       TAGALOG SIGN PAMUDPOD
  0x171F, 0x1731, // Lo  [19] TAGALOG LETTER ARCHAIC RA..HANUNOO LETTER HA
  0x1732, 0x1733, // Mn   [2] HANUNOO VOWEL SIGN I..HANUNOO VOWEL SIGN U
  0x1734, 0x1734, // Mc       HANUNOO SIGN PAMUDPOD
  0x1740, 0x1751, // Lo  [18] BUHID LETTER A..BUHID LETTER HA
  0x1752, 0x1753, // Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
  0x1760, 0x176C, // Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
  0x176E, 0x1770, // Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
  0x1772, 0x1773, // Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
  0x1780, 0x17B3, // Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
  0x17B4, 0x17B5, // Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
  0x17B6, 0x17B6, // Mc       KHMER VOWEL SIGN AA
  0x17B7, 0x17BD, // Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
  0x17BE, 0x17C5, // Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
  0x17C6, 0x17C6, // Mn       KHMER SIGN NIKAHIT
  0x17C7, 0x17C8, // Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
  0x17C9, 0x17D3, // Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
  0x17D7, 0x17D7, // Lm       KHMER SIGN LEK TOO
  0x17DC, 0x17DC, // Lo       KHMER SIGN AVAKRAHASANYA
  0x17DD, 0x17DD, // Mn       KHMER SIGN ATTHACAN
  0x17E0, 0x17E9, // Nd  [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
  0x180B, 0x180D, // Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
  0x180F, 0x180F, // Mn       MONGOLIAN FREE VARIATION SELECTOR FOUR
  0x1810, 0x1819, // Nd  [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
  0x1820, 0x1842, // Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
  0x1843, 0x1843, // Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
  0x1844, 0x1878, // Lo  [53] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER CHA WITH TWO DOTS
  0x1880, 0x1884, // Lo   [5] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
  0x1885, 0x1886, // Mn   [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
  0x1887, 0x18A8, // Lo  [34] MONGOLIAN LETTER ALI GALI A..MONGOLIAN LETTER MANCHU ALI GALI BHA
  0x18A9, 0x18A9, // Mn       MONGOLIAN LETTER ALI GALI DAGALGA
  0x18AA, 0x18AA, // Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
  0x18B0, 0x18F5, // Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
  0x1900, 0x191E, // Lo  [31] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER TRA
  0x1920, 0x1922, // Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
  0x1923, 0x1926, // Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
  0x1927, 0x1928, // Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
  0x1929, 0x192B, // Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
  0x1930, 0x1931, // Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
  0x1932, 0x1932, // Mn       LIMBU SMALL LETTER ANUSVARA
  0x1933, 0x1938, // Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
  0x1939, 0x193B, // Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
  0x1946, 0x194F, // Nd  [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
  0x1950, 0x196D, // Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
  0x1970, 0x1974, // Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
  0x1980, 0x19AB, // Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
  0x19B0, 0x19C9, // Lo  [26] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE TONE MARK-2
  0x19D0, 0x19D9, // Nd  [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
  0x19DA, 0x19DA, // No       NEW TAI LUE THAM DIGIT ONE
  0x1A00, 0x1A16, // Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
  0x1A17, 0x1A18, // Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
  0x1A19, 0x1A1A, // Mc   [2] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN O
  0x1A1B, 0x1A1B, // Mn       BUGINESE VOWEL SIGN AE
  0x1A20, 0x1A54, // Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
  0x1A55, 0x1A55, // Mc       TAI THAM CONSONANT SIGN MEDIAL RA
  0x1A56, 0x1A56, // Mn       TAI THAM CONSONANT SIGN MEDIAL LA
  0x1A57, 0x1A57, // Mc       TAI THAM CONSONANT SIGN LA TANG LAI
  0x1A58, 0x1A5E, // Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
  0x1A60, 0x1A60, // Mn       TAI THAM SIGN SAKOT
  0x1A61, 0x1A61, // Mc       TAI THAM VOWEL SIGN A
  0x1A62, 0x1A62, // Mn       TAI THAM VOWEL SIGN MAI SAT
  0x1A63, 0x1A64, // Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
  0x1A65, 0x1A6C, // Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
  0x1A6D, 0x1A72, // Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
  0x1A73, 0x1A7C, // Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
  0x1A7F, 0x1A7F, // Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
  0x1A80, 0x1A89, // Nd  [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
  0x1A90, 0x1A99, // Nd  [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
  0x1AA7, 0x1AA7, // Lm       TAI THAM SIGN MAI YAMOK
  0x1AB0, 0x1ABD, // Mn  [14] COMBINING DOUBLED CIRCUMFLEX ACCENT..COMBINING PARENTHESES BELOW
  0x1ABF, 0x1ADD, // Mn  [31] COMBINING LATIN SMALL LETTER W BELOW..COMBINING DOT-AND-RING BELOW
  0x1AE0, 0x1AEB, // Mn  [12] COMBINING LEFT TACK ABOVE..COMBINING DOUBLE RIGHTWARDS ARROW ABOVE
  0x1B00, 0x1B03, // Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
  0x1B04, 0x1B04, // Mc       BALINESE SIGN BISAH
  0x1B05, 0x1B33, // Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
  0x1B34, 0x1B34, // Mn       BALINESE SIGN REREKAN
  0x1B35, 0x1B35, // Mc       BALINESE VOWEL SIGN TEDUNG
  0x1B36, 0x1B3A, // Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
  0x1B3B, 0x1B3B, // Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
  0x1B3C, 0x1B3C, // Mn       BALINESE VOWEL SIGN LA LENGA
  0x1B3D, 0x1B41, // Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
  0x1B42, 0x1B42, // Mn       BALINESE VOWEL SIGN PEPET
  0x1B43, 0x1B44, // Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
  0x1B45, 0x1B4C, // Lo   [8] BALINESE LETTER KAF SASAK..BALINESE LETTER ARCHAIC JNYA
  0x1B50, 0x1B59, // Nd  [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
  0x1B6B, 0x1B73, // Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
  0x1B80, 0x1B81, // Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
  0x1B82, 0x1B82, // Mc       SUNDANESE SIGN PANGWISAD
  0x1B83, 0x1BA0, // Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
  0x1BA1, 0x1BA1, // Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
  0x1BA2, 0x1BA5, // Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
  0x1BA6, 0x1BA7, // Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
  0x1BA8, 0x1BA9, // Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
  0x1BAA, 0x1BAA, // Mc       SUNDANESE SIGN PAMAAEH
  0x1BAB, 0x1BAD, // Mn   [3] SUNDANESE SIGN VIRAMA..SUNDANESE CONSONANT SIGN PASANGAN WA
  0x1BAE, 0x1BAF, // Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
  0x1BB0, 0x1BB9, // Nd  [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
  0x1BBA, 0x1BE5, // Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
  0x1BE6, 0x1BE6, // Mn       BATAK SIGN TOMPI
  0x1BE7, 0x1BE7, // Mc       BATAK VOWEL SIGN E
  0x1BE8, 0x1BE9, // Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
  0x1BEA, 0x1BEC, // Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
  0x1BED, 0x1BED, // Mn       BATAK VOWEL SIGN KARO O
  0x1BEE, 0x1BEE, // Mc       BATAK VOWEL SIGN U
  0x1BEF, 0x1BF1, // Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
  0x1BF2, 0x1BF3, // Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
  0x1C00, 0x1C23, // Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
  0x1C24, 0x1C2B, // Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
  0x1C2C, 0x1C33, // Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
  0x1C34, 0x1C35, // Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
  0x1C36, 0x1C37, // Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
  0x1C40, 0x1C49, // Nd  [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
  0x1C4D, 0x1C4F, // Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
  0x1C50, 0x1C59, // Nd  [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
  0x1C5A, 0x1C77, // Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
  0x1C78, 0x1C7D, // Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
  0x1C80, 0x1C8A, // L&  [11] CYRILLIC SMALL LETTER ROUNDED VE..CYRILLIC SMALL LETTER TJE
  0x1C90, 0x1CBA, // L&  [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
  0x1CBD, 0x1CBF, // L&   [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
  0x1CD0, 0x1CD2, // Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
  0x1CD4, 0x1CE0, // Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
  0x1CE1, 0x1CE1, // Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
  0x1CE2, 0x1CE8, // Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
  0x1CE9, 0x1CEC, // Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
  0x1CED, 0x1CED, // Mn       VEDIC SIGN TIRYAK
  0x1CEE, 0x1CF3, // Lo   [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
  0x1CF4, 0x1CF4, // Mn       VEDIC TONE CANDRA ABOVE
  0x1CF5, 0x1CF6, // Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
  0x1CF7, 0x1CF7, // Mc       VEDIC SIGN ATIKRAMA
  0x1CF8, 0x1CF9, // Mn   [2] VEDIC TONE RING ABOVE..VEDIC TONE DOUBLE RING ABOVE
  0x1CFA, 0x1CFA, // Lo       VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
  0x1D00, 0x1D2B, // L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
  0x1D2C, 0x1D6A, // Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
  0x1D6B, 0x1D77, // L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
  0x1D78, 0x1D78, // Lm       MODIFIER LETTER CYRILLIC EN
  0x1D79, 0x1D9A, // L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
  0x1D9B, 0x1DBF, // Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
  0x1DC0, 0x1DFF, // Mn  [64] COMBINING DOTTED GRAVE ACCENT..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
  0x1E00, 0x1F15, // L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
  0x1F18, 0x1F1D, // L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  0x1F20, 0x1F45, // L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
  0x1F48, 0x1F4D, // L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  0x1F50, 0x1F57, // L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
  0x1F59, 0x1F59, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
  0x1F5B, 0x1F5B, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  0x1F5D, 0x1F5D, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  0x1F5F, 0x1F7D, // L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
  0x1F80, 0x1FB4, // L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
  0x1FB6, 0x1FBC, // L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
  0x1FBE, 0x1FBE, // L&       GREEK PROSGEGRAMMENI
  0x1FC2, 0x1FC4, // L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
  0x1FC6, 0x1FCC, // L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
  0x1FD0, 0x1FD3, // L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
  0x1FD6, 0x1FDB, // L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
  0x1FE0, 0x1FEC, // L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
  0x1FF2, 0x1FF4, // L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
  0x1FF6, 0x1FFC, // L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
  0x200C, 0x200D, // Cf   [2] ZERO WIDTH NON-JOINER..ZERO WIDTH JOINER
  0x203F, 0x2040, // Pc   [2] UNDERTIE..CHARACTER TIE
  0x2054, 0x2054, // Pc       INVERTED UNDERTIE
  0x2071, 0x2071, // Lm       SUPERSCRIPT LATIN SMALL LETTER I
  0x207F, 0x207F, // Lm       SUPERSCRIPT LATIN SMALL LETTER N
  0x2090, 0x209C, // Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
  0x20D0, 0x20DC, // Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
  0x20E1, 0x20E1, // Mn       COMBINING LEFT RIGHT ARROW ABOVE
  0x20E5, 0x20F0, // Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
  0x2102, 0x2102, // L&       DOUBLE-STRUCK CAPITAL C
  0x2107, 0x2107, // L&       EULER CONSTANT
  0x210A, 0x2113, // L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
  0x2115, 0x2115, // L&       DOUBLE-STRUCK CAPITAL N
  0x2118, 0x2118, // Sm       SCRIPT CAPITAL P
  0x2119, 0x211D, // L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
  0x2124, 0x2124, // L&       DOUBLE-STRUCK CAPITAL Z
  0x2126, 0x2126, // L&       OHM SIGN
  0x2128, 0x2128, // L&       BLACK-LETTER CAPITAL Z
  0x212A, 0x212D, // L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
  0x212E, 0x212E, // So       ESTIMATED SYMBOL
  0x212F, 0x2134, // L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
  0x2135, 0x2138, // Lo   [4] ALEF SYMBOL..DALET SYMBOL
  0x2139, 0x2139, // L&       INFORMATION SOURCE
  0x213C, 0x213F, // L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
  0x2145, 0x2149, // L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
  0x214E, 0x214E, // L&       TURNED SMALL F
  0x2160, 0x2182, // Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
  0x2183, 0x2184, // L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
  0x2185, 0x2188, // Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
  0x2C00, 0x2C7B, // L& [124] GLAGOLITIC CAPITAL LETTER AZU..LATIN LETTER SMALL CAPITAL TURNED E
  0x2C7C, 0x2C7D, // Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
  0x2C7E, 0x2CE4, // L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
  0x2CEB, 0x2CEE, // L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
  0x2CEF, 0x2CF1, // Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
  0x2CF2, 0x2CF3, // L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
  0x2D00, 0x2D25, // L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
  0x2D27, 0x2D27, // L&       GEORGIAN SMALL LETTER YN
  0x2D2D, 0x2D2D, // L&       GEORGIAN SMALL LETTER AEN
  0x2D30, 0x2D67, // Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
  0x2D6F, 0x2D6F, // Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
  0x2D7F, 0x2D7F, // Mn       TIFINAGH CONSONANT JOINER
  0x2D80, 0x2D96, // Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
  0x2DA0, 0x2DA6, // Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
  0x2DA8, 0x2DAE, // Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
  0x2DB0, 0x2DB6, // Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
  0x2DB8, 0x2DBE, // Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
  0x2DC0, 0x2DC6, // Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
  0x2DC8, 0x2DCE, // Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
  0x2DD0, 0x2DD6, // Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
  0x2DD8, 0x2DDE, // Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
  0x2DE0, 0x2DFF, // Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
  0x3005, 0x3005, // Lm       IDEOGRAPHIC ITERATION MARK
  0x3006, 0x3006, // Lo       IDEOGRAPHIC CLOSING MARK
  0x3007, 0x3007, // Nl       IDEOGRAPHIC NUMBER ZERO
  0x3021, 0x3029, // Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
  0x302A, 0x302D, // Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
  0x302E, 0x302F, // Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
  0x3031, 0x3035, // Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
  0x3038, 0x303A, // Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
  0x303B, 0x303B, // Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
  0x303C, 0x303C, // Lo       MASU MARK
  0x3041, 0x3096, // Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
  0x3099, 0x309A, // Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  0x309B, 0x309C, // Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  0x309D, 0x309E, // Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
  0x309F, 0x309F, // Lo       HIRAGANA DIGRAPH YORI
  0x30A1, 0x30FA, // Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
  0x30FB, 0x30FB, // Po       KATAKANA MIDDLE DOT
  0x30FC, 0x30FE, // Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
  0x30FF, 0x30FF, // Lo       KATAKANA DIGRAPH KOTO
  0x3105, 0x312F, // Lo  [43] BOPOMOFO LETTER B..BOPOMOFO LETTER NN
  0x3131, 0x318E, // Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
  0x31A0, 0x31BF, // Lo  [32] BOPOMOFO LETTER BU..BOPOMOFO LETTER AH
  0x31F0, 0x31FF, // Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
  0x3400, 0x4DBF, // Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
  0x4E00, 0xA014, // Lo [21013] CJK UNIFIED IDEOGRAPH-4E00..YI SYLLABLE E
  0xA015, 0xA015, // Lm       YI SYLLABLE WU
  0xA016, 0xA48C, // Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
  0xA4D0, 0xA4F7, // Lo  [40] LISU LETTER BA..LISU LETTER OE
  0xA4F8, 0xA4FD, // Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
  0xA500, 0xA60B, // Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
  0xA60C, 0xA60C, // Lm       VAI SYLLABLE LENGTHENER
  0xA610, 0xA61F, // Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
  0xA620, 0xA629, // Nd  [10] VAI DIGIT ZERO..VAI DIGIT NINE
  0xA62A, 0xA62B, // Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
  0xA640, 0xA66D, // L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
  0xA66E, 0xA66E, // Lo       CYRILLIC LETTER MULTIOCULAR O
  0xA66F, 0xA66F, // Mn       COMBINING CYRILLIC VZMET
  0xA674, 0xA67D, // Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
  0xA67F, 0xA67F, // Lm       CYRILLIC PAYEROK
  0xA680, 0xA69B, // L&  [28] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER CROSSED O
  0xA69C, 0xA69D, // Lm   [2] MODIFIER LETTER CYRILLIC HARD SIGN..MODIFIER LETTER CYRILLIC SOFT SIGN
  0xA69E, 0xA69F, // Mn   [2] COMBINING CYRILLIC LETTER EF..COMBINING CYRILLIC LETTER IOTIFIED E
  0xA6A0, 0xA6E5, // Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
  0xA6E6, 0xA6EF, // Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
  0xA6F0, 0xA6F1, // Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
  0xA717, 0xA71F, // Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
  0xA722, 0xA76F, // L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
  0xA770, 0xA770, // Lm       MODIFIER LETTER US
  0xA771, 0xA787, // L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
  0xA788, 0xA788, // Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
  0xA78B, 0xA78E, // L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
  0xA78F, 0xA78F, // Lo       LATIN LETTER SINOLOGICAL DOT
  0xA790, 0xA7DC, // L&  [77] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN CAPITAL LETTER LAMBDA WITH STROKE
  0xA7F1, 0xA7F4, // Lm   [4] MODIFIER LETTER CAPITAL S..MODIFIER LETTER CAPITAL Q
  0xA7F5, 0xA7F6, // L&   [2] LATIN CAPITAL LETTER REVERSED HALF H..LATIN SMALL LETTER REVERSED HALF H
  0xA7F7, 0xA7F7, // Lo       LATIN EPIGRAPHIC LETTER SIDEWAYS I
  0xA7F8, 0xA7F9, // Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
  0xA7FA, 0xA7FA, // L&       LATIN LETTER SMALL CAPITAL TURNED M
  0xA7FB, 0xA801, // Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
  0xA802, 0xA802, // Mn       SYLOTI NAGRI SIGN DVISVARA
  0xA803, 0xA805, // Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
  0xA806, 0xA806, // Mn       SYLOTI NAGRI SIGN HASANTA
  0xA807, 0xA80A, // Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
  0xA80B, 0xA80B, // Mn       SYLOTI NAGRI SIGN ANUSVARA
  0xA80C, 0xA822, // Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
  0xA823, 0xA824, // Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
  0xA825, 0xA826, // Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
  0xA827, 0xA827, // Mc       SYLOTI NAGRI VOWEL SIGN OO
  0xA82C, 0xA82C, // Mn       SYLOTI NAGRI SIGN ALTERNATE HASANTA
  0xA840, 0xA873, // Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
  0xA880, 0xA881, // Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
  0xA882, 0xA8B3, // Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
  0xA8B4, 0xA8C3, // Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
  0xA8C4, 0xA8C5, // Mn   [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA SIGN CANDRABINDU
  0xA8D0, 0xA8D9, // Nd  [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
  0xA8E0, 0xA8F1, // Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
  0xA8F2, 0xA8F7, // Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
  0xA8FB, 0xA8FB, // Lo       DEVANAGARI HEADSTROKE
  0xA8FD, 0xA8FE, // Lo   [2] DEVANAGARI JAIN OM..DEVANAGARI LETTER AY
  0xA8FF, 0xA8FF, // Mn       DEVANAGARI VOWEL SIGN AY
  0xA900, 0xA909, // Nd  [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
  0xA90A, 0xA925, // Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
  0xA926, 0xA92D, // Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
  0xA930, 0xA946, // Lo  [23] REJANG LETTER KA..REJANG LETTER A
  0xA947, 0xA951, // Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
  0xA952, 0xA953, // Mc   [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
  0xA960, 0xA97C, // Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
  0xA980, 0xA982, // Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
  0xA983, 0xA983, // Mc       JAVANESE SIGN WIGNYAN
  0xA984, 0xA9B2, // Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
  0xA9B3, 0xA9B3, // Mn       JAVANESE SIGN CECAK TELU
  0xA9B4, 0xA9B5, // Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
  0xA9B6, 0xA9B9, // Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
  0xA9BA, 0xA9BB, // Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
  0xA9BC, 0xA9BD, // Mn   [2] JAVANESE VOWEL SIGN PEPET..JAVANESE CONSONANT SIGN KERET
  0xA9BE, 0xA9C0, // Mc   [3] JAVANESE CONSONANT SIGN PENGKAL..JAVANESE PANGKON
  0xA9CF, 0xA9CF, // Lm       JAVANESE PANGRANGKEP
  0xA9D0, 0xA9D9, // Nd  [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
  0xA9E0, 0xA9E4, // Lo   [5] MYANMAR LETTER SHAN GHA..MYANMAR LETTER SHAN BHA
  0xA9E5, 0xA9E5, // Mn       MYANMAR SIGN SHAN SAW
  0xA9E6, 0xA9E6, // Lm       MYANMAR MODIFIER LETTER SHAN REDUPLICATION
  0xA9E7, 0xA9EF, // Lo   [9] MYANMAR LETTER TAI LAING NYA..MYANMAR LETTER TAI LAING NNA
  0xA9F0, 0xA9F9, // Nd  [10] MYANMAR TAI LAING DIGIT ZERO..MYANMAR TAI LAING DIGIT NINE
  0xA9FA, 0xA9FE, // Lo   [5] MYANMAR LETTER TAI LAING LLA..MYANMAR LETTER TAI LAING BHA
  0xAA00, 0xAA28, // Lo  [41] CHAM LETTER A..CHAM LETTER HA
  0xAA29, 0xAA2E, // Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
  0xAA2F, 0xAA30, // Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
  0xAA31, 0xAA32, // Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
  0xAA33, 0xAA34, // Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
  0xAA35, 0xAA36, // Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
  0xAA40, 0xAA42, // Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
  0xAA43, 0xAA43, // Mn       CHAM CONSONANT SIGN FINAL NG
  0xAA44, 0xAA4B, // Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
  0xAA4C, 0xAA4C, // Mn       CHAM CONSONANT SIGN FINAL M
  0xAA4D, 0xAA4D, // Mc       CHAM CONSONANT SIGN FINAL H
  0xAA50, 0xAA59, // Nd  [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
  0xAA60, 0xAA6F, // Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
  0xAA70, 0xAA70, // Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
  0xAA71, 0xAA76, // Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
  0xAA7A, 0xAA7A, // Lo       MYANMAR LETTER AITON RA
  0xAA7B, 0xAA7B, // Mc       MYANMAR SIGN PAO KAREN TONE
  0xAA7C, 0xAA7C, // Mn       MYANMAR SIGN TAI LAING TONE-2
  0xAA7D, 0xAA7D, // Mc       MYANMAR SIGN TAI LAING TONE-5
  0xAA7E, 0xAAAF, // Lo  [50] MYANMAR LETTER SHWE PALAUNG CHA..TAI VIET LETTER HIGH O
  0xAAB0, 0xAAB0, // Mn       TAI VIET MAI KANG
  0xAAB1, 0xAAB1, // Lo       TAI VIET VOWEL AA
  0xAAB2, 0xAAB4, // Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
  0xAAB5, 0xAAB6, // Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
  0xAAB7, 0xAAB8, // Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
  0xAAB9, 0xAABD, // Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
  0xAABE, 0xAABF, // Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
  0xAAC0, 0xAAC0, // Lo       TAI VIET TONE MAI NUENG
  0xAAC1, 0xAAC1, // Mn       TAI VIET TONE MAI THO
  0xAAC2, 0xAAC2, // Lo       TAI VIET TONE MAI SONG
  0xAADB, 0xAADC, // Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
  0xAADD, 0xAADD, // Lm       TAI VIET SYMBOL SAM
  0xAAE0, 0xAAEA, // Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
  0xAAEB, 0xAAEB, // Mc       MEETEI MAYEK VOWEL SIGN II
  0xAAEC, 0xAAED, // Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
  0xAAEE, 0xAAEF, // Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
  0xAAF2, 0xAAF2, // Lo       MEETEI MAYEK ANJI
  0xAAF3, 0xAAF4, // Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
  0xAAF5, 0xAAF5, // Mc       MEETEI MAYEK VOWEL SIGN VISARGA
  0xAAF6, 0xAAF6, // Mn       MEETEI MAYEK VIRAMA
  0xAB01, 0xAB06, // Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
  0xAB09, 0xAB0E, // Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
  0xAB11, 0xAB16, // Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
  0xAB20, 0xAB26, // Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
  0xAB28, 0xAB2E, // Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
  0xAB30, 0xAB5A, // L&  [43] LATIN SMALL LETTER BARRED ALPHA..LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
  0xAB5C, 0xAB5F, // Lm   [4] MODIFIER LETTER SMALL HENG..MODIFIER LETTER SMALL U WITH LEFT HOOK
  0xAB60, 0xAB68, // L&   [9] LATIN SMALL LETTER SAKHA YAT..LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE
  0xAB69, 0xAB69, // Lm       MODIFIER LETTER SMALL TURNED W
  0xAB70, 0xABBF, // L&  [80] CHEROKEE SMALL LETTER A..CHEROKEE SMALL LETTER YA
  0xABC0, 0xABE2, // Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
  0xABE3, 0xABE4, // Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
  0xABE5, 0xABE5, // Mn       MEETEI MAYEK VOWEL SIGN ANAP
  0xABE6, 0xABE7, // Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
  0xABE8, 0xABE8, // Mn       MEETEI MAYEK VOWEL SIGN UNAP
  0xABE9, 0xABEA, // Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
  0xABEC, 0xABEC, // Mc       MEETEI MAYEK LUM IYEK
  0xABED, 0xABED, // Mn       MEETEI MAYEK APUN IYEK
  0xABF0, 0xABF9, // Nd  [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
  0xAC00, 0xD7A3, // Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
  0xD7B0, 0xD7C6, // Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
  0xD7CB, 0xD7FB, // Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
  0xF900, 0xFA6D, // Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
  0xFA70, 0xFAD9, // Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
  0xFB00, 0xFB06, // L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
  0xFB13, 0xFB17, // L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
  0xFB1D, 0xFB1D, // Lo       HEBREW LETTER YOD WITH HIRIQ
  0xFB1E, 0xFB1E, // Mn       HEBREW POINT JUDEO-SPANISH VARIKA
  0xFB1F, 0xFB28, // Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
  0xFB2A, 0xFB36, // Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
  0xFB38, 0xFB3C, // Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
  0xFB3E, 0xFB3E, // Lo       HEBREW LETTER MEM WITH DAGESH
  0xFB40, 0xFB41, // Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
  0xFB43, 0xFB44, // Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
  0xFB46, 0xFBB1, // Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
  0xFBD3, 0xFD3D, // Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
  0xFD50, 0xFD8F, // Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
  0xFD92, 0xFDC7, // Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
  0xFDF0, 0xFDFB, // Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
  0xFE00, 0xFE0F, // Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
  0xFE20, 0xFE2F, // Mn  [16] COMBINING LIGATURE LEFT HALF..COMBINING CYRILLIC TITLO RIGHT HALF
  0xFE33, 0xFE34, // Pc   [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
  0xFE4D, 0xFE4F, // Pc   [3] DASHED LOW LINE..WAVY LOW LINE
  0xFE70, 0xFE74, // Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
  0xFE76, 0xFEFC, // Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
  0xFF10, 0xFF19, // Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
  0xFF21, 0xFF3A, // L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
  0xFF3F, 0xFF3F, // Pc       FULLWIDTH LOW LINE
  0xFF41, 0xFF5A, // L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
  0xFF65, 0xFF65, // Po       HALFWIDTH KATAKANA MIDDLE DOT
  0xFF66, 0xFF6F, // Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
  0xFF70, 0xFF70, // Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
  0xFF71, 0xFF9D, // Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
  0xFF9E, 0xFF9F, // Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
  0xFFA0, 0xFFBE, // Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
  0xFFC2, 0xFFC7, // Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
  0xFFCA, 0xFFCF, // Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
  0xFFD2, 0xFFD7, // Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
  0xFFDA, 0xFFDC, // Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
  0x10000, 0x1000B, // Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
  0x1000D, 0x10026, // Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
  0x10028, 0x1003A, // Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
  0x1003C, 0x1003D, // Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
  0x1003F, 0x1004D, // Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
  0x10050, 0x1005D, // Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
  0x10080, 0x100FA, // Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
  0x10140, 0x10174, // Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
  0x101FD, 0x101FD, // Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
  0x10280, 0x1029C, // Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
  0x102A0, 0x102D0, // Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
  0x102E0, 0x102E0, // Mn       COPTIC EPACT THOUSANDS MARK
  0x10300, 0x1031F, // Lo  [32] OLD ITALIC LETTER A..OLD ITALIC LETTER ESS
  0x1032D, 0x10340, // Lo  [20] OLD ITALIC LETTER YE..GOTHIC LETTER PAIRTHRA
  0x10341, 0x10341, // Nl       GOTHIC LETTER NINETY
  0x10342, 0x10349, // Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
  0x1034A, 0x1034A, // Nl       GOTHIC LETTER NINE HUNDRED
  0x10350, 0x10375, // Lo  [38] OLD PERMIC LETTER AN..OLD PERMIC LETTER IA
  0x10376, 0x1037A, // Mn   [5] COMBINING OLD PERMIC LETTER AN..COMBINING OLD PERMIC LETTER SII
  0x10380, 0x1039D, // Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
  0x103A0, 0x103C3, // Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
  0x103C8, 0x103CF, // Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
  0x103D1, 0x103D5, // Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
  0x10400, 0x1044F, // L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
  0x10450, 0x1049D, // Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
  0x104A0, 0x104A9, // Nd  [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
  0x104B0, 0x104D3, // L&  [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
  0x104D8, 0x104FB, // L&  [36] OSAGE SMALL LETTER A..OSAGE SMALL LETTER ZHA
  0x10500, 0x10527, // Lo  [40] ELBASAN LETTER A..ELBASAN LETTER KHE
  0x10530, 0x10563, // Lo  [52] CAUCASIAN ALBANIAN LETTER ALT..CAUCASIAN ALBANIAN LETTER KIW
  0x10570, 0x1057A, // L&  [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
  0x1057C, 0x1058A, // L&  [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
  0x1058C, 0x10592, // L&   [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
  0x10594, 0x10595, // L&   [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
  0x10597, 0x105A1, // L&  [11] VITHKUQI SMALL LETTER A..VITHKUQI SMALL LETTER GA
  0x105A3, 0x105B1, // L&  [15] VITHKUQI SMALL LETTER HA..VITHKUQI SMALL LETTER RE
  0x105B3, 0x105B9, // L&   [7] VITHKUQI SMALL LETTER SE..VITHKUQI SMALL LETTER XE
  0x105BB, 0x105BC, // L&   [2] VITHKUQI SMALL LETTER Y..VITHKUQI SMALL LETTER ZE
  0x105C0, 0x105F3, // Lo  [52] TODHRI LETTER A..TODHRI LETTER OO
  0x10600, 0x10736, // Lo [311] LINEAR A SIGN AB001..LINEAR A SIGN A664
  0x10740, 0x10755, // Lo  [22] LINEAR A SIGN A701 A..LINEAR A SIGN A732 JE
  0x10760, 0x10767, // Lo   [8] LINEAR A SIGN A800..LINEAR A SIGN A807
  0x10780, 0x10785, // Lm   [6] MODIFIER LETTER SMALL CAPITAL AA..MODIFIER LETTER SMALL B WITH HOOK
  0x10787, 0x107B0, // Lm  [42] MODIFIER LETTER SMALL DZ DIGRAPH..MODIFIER LETTER SMALL V WITH RIGHT HOOK
  0x107B2, 0x107BA, // Lm   [9] MODIFIER LETTER SMALL CAPITAL Y..MODIFIER LETTER SMALL S WITH CURL
  0x10800, 0x10805, // Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
  0x10808, 0x10808, // Lo       CYPRIOT SYLLABLE JO
  0x1080A, 0x10835, // Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
  0x10837, 0x10838, // Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
  0x1083C, 0x1083C, // Lo       CYPRIOT SYLLABLE ZA
  0x1083F, 0x10855, // Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
  0x10860, 0x10876, // Lo  [23] PALMYRENE LETTER ALEPH..PALMYRENE LETTER TAW
  0x10880, 0x1089E, // Lo  [31] NABATAEAN LETTER FINAL ALEPH..NABATAEAN LETTER TAW
  0x108E0, 0x108F2, // Lo  [19] HATRAN LETTER ALEPH..HATRAN LETTER QOPH
  0x108F4, 0x108F5, // Lo   [2] HATRAN LETTER SHIN..HATRAN LETTER TAW
  0x10900, 0x10915, // Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
  0x10920, 0x10939, // Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
  0x10940, 0x10959, // Lo  [26] SIDETIC LETTER N01..SIDETIC LETTER N26
  0x10980, 0x109B7, // Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
  0x109BE, 0x109BF, // Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
  0x10A00, 0x10A00, // Lo       KHAROSHTHI LETTER A
  0x10A01, 0x10A03, // Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
  0x10A05, 0x10A06, // Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
  0x10A0C, 0x10A0F, // Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
  0x10A10, 0x10A13, // Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
  0x10A15, 0x10A17, // Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
  0x10A19, 0x10A35, // Lo  [29] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER VHA
  0x10A38, 0x10A3A, // Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
  0x10A3F, 0x10A3F, // Mn       KHAROSHTHI VIRAMA
  0x10A60, 0x10A7C, // Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
  0x10A80, 0x10A9C, // Lo  [29] OLD NORTH ARABIAN LETTER HEH..OLD NORTH ARABIAN LETTER ZAH
  0x10AC0, 0x10AC7, // Lo   [8] MANICHAEAN LETTER ALEPH..MANICHAEAN LETTER WAW
  0x10AC9, 0x10AE4, // Lo  [28] MANICHAEAN LETTER ZAYIN..MANICHAEAN LETTER TAW
  0x10AE5, 0x10AE6, // Mn   [2] MANICHAEAN ABBREVIATION MARK ABOVE..MANICHAEAN ABBREVIATION MARK BELOW
  0x10B00, 0x10B35, // Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
  0x10B40, 0x10B55, // Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
  0x10B60, 0x10B72, // Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
  0x10B80, 0x10B91, // Lo  [18] PSALTER PAHLAVI LETTER ALEPH..PSALTER PAHLAVI LETTER TAW
  0x10C00, 0x10C48, // Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
  0x10C80, 0x10CB2, // L&  [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
  0x10CC0, 0x10CF2, // L&  [51] OLD HUNGARIAN SMALL LETTER A..OLD HUNGARIAN SMALL LETTER US
  0x10D00, 0x10D23, // Lo  [36] HANIFI ROHINGYA LETTER A..HANIFI ROHINGYA MARK NA KHONNA
  0x10D24, 0x10D27, // Mn   [4] HANIFI ROHINGYA SIGN HARBAHAY..HANIFI ROHINGYA SIGN TASSI
  0x10D30, 0x10D39, // Nd  [10] HANIFI ROHINGYA DIGIT ZERO..HANIFI ROHINGYA DIGIT NINE
  0x10D40, 0x10D49, // Nd  [10] GARAY DIGIT ZERO..GARAY DIGIT NINE
  0x10D4A, 0x10D4D, // Lo   [4] GARAY VOWEL SIGN A..GARAY VOWEL SIGN EE
  0x10D4E, 0x10D4E, // Lm       GARAY VOWEL LENGTH MARK
  0x10D4F, 0x10D4F, // Lo       GARAY SUKUN
  0x10D50, 0x10D65, // L&  [22] GARAY CAPITAL LETTER A..GARAY CAPITAL LETTER OLD NA
  0x10D69, 0x10D6D, // Mn   [5] GARAY VOWEL SIGN E..GARAY CONSONANT NASALIZATION MARK
  0x10D6F, 0x10D6F, // Lm       GARAY REDUPLICATION MARK
  0x10D70, 0x10D85, // L&  [22] GARAY SMALL LETTER A..GARAY SMALL LETTER OLD NA
  0x10E80, 0x10EA9, // Lo  [42] YEZIDI LETTER ELIF..YEZIDI LETTER ET
  0x10EAB, 0x10EAC, // Mn   [2] YEZIDI COMBINING HAMZA MARK..YEZIDI COMBINING MADDA MARK
  0x10EB0, 0x10EB1, // Lo   [2] YEZIDI LETTER LAM WITH DOT ABOVE..YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
  0x10EC2, 0x10EC4, // Lo   [3] ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW..ARABIC LETTER KAF WITH TWO DOTS VERTICALLY BELOW
  0x10EC5, 0x10EC5, // Lm       ARABIC SMALL YEH BARREE WITH TWO DOTS BELOW
  0x10EC6, 0x10EC7, // Lo   [2] ARABIC LETTER THIN NOON..ARABIC LETTER YEH WITH FOUR DOTS BELOW
  0x10EFA, 0x10EFF, // Mn   [6] ARABIC DOUBLE VERTICAL BAR BELOW..ARABIC SMALL LOW WORD MADDA
  0x10F00, 0x10F1C, // Lo  [29] OLD SOGDIAN LETTER ALEPH..OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
  0x10F27, 0x10F27, // Lo       OLD SOGDIAN LIGATURE AYIN-DALETH
  0x10F30, 0x10F45, // Lo  [22] SOGDIAN LETTER ALEPH..SOGDIAN INDEPENDENT SHIN
  0x10F46, 0x10F50, // Mn  [11] SOGDIAN COMBINING DOT BELOW..SOGDIAN COMBINING STROKE BELOW
  0x10F70, 0x10F81, // Lo  [18] OLD UYGHUR LETTER ALEPH..OLD UYGHUR LETTER LESH
  0x10F82, 0x10F85, // Mn   [4] OLD UYGHUR COMBINING DOT ABOVE..OLD UYGHUR COMBINING TWO DOTS BELOW
  0x10FB0, 0x10FC4, // Lo  [21] CHORASMIAN LETTER ALEPH..CHORASMIAN LETTER TAW
  0x10FE0, 0x10FF6, // Lo  [23] ELYMAIC LETTER ALEPH..ELYMAIC LIGATURE ZAYIN-YODH
  0x11000, 0x11000, // Mc       BRAHMI SIGN CANDRABINDU
  0x11001, 0x11001, // Mn       BRAHMI SIGN ANUSVARA
  0x11002, 0x11002, // Mc       BRAHMI SIGN VISARGA
  0x11003, 0x11037, // Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
  0x11038, 0x11046, // Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
  0x11066, 0x1106F, // Nd  [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
  0x11070, 0x11070, // Mn       BRAHMI SIGN OLD TAMIL VIRAMA
  0x11071, 0x11072, // Lo   [2] BRAHMI LETTER OLD TAMIL SHORT E..BRAHMI LETTER OLD TAMIL SHORT O
  0x11073, 0x11074, // Mn   [2] BRAHMI VOWEL SIGN OLD TAMIL SHORT E..BRAHMI VOWEL SIGN OLD TAMIL SHORT O
  0x11075, 0x11075, // Lo       BRAHMI LETTER OLD TAMIL LLA
  0x1107F, 0x11081, // Mn   [3] BRAHMI NUMBER JOINER..KAITHI SIGN ANUSVARA
  0x11082, 0x11082, // Mc       KAITHI SIGN VISARGA
  0x11083, 0x110AF, // Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
  0x110B0, 0x110B2, // Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
  0x110B3, 0x110B6, // Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
  0x110B7, 0x110B8, // Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
  0x110B9, 0x110BA, // Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
  0x110C2, 0x110C2, // Mn       KAITHI VOWEL SIGN VOCALIC R
  0x110D0, 0x110E8, // Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
  0x110F0, 0x110F9, // Nd  [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
  0x11100, 0x11102, // Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
  0x11103, 0x11126, // Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
  0x11127, 0x1112B, // Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
  0x1112C, 0x1112C, // Mc       CHAKMA VOWEL SIGN E
  0x1112D, 0x11134, // Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
  0x11136, 0x1113F, // Nd  [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
  0x11144, 0x11144, // Lo       CHAKMA LETTER LHAA
  0x11145, 0x11146, // Mc   [2] CHAKMA VOWEL SIGN AA..CHAKMA VOWEL SIGN EI
  0x11147, 0x11147, // Lo       CHAKMA LETTER VAA
  0x11150, 0x11172, // Lo  [35] MAHAJANI LETTER A..MAHAJANI LETTER RRA
  0x11173, 0x11173, // Mn       MAHAJANI SIGN NUKTA
  0x11176, 0x11176, // Lo       MAHAJANI LIGATURE SHRI
  0x11180, 0x11181, // Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
  0x11182, 0x11182, // Mc       SHARADA SIGN VISARGA
  0x11183, 0x111B2, // Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
  0x111B3, 0x111B5, // Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
  0x111B6, 0x111BE, // Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
  0x111BF, 0x111C0, // Mc   [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
  0x111C1, 0x111C4, // Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
  0x111C9, 0x111CC, // Mn   [4] SHARADA SANDHI MARK..SHARADA EXTRA SHORT VOWEL MARK
  0x111CE, 0x111CE, // Mc       SHARADA VOWEL SIGN PRISHTHAMATRA E
  0x111CF, 0x111CF, // Mn       SHARADA SIGN INVERTED CANDRABINDU
  0x111D0, 0x111D9, // Nd  [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
  0x111DA, 0x111DA, // Lo       SHARADA EKAM
  0x111DC, 0x111DC, // Lo       SHARADA HEADSTROKE
  0x11200, 0x11211, // Lo  [18] KHOJKI LETTER A..KHOJKI LETTER JJA
  0x11213, 0x1122B, // Lo  [25] KHOJKI LETTER NYA..KHOJKI LETTER LLA
  0x1122C, 0x1122E, // Mc   [3] KHOJKI VOWEL SIGN AA..KHOJKI VOWEL SIGN II
  0x1122F, 0x11231, // Mn   [3] KHOJKI VOWEL SIGN U..KHOJKI VOWEL SIGN AI
  0x11232, 0x11233, // Mc   [2] KHOJKI VOWEL SIGN O..KHOJKI VOWEL SIGN AU
  0x11234, 0x11234, // Mn       KHOJKI SIGN ANUSVARA
  0x11235, 0x11235, // Mc       KHOJKI SIGN VIRAMA
  0x11236, 0x11237, // Mn   [2] KHOJKI SIGN NUKTA..KHOJKI SIGN SHADDA
  0x1123E, 0x1123E, // Mn       KHOJKI SIGN SUKUN
  0x1123F, 0x11240, // Lo   [2] KHOJKI LETTER QA..KHOJKI LETTER SHORT I
  0x11241, 0x11241, // Mn       KHOJKI VOWEL SIGN VOCALIC R
  0x11280, 0x11286, // Lo   [7] MULTANI LETTER A..MULTANI LETTER GA
  0x11288, 0x11288, // Lo       MULTANI LETTER GHA
  0x1128A, 0x1128D, // Lo   [4] MULTANI LETTER CA..MULTANI LETTER JJA
  0x1128F, 0x1129D, // Lo  [15] MULTANI LETTER NYA..MULTANI LETTER BA
  0x1129F, 0x112A8, // Lo  [10] MULTANI LETTER BHA..MULTANI LETTER RHA
  0x112B0, 0x112DE, // Lo  [47] KHUDAWADI LETTER A..KHUDAWADI LETTER HA
  0x112DF, 0x112DF, // Mn       KHUDAWADI SIGN ANUSVARA
  0x112E0, 0x112E2, // Mc   [3] KHUDAWADI VOWEL SIGN AA..KHUDAWADI VOWEL SIGN II
  0x112E3, 0x112EA, // Mn   [8] KHUDAWADI VOWEL SIGN U..KHUDAWADI SIGN VIRAMA
  0x112F0, 0x112F9, // Nd  [10] KHUDAWADI DIGIT ZERO..KHUDAWADI DIGIT NINE
  0x11300, 0x11301, // Mn   [2] GRANTHA SIGN COMBINING ANUSVARA ABOVE..GRANTHA SIGN CANDRABINDU
  0x11302, 0x11303, // Mc   [2] GRANTHA SIGN ANUSVARA..GRANTHA SIGN VISARGA
  0x11305, 0x1130C, // Lo   [8] GRANTHA LETTER A..GRANTHA LETTER VOCALIC L
  0x1130F, 0x11310, // Lo   [2] GRANTHA LETTER EE..GRANTHA LETTER AI
  0x11313, 0x11328, // Lo  [22] GRANTHA LETTER OO..GRANTHA LETTER NA
  0x1132A, 0x11330, // Lo   [7] GRANTHA LETTER PA..GRANTHA LETTER RA
  0x11332, 0x11333, // Lo   [2] GRANTHA LETTER LA..GRANTHA LETTER LLA
  0x11335, 0x11339, // Lo   [5] GRANTHA LETTER VA..GRANTHA LETTER HA
  0x1133B, 0x1133C, // Mn   [2] COMBINING BINDU BELOW..GRANTHA SIGN NUKTA
  0x1133D, 0x1133D, // Lo       GRANTHA SIGN AVAGRAHA
  0x1133E, 0x1133F, // Mc   [2] GRANTHA VOWEL SIGN AA..GRANTHA VOWEL SIGN I
  0x11340, 0x11340, // Mn       GRANTHA VOWEL SIGN II
  0x11341, 0x11344, // Mc   [4] GRANTHA VOWEL SIGN U..GRANTHA VOWEL SIGN VOCALIC RR
  0x11347, 0x11348, // Mc   [2] GRANTHA VOWEL SIGN EE..GRANTHA VOWEL SIGN AI
  0x1134B, 0x1134D, // Mc   [3] GRANTHA VOWEL SIGN OO..GRANTHA SIGN VIRAMA
  0x11350, 0x11350, // Lo       GRANTHA OM
  0x11357, 0x11357, // Mc       GRANTHA AU LENGTH MARK
  0x1135D, 0x11361, // Lo   [5] GRANTHA SIGN PLUTA..GRANTHA LETTER VOCALIC LL
  0x11362, 0x11363, // Mc   [2] GRANTHA VOWEL SIGN VOCALIC L..GRANTHA VOWEL SIGN VOCALIC LL
  0x11366, 0x1136C, // Mn   [7] COMBINING GRANTHA DIGIT ZERO..COMBINING GRANTHA DIGIT SIX
  0x11370, 0x11374, // Mn   [5] COMBINING GRANTHA LETTER A..COMBINING GRANTHA LETTER PA
  0x11380, 0x11389, // Lo  [10] TULU-TIGALARI LETTER A..TULU-TIGALARI LETTER VOCALIC LL
  0x1138B, 0x1138B, // Lo       TULU-TIGALARI LETTER EE
  0x1138E, 0x1138E, // Lo       TULU-TIGALARI LETTER AI
  0x11390, 0x113B5, // Lo  [38] TULU-TIGALARI LETTER OO..TULU-TIGALARI LETTER LLLA
  0x113B7, 0x113B7, // Lo       TULU-TIGALARI SIGN AVAGRAHA
  0x113B8, 0x113BA, // Mc   [3] TULU-TIGALARI VOWEL SIGN AA..TULU-TIGALARI VOWEL SIGN II
  0x113BB, 0x113C0, // Mn   [6] TULU-TIGALARI VOWEL SIGN U..TULU-TIGALARI VOWEL SIGN VOCALIC LL
  0x113C2, 0x113C2, // Mc       TULU-TIGALARI VOWEL SIGN EE
  0x113C5, 0x113C5, // Mc       TULU-TIGALARI VOWEL SIGN AI
  0x113C7, 0x113CA, // Mc   [4] TULU-TIGALARI VOWEL SIGN OO..TULU-TIGALARI SIGN CANDRA ANUNASIKA
  0x113CC, 0x113CD, // Mc   [2] TULU-TIGALARI SIGN ANUSVARA..TULU-TIGALARI SIGN VISARGA
  0x113CE, 0x113CE, // Mn       TULU-TIGALARI SIGN VIRAMA
  0x113CF, 0x113CF, // Mc       TULU-TIGALARI SIGN LOOPED VIRAMA
  0x113D0, 0x113D0, // Mn       TULU-TIGALARI CONJOINER
  0x113D1, 0x113D1, // Lo       TULU-TIGALARI REPHA
  0x113D2, 0x113D2, // Mn       TULU-TIGALARI GEMINATION MARK
  0x113D3, 0x113D3, // Lo       TULU-TIGALARI SIGN PLUTA
  0x113E1, 0x113E2, // Mn   [2] TULU-TIGALARI VEDIC TONE SVARITA..TULU-TIGALARI VEDIC TONE ANUDATTA
  0x11400, 0x11434, // Lo  [53] NEWA LETTER A..NEWA LETTER HA
  0x11435, 0x11437, // Mc   [3] NEWA VOWEL SIGN AA..NEWA VOWEL SIGN II
  0x11438, 0x1143F, // Mn   [8] NEWA VOWEL SIGN U..NEWA VOWEL SIGN AI
  0x11440, 0x11441, // Mc   [2] NEWA VOWEL SIGN O..NEWA VOWEL SIGN AU
  0x11442, 0x11444, // Mn   [3] NEWA SIGN VIRAMA..NEWA SIGN ANUSVARA
  0x11445, 0x11445, // Mc       NEWA SIGN VISARGA
  0x11446, 0x11446, // Mn       NEWA SIGN NUKTA
  0x11447, 0x1144A, // Lo   [4] NEWA SIGN AVAGRAHA..NEWA SIDDHI
  0x11450, 0x11459, // Nd  [10] NEWA DIGIT ZERO..NEWA DIGIT NINE
  0x1145E, 0x1145E, // Mn       NEWA SANDHI MARK
  0x1145F, 0x11461, // Lo   [3] NEWA LETTER VEDIC ANUSVARA..NEWA SIGN UPADHMANIYA
  0x11480, 0x114AF, // Lo  [48] TIRHUTA ANJI..TIRHUTA LETTER HA
  0x114B0, 0x114B2, // Mc   [3] TIRHUTA VOWEL SIGN AA..TIRHUTA VOWEL SIGN II
  0x114B3, 0x114B8, // Mn   [6] TIRHUTA VOWEL SIGN U..TIRHUTA VOWEL SIGN VOCALIC LL
  0x114B9, 0x114B9, // Mc       TIRHUTA VOWEL SIGN E
  0x114BA, 0x114BA, // Mn       TIRHUTA VOWEL SIGN SHORT E
  0x114BB, 0x114BE, // Mc   [4] TIRHUTA VOWEL SIGN AI..TIRHUTA VOWEL SIGN AU
  0x114BF, 0x114C0, // Mn   [2] TIRHUTA SIGN CANDRABINDU..TIRHUTA SIGN ANUSVARA
  0x114C1, 0x114C1, // Mc       TIRHUTA SIGN VISARGA
  0x114C2, 0x114C3, // Mn   [2] TIRHUTA SIGN VIRAMA..TIRHUTA SIGN NUKTA
  0x114C4, 0x114C5, // Lo   [2] TIRHUTA SIGN AVAGRAHA..TIRHUTA GVANG
  0x114C7, 0x114C7, // Lo       TIRHUTA OM
  0x114D0, 0x114D9, // Nd  [10] TIRHUTA DIGIT ZERO..TIRHUTA DIGIT NINE
  0x11580, 0x115AE, // Lo  [47] SIDDHAM LETTER A..SIDDHAM LETTER HA
  0x115AF, 0x115B1, // Mc   [3] SIDDHAM VOWEL SIGN AA..SIDDHAM VOWEL SIGN II
  0x115B2, 0x115B5, // Mn   [4] SIDDHAM VOWEL SIGN U..SIDDHAM VOWEL SIGN VOCALIC RR
  0x115B8, 0x115BB, // Mc   [4] SIDDHAM VOWEL SIGN E..SIDDHAM VOWEL SIGN AU
  0x115BC, 0x115BD, // Mn   [2] SIDDHAM SIGN CANDRABINDU..SIDDHAM SIGN ANUSVARA
  0x115BE, 0x115BE, // Mc       SIDDHAM SIGN VISARGA
  0x115BF, 0x115C0, // Mn   [2] SIDDHAM SIGN VIRAMA..SIDDHAM SIGN NUKTA
  0x115D8, 0x115DB, // Lo   [4] SIDDHAM LETTER THREE-CIRCLE ALTERNATE I..SIDDHAM LETTER ALTERNATE U
  0x115DC, 0x115DD, // Mn   [2] SIDDHAM VOWEL SIGN ALTERNATE U..SIDDHAM VOWEL SIGN ALTERNATE UU
  0x11600, 0x1162F, // Lo  [48] MODI LETTER A..MODI LETTER LLA
  0x11630, 0x11632, // Mc   [3] MODI VOWEL SIGN AA..MODI VOWEL SIGN II
  0x11633, 0x1163A, // Mn   [8] MODI VOWEL SIGN U..MODI VOWEL SIGN AI
  0x1163B, 0x1163C, // Mc   [2] MODI VOWEL SIGN O..MODI VOWEL SIGN AU
  0x1163D, 0x1163D, // Mn       MODI SIGN ANUSVARA
  0x1163E, 0x1163E, // Mc       MODI SIGN VISARGA
  0x1163F, 0x11640, // Mn   [2] MODI SIGN VIRAMA..MODI SIGN ARDHACANDRA
  0x11644, 0x11644, // Lo       MODI SIGN HUVA
  0x11650, 0x11659, // Nd  [10] MODI DIGIT ZERO..MODI DIGIT NINE
  0x11680, 0x116AA, // Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
  0x116AB, 0x116AB, // Mn       TAKRI SIGN ANUSVARA
  0x116AC, 0x116AC, // Mc       TAKRI SIGN VISARGA
  0x116AD, 0x116AD, // Mn       TAKRI VOWEL SIGN AA
  0x116AE, 0x116AF, // Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
  0x116B0, 0x116B5, // Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
  0x116B6, 0x116B6, // Mc       TAKRI SIGN VIRAMA
  0x116B7, 0x116B7, // Mn       TAKRI SIGN NUKTA
  0x116B8, 0x116B8, // Lo       TAKRI LETTER ARCHAIC KHA
  0x116C0, 0x116C9, // Nd  [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
  0x116D0, 0x116E3, // Nd  [20] MYANMAR PAO DIGIT ZERO..MYANMAR EASTERN PWO KAREN DIGIT NINE
  0x11700, 0x1171A, // Lo  [27] AHOM LETTER KA..AHOM LETTER ALTERNATE BA
  0x1171D, 0x1171D, // Mn       AHOM CONSONANT SIGN MEDIAL LA
  0x1171E, 0x1171E, // Mc       AHOM CONSONANT SIGN MEDIAL RA
  0x1171F, 0x1171F, // Mn       AHOM CONSONANT SIGN MEDIAL LIGATING RA
  0x11720, 0x11721, // Mc   [2] AHOM VOWEL SIGN A..AHOM VOWEL SIGN AA
  0x11722, 0x11725, // Mn   [4] AHOM VOWEL SIGN I..AHOM VOWEL SIGN UU
  0x11726, 0x11726, // Mc       AHOM VOWEL SIGN E
  0x11727, 0x1172B, // Mn   [5] AHOM VOWEL SIGN AW..AHOM SIGN KILLER
  0x11730, 0x11739, // Nd  [10] AHOM DIGIT ZERO..AHOM DIGIT NINE
  0x11740, 0x11746, // Lo   [7] AHOM LETTER CA..AHOM LETTER LLA
  0x11800, 0x1182B, // Lo  [44] DOGRA LETTER A..DOGRA LETTER RRA
  0x1182C, 0x1182E, // Mc   [3] DOGRA VOWEL SIGN AA..DOGRA VOWEL SIGN II
  0x1182F, 0x11837, // Mn   [9] DOGRA VOWEL SIGN U..DOGRA SIGN ANUSVARA
  0x11838, 0x11838, // Mc       DOGRA SIGN VISARGA
  0x11839, 0x1183A, // Mn   [2] DOGRA SIGN VIRAMA..DOGRA SIGN NUKTA
  0x118A0, 0x118DF, // L&  [64] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI SMALL LETTER VIYO
  0x118E0, 0x118E9, // Nd  [10] WARANG CITI DIGIT ZERO..WARANG CITI DIGIT NINE
  0x118FF, 0x11906, // Lo   [8] WARANG CITI OM..DIVES AKURU LETTER E
  0x11909, 0x11909, // Lo       DIVES AKURU LETTER O
  0x1190C, 0x11913, // Lo   [8] DIVES AKURU LETTER KA..DIVES AKURU LETTER JA
  0x11915, 0x11916, // Lo   [2] DIVES AKURU LETTER NYA..DIVES AKURU LETTER TTA
  0x11918, 0x1192F, // Lo  [24] DIVES AKURU LETTER DDA..DIVES AKURU LETTER ZA
  0x11930, 0x11935, // Mc   [6] DIVES AKURU VOWEL SIGN AA..DIVES AKURU VOWEL SIGN E
  0x11937, 0x11938, // Mc   [2] DIVES AKURU VOWEL SIGN AI..DIVES AKURU VOWEL SIGN O
  0x1193B, 0x1193C, // Mn   [2] DIVES AKURU SIGN ANUSVARA..DIVES AKURU SIGN CANDRABINDU
  0x1193D, 0x1193D, // Mc       DIVES AKURU SIGN HALANTA
  0x1193E, 0x1193E, // Mn       DIVES AKURU VIRAMA
  0x1193F, 0x1193F, // Lo       DIVES AKURU PREFIXED NASAL SIGN
  0x11940, 0x11940, // Mc       DIVES AKURU MEDIAL YA
  0x11941, 0x11941, // Lo       DIVES AKURU INITIAL RA
  0x11942, 0x11942, // Mc       DIVES AKURU MEDIAL RA
  0x11943, 0x11943, // Mn       DIVES AKURU SIGN NUKTA
  0x11950, 0x11959, // Nd  [10] DIVES AKURU DIGIT ZERO..DIVES AKURU DIGIT NINE
  0x119A0, 0x119A7, // Lo   [8] NANDINAGARI LETTER A..NANDINAGARI LETTER VOCALIC RR
  0x119AA, 0x119D0, // Lo  [39] NANDINAGARI LETTER E..NANDINAGARI LETTER RRA
  0x119D1, 0x119D3, // Mc   [3] NANDINAGARI VOWEL SIGN AA..NANDINAGARI VOWEL SIGN II
  0x119D4, 0x119D7, // Mn   [4] NANDINAGARI VOWEL SIGN U..NANDINAGARI VOWEL SIGN VOCALIC RR
  0x119DA, 0x119DB, // Mn   [2] NANDINAGARI VOWEL SIGN E..NANDINAGARI VOWEL SIGN AI
  0x119DC, 0x119DF, // Mc   [4] NANDINAGARI VOWEL SIGN O..NANDINAGARI SIGN VISARGA
  0x119E0, 0x119E0, // Mn       NANDINAGARI SIGN VIRAMA
  0x119E1, 0x119E1, // Lo       NANDINAGARI SIGN AVAGRAHA
  0x119E3, 0x119E3, // Lo       NANDINAGARI HEADSTROKE
  0x119E4, 0x119E4, // Mc       NANDINAGARI VOWEL SIGN PRISHTHAMATRA E
  0x11A00, 0x11A00, // Lo       ZANABAZAR SQUARE LETTER A
  0x11A01, 0x11A0A, // Mn  [10] ZANABAZAR SQUARE VOWEL SIGN I..ZANABAZAR SQUARE VOWEL LENGTH MARK
  0x11A0B, 0x11A32, // Lo  [40] ZANABAZAR SQUARE LETTER KA..ZANABAZAR SQUARE LETTER KSSA
  0x11A33, 0x11A38, // Mn   [6] ZANABAZAR SQUARE FINAL CONSONANT MARK..ZANABAZAR SQUARE SIGN ANUSVARA
  0x11A39, 0x11A39, // Mc       ZANABAZAR SQUARE SIGN VISARGA
  0x11A3A, 0x11A3A, // Lo       ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
  0x11A3B, 0x11A3E, // Mn   [4] ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA..ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
  0x11A47, 0x11A47, // Mn       ZANABAZAR SQUARE SUBJOINER
  0x11A50, 0x11A50, // Lo       SOYOMBO LETTER A
  0x11A51, 0x11A56, // Mn   [6] SOYOMBO VOWEL SIGN I..SOYOMBO VOWEL SIGN OE
  0x11A57, 0x11A58, // Mc   [2] SOYOMBO VOWEL SIGN AI..SOYOMBO VOWEL SIGN AU
  0x11A59, 0x11A5B, // Mn   [3] SOYOMBO VOWEL SIGN VOCALIC R..SOYOMBO VOWEL LENGTH MARK
  0x11A5C, 0x11A89, // Lo  [46] SOYOMBO LETTER KA..SOYOMBO CLUSTER-INITIAL LETTER SA
  0x11A8A, 0x11A96, // Mn  [13] SOYOMBO FINAL CONSONANT SIGN G..SOYOMBO SIGN ANUSVARA
  0x11A97, 0x11A97, // Mc       SOYOMBO SIGN VISARGA
  0x11A98, 0x11A99, // Mn   [2] SOYOMBO GEMINATION MARK..SOYOMBO SUBJOINER
  0x11A9D, 0x11A9D, // Lo       SOYOMBO MARK PLUTA
  0x11AB0, 0x11AF8, // Lo  [73] CANADIAN SYLLABICS NATTILIK HI..PAU CIN HAU GLOTTAL STOP FINAL
  0x11B60, 0x11B60, // Mn       SHARADA VOWEL SIGN OE
  0x11B61, 0x11B61, // Mc       SHARADA VOWEL SIGN OOE
  0x11B62, 0x11B64, // Mn   [3] SHARADA VOWEL SIGN UE..SHARADA VOWEL SIGN SHORT E
  0x11B65, 0x11B65, // Mc       SHARADA VOWEL SIGN SHORT O
  0x11B66, 0x11B66, // Mn       SHARADA VOWEL SIGN CANDRA E
  0x11B67, 0x11B67, // Mc       SHARADA VOWEL SIGN CANDRA O
  0x11BC0, 0x11BE0, // Lo  [33] SUNUWAR LETTER DEVI..SUNUWAR LETTER KLOKO
  0x11BF0, 0x11BF9, // Nd  [10] SUNUWAR DIGIT ZERO..SUNUWAR DIGIT NINE
  0x11C00, 0x11C08, // Lo   [9] BHAIKSUKI LETTER A..BHAIKSUKI LETTER VOCALIC L
  0x11C0A, 0x11C2E, // Lo  [37] BHAIKSUKI LETTER E..BHAIKSUKI LETTER HA
  0x11C2F, 0x11C2F, // Mc       BHAIKSUKI VOWEL SIGN AA
  0x11C30, 0x11C36, // Mn   [7] BHAIKSUKI VOWEL SIGN I..BHAIKSUKI VOWEL SIGN VOCALIC L
  0x11C38, 0x11C3D, // Mn   [6] BHAIKSUKI VOWEL SIGN E..BHAIKSUKI SIGN ANUSVARA
  0x11C3E, 0x11C3E, // Mc       BHAIKSUKI SIGN VISARGA
  0x11C3F, 0x11C3F, // Mn       BHAIKSUKI SIGN VIRAMA
  0x11C40, 0x11C40, // Lo       BHAIKSUKI SIGN AVAGRAHA
  0x11C50, 0x11C59, // Nd  [10] BHAIKSUKI DIGIT ZERO..BHAIKSUKI DIGIT NINE
  0x11C72, 0x11C8F, // Lo  [30] MARCHEN LETTER KA..MARCHEN LETTER A
  0x11C92, 0x11CA7, // Mn  [22] MARCHEN SUBJOINED LETTER KA..MARCHEN SUBJOINED LETTER ZA
  0x11CA9, 0x11CA9, // Mc       MARCHEN SUBJOINED LETTER YA
  0x11CAA, 0x11CB0, // Mn   [7] MARCHEN SUBJOINED LETTER RA..MARCHEN VOWEL SIGN AA
  0x11CB1, 0x11CB1, // Mc       MARCHEN VOWEL SIGN I
  0x11CB2, 0x11CB3, // Mn   [2] MARCHEN VOWEL SIGN U..MARCHEN VOWEL SIGN E
  0x11CB4, 0x11CB4, // Mc       MARCHEN VOWEL SIGN O
  0x11CB5, 0x11CB6, // Mn   [2] MARCHEN SIGN ANUSVARA..MARCHEN SIGN CANDRABINDU
  0x11D00, 0x11D06, // Lo   [7] MASARAM GONDI LETTER A..MASARAM GONDI LETTER E
  0x11D08, 0x11D09, // Lo   [2] MASARAM GONDI LETTER AI..MASARAM GONDI LETTER O
  0x11D0B, 0x11D30, // Lo  [38] MASARAM GONDI LETTER AU..MASARAM GONDI LETTER TRA
  0x11D31, 0x11D36, // Mn   [6] MASARAM GONDI VOWEL SIGN AA..MASARAM GONDI VOWEL SIGN VOCALIC R
  0x11D3A, 0x11D3A, // Mn       MASARAM GONDI VOWEL SIGN E
  0x11D3C, 0x11D3D, // Mn   [2] MASARAM GONDI VOWEL SIGN AI..MASARAM GONDI VOWEL SIGN O
  0x11D3F, 0x11D45, // Mn   [7] MASARAM GONDI VOWEL SIGN AU..MASARAM GONDI VIRAMA
  0x11D46, 0x11D46, // Lo       MASARAM GONDI REPHA
  0x11D47, 0x11D47, // Mn       MASARAM GONDI RA-KARA
  0x11D50, 0x11D59, // Nd  [10] MASARAM GONDI DIGIT ZERO..MASARAM GONDI DIGIT NINE
  0x11D60, 0x11D65, // Lo   [6] GUNJALA GONDI LETTER A..GUNJALA GONDI LETTER UU
  0x11D67, 0x11D68, // Lo   [2] GUNJALA GONDI LETTER EE..GUNJALA GONDI LETTER AI
  0x11D6A, 0x11D89, // Lo  [32] GUNJALA GONDI LETTER OO..GUNJALA GONDI LETTER SA
  0x11D8A, 0x11D8E, // Mc   [5] GUNJALA GONDI VOWEL SIGN AA..GUNJALA GONDI VOWEL SIGN UU
  0x11D90, 0x11D91, // Mn   [2] GUNJALA GONDI VOWEL SIGN EE..GUNJALA GONDI VOWEL SIGN AI
  0x11D93, 0x11D94, // Mc   [2] GUNJALA GONDI VOWEL SIGN OO..GUNJALA GONDI VOWEL SIGN AU
  0x11D95, 0x11D95, // Mn       GUNJALA GONDI SIGN ANUSVARA
  0x11D96, 0x11D96, // Mc       GUNJALA GONDI SIGN VISARGA
  0x11D97, 0x11D97, // Mn       GUNJALA GONDI VIRAMA
  0x11D98, 0x11D98, // Lo       GUNJALA GONDI OM
  0x11DA0, 0x11DA9, // Nd  [10] GUNJALA GONDI DIGIT ZERO..GUNJALA GONDI DIGIT NINE
  0x11DB0, 0x11DD8, // Lo  [41] TOLONG SIKI LETTER I..TOLONG SIKI LETTER RRH
  0x11DD9, 0x11DD9, // Lm       TOLONG SIKI SIGN SELA
  0x11DDA, 0x11DDB, // Lo   [2] TOLONG SIKI SIGN HECAKA..TOLONG SIKI UNGGA
  0x11DE0, 0x11DE9, // Nd  [10] TOLONG SIKI DIGIT ZERO..TOLONG SIKI DIGIT NINE
  0x11EE0, 0x11EF2, // Lo  [19] MAKASAR LETTER KA..MAKASAR ANGKA
  0x11EF3, 0x11EF4, // Mn   [2] MAKASAR VOWEL SIGN I..MAKASAR VOWEL SIGN U
  0x11EF5, 0x11EF6, // Mc   [2] MAKASAR VOWEL SIGN E..MAKASAR VOWEL SIGN O
  0x11F00, 0x11F01, // Mn   [2] KAWI SIGN CANDRABINDU..KAWI SIGN ANUSVARA
  0x11F02, 0x11F02, // Lo       KAWI SIGN REPHA
  0x11F03, 0x11F03, // Mc       KAWI SIGN VISARGA
  0x11F04, 0x11F10, // Lo  [13] KAWI LETTER A..KAWI LETTER O
  0x11F12, 0x11F33, // Lo  [34] KAWI LETTER KA..KAWI LETTER JNYA
  0x11F34, 0x11F35, // Mc   [2] KAWI VOWEL SIGN AA..KAWI VOWEL SIGN ALTERNATE AA
  0x11F36, 0x11F3A, // Mn   [5] KAWI VOWEL SIGN I..KAWI VOWEL SIGN VOCALIC R
  0x11F3E, 0x11F3F, // Mc   [2] KAWI VOWEL SIGN E..KAWI VOWEL SIGN AI
  0x11F40, 0x11F40, // Mn       KAWI VOWEL SIGN EU
  0x11F41, 0x11F41, // Mc       KAWI SIGN KILLER
  0x11F42, 0x11F42, // Mn       KAWI CONJOINER
  0x11F50, 0x11F59, // Nd  [10] KAWI DIGIT ZERO..KAWI DIGIT NINE
  0x11F5A, 0x11F5A, // Mn       KAWI SIGN NUKTA
  0x11FB0, 0x11FB0, // Lo       LISU LETTER YHA
  0x12000, 0x12399, // Lo [922] CUNEIFORM SIGN A..CUNEIFORM SIGN U U
  0x12400, 0x1246E, // Nl [111] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
  0x12480, 0x12543, // Lo [196] CUNEIFORM SIGN AB TIMES NUN TENU..CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
  0x12F90, 0x12FF0, // Lo  [97] CYPRO-MINOAN SIGN CM001..CYPRO-MINOAN SIGN CM114
  0x13000, 0x1342F, // Lo [1072] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH V011D
  0x13440, 0x13440, // Mn       EGYPTIAN HIEROGLYPH MIRROR HORIZONTALLY
  0x13441, 0x13446, // Lo   [6] EGYPTIAN HIEROGLYPH FULL BLANK..EGYPTIAN HIEROGLYPH WIDE LOST SIGN
  0x13447, 0x13455, // Mn  [15] EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START..EGYPTIAN HIEROGLYPH MODIFIER DAMAGED
  0x13460, 0x143FA, // Lo [3995] EGYPTIAN HIEROGLYPH-13460..EGYPTIAN HIEROGLYPH-143FA
  0x14400, 0x14646, // Lo [583] ANATOLIAN HIEROGLYPH A001..ANATOLIAN HIEROGLYPH A530
  0x16100, 0x1611D, // Lo  [30] GURUNG KHEMA LETTER A..GURUNG KHEMA LETTER SA
  0x1611E, 0x16129, // Mn  [12] GURUNG KHEMA VOWEL SIGN AA..GURUNG KHEMA VOWEL LENGTH MARK
  0x1612A, 0x1612C, // Mc   [3] GURUNG KHEMA CONSONANT SIGN MEDIAL YA..GURUNG KHEMA CONSONANT SIGN MEDIAL HA
  0x1612D, 0x1612F, // Mn   [3] GURUNG KHEMA SIGN ANUSVARA..GURUNG KHEMA SIGN THOLHOMA
  0x16130, 0x16139, // Nd  [10] GURUNG KHEMA DIGIT ZERO..GURUNG KHEMA DIGIT NINE
  0x16800, 0x16A38, // Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
  0x16A40, 0x16A5E, // Lo  [31] MRO LETTER TA..MRO LETTER TEK
  0x16A60, 0x16A69, // Nd  [10] MRO DIGIT ZERO..MRO DIGIT NINE
  0x16A70, 0x16ABE, // Lo  [79] TANGSA LETTER OZ..TANGSA LETTER ZA
  0x16AC0, 0x16AC9, // Nd  [10] TANGSA DIGIT ZERO..TANGSA DIGIT NINE
  0x16AD0, 0x16AED, // Lo  [30] BASSA VAH LETTER ENNI..BASSA VAH LETTER I
  0x16AF0, 0x16AF4, // Mn   [5] BASSA VAH COMBINING HIGH TONE..BASSA VAH COMBINING HIGH-LOW TONE
  0x16B00, 0x16B2F, // Lo  [48] PAHAWH HMONG VOWEL KEEB..PAHAWH HMONG CONSONANT CAU
  0x16B30, 0x16B36, // Mn   [7] PAHAWH HMONG MARK CIM TUB..PAHAWH HMONG MARK CIM TAUM
  0x16B40, 0x16B43, // Lm   [4] PAHAWH HMONG SIGN VOS SEEV..PAHAWH HMONG SIGN IB YAM
  0x16B50, 0x16B59, // Nd  [10] PAHAWH HMONG DIGIT ZERO..PAHAWH HMONG DIGIT NINE
  0x16B63, 0x16B77, // Lo  [21] PAHAWH HMONG SIGN VOS LUB..PAHAWH HMONG SIGN CIM NRES TOS
  0x16B7D, 0x16B8F, // Lo  [19] PAHAWH HMONG CLAN SIGN TSHEEJ..PAHAWH HMONG CLAN SIGN VWJ
  0x16D40, 0x16D42, // Lm   [3] KIRAT RAI SIGN ANUSVARA..KIRAT RAI SIGN VISARGA
  0x16D43, 0x16D6A, // Lo  [40] KIRAT RAI LETTER A..KIRAT RAI VOWEL SIGN AU
  0x16D6B, 0x16D6C, // Lm   [2] KIRAT RAI SIGN VIRAMA..KIRAT RAI SIGN SAAT
  0x16D70, 0x16D79, // Nd  [10] KIRAT RAI DIGIT ZERO..KIRAT RAI DIGIT NINE
  0x16E40, 0x16E7F, // L&  [64] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN SMALL LETTER Y
  0x16EA0, 0x16EB8, // L&  [25] BERIA ERFE CAPITAL LETTER ARKAB..BERIA ERFE CAPITAL LETTER AY
  0x16EBB, 0x16ED3, // L&  [25] BERIA ERFE SMALL LETTER ARKAB..BERIA ERFE SMALL LETTER AY
  0x16F00, 0x16F4A, // Lo  [75] MIAO LETTER PA..MIAO LETTER RTE
  0x16F4F, 0x16F4F, // Mn       MIAO SIGN CONSONANT MODIFIER BAR
  0x16F50, 0x16F50, // Lo       MIAO LETTER NASALIZATION
  0x16F51, 0x16F87, // Mc  [55] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN UI
  0x16F8F, 0x16F92, // Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
  0x16F93, 0x16F9F, // Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
  0x16FE0, 0x16FE1, // Lm   [2] TANGUT ITERATION MARK..NUSHU ITERATION MARK
  0x16FE3, 0x16FE3, // Lm       OLD CHINESE ITERATION MARK
  0x16FE4, 0x16FE4, // Mn       KHITAN SMALL SCRIPT FILLER
  0x16FF0, 0x16FF1, // Mc   [2] VIETNAMESE ALTERNATE READING MARK CA..VIETNAMESE ALTERNATE READING MARK NHAY
  0x16FF2, 0x16FF3, // Lm   [2] CHINESE SMALL SIMPLIFIED ER..CHINESE SMALL TRADITIONAL ER
  0x16FF4, 0x16FF6, // Nl   [3] YANGQIN SIGN SLOW ONE BEAT..YANGQIN SIGN SLOW TWO BEATS
  0x17000, 0x18CD5, // Lo [7382] TANGUT IDEOGRAPH-17000..KHITAN SMALL SCRIPT CHARACTER-18CD5
  0x18CFF, 0x18D1E, // Lo  [32] KHITAN SMALL SCRIPT CHARACTER-18CFF..TANGUT IDEOGRAPH-18D1E
  0x18D80, 0x18DF2, // Lo [115] TANGUT COMPONENT-769..TANGUT COMPONENT-883
  0x1AFF0, 0x1AFF3, // Lm   [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
  0x1AFF5, 0x1AFFB, // Lm   [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
  0x1AFFD, 0x1AFFE, // Lm   [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
  0x1B000, 0x1B122, // Lo [291] KATAKANA LETTER ARCHAIC E..KATAKANA LETTER ARCHAIC WU
  0x1B132, 0x1B132, // Lo       HIRAGANA LETTER SMALL KO
  0x1B150, 0x1B152, // Lo   [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
  0x1B155, 0x1B155, // Lo       KATAKANA LETTER SMALL KO
  0x1B164, 0x1B167, // Lo   [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
  0x1B170, 0x1B2FB, // Lo [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
  0x1BC00, 0x1BC6A, // Lo [107] DUPLOYAN LETTER H..DUPLOYAN LETTER VOCALIC M
  0x1BC70, 0x1BC7C, // Lo  [13] DUPLOYAN AFFIX LEFT HORIZONTAL SECANT..DUPLOYAN AFFIX ATTACHED TANGENT HOOK
  0x1BC80, 0x1BC88, // Lo   [9] DUPLOYAN AFFIX HIGH ACUTE..DUPLOYAN AFFIX HIGH VERTICAL
  0x1BC90, 0x1BC99, // Lo  [10] DUPLOYAN AFFIX LOW ACUTE..DUPLOYAN AFFIX LOW ARROW
  0x1BC9D, 0x1BC9E, // Mn   [2] DUPLOYAN THICK LETTER SELECTOR..DUPLOYAN DOUBLE MARK
  0x1CCF0, 0x1CCF9, // Nd  [10] OUTLINED DIGIT ZERO..OUTLINED DIGIT NINE
  0x1CF00, 0x1CF2D, // Mn  [46] ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON LEFT..ZNAMENNY COMBINING MARK KRYZH ON LEFT
  0x1CF30, 0x1CF46, // Mn  [23] ZNAMENNY COMBINING TONAL RANGE MARK MRACHNO..ZNAMENNY PRIZNAK MODIFIER ROG
  0x1D165, 0x1D166, // Mc   [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
  0x1D167, 0x1D169, // Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
  0x1D16D, 0x1D172, // Mc   [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
  0x1D17B, 0x1D182, // Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
  0x1D185, 0x1D18B, // Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
  0x1D1AA, 0x1D1AD, // Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
  0x1D242, 0x1D244, // Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
  0x1D400, 0x1D454, // L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
  0x1D456, 0x1D49C, // L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
  0x1D49E, 0x1D49F, // L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
  0x1D4A2, 0x1D4A2, // L&       MATHEMATICAL SCRIPT CAPITAL G
  0x1D4A5, 0x1D4A6, // L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
  0x1D4A9, 0x1D4AC, // L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
  0x1D4AE, 0x1D4B9, // L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
  0x1D4BB, 0x1D4BB, // L&       MATHEMATICAL SCRIPT SMALL F
  0x1D4BD, 0x1D4C3, // L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
  0x1D4C5, 0x1D505, // L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
  0x1D507, 0x1D50A, // L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
  0x1D50D, 0x1D514, // L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
  0x1D516, 0x1D51C, // L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
  0x1D51E, 0x1D539, // L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
  0x1D53B, 0x1D53E, // L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
  0x1D540, 0x1D544, // L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
  0x1D546, 0x1D546, // L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
  0x1D54A, 0x1D550, // L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
  0x1D552, 0x1D6A5, // L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
  0x1D6A8, 0x1D6C0, // L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
  0x1D6C2, 0x1D6DA, // L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
  0x1D6DC, 0x1D6FA, // L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
  0x1D6FC, 0x1D714, // L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
  0x1D716, 0x1D734, // L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
  0x1D736, 0x1D74E, // L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
  0x1D750, 0x1D76E, // L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
  0x1D770, 0x1D788, // L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
  0x1D78A, 0x1D7A8, // L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
  0x1D7AA, 0x1D7C2, // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
  0x1D7C4, 0x1D7CB, // L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
  0x1D7CE, 0x1D7FF, // Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
  0x1DA00, 0x1DA36, // Mn  [55] SIGNWRITING HEAD RIM..SIGNWRITING AIR SUCKING IN
  0x1DA3B, 0x1DA6C, // Mn  [50] SIGNWRITING MOUTH CLOSED NEUTRAL..SIGNWRITING EXCITEMENT
  0x1DA75, 0x1DA75, // Mn       SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
  0x1DA84, 0x1DA84, // Mn       SIGNWRITING LOCATION HEAD NECK
  0x1DA9B, 0x1DA9F, // Mn   [5] SIGNWRITING FILL MODIFIER-2..SIGNWRITING FILL MODIFIER-6
  0x1DAA1, 0x1DAAF, // Mn  [15] SIGNWRITING ROTATION MODIFIER-2..SIGNWRITING ROTATION MODIFIER-16
  0x1DF00, 0x1DF09, // L&  [10] LATIN SMALL LETTER FENG DIGRAPH WITH TRILL..LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK
  0x1DF0A, 0x1DF0A, // Lo       LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
  0x1DF0B, 0x1DF1E, // L&  [20] LATIN SMALL LETTER ESH WITH DOUBLE BAR..LATIN SMALL LETTER S WITH CURL
  0x1DF25, 0x1DF2A, // L&   [6] LATIN SMALL LETTER D WITH MID-HEIGHT LEFT HOOK..LATIN SMALL LETTER T WITH MID-HEIGHT LEFT HOOK
  0x1E000, 0x1E006, // Mn   [7] COMBINING GLAGOLITIC LETTER AZU..COMBINING GLAGOLITIC LETTER ZHIVETE
  0x1E008, 0x1E018, // Mn  [17] COMBINING GLAGOLITIC LETTER ZEMLJA..COMBINING GLAGOLITIC LETTER HERU
  0x1E01B, 0x1E021, // Mn   [7] COMBINING GLAGOLITIC LETTER SHTA..COMBINING GLAGOLITIC LETTER YATI
  0x1E023, 0x1E024, // Mn   [2] COMBINING GLAGOLITIC LETTER YU..COMBINING GLAGOLITIC LETTER SMALL YUS
  0x1E026, 0x1E02A, // Mn   [5] COMBINING GLAGOLITIC LETTER YO..COMBINING GLAGOLITIC LETTER FITA
  0x1E030, 0x1E06D, // Lm  [62] MODIFIER LETTER CYRILLIC SMALL A..MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE
  0x1E08F, 0x1E08F, // Mn       COMBINING CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
  0x1E100, 0x1E12C, // Lo  [45] NYIAKENG PUACHUE HMONG LETTER MA..NYIAKENG PUACHUE HMONG LETTER W
  0x1E130, 0x1E136, // Mn   [7] NYIAKENG PUACHUE HMONG TONE-B..NYIAKENG PUACHUE HMONG TONE-D
  0x1E137, 0x1E13D, // Lm   [7] NYIAKENG PUACHUE HMONG SIGN FOR PERSON..NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
  0x1E140, 0x1E149, // Nd  [10] NYIAKENG PUACHUE HMONG DIGIT ZERO..NYIAKENG PUACHUE HMONG DIGIT NINE
  0x1E14E, 0x1E14E, // Lo       NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
  0x1E290, 0x1E2AD, // Lo  [30] TOTO LETTER PA..TOTO LETTER A
  0x1E2AE, 0x1E2AE, // Mn       TOTO SIGN RISING TONE
  0x1E2C0, 0x1E2EB, // Lo  [44] WANCHO LETTER AA..WANCHO LETTER YIH
  0x1E2EC, 0x1E2EF, // Mn   [4] WANCHO TONE TUP..WANCHO TONE KOINI
  0x1E2F0, 0x1E2F9, // Nd  [10] WANCHO DIGIT ZERO..WANCHO DIGIT NINE
  0x1E4D0, 0x1E4EA, // Lo  [27] NAG MUNDARI LETTER O..NAG MUNDARI LETTER ELL
  0x1E4EB, 0x1E4EB, // Lm       NAG MUNDARI SIGN OJOD
  0x1E4EC, 0x1E4EF, // Mn   [4] NAG MUNDARI SIGN MUHOR..NAG MUNDARI SIGN SUTUH
  0x1E4F0, 0x1E4F9, // Nd  [10] NAG MUNDARI DIGIT ZERO..NAG MUNDARI DIGIT NINE
  0x1E5D0, 0x1E5ED, // Lo  [30] OL ONAL LETTER O..OL ONAL LETTER EG
  0x1E5EE, 0x1E5EF, // Mn   [2] OL ONAL SIGN MU..OL ONAL SIGN IKIR
  0x1E5F0, 0x1E5F0, // Lo       OL ONAL SIGN HODDOND
  0x1E5F1, 0x1E5FA, // Nd  [10] OL ONAL DIGIT ZERO..OL ONAL DIGIT NINE
  0x1E6C0, 0x1E6DE, // Lo  [31] TAI YO LETTER LOW KO..TAI YO LETTER HIGH KVO
  0x1E6E0, 0x1E6E2, // Lo   [3] TAI YO LETTER AA..TAI YO LETTER UE
  0x1E6E3, 0x1E6E3, // Mn       TAI YO SIGN UE
  0x1E6E4, 0x1E6E5, // Lo   [2] TAI YO LETTER U..TAI YO LETTER AE
  0x1E6E6, 0x1E6E6, // Mn       TAI YO SIGN AU
  0x1E6E7, 0x1E6ED, // Lo   [7] TAI YO LETTER O..TAI YO LETTER AUE
  0x1E6EE, 0x1E6EF, // Mn   [2] TAI YO SIGN AY..TAI YO SIGN ANG
  0x1E6F0, 0x1E6F4, // Lo   [5] TAI YO LETTER AN..TAI YO LETTER AP
  0x1E6F5, 0x1E6F5, // Mn       TAI YO SIGN OM
  0x1E6FE, 0x1E6FE, // Lo       TAI YO SYMBOL MUEANG
  0x1E6FF, 0x1E6FF, // Lm       TAI YO XAM LAI
  0x1E7E0, 0x1E7E6, // Lo   [7] ETHIOPIC SYLLABLE HHYA..ETHIOPIC SYLLABLE HHYO
  0x1E7E8, 0x1E7EB, // Lo   [4] ETHIOPIC SYLLABLE GURAGE HHWA..ETHIOPIC SYLLABLE HHWE
  0x1E7ED, 0x1E7EE, // Lo   [2] ETHIOPIC SYLLABLE GURAGE MWI..ETHIOPIC SYLLABLE GURAGE MWEE
  0x1E7F0, 0x1E7FE, // Lo  [15] ETHIOPIC SYLLABLE GURAGE QWI..ETHIOPIC SYLLABLE GURAGE PWEE
  0x1E800, 0x1E8C4, // Lo [197] MENDE KIKAKUI SYLLABLE M001 KI..MENDE KIKAKUI SYLLABLE M060 NYON
  0x1E8D0, 0x1E8D6, // Mn   [7] MENDE KIKAKUI COMBINING NUMBER TEENS..MENDE KIKAKUI COMBINING NUMBER MILLIONS
  0x1E900, 0x1E943, // L&  [68] ADLAM CAPITAL LETTER ALIF..ADLAM SMALL LETTER SHA
  0x1E944, 0x1E94A, // Mn   [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
  0x1E94B, 0x1E94B, // Lm       ADLAM NASALIZATION MARK
  0x1E950, 0x1E959, // Nd  [10] ADLAM DIGIT ZERO..ADLAM DIGIT NINE
  0x1EE00, 0x1EE03, // Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
  0x1EE05, 0x1EE1F, // Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
  0x1EE21, 0x1EE22, // Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
  0x1EE24, 0x1EE24, // Lo       ARABIC MATHEMATICAL INITIAL HEH
  0x1EE27, 0x1EE27, // Lo       ARABIC MATHEMATICAL INITIAL HAH
  0x1EE29, 0x1EE32, // Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
  0x1EE34, 0x1EE37, // Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
  0x1EE39, 0x1EE39, // Lo       ARABIC MATHEMATICAL INITIAL DAD
  0x1EE3B, 0x1EE3B, // Lo       ARABIC MATHEMATICAL INITIAL GHAIN
  0x1EE42, 0x1EE42, // Lo       ARABIC MATHEMATICAL TAILED JEEM
  0x1EE47, 0x1EE47, // Lo       ARABIC MATHEMATICAL TAILED HAH
  0x1EE49, 0x1EE49, // Lo       ARABIC MATHEMATICAL TAILED YEH
  0x1EE4B, 0x1EE4B, // Lo       ARABIC MATHEMATICAL TAILED LAM
  0x1EE4D, 0x1EE4F, // Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
  0x1EE51, 0x1EE52, // Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
  0x1EE54, 0x1EE54, // Lo       ARABIC MATHEMATICAL TAILED SHEEN
  0x1EE57, 0x1EE57, // Lo       ARABIC MATHEMATICAL TAILED KHAH
  0x1EE59, 0x1EE59, // Lo       ARABIC MATHEMATICAL TAILED DAD
  0x1EE5B, 0x1EE5B, // Lo       ARABIC MATHEMATICAL TAILED GHAIN
  0x1EE5D, 0x1EE5D, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
  0x1EE5F, 0x1EE5F, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
  0x1EE61, 0x1EE62, // Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
  0x1EE64, 0x1EE64, // Lo       ARABIC MATHEMATICAL STRETCHED HEH
  0x1EE67, 0x1EE6A, // Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
  0x1EE6C, 0x1EE72, // Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
  0x1EE74, 0x1EE77, // Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
  0x1EE79, 0x1EE7C, // Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
  0x1EE7E, 0x1EE7E, // Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
  0x1EE80, 0x1EE89, // Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
  0x1EE8B, 0x1EE9B, // Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
  0x1EEA1, 0x1EEA3, // Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
  0x1EEA5, 0x1EEA9, // Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
  0x1EEAB, 0x1EEBB, // Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
  0x1FBF0, 0x1FBF9, // Nd  [10] SEGMENTED DIGIT ZERO..SEGMENTED DIGIT NINE
  0x20000, 0x2A6DF, // Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
  0x2A700, 0x2B81D, // Lo [4382] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B81D
  0x2B820, 0x2CEAD, // Lo [5774] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEAD
  0x2CEB0, 0x2EBE0, // Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
  0x2EBF0, 0x2EE5D, // Lo [622] CJK UNIFIED IDEOGRAPH-2EBF0..CJK UNIFIED IDEOGRAPH-2EE5D
  0x2F800, 0x2FA1D, // Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
  0x30000, 0x3134A, // Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
  0x31350, 0x33479, // Lo [8490] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-33479
  0xE0100, 0xE01EF, // Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
)
internal val identifierIgnorableRanges = intArrayOf(
  0xAD, 0xAD, // Cf       SOFT HYPHEN
  0x34F, 0x34F, // Mn       COMBINING GRAPHEME JOINER
  0x61C, 0x61C, // Cf       ARABIC LETTER MARK
  0x115F, 0x1160, // Lo   [2] HANGUL CHOSEONG FILLER..HANGUL JUNGSEONG FILLER
  0x17B4, 0x17B5, // Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
  0x180B, 0x180D, // Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
  0x180E, 0x180E, // Cf       MONGOLIAN VOWEL SEPARATOR
  0x180F, 0x180F, // Mn       MONGOLIAN FREE VARIATION SELECTOR FOUR
  0x200B, 0x200F, // Cf   [5] ZERO WIDTH SPACE..RIGHT-TO-LEFT MARK
  0x202A, 0x202E, // Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
  0x2060, 0x2064, // Cf   [5] WORD JOINER..INVISIBLE PLUS
  0x2066, 0x206F, // Cf  [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
  0x3164, 0x3164, // Lo       HANGUL FILLER
  0xFE00, 0xFE0F, // Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
  0xFEFF, 0xFEFF, // Cf       ZERO WIDTH NO-BREAK SPACE
  0xFFA0, 0xFFA0, // Lo       HALFWIDTH HANGUL FILLER
  0x1BCA0, 0x1BCA3, // Cf   [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
  0x1D173, 0x1D17A, // Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
  0xE0001, 0xE0001, // Cf       LANGUAGE TAG
  0xE0020, 0xE007F, // Cf  [96] TAG SPACE..CANCEL TAG
  0xE0100, 0xE01EF, // Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
)
internal val uppercaseRanges = intArrayOf(
  0x41, 0x5A, // L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
  0xC0, 0xD6, // L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
  0xD8, 0xDE, // L&   [7] LATIN CAPITAL LETTER O WITH STROKE..LATIN CAPITAL LETTER THORN
  0x100, 0x100, // L&       LATIN CAPITAL LETTER A WITH MACRON
  0x102, 0x102, // L&       LATIN CAPITAL LETTER A WITH BREVE
  0x104, 0x104, // L&       LATIN CAPITAL LETTER A WITH OGONEK
  0x106, 0x106, // L&       LATIN CAPITAL LETTER C WITH ACUTE
  0x108, 0x108, // L&       LATIN CAPITAL LETTER C WITH CIRCUMFLEX
  0x10A, 0x10A, // L&       LATIN CAPITAL LETTER C WITH DOT ABOVE
  0x10C, 0x10C, // L&       LATIN CAPITAL LETTER C WITH CARON
  0x10E, 0x10E, // L&       LATIN CAPITAL LETTER D WITH CARON
  0x110, 0x110, // L&       LATIN CAPITAL LETTER D WITH STROKE
  0x112, 0x112, // L&       LATIN CAPITAL LETTER E WITH MACRON
  0x114, 0x114, // L&       LATIN CAPITAL LETTER E WITH BREVE
  0x116, 0x116, // L&       LATIN CAPITAL LETTER E WITH DOT ABOVE
  0x118, 0x118, // L&       LATIN CAPITAL LETTER E WITH OGONEK
  0x11A, 0x11A, // L&       LATIN CAPITAL LETTER E WITH CARON
  0x11C, 0x11C, // L&       LATIN CAPITAL LETTER G WITH CIRCUMFLEX
  0x11E, 0x11E, // L&       LATIN CAPITAL LETTER G WITH BREVE
  0x120, 0x120, // L&       LATIN CAPITAL LETTER G WITH DOT ABOVE
  0x122, 0x122, // L&       LATIN CAPITAL LETTER G WITH CEDILLA
  0x124, 0x124, // L&       LATIN CAPITAL LETTER H WITH CIRCUMFLEX
  0x126, 0x126, // L&       LATIN CAPITAL LETTER H WITH STROKE
  0x128, 0x128, // L&       LATIN CAPITAL LETTER I WITH TILDE
  0x12A, 0x12A, // L&       LATIN CAPITAL LETTER I WITH MACRON
  0x12C, 0x12C, // L&       LATIN CAPITAL LETTER I WITH BREVE
  0x12E, 0x12E, // L&       LATIN CAPITAL LETTER I WITH OGONEK
  0x130, 0x130, // L&       LATIN CAPITAL LETTER I WITH DOT ABOVE
  0x132, 0x132, // L&       LATIN CAPITAL LIGATURE IJ
  0x134, 0x134, // L&       LATIN CAPITAL LETTER J WITH CIRCUMFLEX
  0x136, 0x136, // L&       LATIN CAPITAL LETTER K WITH CEDILLA
  0x139, 0x139, // L&       LATIN CAPITAL LETTER L WITH ACUTE
  0x13B, 0x13B, // L&       LATIN CAPITAL LETTER L WITH CEDILLA
  0x13D, 0x13D, // L&       LATIN CAPITAL LETTER L WITH CARON
  0x13F, 0x13F, // L&       LATIN CAPITAL LETTER L WITH MIDDLE DOT
  0x141, 0x141, // L&       LATIN CAPITAL LETTER L WITH STROKE
  0x143, 0x143, // L&       LATIN CAPITAL LETTER N WITH ACUTE
  0x145, 0x145, // L&       LATIN CAPITAL LETTER N WITH CEDILLA
  0x147, 0x147, // L&       LATIN CAPITAL LETTER N WITH CARON
  0x14A, 0x14A, // L&       LATIN CAPITAL LETTER ENG
  0x14C, 0x14C, // L&       LATIN CAPITAL LETTER O WITH MACRON
  0x14E, 0x14E, // L&       LATIN CAPITAL LETTER O WITH BREVE
  0x150, 0x150, // L&       LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
  0x152, 0x152, // L&       LATIN CAPITAL LIGATURE OE
  0x154, 0x154, // L&       LATIN CAPITAL LETTER R WITH ACUTE
  0x156, 0x156, // L&       LATIN CAPITAL LETTER R WITH CEDILLA
  0x158, 0x158, // L&       LATIN CAPITAL LETTER R WITH CARON
  0x15A, 0x15A, // L&       LATIN CAPITAL LETTER S WITH ACUTE
  0x15C, 0x15C, // L&       LATIN CAPITAL LETTER S WITH CIRCUMFLEX
  0x15E, 0x15E, // L&       LATIN CAPITAL LETTER S WITH CEDILLA
  0x160, 0x160, // L&       LATIN CAPITAL LETTER S WITH CARON
  0x162, 0x162, // L&       LATIN CAPITAL LETTER T WITH CEDILLA
  0x164, 0x164, // L&       LATIN CAPITAL LETTER T WITH CARON
  0x166, 0x166, // L&       LATIN CAPITAL LETTER T WITH STROKE
  0x168, 0x168, // L&       LATIN CAPITAL LETTER U WITH TILDE
  0x16A, 0x16A, // L&       LATIN CAPITAL LETTER U WITH MACRON
  0x16C, 0x16C, // L&       LATIN CAPITAL LETTER U WITH BREVE
  0x16E, 0x16E, // L&       LATIN CAPITAL LETTER U WITH RING ABOVE
  0x170, 0x170, // L&       LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
  0x172, 0x172, // L&       LATIN CAPITAL LETTER U WITH OGONEK
  0x174, 0x174, // L&       LATIN CAPITAL LETTER W WITH CIRCUMFLEX
  0x176, 0x176, // L&       LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
  0x178, 0x179, // L&   [2] LATIN CAPITAL LETTER Y WITH DIAERESIS..LATIN CAPITAL LETTER Z WITH ACUTE
  0x17B, 0x17B, // L&       LATIN CAPITAL LETTER Z WITH DOT ABOVE
  0x17D, 0x17D, // L&       LATIN CAPITAL LETTER Z WITH CARON
  0x181, 0x182, // L&   [2] LATIN CAPITAL LETTER B WITH HOOK..LATIN CAPITAL LETTER B WITH TOPBAR
  0x184, 0x184, // L&       LATIN CAPITAL LETTER TONE SIX
  0x186, 0x187, // L&   [2] LATIN CAPITAL LETTER OPEN O..LATIN CAPITAL LETTER C WITH HOOK
  0x189, 0x18B, // L&   [3] LATIN CAPITAL LETTER AFRICAN D..LATIN CAPITAL LETTER D WITH TOPBAR
  0x18E, 0x191, // L&   [4] LATIN CAPITAL LETTER REVERSED E..LATIN CAPITAL LETTER F WITH HOOK
  0x193, 0x194, // L&   [2] LATIN CAPITAL LETTER G WITH HOOK..LATIN CAPITAL LETTER GAMMA
  0x196, 0x198, // L&   [3] LATIN CAPITAL LETTER IOTA..LATIN CAPITAL LETTER K WITH HOOK
  0x19C, 0x19D, // L&   [2] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER N WITH LEFT HOOK
  0x19F, 0x1A0, // L&   [2] LATIN CAPITAL LETTER O WITH MIDDLE TILDE..LATIN CAPITAL LETTER O WITH HORN
  0x1A2, 0x1A2, // L&       LATIN CAPITAL LETTER OI
  0x1A4, 0x1A4, // L&       LATIN CAPITAL LETTER P WITH HOOK
  0x1A6, 0x1A7, // L&   [2] LATIN LETTER YR..LATIN CAPITAL LETTER TONE TWO
  0x1A9, 0x1A9, // L&       LATIN CAPITAL LETTER ESH
  0x1AC, 0x1AC, // L&       LATIN CAPITAL LETTER T WITH HOOK
  0x1AE, 0x1AF, // L&   [2] LATIN CAPITAL LETTER T WITH RETROFLEX HOOK..LATIN CAPITAL LETTER U WITH HORN
  0x1B1, 0x1B3, // L&   [3] LATIN CAPITAL LETTER UPSILON..LATIN CAPITAL LETTER Y WITH HOOK
  0x1B5, 0x1B5, // L&       LATIN CAPITAL LETTER Z WITH STROKE
  0x1B7, 0x1B8, // L&   [2] LATIN CAPITAL LETTER EZH..LATIN CAPITAL LETTER EZH REVERSED
  0x1BC, 0x1BC, // L&       LATIN CAPITAL LETTER TONE FIVE
  0x1C4, 0x1C4, // L&       LATIN CAPITAL LETTER DZ WITH CARON
  0x1C7, 0x1C7, // L&       LATIN CAPITAL LETTER LJ
  0x1CA, 0x1CA, // L&       LATIN CAPITAL LETTER NJ
  0x1CD, 0x1CD, // L&       LATIN CAPITAL LETTER A WITH CARON
  0x1CF, 0x1CF, // L&       LATIN CAPITAL LETTER I WITH CARON
  0x1D1, 0x1D1, // L&       LATIN CAPITAL LETTER O WITH CARON
  0x1D3, 0x1D3, // L&       LATIN CAPITAL LETTER U WITH CARON
  0x1D5, 0x1D5, // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
  0x1D7, 0x1D7, // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
  0x1D9, 0x1D9, // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
  0x1DB, 0x1DB, // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
  0x1DE, 0x1DE, // L&       LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
  0x1E0, 0x1E0, // L&       LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
  0x1E2, 0x1E2, // L&       LATIN CAPITAL LETTER AE WITH MACRON
  0x1E4, 0x1E4, // L&       LATIN CAPITAL LETTER G WITH STROKE
  0x1E6, 0x1E6, // L&       LATIN CAPITAL LETTER G WITH CARON
  0x1E8, 0x1E8, // L&       LATIN CAPITAL LETTER K WITH CARON
  0x1EA, 0x1EA, // L&       LATIN CAPITAL LETTER O WITH OGONEK
  0x1EC, 0x1EC, // L&       LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
  0x1EE, 0x1EE, // L&       LATIN CAPITAL LETTER EZH WITH CARON
  0x1F1, 0x1F1, // L&       LATIN CAPITAL LETTER DZ
  0x1F4, 0x1F4, // L&       LATIN CAPITAL LETTER G WITH ACUTE
  0x1F6, 0x1F8, // L&   [3] LATIN CAPITAL LETTER HWAIR..LATIN CAPITAL LETTER N WITH GRAVE
  0x1FA, 0x1FA, // L&       LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
  0x1FC, 0x1FC, // L&       LATIN CAPITAL LETTER AE WITH ACUTE
  0x1FE, 0x1FE, // L&       LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
  0x200, 0x200, // L&       LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
  0x202, 0x202, // L&       LATIN CAPITAL LETTER A WITH INVERTED BREVE
  0x204, 0x204, // L&       LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
  0x206, 0x206, // L&       LATIN CAPITAL LETTER E WITH INVERTED BREVE
  0x208, 0x208, // L&       LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
  0x20A, 0x20A, // L&       LATIN CAPITAL LETTER I WITH INVERTED BREVE
  0x20C, 0x20C, // L&       LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
  0x20E, 0x20E, // L&       LATIN CAPITAL LETTER O WITH INVERTED BREVE
  0x210, 0x210, // L&       LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
  0x212, 0x212, // L&       LATIN CAPITAL LETTER R WITH INVERTED BREVE
  0x214, 0x214, // L&       LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
  0x216, 0x216, // L&       LATIN CAPITAL LETTER U WITH INVERTED BREVE
  0x218, 0x218, // L&       LATIN CAPITAL LETTER S WITH COMMA BELOW
  0x21A, 0x21A, // L&       LATIN CAPITAL LETTER T WITH COMMA BELOW
  0x21C, 0x21C, // L&       LATIN CAPITAL LETTER YOGH
  0x21E, 0x21E, // L&       LATIN CAPITAL LETTER H WITH CARON
  0x220, 0x220, // L&       LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
  0x222, 0x222, // L&       LATIN CAPITAL LETTER OU
  0x224, 0x224, // L&       LATIN CAPITAL LETTER Z WITH HOOK
  0x226, 0x226, // L&       LATIN CAPITAL LETTER A WITH DOT ABOVE
  0x228, 0x228, // L&       LATIN CAPITAL LETTER E WITH CEDILLA
  0x22A, 0x22A, // L&       LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
  0x22C, 0x22C, // L&       LATIN CAPITAL LETTER O WITH TILDE AND MACRON
  0x22E, 0x22E, // L&       LATIN CAPITAL LETTER O WITH DOT ABOVE
  0x230, 0x230, // L&       LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
  0x232, 0x232, // L&       LATIN CAPITAL LETTER Y WITH MACRON
  0x23A, 0x23B, // L&   [2] LATIN CAPITAL LETTER A WITH STROKE..LATIN CAPITAL LETTER C WITH STROKE
  0x23D, 0x23E, // L&   [2] LATIN CAPITAL LETTER L WITH BAR..LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
  0x241, 0x241, // L&       LATIN CAPITAL LETTER GLOTTAL STOP
  0x243, 0x246, // L&   [4] LATIN CAPITAL LETTER B WITH STROKE..LATIN CAPITAL LETTER E WITH STROKE
  0x248, 0x248, // L&       LATIN CAPITAL LETTER J WITH STROKE
  0x24A, 0x24A, // L&       LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
  0x24C, 0x24C, // L&       LATIN CAPITAL LETTER R WITH STROKE
  0x24E, 0x24E, // L&       LATIN CAPITAL LETTER Y WITH STROKE
  0x370, 0x370, // L&       GREEK CAPITAL LETTER HETA
  0x372, 0x372, // L&       GREEK CAPITAL LETTER ARCHAIC SAMPI
  0x376, 0x376, // L&       GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
  0x37F, 0x37F, // L&       GREEK CAPITAL LETTER YOT
  0x386, 0x386, // L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
  0x388, 0x38A, // L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
  0x38C, 0x38C, // L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
  0x38E, 0x38F, // L&   [2] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER OMEGA WITH TONOS
  0x391, 0x3A1, // L&  [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
  0x3A3, 0x3AB, // L&   [9] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
  0x3CF, 0x3CF, // L&       GREEK CAPITAL KAI SYMBOL
  0x3D2, 0x3D4, // L&   [3] GREEK UPSILON WITH HOOK SYMBOL..GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
  0x3D8, 0x3D8, // L&       GREEK LETTER ARCHAIC KOPPA
  0x3DA, 0x3DA, // L&       GREEK LETTER STIGMA
  0x3DC, 0x3DC, // L&       GREEK LETTER DIGAMMA
  0x3DE, 0x3DE, // L&       GREEK LETTER KOPPA
  0x3E0, 0x3E0, // L&       GREEK LETTER SAMPI
  0x3E2, 0x3E2, // L&       COPTIC CAPITAL LETTER SHEI
  0x3E4, 0x3E4, // L&       COPTIC CAPITAL LETTER FEI
  0x3E6, 0x3E6, // L&       COPTIC CAPITAL LETTER KHEI
  0x3E8, 0x3E8, // L&       COPTIC CAPITAL LETTER HORI
  0x3EA, 0x3EA, // L&       COPTIC CAPITAL LETTER GANGIA
  0x3EC, 0x3EC, // L&       COPTIC CAPITAL LETTER SHIMA
  0x3EE, 0x3EE, // L&       COPTIC CAPITAL LETTER DEI
  0x3F4, 0x3F4, // L&       GREEK CAPITAL THETA SYMBOL
  0x3F7, 0x3F7, // L&       GREEK CAPITAL LETTER SHO
  0x3F9, 0x3FA, // L&   [2] GREEK CAPITAL LUNATE SIGMA SYMBOL..GREEK CAPITAL LETTER SAN
  0x3FD, 0x42F, // L&  [51] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC CAPITAL LETTER YA
  0x460, 0x460, // L&       CYRILLIC CAPITAL LETTER OMEGA
  0x462, 0x462, // L&       CYRILLIC CAPITAL LETTER YAT
  0x464, 0x464, // L&       CYRILLIC CAPITAL LETTER IOTIFIED E
  0x466, 0x466, // L&       CYRILLIC CAPITAL LETTER LITTLE YUS
  0x468, 0x468, // L&       CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
  0x46A, 0x46A, // L&       CYRILLIC CAPITAL LETTER BIG YUS
  0x46C, 0x46C, // L&       CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
  0x46E, 0x46E, // L&       CYRILLIC CAPITAL LETTER KSI
  0x470, 0x470, // L&       CYRILLIC CAPITAL LETTER PSI
  0x472, 0x472, // L&       CYRILLIC CAPITAL LETTER FITA
  0x474, 0x474, // L&       CYRILLIC CAPITAL LETTER IZHITSA
  0x476, 0x476, // L&       CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
  0x478, 0x478, // L&       CYRILLIC CAPITAL LETTER UK
  0x47A, 0x47A, // L&       CYRILLIC CAPITAL LETTER ROUND OMEGA
  0x47C, 0x47C, // L&       CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
  0x47E, 0x47E, // L&       CYRILLIC CAPITAL LETTER OT
  0x480, 0x480, // L&       CYRILLIC CAPITAL LETTER KOPPA
  0x48A, 0x48A, // L&       CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
  0x48C, 0x48C, // L&       CYRILLIC CAPITAL LETTER SEMISOFT SIGN
  0x48E, 0x48E, // L&       CYRILLIC CAPITAL LETTER ER WITH TICK
  0x490, 0x490, // L&       CYRILLIC CAPITAL LETTER GHE WITH UPTURN
  0x492, 0x492, // L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE
  0x494, 0x494, // L&       CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
  0x496, 0x496, // L&       CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
  0x498, 0x498, // L&       CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
  0x49A, 0x49A, // L&       CYRILLIC CAPITAL LETTER KA WITH DESCENDER
  0x49C, 0x49C, // L&       CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
  0x49E, 0x49E, // L&       CYRILLIC CAPITAL LETTER KA WITH STROKE
  0x4A0, 0x4A0, // L&       CYRILLIC CAPITAL LETTER BASHKIR KA
  0x4A2, 0x4A2, // L&       CYRILLIC CAPITAL LETTER EN WITH DESCENDER
  0x4A4, 0x4A4, // L&       CYRILLIC CAPITAL LIGATURE EN GHE
  0x4A6, 0x4A6, // L&       CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
  0x4A8, 0x4A8, // L&       CYRILLIC CAPITAL LETTER ABKHASIAN HA
  0x4AA, 0x4AA, // L&       CYRILLIC CAPITAL LETTER ES WITH DESCENDER
  0x4AC, 0x4AC, // L&       CYRILLIC CAPITAL LETTER TE WITH DESCENDER
  0x4AE, 0x4AE, // L&       CYRILLIC CAPITAL LETTER STRAIGHT U
  0x4B0, 0x4B0, // L&       CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
  0x4B2, 0x4B2, // L&       CYRILLIC CAPITAL LETTER HA WITH DESCENDER
  0x4B4, 0x4B4, // L&       CYRILLIC CAPITAL LIGATURE TE TSE
  0x4B6, 0x4B6, // L&       CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
  0x4B8, 0x4B8, // L&       CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
  0x4BA, 0x4BA, // L&       CYRILLIC CAPITAL LETTER SHHA
  0x4BC, 0x4BC, // L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE
  0x4BE, 0x4BE, // L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
  0x4C0, 0x4C1, // L&   [2] CYRILLIC LETTER PALOCHKA..CYRILLIC CAPITAL LETTER ZHE WITH BREVE
  0x4C3, 0x4C3, // L&       CYRILLIC CAPITAL LETTER KA WITH HOOK
  0x4C5, 0x4C5, // L&       CYRILLIC CAPITAL LETTER EL WITH TAIL
  0x4C7, 0x4C7, // L&       CYRILLIC CAPITAL LETTER EN WITH HOOK
  0x4C9, 0x4C9, // L&       CYRILLIC CAPITAL LETTER EN WITH TAIL
  0x4CB, 0x4CB, // L&       CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
  0x4CD, 0x4CD, // L&       CYRILLIC CAPITAL LETTER EM WITH TAIL
  0x4D0, 0x4D0, // L&       CYRILLIC CAPITAL LETTER A WITH BREVE
  0x4D2, 0x4D2, // L&       CYRILLIC CAPITAL LETTER A WITH DIAERESIS
  0x4D4, 0x4D4, // L&       CYRILLIC CAPITAL LIGATURE A IE
  0x4D6, 0x4D6, // L&       CYRILLIC CAPITAL LETTER IE WITH BREVE
  0x4D8, 0x4D8, // L&       CYRILLIC CAPITAL LETTER SCHWA
  0x4DA, 0x4DA, // L&       CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
  0x4DC, 0x4DC, // L&       CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
  0x4DE, 0x4DE, // L&       CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
  0x4E0, 0x4E0, // L&       CYRILLIC CAPITAL LETTER ABKHASIAN DZE
  0x4E2, 0x4E2, // L&       CYRILLIC CAPITAL LETTER I WITH MACRON
  0x4E4, 0x4E4, // L&       CYRILLIC CAPITAL LETTER I WITH DIAERESIS
  0x4E6, 0x4E6, // L&       CYRILLIC CAPITAL LETTER O WITH DIAERESIS
  0x4E8, 0x4E8, // L&       CYRILLIC CAPITAL LETTER BARRED O
  0x4EA, 0x4EA, // L&       CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
  0x4EC, 0x4EC, // L&       CYRILLIC CAPITAL LETTER E WITH DIAERESIS
  0x4EE, 0x4EE, // L&       CYRILLIC CAPITAL LETTER U WITH MACRON
  0x4F0, 0x4F0, // L&       CYRILLIC CAPITAL LETTER U WITH DIAERESIS
  0x4F2, 0x4F2, // L&       CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
  0x4F4, 0x4F4, // L&       CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
  0x4F6, 0x4F6, // L&       CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
  0x4F8, 0x4F8, // L&       CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
  0x4FA, 0x4FA, // L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
  0x4FC, 0x4FC, // L&       CYRILLIC CAPITAL LETTER HA WITH HOOK
  0x4FE, 0x4FE, // L&       CYRILLIC CAPITAL LETTER HA WITH STROKE
  0x500, 0x500, // L&       CYRILLIC CAPITAL LETTER KOMI DE
  0x502, 0x502, // L&       CYRILLIC CAPITAL LETTER KOMI DJE
  0x504, 0x504, // L&       CYRILLIC CAPITAL LETTER KOMI ZJE
  0x506, 0x506, // L&       CYRILLIC CAPITAL LETTER KOMI DZJE
  0x508, 0x508, // L&       CYRILLIC CAPITAL LETTER KOMI LJE
  0x50A, 0x50A, // L&       CYRILLIC CAPITAL LETTER KOMI NJE
  0x50C, 0x50C, // L&       CYRILLIC CAPITAL LETTER KOMI SJE
  0x50E, 0x50E, // L&       CYRILLIC CAPITAL LETTER KOMI TJE
  0x510, 0x510, // L&       CYRILLIC CAPITAL LETTER REVERSED ZE
  0x512, 0x512, // L&       CYRILLIC CAPITAL LETTER EL WITH HOOK
  0x514, 0x514, // L&       CYRILLIC CAPITAL LETTER LHA
  0x516, 0x516, // L&       CYRILLIC CAPITAL LETTER RHA
  0x518, 0x518, // L&       CYRILLIC CAPITAL LETTER YAE
  0x51A, 0x51A, // L&       CYRILLIC CAPITAL LETTER QA
  0x51C, 0x51C, // L&       CYRILLIC CAPITAL LETTER WE
  0x51E, 0x51E, // L&       CYRILLIC CAPITAL LETTER ALEUT KA
  0x520, 0x520, // L&       CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
  0x522, 0x522, // L&       CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
  0x524, 0x524, // L&       CYRILLIC CAPITAL LETTER PE WITH DESCENDER
  0x526, 0x526, // L&       CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
  0x528, 0x528, // L&       CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
  0x52A, 0x52A, // L&       CYRILLIC CAPITAL LETTER DZZHE
  0x52C, 0x52C, // L&       CYRILLIC CAPITAL LETTER DCHE
  0x52E, 0x52E, // L&       CYRILLIC CAPITAL LETTER EL WITH DESCENDER
  0x531, 0x556, // L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
  0x10A0, 0x10C5, // L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
  0x10C7, 0x10C7, // L&       GEORGIAN CAPITAL LETTER YN
  0x10CD, 0x10CD, // L&       GEORGIAN CAPITAL LETTER AEN
  0x13A0, 0x13F5, // L&  [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
  0x1C89, 0x1C89, // L&       CYRILLIC CAPITAL LETTER TJE
  0x1C90, 0x1CBA, // L&  [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
  0x1CBD, 0x1CBF, // L&   [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
  0x1E00, 0x1E00, // L&       LATIN CAPITAL LETTER A WITH RING BELOW
  0x1E02, 0x1E02, // L&       LATIN CAPITAL LETTER B WITH DOT ABOVE
  0x1E04, 0x1E04, // L&       LATIN CAPITAL LETTER B WITH DOT BELOW
  0x1E06, 0x1E06, // L&       LATIN CAPITAL LETTER B WITH LINE BELOW
  0x1E08, 0x1E08, // L&       LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
  0x1E0A, 0x1E0A, // L&       LATIN CAPITAL LETTER D WITH DOT ABOVE
  0x1E0C, 0x1E0C, // L&       LATIN CAPITAL LETTER D WITH DOT BELOW
  0x1E0E, 0x1E0E, // L&       LATIN CAPITAL LETTER D WITH LINE BELOW
  0x1E10, 0x1E10, // L&       LATIN CAPITAL LETTER D WITH CEDILLA
  0x1E12, 0x1E12, // L&       LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
  0x1E14, 0x1E14, // L&       LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
  0x1E16, 0x1E16, // L&       LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
  0x1E18, 0x1E18, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
  0x1E1A, 0x1E1A, // L&       LATIN CAPITAL LETTER E WITH TILDE BELOW
  0x1E1C, 0x1E1C, // L&       LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
  0x1E1E, 0x1E1E, // L&       LATIN CAPITAL LETTER F WITH DOT ABOVE
  0x1E20, 0x1E20, // L&       LATIN CAPITAL LETTER G WITH MACRON
  0x1E22, 0x1E22, // L&       LATIN CAPITAL LETTER H WITH DOT ABOVE
  0x1E24, 0x1E24, // L&       LATIN CAPITAL LETTER H WITH DOT BELOW
  0x1E26, 0x1E26, // L&       LATIN CAPITAL LETTER H WITH DIAERESIS
  0x1E28, 0x1E28, // L&       LATIN CAPITAL LETTER H WITH CEDILLA
  0x1E2A, 0x1E2A, // L&       LATIN CAPITAL LETTER H WITH BREVE BELOW
  0x1E2C, 0x1E2C, // L&       LATIN CAPITAL LETTER I WITH TILDE BELOW
  0x1E2E, 0x1E2E, // L&       LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
  0x1E30, 0x1E30, // L&       LATIN CAPITAL LETTER K WITH ACUTE
  0x1E32, 0x1E32, // L&       LATIN CAPITAL LETTER K WITH DOT BELOW
  0x1E34, 0x1E34, // L&       LATIN CAPITAL LETTER K WITH LINE BELOW
  0x1E36, 0x1E36, // L&       LATIN CAPITAL LETTER L WITH DOT BELOW
  0x1E38, 0x1E38, // L&       LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
  0x1E3A, 0x1E3A, // L&       LATIN CAPITAL LETTER L WITH LINE BELOW
  0x1E3C, 0x1E3C, // L&       LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
  0x1E3E, 0x1E3E, // L&       LATIN CAPITAL LETTER M WITH ACUTE
  0x1E40, 0x1E40, // L&       LATIN CAPITAL LETTER M WITH DOT ABOVE
  0x1E42, 0x1E42, // L&       LATIN CAPITAL LETTER M WITH DOT BELOW
  0x1E44, 0x1E44, // L&       LATIN CAPITAL LETTER N WITH DOT ABOVE
  0x1E46, 0x1E46, // L&       LATIN CAPITAL LETTER N WITH DOT BELOW
  0x1E48, 0x1E48, // L&       LATIN CAPITAL LETTER N WITH LINE BELOW
  0x1E4A, 0x1E4A, // L&       LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
  0x1E4C, 0x1E4C, // L&       LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
  0x1E4E, 0x1E4E, // L&       LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
  0x1E50, 0x1E50, // L&       LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
  0x1E52, 0x1E52, // L&       LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
  0x1E54, 0x1E54, // L&       LATIN CAPITAL LETTER P WITH ACUTE
  0x1E56, 0x1E56, // L&       LATIN CAPITAL LETTER P WITH DOT ABOVE
  0x1E58, 0x1E58, // L&       LATIN CAPITAL LETTER R WITH DOT ABOVE
  0x1E5A, 0x1E5A, // L&       LATIN CAPITAL LETTER R WITH DOT BELOW
  0x1E5C, 0x1E5C, // L&       LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
  0x1E5E, 0x1E5E, // L&       LATIN CAPITAL LETTER R WITH LINE BELOW
  0x1E60, 0x1E60, // L&       LATIN CAPITAL LETTER S WITH DOT ABOVE
  0x1E62, 0x1E62, // L&       LATIN CAPITAL LETTER S WITH DOT BELOW
  0x1E64, 0x1E64, // L&       LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
  0x1E66, 0x1E66, // L&       LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
  0x1E68, 0x1E68, // L&       LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
  0x1E6A, 0x1E6A, // L&       LATIN CAPITAL LETTER T WITH DOT ABOVE
  0x1E6C, 0x1E6C, // L&       LATIN CAPITAL LETTER T WITH DOT BELOW
  0x1E6E, 0x1E6E, // L&       LATIN CAPITAL LETTER T WITH LINE BELOW
  0x1E70, 0x1E70, // L&       LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
  0x1E72, 0x1E72, // L&       LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
  0x1E74, 0x1E74, // L&       LATIN CAPITAL LETTER U WITH TILDE BELOW
  0x1E76, 0x1E76, // L&       LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
  0x1E78, 0x1E78, // L&       LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
  0x1E7A, 0x1E7A, // L&       LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
  0x1E7C, 0x1E7C, // L&       LATIN CAPITAL LETTER V WITH TILDE
  0x1E7E, 0x1E7E, // L&       LATIN CAPITAL LETTER V WITH DOT BELOW
  0x1E80, 0x1E80, // L&       LATIN CAPITAL LETTER W WITH GRAVE
  0x1E82, 0x1E82, // L&       LATIN CAPITAL LETTER W WITH ACUTE
  0x1E84, 0x1E84, // L&       LATIN CAPITAL LETTER W WITH DIAERESIS
  0x1E86, 0x1E86, // L&       LATIN CAPITAL LETTER W WITH DOT ABOVE
  0x1E88, 0x1E88, // L&       LATIN CAPITAL LETTER W WITH DOT BELOW
  0x1E8A, 0x1E8A, // L&       LATIN CAPITAL LETTER X WITH DOT ABOVE
  0x1E8C, 0x1E8C, // L&       LATIN CAPITAL LETTER X WITH DIAERESIS
  0x1E8E, 0x1E8E, // L&       LATIN CAPITAL LETTER Y WITH DOT ABOVE
  0x1E90, 0x1E90, // L&       LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
  0x1E92, 0x1E92, // L&       LATIN CAPITAL LETTER Z WITH DOT BELOW
  0x1E94, 0x1E94, // L&       LATIN CAPITAL LETTER Z WITH LINE BELOW
  0x1E9E, 0x1E9E, // L&       LATIN CAPITAL LETTER SHARP S
  0x1EA0, 0x1EA0, // L&       LATIN CAPITAL LETTER A WITH DOT BELOW
  0x1EA2, 0x1EA2, // L&       LATIN CAPITAL LETTER A WITH HOOK ABOVE
  0x1EA4, 0x1EA4, // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
  0x1EA6, 0x1EA6, // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
  0x1EA8, 0x1EA8, // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EAA, 0x1EAA, // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
  0x1EAC, 0x1EAC, // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
  0x1EAE, 0x1EAE, // L&       LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
  0x1EB0, 0x1EB0, // L&       LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
  0x1EB2, 0x1EB2, // L&       LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
  0x1EB4, 0x1EB4, // L&       LATIN CAPITAL LETTER A WITH BREVE AND TILDE
  0x1EB6, 0x1EB6, // L&       LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
  0x1EB8, 0x1EB8, // L&       LATIN CAPITAL LETTER E WITH DOT BELOW
  0x1EBA, 0x1EBA, // L&       LATIN CAPITAL LETTER E WITH HOOK ABOVE
  0x1EBC, 0x1EBC, // L&       LATIN CAPITAL LETTER E WITH TILDE
  0x1EBE, 0x1EBE, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
  0x1EC0, 0x1EC0, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
  0x1EC2, 0x1EC2, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
  0x1EC4, 0x1EC4, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
  0x1EC6, 0x1EC6, // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
  0x1EC8, 0x1EC8, // L&       LATIN CAPITAL LETTER I WITH HOOK ABOVE
  0x1ECA, 0x1ECA, // L&       LATIN CAPITAL LETTER I WITH DOT BELOW
  0x1ECC, 0x1ECC, // L&       LATIN CAPITAL LETTER O WITH DOT BELOW
  0x1ECE, 0x1ECE, // L&       LATIN CAPITAL LETTER O WITH HOOK ABOVE
  0x1ED0, 0x1ED0, // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
  0x1ED2, 0x1ED2, // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
  0x1ED4, 0x1ED4, // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
  0x1ED6, 0x1ED6, // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
  0x1ED8, 0x1ED8, // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
  0x1EDA, 0x1EDA, // L&       LATIN CAPITAL LETTER O WITH HORN AND ACUTE
  0x1EDC, 0x1EDC, // L&       LATIN CAPITAL LETTER O WITH HORN AND GRAVE
  0x1EDE, 0x1EDE, // L&       LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
  0x1EE0, 0x1EE0, // L&       LATIN CAPITAL LETTER O WITH HORN AND TILDE
  0x1EE2, 0x1EE2, // L&       LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
  0x1EE4, 0x1EE4, // L&       LATIN CAPITAL LETTER U WITH DOT BELOW
  0x1EE6, 0x1EE6, // L&       LATIN CAPITAL LETTER U WITH HOOK ABOVE
  0x1EE8, 0x1EE8, // L&       LATIN CAPITAL LETTER U WITH HORN AND ACUTE
  0x1EEA, 0x1EEA, // L&       LATIN CAPITAL LETTER U WITH HORN AND GRAVE
  0x1EEC, 0x1EEC, // L&       LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
  0x1EEE, 0x1EEE, // L&       LATIN CAPITAL LETTER U WITH HORN AND TILDE
  0x1EF0, 0x1EF0, // L&       LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
  0x1EF2, 0x1EF2, // L&       LATIN CAPITAL LETTER Y WITH GRAVE
  0x1EF4, 0x1EF4, // L&       LATIN CAPITAL LETTER Y WITH DOT BELOW
  0x1EF6, 0x1EF6, // L&       LATIN CAPITAL LETTER Y WITH HOOK ABOVE
  0x1EF8, 0x1EF8, // L&       LATIN CAPITAL LETTER Y WITH TILDE
  0x1EFA, 0x1EFA, // L&       LATIN CAPITAL LETTER MIDDLE-WELSH LL
  0x1EFC, 0x1EFC, // L&       LATIN CAPITAL LETTER MIDDLE-WELSH V
  0x1EFE, 0x1EFE, // L&       LATIN CAPITAL LETTER Y WITH LOOP
  0x1F08, 0x1F0F, // L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
  0x1F18, 0x1F1D, // L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
  0x1F28, 0x1F2F, // L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
  0x1F38, 0x1F3F, // L&   [8] GREEK CAPITAL LETTER IOTA WITH PSILI..GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
  0x1F48, 0x1F4D, // L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
  0x1F59, 0x1F59, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
  0x1F5B, 0x1F5B, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
  0x1F5D, 0x1F5D, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
  0x1F5F, 0x1F5F, // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
  0x1F68, 0x1F6F, // L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
  0x1FB8, 0x1FBB, // L&   [4] GREEK CAPITAL LETTER ALPHA WITH VRACHY..GREEK CAPITAL LETTER ALPHA WITH OXIA
  0x1FC8, 0x1FCB, // L&   [4] GREEK CAPITAL LETTER EPSILON WITH VARIA..GREEK CAPITAL LETTER ETA WITH OXIA
  0x1FD8, 0x1FDB, // L&   [4] GREEK CAPITAL LETTER IOTA WITH VRACHY..GREEK CAPITAL LETTER IOTA WITH OXIA
  0x1FE8, 0x1FEC, // L&   [5] GREEK CAPITAL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
  0x1FF8, 0x1FFB, // L&   [4] GREEK CAPITAL LETTER OMICRON WITH VARIA..GREEK CAPITAL LETTER OMEGA WITH OXIA
  0x2102, 0x2102, // L&       DOUBLE-STRUCK CAPITAL C
  0x2107, 0x2107, // L&       EULER CONSTANT
  0x210B, 0x210D, // L&   [3] SCRIPT CAPITAL H..DOUBLE-STRUCK CAPITAL H
  0x2110, 0x2112, // L&   [3] SCRIPT CAPITAL I..SCRIPT CAPITAL L
  0x2115, 0x2115, // L&       DOUBLE-STRUCK CAPITAL N
  0x2119, 0x211D, // L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
  0x2124, 0x2124, // L&       DOUBLE-STRUCK CAPITAL Z
  0x2126, 0x2126, // L&       OHM SIGN
  0x2128, 0x2128, // L&       BLACK-LETTER CAPITAL Z
  0x212A, 0x212D, // L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
  0x2130, 0x2133, // L&   [4] SCRIPT CAPITAL E..SCRIPT CAPITAL M
  0x213E, 0x213F, // L&   [2] DOUBLE-STRUCK CAPITAL GAMMA..DOUBLE-STRUCK CAPITAL PI
  0x2145, 0x2145, // L&       DOUBLE-STRUCK ITALIC CAPITAL D
  0x2160, 0x216F, // Nl  [16] ROMAN NUMERAL ONE..ROMAN NUMERAL ONE THOUSAND
  0x2183, 0x2183, // L&       ROMAN NUMERAL REVERSED ONE HUNDRED
  0x24B6, 0x24CF, // So  [26] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN CAPITAL LETTER Z
  0x2C00, 0x2C2F, // L&  [48] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI
  0x2C60, 0x2C60, // L&       LATIN CAPITAL LETTER L WITH DOUBLE BAR
  0x2C62, 0x2C64, // L&   [3] LATIN CAPITAL LETTER L WITH MIDDLE TILDE..LATIN CAPITAL LETTER R WITH TAIL
  0x2C67, 0x2C67, // L&       LATIN CAPITAL LETTER H WITH DESCENDER
  0x2C69, 0x2C69, // L&       LATIN CAPITAL LETTER K WITH DESCENDER
  0x2C6B, 0x2C6B, // L&       LATIN CAPITAL LETTER Z WITH DESCENDER
  0x2C6D, 0x2C70, // L&   [4] LATIN CAPITAL LETTER ALPHA..LATIN CAPITAL LETTER TURNED ALPHA
  0x2C72, 0x2C72, // L&       LATIN CAPITAL LETTER W WITH HOOK
  0x2C75, 0x2C75, // L&       LATIN CAPITAL LETTER HALF H
  0x2C7E, 0x2C80, // L&   [3] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC CAPITAL LETTER ALFA
  0x2C82, 0x2C82, // L&       COPTIC CAPITAL LETTER VIDA
  0x2C84, 0x2C84, // L&       COPTIC CAPITAL LETTER GAMMA
  0x2C86, 0x2C86, // L&       COPTIC CAPITAL LETTER DALDA
  0x2C88, 0x2C88, // L&       COPTIC CAPITAL LETTER EIE
  0x2C8A, 0x2C8A, // L&       COPTIC CAPITAL LETTER SOU
  0x2C8C, 0x2C8C, // L&       COPTIC CAPITAL LETTER ZATA
  0x2C8E, 0x2C8E, // L&       COPTIC CAPITAL LETTER HATE
  0x2C90, 0x2C90, // L&       COPTIC CAPITAL LETTER THETHE
  0x2C92, 0x2C92, // L&       COPTIC CAPITAL LETTER IAUDA
  0x2C94, 0x2C94, // L&       COPTIC CAPITAL LETTER KAPA
  0x2C96, 0x2C96, // L&       COPTIC CAPITAL LETTER LAULA
  0x2C98, 0x2C98, // L&       COPTIC CAPITAL LETTER MI
  0x2C9A, 0x2C9A, // L&       COPTIC CAPITAL LETTER NI
  0x2C9C, 0x2C9C, // L&       COPTIC CAPITAL LETTER KSI
  0x2C9E, 0x2C9E, // L&       COPTIC CAPITAL LETTER O
  0x2CA0, 0x2CA0, // L&       COPTIC CAPITAL LETTER PI
  0x2CA2, 0x2CA2, // L&       COPTIC CAPITAL LETTER RO
  0x2CA4, 0x2CA4, // L&       COPTIC CAPITAL LETTER SIMA
  0x2CA6, 0x2CA6, // L&       COPTIC CAPITAL LETTER TAU
  0x2CA8, 0x2CA8, // L&       COPTIC CAPITAL LETTER UA
  0x2CAA, 0x2CAA, // L&       COPTIC CAPITAL LETTER FI
  0x2CAC, 0x2CAC, // L&       COPTIC CAPITAL LETTER KHI
  0x2CAE, 0x2CAE, // L&       COPTIC CAPITAL LETTER PSI
  0x2CB0, 0x2CB0, // L&       COPTIC CAPITAL LETTER OOU
  0x2CB2, 0x2CB2, // L&       COPTIC CAPITAL LETTER DIALECT-P ALEF
  0x2CB4, 0x2CB4, // L&       COPTIC CAPITAL LETTER OLD COPTIC AIN
  0x2CB6, 0x2CB6, // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
  0x2CB8, 0x2CB8, // L&       COPTIC CAPITAL LETTER DIALECT-P KAPA
  0x2CBA, 0x2CBA, // L&       COPTIC CAPITAL LETTER DIALECT-P NI
  0x2CBC, 0x2CBC, // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
  0x2CBE, 0x2CBE, // L&       COPTIC CAPITAL LETTER OLD COPTIC OOU
  0x2CC0, 0x2CC0, // L&       COPTIC CAPITAL LETTER SAMPI
  0x2CC2, 0x2CC2, // L&       COPTIC CAPITAL LETTER CROSSED SHEI
  0x2CC4, 0x2CC4, // L&       COPTIC CAPITAL LETTER OLD COPTIC SHEI
  0x2CC6, 0x2CC6, // L&       COPTIC CAPITAL LETTER OLD COPTIC ESH
  0x2CC8, 0x2CC8, // L&       COPTIC CAPITAL LETTER AKHMIMIC KHEI
  0x2CCA, 0x2CCA, // L&       COPTIC CAPITAL LETTER DIALECT-P HORI
  0x2CCC, 0x2CCC, // L&       COPTIC CAPITAL LETTER OLD COPTIC HORI
  0x2CCE, 0x2CCE, // L&       COPTIC CAPITAL LETTER OLD COPTIC HA
  0x2CD0, 0x2CD0, // L&       COPTIC CAPITAL LETTER L-SHAPED HA
  0x2CD2, 0x2CD2, // L&       COPTIC CAPITAL LETTER OLD COPTIC HEI
  0x2CD4, 0x2CD4, // L&       COPTIC CAPITAL LETTER OLD COPTIC HAT
  0x2CD6, 0x2CD6, // L&       COPTIC CAPITAL LETTER OLD COPTIC GANGIA
  0x2CD8, 0x2CD8, // L&       COPTIC CAPITAL LETTER OLD COPTIC DJA
  0x2CDA, 0x2CDA, // L&       COPTIC CAPITAL LETTER OLD COPTIC SHIMA
  0x2CDC, 0x2CDC, // L&       COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
  0x2CDE, 0x2CDE, // L&       COPTIC CAPITAL LETTER OLD NUBIAN NGI
  0x2CE0, 0x2CE0, // L&       COPTIC CAPITAL LETTER OLD NUBIAN NYI
  0x2CE2, 0x2CE2, // L&       COPTIC CAPITAL LETTER OLD NUBIAN WAU
  0x2CEB, 0x2CEB, // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
  0x2CED, 0x2CED, // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
  0x2CF2, 0x2CF2, // L&       COPTIC CAPITAL LETTER BOHAIRIC KHEI
  0xA640, 0xA640, // L&       CYRILLIC CAPITAL LETTER ZEMLYA
  0xA642, 0xA642, // L&       CYRILLIC CAPITAL LETTER DZELO
  0xA644, 0xA644, // L&       CYRILLIC CAPITAL LETTER REVERSED DZE
  0xA646, 0xA646, // L&       CYRILLIC CAPITAL LETTER IOTA
  0xA648, 0xA648, // L&       CYRILLIC CAPITAL LETTER DJERV
  0xA64A, 0xA64A, // L&       CYRILLIC CAPITAL LETTER MONOGRAPH UK
  0xA64C, 0xA64C, // L&       CYRILLIC CAPITAL LETTER BROAD OMEGA
  0xA64E, 0xA64E, // L&       CYRILLIC CAPITAL LETTER NEUTRAL YER
  0xA650, 0xA650, // L&       CYRILLIC CAPITAL LETTER YERU WITH BACK YER
  0xA652, 0xA652, // L&       CYRILLIC CAPITAL LETTER IOTIFIED YAT
  0xA654, 0xA654, // L&       CYRILLIC CAPITAL LETTER REVERSED YU
  0xA656, 0xA656, // L&       CYRILLIC CAPITAL LETTER IOTIFIED A
  0xA658, 0xA658, // L&       CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
  0xA65A, 0xA65A, // L&       CYRILLIC CAPITAL LETTER BLENDED YUS
  0xA65C, 0xA65C, // L&       CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
  0xA65E, 0xA65E, // L&       CYRILLIC CAPITAL LETTER YN
  0xA660, 0xA660, // L&       CYRILLIC CAPITAL LETTER REVERSED TSE
  0xA662, 0xA662, // L&       CYRILLIC CAPITAL LETTER SOFT DE
  0xA664, 0xA664, // L&       CYRILLIC CAPITAL LETTER SOFT EL
  0xA666, 0xA666, // L&       CYRILLIC CAPITAL LETTER SOFT EM
  0xA668, 0xA668, // L&       CYRILLIC CAPITAL LETTER MONOCULAR O
  0xA66A, 0xA66A, // L&       CYRILLIC CAPITAL LETTER BINOCULAR O
  0xA66C, 0xA66C, // L&       CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
  0xA680, 0xA680, // L&       CYRILLIC CAPITAL LETTER DWE
  0xA682, 0xA682, // L&       CYRILLIC CAPITAL LETTER DZWE
  0xA684, 0xA684, // L&       CYRILLIC CAPITAL LETTER ZHWE
  0xA686, 0xA686, // L&       CYRILLIC CAPITAL LETTER CCHE
  0xA688, 0xA688, // L&       CYRILLIC CAPITAL LETTER DZZE
  0xA68A, 0xA68A, // L&       CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
  0xA68C, 0xA68C, // L&       CYRILLIC CAPITAL LETTER TWE
  0xA68E, 0xA68E, // L&       CYRILLIC CAPITAL LETTER TSWE
  0xA690, 0xA690, // L&       CYRILLIC CAPITAL LETTER TSSE
  0xA692, 0xA692, // L&       CYRILLIC CAPITAL LETTER TCHE
  0xA694, 0xA694, // L&       CYRILLIC CAPITAL LETTER HWE
  0xA696, 0xA696, // L&       CYRILLIC CAPITAL LETTER SHWE
  0xA698, 0xA698, // L&       CYRILLIC CAPITAL LETTER DOUBLE O
  0xA69A, 0xA69A, // L&       CYRILLIC CAPITAL LETTER CROSSED O
  0xA722, 0xA722, // L&       LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
  0xA724, 0xA724, // L&       LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
  0xA726, 0xA726, // L&       LATIN CAPITAL LETTER HENG
  0xA728, 0xA728, // L&       LATIN CAPITAL LETTER TZ
  0xA72A, 0xA72A, // L&       LATIN CAPITAL LETTER TRESILLO
  0xA72C, 0xA72C, // L&       LATIN CAPITAL LETTER CUATRILLO
  0xA72E, 0xA72E, // L&       LATIN CAPITAL LETTER CUATRILLO WITH COMMA
  0xA732, 0xA732, // L&       LATIN CAPITAL LETTER AA
  0xA734, 0xA734, // L&       LATIN CAPITAL LETTER AO
  0xA736, 0xA736, // L&       LATIN CAPITAL LETTER AU
  0xA738, 0xA738, // L&       LATIN CAPITAL LETTER AV
  0xA73A, 0xA73A, // L&       LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
  0xA73C, 0xA73C, // L&       LATIN CAPITAL LETTER AY
  0xA73E, 0xA73E, // L&       LATIN CAPITAL LETTER REVERSED C WITH DOT
  0xA740, 0xA740, // L&       LATIN CAPITAL LETTER K WITH STROKE
  0xA742, 0xA742, // L&       LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
  0xA744, 0xA744, // L&       LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
  0xA746, 0xA746, // L&       LATIN CAPITAL LETTER BROKEN L
  0xA748, 0xA748, // L&       LATIN CAPITAL LETTER L WITH HIGH STROKE
  0xA74A, 0xA74A, // L&       LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
  0xA74C, 0xA74C, // L&       LATIN CAPITAL LETTER O WITH LOOP
  0xA74E, 0xA74E, // L&       LATIN CAPITAL LETTER OO
  0xA750, 0xA750, // L&       LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
  0xA752, 0xA752, // L&       LATIN CAPITAL LETTER P WITH FLOURISH
  0xA754, 0xA754, // L&       LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
  0xA756, 0xA756, // L&       LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
  0xA758, 0xA758, // L&       LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
  0xA75A, 0xA75A, // L&       LATIN CAPITAL LETTER R ROTUNDA
  0xA75C, 0xA75C, // L&       LATIN CAPITAL LETTER RUM ROTUNDA
  0xA75E, 0xA75E, // L&       LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
  0xA760, 0xA760, // L&       LATIN CAPITAL LETTER VY
  0xA762, 0xA762, // L&       LATIN CAPITAL LETTER VISIGOTHIC Z
  0xA764, 0xA764, // L&       LATIN CAPITAL LETTER THORN WITH STROKE
  0xA766, 0xA766, // L&       LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
  0xA768, 0xA768, // L&       LATIN CAPITAL LETTER VEND
  0xA76A, 0xA76A, // L&       LATIN CAPITAL LETTER ET
  0xA76C, 0xA76C, // L&       LATIN CAPITAL LETTER IS
  0xA76E, 0xA76E, // L&       LATIN CAPITAL LETTER CON
  0xA779, 0xA779, // L&       LATIN CAPITAL LETTER INSULAR D
  0xA77B, 0xA77B, // L&       LATIN CAPITAL LETTER INSULAR F
  0xA77D, 0xA77E, // L&   [2] LATIN CAPITAL LETTER INSULAR G..LATIN CAPITAL LETTER TURNED INSULAR G
  0xA780, 0xA780, // L&       LATIN CAPITAL LETTER TURNED L
  0xA782, 0xA782, // L&       LATIN CAPITAL LETTER INSULAR R
  0xA784, 0xA784, // L&       LATIN CAPITAL LETTER INSULAR S
  0xA786, 0xA786, // L&       LATIN CAPITAL LETTER INSULAR T
  0xA78B, 0xA78B, // L&       LATIN CAPITAL LETTER SALTILLO
  0xA78D, 0xA78D, // L&       LATIN CAPITAL LETTER TURNED H
  0xA790, 0xA790, // L&       LATIN CAPITAL LETTER N WITH DESCENDER
  0xA792, 0xA792, // L&       LATIN CAPITAL LETTER C WITH BAR
  0xA796, 0xA796, // L&       LATIN CAPITAL LETTER B WITH FLOURISH
  0xA798, 0xA798, // L&       LATIN CAPITAL LETTER F WITH STROKE
  0xA79A, 0xA79A, // L&       LATIN CAPITAL LETTER VOLAPUK AE
  0xA79C, 0xA79C, // L&       LATIN CAPITAL LETTER VOLAPUK OE
  0xA79E, 0xA79E, // L&       LATIN CAPITAL LETTER VOLAPUK UE
  0xA7A0, 0xA7A0, // L&       LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
  0xA7A2, 0xA7A2, // L&       LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
  0xA7A4, 0xA7A4, // L&       LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
  0xA7A6, 0xA7A6, // L&       LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
  0xA7A8, 0xA7A8, // L&       LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
  0xA7AA, 0xA7AE, // L&   [5] LATIN CAPITAL LETTER H WITH HOOK..LATIN CAPITAL LETTER SMALL CAPITAL I
  0xA7B0, 0xA7B4, // L&   [5] LATIN CAPITAL LETTER TURNED K..LATIN CAPITAL LETTER BETA
  0xA7B6, 0xA7B6, // L&       LATIN CAPITAL LETTER OMEGA
  0xA7B8, 0xA7B8, // L&       LATIN CAPITAL LETTER U WITH STROKE
  0xA7BA, 0xA7BA, // L&       LATIN CAPITAL LETTER GLOTTAL A
  0xA7BC, 0xA7BC, // L&       LATIN CAPITAL LETTER GLOTTAL I
  0xA7BE, 0xA7BE, // L&       LATIN CAPITAL LETTER GLOTTAL U
  0xA7C0, 0xA7C0, // L&       LATIN CAPITAL LETTER OLD POLISH O
  0xA7C2, 0xA7C2, // L&       LATIN CAPITAL LETTER ANGLICANA W
  0xA7C4, 0xA7C7, // L&   [4] LATIN CAPITAL LETTER C WITH PALATAL HOOK..LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY
  0xA7C9, 0xA7C9, // L&       LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY
  0xA7CB, 0xA7CC, // L&   [2] LATIN CAPITAL LETTER RAMS HORN..LATIN CAPITAL LETTER S WITH DIAGONAL STROKE
  0xA7CE, 0xA7CE, // L&       LATIN CAPITAL LETTER PHARYNGEAL VOICED FRICATIVE
  0xA7D0, 0xA7D0, // L&       LATIN CAPITAL LETTER CLOSED INSULAR G
  0xA7D2, 0xA7D2, // L&       LATIN CAPITAL LETTER DOUBLE THORN
  0xA7D4, 0xA7D4, // L&       LATIN CAPITAL LETTER DOUBLE WYNN
  0xA7D6, 0xA7D6, // L&       LATIN CAPITAL LETTER MIDDLE SCOTS S
  0xA7D8, 0xA7D8, // L&       LATIN CAPITAL LETTER SIGMOID S
  0xA7DA, 0xA7DA, // L&       LATIN CAPITAL LETTER LAMBDA
  0xA7DC, 0xA7DC, // L&       LATIN CAPITAL LETTER LAMBDA WITH STROKE
  0xA7F5, 0xA7F5, // L&       LATIN CAPITAL LETTER REVERSED HALF H
  0xFF21, 0xFF3A, // L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
  0x10400, 0x10427, // L&  [40] DESERET CAPITAL LETTER LONG I..DESERET CAPITAL LETTER EW
  0x104B0, 0x104D3, // L&  [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
  0x10570, 0x1057A, // L&  [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
  0x1057C, 0x1058A, // L&  [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
  0x1058C, 0x10592, // L&   [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
  0x10594, 0x10595, // L&   [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
  0x10C80, 0x10CB2, // L&  [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
  0x10D50, 0x10D65, // L&  [22] GARAY CAPITAL LETTER A..GARAY CAPITAL LETTER OLD NA
  0x118A0, 0x118BF, // L&  [32] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI CAPITAL LETTER VIYO
  0x16E40, 0x16E5F, // L&  [32] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN CAPITAL LETTER Y
  0x16EA0, 0x16EB8, // L&  [25] BERIA ERFE CAPITAL LETTER ARKAB..BERIA ERFE CAPITAL LETTER AY
  0x1D400, 0x1D419, // L&  [26] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL BOLD CAPITAL Z
  0x1D434, 0x1D44D, // L&  [26] MATHEMATICAL ITALIC CAPITAL A..MATHEMATICAL ITALIC CAPITAL Z
  0x1D468, 0x1D481, // L&  [26] MATHEMATICAL BOLD ITALIC CAPITAL A..MATHEMATICAL BOLD ITALIC CAPITAL Z
  0x1D49C, 0x1D49C, // L&       MATHEMATICAL SCRIPT CAPITAL A
  0x1D49E, 0x1D49F, // L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
  0x1D4A2, 0x1D4A2, // L&       MATHEMATICAL SCRIPT CAPITAL G
  0x1D4A5, 0x1D4A6, // L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
  0x1D4A9, 0x1D4AC, // L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
  0x1D4AE, 0x1D4B5, // L&   [8] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT CAPITAL Z
  0x1D4D0, 0x1D4E9, // L&  [26] MATHEMATICAL BOLD SCRIPT CAPITAL A..MATHEMATICAL BOLD SCRIPT CAPITAL Z
  0x1D504, 0x1D505, // L&   [2] MATHEMATICAL FRAKTUR CAPITAL A..MATHEMATICAL FRAKTUR CAPITAL B
  0x1D507, 0x1D50A, // L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
  0x1D50D, 0x1D514, // L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
  0x1D516, 0x1D51C, // L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
  0x1D538, 0x1D539, // L&   [2] MATHEMATICAL DOUBLE-STRUCK CAPITAL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
  0x1D53B, 0x1D53E, // L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
  0x1D540, 0x1D544, // L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
  0x1D546, 0x1D546, // L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
  0x1D54A, 0x1D550, // L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
  0x1D56C, 0x1D585, // L&  [26] MATHEMATICAL BOLD FRAKTUR CAPITAL A..MATHEMATICAL BOLD FRAKTUR CAPITAL Z
  0x1D5A0, 0x1D5B9, // L&  [26] MATHEMATICAL SANS-SERIF CAPITAL A..MATHEMATICAL SANS-SERIF CAPITAL Z
  0x1D5D4, 0x1D5ED, // L&  [26] MATHEMATICAL SANS-SERIF BOLD CAPITAL A..MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
  0x1D608, 0x1D621, // L&  [26] MATHEMATICAL SANS-SERIF ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
  0x1D63C, 0x1D655, // L&  [26] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
  0x1D670, 0x1D689, // L&  [26] MATHEMATICAL MONOSPACE CAPITAL A..MATHEMATICAL MONOSPACE CAPITAL Z
  0x1D6A8, 0x1D6C0, // L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
  0x1D6E2, 0x1D6FA, // L&  [25] MATHEMATICAL ITALIC CAPITAL ALPHA..MATHEMATICAL ITALIC CAPITAL OMEGA
  0x1D71C, 0x1D734, // L&  [25] MATHEMATICAL BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
  0x1D756, 0x1D76E, // L&  [25] MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
  0x1D790, 0x1D7A8, // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
  0x1D7CA, 0x1D7CA, // L&       MATHEMATICAL BOLD CAPITAL DIGAMMA
  0x1E900, 0x1E921, // L&  [34] ADLAM CAPITAL LETTER ALIF..ADLAM CAPITAL LETTER SHA
  0x1F130, 0x1F149, // So  [26] SQUARED LATIN CAPITAL LETTER A..SQUARED LATIN CAPITAL LETTER Z
  0x1F150, 0x1F169, // So  [26] NEGATIVE CIRCLED LATIN CAPITAL LETTER A..NEGATIVE CIRCLED LATIN CAPITAL LETTER Z
  0x1F170, 0x1F189, // So  [26] NEGATIVE SQUARED LATIN CAPITAL LETTER A..NEGATIVE SQUARED LATIN CAPITAL LETTER Z
)
/**
 * Codepoints are derived from https://www.unicode.org/Public/UCD/latest/ucd/Scripts.txt
 * Scripts-17.0.0.txt
 * Date: 2025-07-24, 13:28:55 GMT
 * © 2025 Unicode®, Inc.
 * Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * For terms of use and license, see https://www.unicode.org/terms_of_use.html
 * 
 * Unicode Character Database
 * For documentation, see https://www.unicode.org/reports/tr44/
 * For more information, see:
 * UAX #24, Unicode Script Property: https://www.unicode.org/reports/tr24/
 * Especially the sections:
 * https://www.unicode.org/reports/tr24/#Assignment_Script_Values
 * https://www.unicode.org/reports/tr24/#Assignment_ScriptX_Values
 * 
 */
internal val commonRanges = intArrayOf(
  0x0, 0x1F, // Cc  [32] <control-0000>..<control-001F>
  0x20, 0x20, // Zs       SPACE
  0x21, 0x23, // Po   [3] EXCLAMATION MARK..NUMBER SIGN
  0x24, 0x24, // Sc       DOLLAR SIGN
  0x25, 0x27, // Po   [3] PERCENT SIGN..APOSTROPHE
  0x28, 0x28, // Ps       LEFT PARENTHESIS
  0x29, 0x29, // Pe       RIGHT PARENTHESIS
  0x2A, 0x2A, // Po       ASTERISK
  0x2B, 0x2B, // Sm       PLUS SIGN
  0x2C, 0x2C, // Po       COMMA
  0x2D, 0x2D, // Pd       HYPHEN-MINUS
  0x2E, 0x2F, // Po   [2] FULL STOP..SOLIDUS
  0x30, 0x39, // Nd  [10] DIGIT ZERO..DIGIT NINE
  0x3A, 0x3B, // Po   [2] COLON..SEMICOLON
  0x3C, 0x3E, // Sm   [3] LESS-THAN SIGN..GREATER-THAN SIGN
  0x3F, 0x40, // Po   [2] QUESTION MARK..COMMERCIAL AT
  0x5B, 0x5B, // Ps       LEFT SQUARE BRACKET
  0x5C, 0x5C, // Po       REVERSE SOLIDUS
  0x5D, 0x5D, // Pe       RIGHT SQUARE BRACKET
  0x5E, 0x5E, // Sk       CIRCUMFLEX ACCENT
  0x5F, 0x5F, // Pc       LOW LINE
  0x60, 0x60, // Sk       GRAVE ACCENT
  0x7B, 0x7B, // Ps       LEFT CURLY BRACKET
  0x7C, 0x7C, // Sm       VERTICAL LINE
  0x7D, 0x7D, // Pe       RIGHT CURLY BRACKET
  0x7E, 0x7E, // Sm       TILDE
  0x7F, 0x9F, // Cc  [33] <control-007F>..<control-009F>
  0xA0, 0xA0, // Zs       NO-BREAK SPACE
  0xA1, 0xA1, // Po       INVERTED EXCLAMATION MARK
  0xA2, 0xA5, // Sc   [4] CENT SIGN..YEN SIGN
  0xA6, 0xA6, // So       BROKEN BAR
  0xA7, 0xA7, // Po       SECTION SIGN
  0xA8, 0xA8, // Sk       DIAERESIS
  0xA9, 0xA9, // So       COPYRIGHT SIGN
  0xAB, 0xAB, // Pi       LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
  0xAC, 0xAC, // Sm       NOT SIGN
  0xAD, 0xAD, // Cf       SOFT HYPHEN
  0xAE, 0xAE, // So       REGISTERED SIGN
  0xAF, 0xAF, // Sk       MACRON
  0xB0, 0xB0, // So       DEGREE SIGN
  0xB1, 0xB1, // Sm       PLUS-MINUS SIGN
  0xB2, 0xB3, // No   [2] SUPERSCRIPT TWO..SUPERSCRIPT THREE
  0xB4, 0xB4, // Sk       ACUTE ACCENT
  0xB5, 0xB5, // L&       MICRO SIGN
  0xB6, 0xB7, // Po   [2] PILCROW SIGN..MIDDLE DOT
  0xB8, 0xB8, // Sk       CEDILLA
  0xB9, 0xB9, // No       SUPERSCRIPT ONE
  0xBB, 0xBB, // Pf       RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
  0xBC, 0xBE, // No   [3] VULGAR FRACTION ONE QUARTER..VULGAR FRACTION THREE QUARTERS
  0xBF, 0xBF, // Po       INVERTED QUESTION MARK
  0xD7, 0xD7, // Sm       MULTIPLICATION SIGN
  0xF7, 0xF7, // Sm       DIVISION SIGN
  0x2B9, 0x2C1, // Lm   [9] MODIFIER LETTER PRIME..MODIFIER LETTER REVERSED GLOTTAL STOP
  0x2C2, 0x2C5, // Sk   [4] MODIFIER LETTER LEFT ARROWHEAD..MODIFIER LETTER DOWN ARROWHEAD
  0x2C6, 0x2D1, // Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
  0x2D2, 0x2DF, // Sk  [14] MODIFIER LETTER CENTRED RIGHT HALF RING..MODIFIER LETTER CROSS ACCENT
  0x2E5, 0x2E9, // Sk   [5] MODIFIER LETTER EXTRA-HIGH TONE BAR..MODIFIER LETTER EXTRA-LOW TONE BAR
  0x2EC, 0x2EC, // Lm       MODIFIER LETTER VOICING
  0x2ED, 0x2ED, // Sk       MODIFIER LETTER UNASPIRATED
  0x2EE, 0x2EE, // Lm       MODIFIER LETTER DOUBLE APOSTROPHE
  0x2EF, 0x2FF, // Sk  [17] MODIFIER LETTER LOW DOWN ARROWHEAD..MODIFIER LETTER LOW LEFT ARROW
  0x374, 0x374, // Lm       GREEK NUMERAL SIGN
  0x37E, 0x37E, // Po       GREEK QUESTION MARK
  0x385, 0x385, // Sk       GREEK DIALYTIKA TONOS
  0x387, 0x387, // Po       GREEK ANO TELEIA
  0x605, 0x605, // Cf       ARABIC NUMBER MARK ABOVE
  0x60C, 0x60C, // Po       ARABIC COMMA
  0x61B, 0x61B, // Po       ARABIC SEMICOLON
  0x61F, 0x61F, // Po       ARABIC QUESTION MARK
  0x640, 0x640, // Lm       ARABIC TATWEEL
  0x6DD, 0x6DD, // Cf       ARABIC END OF AYAH
  0x8E2, 0x8E2, // Cf       ARABIC DISPUTED END OF AYAH
  0x964, 0x965, // Po   [2] DEVANAGARI DANDA..DEVANAGARI DOUBLE DANDA
  0xE3F, 0xE3F, // Sc       THAI CURRENCY SYMBOL BAHT
  0xFD5, 0xFD8, // So   [4] RIGHT-FACING SVASTI SIGN..LEFT-FACING SVASTI SIGN WITH DOTS
  0x10FB, 0x10FB, // Po       GEORGIAN PARAGRAPH SEPARATOR
  0x16EB, 0x16ED, // Po   [3] RUNIC SINGLE PUNCTUATION..RUNIC CROSS PUNCTUATION
  0x1735, 0x1736, // Po   [2] PHILIPPINE SINGLE PUNCTUATION..PHILIPPINE DOUBLE PUNCTUATION
  0x1802, 0x1803, // Po   [2] MONGOLIAN COMMA..MONGOLIAN FULL STOP
  0x1805, 0x1805, // Po       MONGOLIAN FOUR DOTS
  0x1CD3, 0x1CD3, // Po       VEDIC SIGN NIHSHVASA
  0x1CE1, 0x1CE1, // Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
  0x1CE9, 0x1CEC, // Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
  0x1CEE, 0x1CF3, // Lo   [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
  0x1CF5, 0x1CF6, // Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
  0x1CF7, 0x1CF7, // Mc       VEDIC SIGN ATIKRAMA
  0x1CFA, 0x1CFA, // Lo       VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
  0x2000, 0x200A, // Zs  [11] EN QUAD..HAIR SPACE
  0x200B, 0x200B, // Cf       ZERO WIDTH SPACE
  0x200E, 0x200F, // Cf   [2] LEFT-TO-RIGHT MARK..RIGHT-TO-LEFT MARK
  0x2010, 0x2015, // Pd   [6] HYPHEN..HORIZONTAL BAR
  0x2016, 0x2017, // Po   [2] DOUBLE VERTICAL LINE..DOUBLE LOW LINE
  0x2018, 0x2018, // Pi       LEFT SINGLE QUOTATION MARK
  0x2019, 0x2019, // Pf       RIGHT SINGLE QUOTATION MARK
  0x201A, 0x201A, // Ps       SINGLE LOW-9 QUOTATION MARK
  0x201B, 0x201C, // Pi   [2] SINGLE HIGH-REVERSED-9 QUOTATION MARK..LEFT DOUBLE QUOTATION MARK
  0x201D, 0x201D, // Pf       RIGHT DOUBLE QUOTATION MARK
  0x201E, 0x201E, // Ps       DOUBLE LOW-9 QUOTATION MARK
  0x201F, 0x201F, // Pi       DOUBLE HIGH-REVERSED-9 QUOTATION MARK
  0x2020, 0x2027, // Po   [8] DAGGER..HYPHENATION POINT
  0x2028, 0x2028, // Zl       LINE SEPARATOR
  0x2029, 0x2029, // Zp       PARAGRAPH SEPARATOR
  0x202A, 0x202E, // Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
  0x202F, 0x202F, // Zs       NARROW NO-BREAK SPACE
  0x2030, 0x2038, // Po   [9] PER MILLE SIGN..CARET
  0x2039, 0x2039, // Pi       SINGLE LEFT-POINTING ANGLE QUOTATION MARK
  0x203A, 0x203A, // Pf       SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
  0x203B, 0x203E, // Po   [4] REFERENCE MARK..OVERLINE
  0x203F, 0x2040, // Pc   [2] UNDERTIE..CHARACTER TIE
  0x2041, 0x2043, // Po   [3] CARET INSERTION POINT..HYPHEN BULLET
  0x2044, 0x2044, // Sm       FRACTION SLASH
  0x2045, 0x2045, // Ps       LEFT SQUARE BRACKET WITH QUILL
  0x2046, 0x2046, // Pe       RIGHT SQUARE BRACKET WITH QUILL
  0x2047, 0x2051, // Po  [11] DOUBLE QUESTION MARK..TWO ASTERISKS ALIGNED VERTICALLY
  0x2052, 0x2052, // Sm       COMMERCIAL MINUS SIGN
  0x2053, 0x2053, // Po       SWUNG DASH
  0x2054, 0x2054, // Pc       INVERTED UNDERTIE
  0x2055, 0x205E, // Po  [10] FLOWER PUNCTUATION MARK..VERTICAL FOUR DOTS
  0x205F, 0x205F, // Zs       MEDIUM MATHEMATICAL SPACE
  0x2060, 0x2064, // Cf   [5] WORD JOINER..INVISIBLE PLUS
  0x2066, 0x206F, // Cf  [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
  0x2070, 0x2070, // No       SUPERSCRIPT ZERO
  0x2074, 0x2079, // No   [6] SUPERSCRIPT FOUR..SUPERSCRIPT NINE
  0x207A, 0x207C, // Sm   [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
  0x207D, 0x207D, // Ps       SUPERSCRIPT LEFT PARENTHESIS
  0x207E, 0x207E, // Pe       SUPERSCRIPT RIGHT PARENTHESIS
  0x2080, 0x2089, // No  [10] SUBSCRIPT ZERO..SUBSCRIPT NINE
  0x208A, 0x208C, // Sm   [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
  0x208D, 0x208D, // Ps       SUBSCRIPT LEFT PARENTHESIS
  0x208E, 0x208E, // Pe       SUBSCRIPT RIGHT PARENTHESIS
  0x20A0, 0x20C1, // Sc  [34] EURO-CURRENCY SIGN..SAUDI RIYAL SIGN
  0x2100, 0x2101, // So   [2] ACCOUNT OF..ADDRESSED TO THE SUBJECT
  0x2102, 0x2102, // L&       DOUBLE-STRUCK CAPITAL C
  0x2103, 0x2106, // So   [4] DEGREE CELSIUS..CADA UNA
  0x2107, 0x2107, // L&       EULER CONSTANT
  0x2108, 0x2109, // So   [2] SCRUPLE..DEGREE FAHRENHEIT
  0x210A, 0x2113, // L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
  0x2114, 0x2114, // So       L B BAR SYMBOL
  0x2115, 0x2115, // L&       DOUBLE-STRUCK CAPITAL N
  0x2116, 0x2117, // So   [2] NUMERO SIGN..SOUND RECORDING COPYRIGHT
  0x2118, 0x2118, // Sm       SCRIPT CAPITAL P
  0x2119, 0x211D, // L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
  0x211E, 0x2123, // So   [6] PRESCRIPTION TAKE..VERSICLE
  0x2124, 0x2124, // L&       DOUBLE-STRUCK CAPITAL Z
  0x2125, 0x2125, // So       OUNCE SIGN
  0x2127, 0x2127, // So       INVERTED OHM SIGN
  0x2128, 0x2128, // L&       BLACK-LETTER CAPITAL Z
  0x2129, 0x2129, // So       TURNED GREEK SMALL LETTER IOTA
  0x212C, 0x212D, // L&   [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
  0x212E, 0x212E, // So       ESTIMATED SYMBOL
  0x212F, 0x2131, // L&   [3] SCRIPT SMALL E..SCRIPT CAPITAL F
  0x2133, 0x2134, // L&   [2] SCRIPT CAPITAL M..SCRIPT SMALL O
  0x2135, 0x2138, // Lo   [4] ALEF SYMBOL..DALET SYMBOL
  0x2139, 0x2139, // L&       INFORMATION SOURCE
  0x213A, 0x213B, // So   [2] ROTATED CAPITAL Q..FACSIMILE SIGN
  0x213C, 0x213F, // L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
  0x2140, 0x2144, // Sm   [5] DOUBLE-STRUCK N-ARY SUMMATION..TURNED SANS-SERIF CAPITAL Y
  0x2145, 0x2149, // L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
  0x214A, 0x214A, // So       PROPERTY LINE
  0x214B, 0x214B, // Sm       TURNED AMPERSAND
  0x214C, 0x214D, // So   [2] PER SIGN..AKTIESELSKAB
  0x214F, 0x214F, // So       SYMBOL FOR SAMARITAN SOURCE
  0x2150, 0x215F, // No  [16] VULGAR FRACTION ONE SEVENTH..FRACTION NUMERATOR ONE
  0x2189, 0x2189, // No       VULGAR FRACTION ZERO THIRDS
  0x218A, 0x218B, // So   [2] TURNED DIGIT TWO..TURNED DIGIT THREE
  0x2190, 0x2194, // Sm   [5] LEFTWARDS ARROW..LEFT RIGHT ARROW
  0x2195, 0x2199, // So   [5] UP DOWN ARROW..SOUTH WEST ARROW
  0x219A, 0x219B, // Sm   [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
  0x219C, 0x219F, // So   [4] LEFTWARDS WAVE ARROW..UPWARDS TWO HEADED ARROW
  0x21A0, 0x21A0, // Sm       RIGHTWARDS TWO HEADED ARROW
  0x21A1, 0x21A2, // So   [2] DOWNWARDS TWO HEADED ARROW..LEFTWARDS ARROW WITH TAIL
  0x21A3, 0x21A3, // Sm       RIGHTWARDS ARROW WITH TAIL
  0x21A4, 0x21A5, // So   [2] LEFTWARDS ARROW FROM BAR..UPWARDS ARROW FROM BAR
  0x21A6, 0x21A6, // Sm       RIGHTWARDS ARROW FROM BAR
  0x21A7, 0x21AD, // So   [7] DOWNWARDS ARROW FROM BAR..LEFT RIGHT WAVE ARROW
  0x21AE, 0x21AE, // Sm       LEFT RIGHT ARROW WITH STROKE
  0x21AF, 0x21CD, // So  [31] DOWNWARDS ZIGZAG ARROW..LEFTWARDS DOUBLE ARROW WITH STROKE
  0x21CE, 0x21CF, // Sm   [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
  0x21D0, 0x21D1, // So   [2] LEFTWARDS DOUBLE ARROW..UPWARDS DOUBLE ARROW
  0x21D2, 0x21D2, // Sm       RIGHTWARDS DOUBLE ARROW
  0x21D3, 0x21D3, // So       DOWNWARDS DOUBLE ARROW
  0x21D4, 0x21D4, // Sm       LEFT RIGHT DOUBLE ARROW
  0x21D5, 0x21F3, // So  [31] UP DOWN DOUBLE ARROW..UP DOWN WHITE ARROW
  0x21F4, 0x22FF, // Sm [268] RIGHT ARROW WITH SMALL CIRCLE..Z NOTATION BAG MEMBERSHIP
  0x2300, 0x2307, // So   [8] DIAMETER SIGN..WAVY LINE
  0x2308, 0x2308, // Ps       LEFT CEILING
  0x2309, 0x2309, // Pe       RIGHT CEILING
  0x230A, 0x230A, // Ps       LEFT FLOOR
  0x230B, 0x230B, // Pe       RIGHT FLOOR
  0x230C, 0x231F, // So  [20] BOTTOM RIGHT CROP..BOTTOM RIGHT CORNER
  0x2320, 0x2321, // Sm   [2] TOP HALF INTEGRAL..BOTTOM HALF INTEGRAL
  0x2322, 0x2328, // So   [7] FROWN..KEYBOARD
  0x2329, 0x2329, // Ps       LEFT-POINTING ANGLE BRACKET
  0x232A, 0x232A, // Pe       RIGHT-POINTING ANGLE BRACKET
  0x232B, 0x237B, // So  [81] ERASE TO THE LEFT..NOT CHECK MARK
  0x237C, 0x237C, // Sm       RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
  0x237D, 0x239A, // So  [30] SHOULDERED OPEN BOX..CLEAR SCREEN SYMBOL
  0x239B, 0x23B3, // Sm  [25] LEFT PARENTHESIS UPPER HOOK..SUMMATION BOTTOM
  0x23B4, 0x23DB, // So  [40] TOP SQUARE BRACKET..FUSE
  0x23DC, 0x23E1, // Sm   [6] TOP PARENTHESIS..BOTTOM TORTOISE SHELL BRACKET
  0x23E2, 0x2429, // So  [72] WHITE TRAPEZIUM..SYMBOL FOR DELETE MEDIUM SHADE FORM
  0x2440, 0x244A, // So  [11] OCR HOOK..OCR DOUBLE BACKSLASH
  0x2460, 0x249B, // No  [60] CIRCLED DIGIT ONE..NUMBER TWENTY FULL STOP
  0x249C, 0x24E9, // So  [78] PARENTHESIZED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
  0x24EA, 0x24FF, // No  [22] CIRCLED DIGIT ZERO..NEGATIVE CIRCLED DIGIT ZERO
  0x2500, 0x25B6, // So [183] BOX DRAWINGS LIGHT HORIZONTAL..BLACK RIGHT-POINTING TRIANGLE
  0x25B7, 0x25B7, // Sm       WHITE RIGHT-POINTING TRIANGLE
  0x25B8, 0x25C0, // So   [9] BLACK RIGHT-POINTING SMALL TRIANGLE..BLACK LEFT-POINTING TRIANGLE
  0x25C1, 0x25C1, // Sm       WHITE LEFT-POINTING TRIANGLE
  0x25C2, 0x25F7, // So  [54] BLACK LEFT-POINTING SMALL TRIANGLE..WHITE CIRCLE WITH UPPER RIGHT QUADRANT
  0x25F8, 0x25FF, // Sm   [8] UPPER LEFT TRIANGLE..LOWER RIGHT TRIANGLE
  0x2600, 0x266E, // So [111] BLACK SUN WITH RAYS..MUSIC NATURAL SIGN
  0x266F, 0x266F, // Sm       MUSIC SHARP SIGN
  0x2670, 0x2767, // So [248] WEST SYRIAC CROSS..ROTATED FLORAL HEART BULLET
  0x2768, 0x2768, // Ps       MEDIUM LEFT PARENTHESIS ORNAMENT
  0x2769, 0x2769, // Pe       MEDIUM RIGHT PARENTHESIS ORNAMENT
  0x276A, 0x276A, // Ps       MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
  0x276B, 0x276B, // Pe       MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
  0x276C, 0x276C, // Ps       MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
  0x276D, 0x276D, // Pe       MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
  0x276E, 0x276E, // Ps       HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
  0x276F, 0x276F, // Pe       HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
  0x2770, 0x2770, // Ps       HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
  0x2771, 0x2771, // Pe       HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
  0x2772, 0x2772, // Ps       LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
  0x2773, 0x2773, // Pe       LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
  0x2774, 0x2774, // Ps       MEDIUM LEFT CURLY BRACKET ORNAMENT
  0x2775, 0x2775, // Pe       MEDIUM RIGHT CURLY BRACKET ORNAMENT
  0x2776, 0x2793, // No  [30] DINGBAT NEGATIVE CIRCLED DIGIT ONE..DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
  0x2794, 0x27BF, // So  [44] HEAVY WIDE-HEADED RIGHTWARDS ARROW..DOUBLE CURLY LOOP
  0x27C0, 0x27C4, // Sm   [5] THREE DIMENSIONAL ANGLE..OPEN SUPERSET
  0x27C5, 0x27C5, // Ps       LEFT S-SHAPED BAG DELIMITER
  0x27C6, 0x27C6, // Pe       RIGHT S-SHAPED BAG DELIMITER
  0x27C7, 0x27E5, // Sm  [31] OR WITH DOT INSIDE..WHITE SQUARE WITH RIGHTWARDS TICK
  0x27E6, 0x27E6, // Ps       MATHEMATICAL LEFT WHITE SQUARE BRACKET
  0x27E7, 0x27E7, // Pe       MATHEMATICAL RIGHT WHITE SQUARE BRACKET
  0x27E8, 0x27E8, // Ps       MATHEMATICAL LEFT ANGLE BRACKET
  0x27E9, 0x27E9, // Pe       MATHEMATICAL RIGHT ANGLE BRACKET
  0x27EA, 0x27EA, // Ps       MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
  0x27EB, 0x27EB, // Pe       MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
  0x27EC, 0x27EC, // Ps       MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
  0x27ED, 0x27ED, // Pe       MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
  0x27EE, 0x27EE, // Ps       MATHEMATICAL LEFT FLATTENED PARENTHESIS
  0x27EF, 0x27EF, // Pe       MATHEMATICAL RIGHT FLATTENED PARENTHESIS
  0x27F0, 0x27FF, // Sm  [16] UPWARDS QUADRUPLE ARROW..LONG RIGHTWARDS SQUIGGLE ARROW
  0x2900, 0x2982, // Sm [131] RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE..Z NOTATION TYPE COLON
  0x2983, 0x2983, // Ps       LEFT WHITE CURLY BRACKET
  0x2984, 0x2984, // Pe       RIGHT WHITE CURLY BRACKET
  0x2985, 0x2985, // Ps       LEFT WHITE PARENTHESIS
  0x2986, 0x2986, // Pe       RIGHT WHITE PARENTHESIS
  0x2987, 0x2987, // Ps       Z NOTATION LEFT IMAGE BRACKET
  0x2988, 0x2988, // Pe       Z NOTATION RIGHT IMAGE BRACKET
  0x2989, 0x2989, // Ps       Z NOTATION LEFT BINDING BRACKET
  0x298A, 0x298A, // Pe       Z NOTATION RIGHT BINDING BRACKET
  0x298B, 0x298B, // Ps       LEFT SQUARE BRACKET WITH UNDERBAR
  0x298C, 0x298C, // Pe       RIGHT SQUARE BRACKET WITH UNDERBAR
  0x298D, 0x298D, // Ps       LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
  0x298E, 0x298E, // Pe       RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
  0x298F, 0x298F, // Ps       LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
  0x2990, 0x2990, // Pe       RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
  0x2991, 0x2991, // Ps       LEFT ANGLE BRACKET WITH DOT
  0x2992, 0x2992, // Pe       RIGHT ANGLE BRACKET WITH DOT
  0x2993, 0x2993, // Ps       LEFT ARC LESS-THAN BRACKET
  0x2994, 0x2994, // Pe       RIGHT ARC GREATER-THAN BRACKET
  0x2995, 0x2995, // Ps       DOUBLE LEFT ARC GREATER-THAN BRACKET
  0x2996, 0x2996, // Pe       DOUBLE RIGHT ARC LESS-THAN BRACKET
  0x2997, 0x2997, // Ps       LEFT BLACK TORTOISE SHELL BRACKET
  0x2998, 0x2998, // Pe       RIGHT BLACK TORTOISE SHELL BRACKET
  0x2999, 0x29D7, // Sm  [63] DOTTED FENCE..BLACK HOURGLASS
  0x29D8, 0x29D8, // Ps       LEFT WIGGLY FENCE
  0x29D9, 0x29D9, // Pe       RIGHT WIGGLY FENCE
  0x29DA, 0x29DA, // Ps       LEFT DOUBLE WIGGLY FENCE
  0x29DB, 0x29DB, // Pe       RIGHT DOUBLE WIGGLY FENCE
  0x29DC, 0x29FB, // Sm  [32] INCOMPLETE INFINITY..TRIPLE PLUS
  0x29FC, 0x29FC, // Ps       LEFT-POINTING CURVED ANGLE BRACKET
  0x29FD, 0x29FD, // Pe       RIGHT-POINTING CURVED ANGLE BRACKET
  0x29FE, 0x2AFF, // Sm [258] TINY..N-ARY WHITE VERTICAL BAR
  0x2B00, 0x2B2F, // So  [48] NORTH EAST WHITE ARROW..WHITE VERTICAL ELLIPSE
  0x2B30, 0x2B44, // Sm  [21] LEFT ARROW WITH SMALL CIRCLE..RIGHTWARDS ARROW THROUGH SUPERSET
  0x2B45, 0x2B46, // So   [2] LEFTWARDS QUADRUPLE ARROW..RIGHTWARDS QUADRUPLE ARROW
  0x2B47, 0x2B4C, // Sm   [6] REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW..RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
  0x2B4D, 0x2B73, // So  [39] DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW..DOWNWARDS TRIANGLE-HEADED ARROW TO BAR
  0x2B76, 0x2BFF, // So [138] NORTH WEST TRIANGLE-HEADED ARROW TO BAR..HELLSCHREIBER PAUSE SYMBOL
  0x2E00, 0x2E01, // Po   [2] RIGHT ANGLE SUBSTITUTION MARKER..RIGHT ANGLE DOTTED SUBSTITUTION MARKER
  0x2E02, 0x2E02, // Pi       LEFT SUBSTITUTION BRACKET
  0x2E03, 0x2E03, // Pf       RIGHT SUBSTITUTION BRACKET
  0x2E04, 0x2E04, // Pi       LEFT DOTTED SUBSTITUTION BRACKET
  0x2E05, 0x2E05, // Pf       RIGHT DOTTED SUBSTITUTION BRACKET
  0x2E06, 0x2E08, // Po   [3] RAISED INTERPOLATION MARKER..DOTTED TRANSPOSITION MARKER
  0x2E09, 0x2E09, // Pi       LEFT TRANSPOSITION BRACKET
  0x2E0A, 0x2E0A, // Pf       RIGHT TRANSPOSITION BRACKET
  0x2E0B, 0x2E0B, // Po       RAISED SQUARE
  0x2E0C, 0x2E0C, // Pi       LEFT RAISED OMISSION BRACKET
  0x2E0D, 0x2E0D, // Pf       RIGHT RAISED OMISSION BRACKET
  0x2E0E, 0x2E16, // Po   [9] EDITORIAL CORONIS..DOTTED RIGHT-POINTING ANGLE
  0x2E17, 0x2E17, // Pd       DOUBLE OBLIQUE HYPHEN
  0x2E18, 0x2E19, // Po   [2] INVERTED INTERROBANG..PALM BRANCH
  0x2E1A, 0x2E1A, // Pd       HYPHEN WITH DIAERESIS
  0x2E1B, 0x2E1B, // Po       TILDE WITH RING ABOVE
  0x2E1C, 0x2E1C, // Pi       LEFT LOW PARAPHRASE BRACKET
  0x2E1D, 0x2E1D, // Pf       RIGHT LOW PARAPHRASE BRACKET
  0x2E1E, 0x2E1F, // Po   [2] TILDE WITH DOT ABOVE..TILDE WITH DOT BELOW
  0x2E20, 0x2E20, // Pi       LEFT VERTICAL BAR WITH QUILL
  0x2E21, 0x2E21, // Pf       RIGHT VERTICAL BAR WITH QUILL
  0x2E22, 0x2E22, // Ps       TOP LEFT HALF BRACKET
  0x2E23, 0x2E23, // Pe       TOP RIGHT HALF BRACKET
  0x2E24, 0x2E24, // Ps       BOTTOM LEFT HALF BRACKET
  0x2E25, 0x2E25, // Pe       BOTTOM RIGHT HALF BRACKET
  0x2E26, 0x2E26, // Ps       LEFT SIDEWAYS U BRACKET
  0x2E27, 0x2E27, // Pe       RIGHT SIDEWAYS U BRACKET
  0x2E28, 0x2E28, // Ps       LEFT DOUBLE PARENTHESIS
  0x2E29, 0x2E29, // Pe       RIGHT DOUBLE PARENTHESIS
  0x2E2A, 0x2E2E, // Po   [5] TWO DOTS OVER ONE DOT PUNCTUATION..REVERSED QUESTION MARK
  0x2E2F, 0x2E2F, // Lm       VERTICAL TILDE
  0x2E30, 0x2E39, // Po  [10] RING POINT..TOP HALF SECTION SIGN
  0x2E3A, 0x2E3B, // Pd   [2] TWO-EM DASH..THREE-EM DASH
  0x2E3C, 0x2E3F, // Po   [4] STENOGRAPHIC FULL STOP..CAPITULUM
  0x2E40, 0x2E40, // Pd       DOUBLE HYPHEN
  0x2E41, 0x2E41, // Po       REVERSED COMMA
  0x2E42, 0x2E42, // Ps       DOUBLE LOW-REVERSED-9 QUOTATION MARK
  0x2E43, 0x2E4F, // Po  [13] DASH WITH LEFT UPTURN..CORNISH VERSE DIVIDER
  0x2E50, 0x2E51, // So   [2] CROSS PATTY WITH RIGHT CROSSBAR..CROSS PATTY WITH LEFT CROSSBAR
  0x2E52, 0x2E54, // Po   [3] TIRONIAN SIGN CAPITAL ET..MEDIEVAL QUESTION MARK
  0x2E55, 0x2E55, // Ps       LEFT SQUARE BRACKET WITH STROKE
  0x2E56, 0x2E56, // Pe       RIGHT SQUARE BRACKET WITH STROKE
  0x2E57, 0x2E57, // Ps       LEFT SQUARE BRACKET WITH DOUBLE STROKE
  0x2E58, 0x2E58, // Pe       RIGHT SQUARE BRACKET WITH DOUBLE STROKE
  0x2E59, 0x2E59, // Ps       TOP HALF LEFT PARENTHESIS
  0x2E5A, 0x2E5A, // Pe       TOP HALF RIGHT PARENTHESIS
  0x2E5B, 0x2E5B, // Ps       BOTTOM HALF LEFT PARENTHESIS
  0x2E5C, 0x2E5C, // Pe       BOTTOM HALF RIGHT PARENTHESIS
  0x2E5D, 0x2E5D, // Pd       OBLIQUE HYPHEN
  0x2FF0, 0x2FFF, // So  [16] IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT..IDEOGRAPHIC DESCRIPTION CHARACTER ROTATION
  0x3000, 0x3000, // Zs       IDEOGRAPHIC SPACE
  0x3001, 0x3003, // Po   [3] IDEOGRAPHIC COMMA..DITTO MARK
  0x3004, 0x3004, // So       JAPANESE INDUSTRIAL STANDARD SYMBOL
  0x3006, 0x3006, // Lo       IDEOGRAPHIC CLOSING MARK
  0x3008, 0x3008, // Ps       LEFT ANGLE BRACKET
  0x3009, 0x3009, // Pe       RIGHT ANGLE BRACKET
  0x300A, 0x300A, // Ps       LEFT DOUBLE ANGLE BRACKET
  0x300B, 0x300B, // Pe       RIGHT DOUBLE ANGLE BRACKET
  0x300C, 0x300C, // Ps       LEFT CORNER BRACKET
  0x300D, 0x300D, // Pe       RIGHT CORNER BRACKET
  0x300E, 0x300E, // Ps       LEFT WHITE CORNER BRACKET
  0x300F, 0x300F, // Pe       RIGHT WHITE CORNER BRACKET
  0x3010, 0x3010, // Ps       LEFT BLACK LENTICULAR BRACKET
  0x3011, 0x3011, // Pe       RIGHT BLACK LENTICULAR BRACKET
  0x3012, 0x3013, // So   [2] POSTAL MARK..GETA MARK
  0x3014, 0x3014, // Ps       LEFT TORTOISE SHELL BRACKET
  0x3015, 0x3015, // Pe       RIGHT TORTOISE SHELL BRACKET
  0x3016, 0x3016, // Ps       LEFT WHITE LENTICULAR BRACKET
  0x3017, 0x3017, // Pe       RIGHT WHITE LENTICULAR BRACKET
  0x3018, 0x3018, // Ps       LEFT WHITE TORTOISE SHELL BRACKET
  0x3019, 0x3019, // Pe       RIGHT WHITE TORTOISE SHELL BRACKET
  0x301A, 0x301A, // Ps       LEFT WHITE SQUARE BRACKET
  0x301B, 0x301B, // Pe       RIGHT WHITE SQUARE BRACKET
  0x301C, 0x301C, // Pd       WAVE DASH
  0x301D, 0x301D, // Ps       REVERSED DOUBLE PRIME QUOTATION MARK
  0x301E, 0x301F, // Pe   [2] DOUBLE PRIME QUOTATION MARK..LOW DOUBLE PRIME QUOTATION MARK
  0x3020, 0x3020, // So       POSTAL MARK FACE
  0x3030, 0x3030, // Pd       WAVY DASH
  0x3031, 0x3035, // Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
  0x3036, 0x3037, // So   [2] CIRCLED POSTAL MARK..IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
  0x303C, 0x303C, // Lo       MASU MARK
  0x303D, 0x303D, // Po       PART ALTERNATION MARK
  0x303E, 0x303F, // So   [2] IDEOGRAPHIC VARIATION INDICATOR..IDEOGRAPHIC HALF FILL SPACE
  0x309B, 0x309C, // Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
  0x30A0, 0x30A0, // Pd       KATAKANA-HIRAGANA DOUBLE HYPHEN
  0x30FB, 0x30FB, // Po       KATAKANA MIDDLE DOT
  0x30FC, 0x30FC, // Lm       KATAKANA-HIRAGANA PROLONGED SOUND MARK
  0x3190, 0x3191, // So   [2] IDEOGRAPHIC ANNOTATION LINKING MARK..IDEOGRAPHIC ANNOTATION REVERSE MARK
  0x3192, 0x3195, // No   [4] IDEOGRAPHIC ANNOTATION ONE MARK..IDEOGRAPHIC ANNOTATION FOUR MARK
  0x3196, 0x319F, // So  [10] IDEOGRAPHIC ANNOTATION TOP MARK..IDEOGRAPHIC ANNOTATION MAN MARK
  0x31C0, 0x31E5, // So  [38] CJK STROKE T..CJK STROKE SZP
  0x31EF, 0x31EF, // So       IDEOGRAPHIC DESCRIPTION CHARACTER SUBTRACTION
  0x3220, 0x3229, // No  [10] PARENTHESIZED IDEOGRAPH ONE..PARENTHESIZED IDEOGRAPH TEN
  0x322A, 0x3247, // So  [30] PARENTHESIZED IDEOGRAPH MOON..CIRCLED IDEOGRAPH KOTO
  0x3248, 0x324F, // No   [8] CIRCLED NUMBER TEN ON BLACK SQUARE..CIRCLED NUMBER EIGHTY ON BLACK SQUARE
  0x3250, 0x3250, // So       PARTNERSHIP SIGN
  0x3251, 0x325F, // No  [15] CIRCLED NUMBER TWENTY ONE..CIRCLED NUMBER THIRTY FIVE
  0x327F, 0x327F, // So       KOREAN STANDARD SYMBOL
  0x3280, 0x3289, // No  [10] CIRCLED IDEOGRAPH ONE..CIRCLED IDEOGRAPH TEN
  0x328A, 0x32B0, // So  [39] CIRCLED IDEOGRAPH MOON..CIRCLED IDEOGRAPH NIGHT
  0x32B1, 0x32BF, // No  [15] CIRCLED NUMBER THIRTY SIX..CIRCLED NUMBER FIFTY
  0x32C0, 0x32CF, // So  [16] IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY..LIMITED LIABILITY SIGN
  0x32FF, 0x32FF, // So       SQUARE ERA NAME REIWA
  0x3358, 0x33FF, // So [168] IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO..SQUARE GAL
  0x4DC0, 0x4DFF, // So  [64] HEXAGRAM FOR THE CREATIVE HEAVEN..HEXAGRAM FOR BEFORE COMPLETION
  0xA700, 0xA716, // Sk  [23] MODIFIER LETTER CHINESE TONE YIN PING..MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR
  0xA717, 0xA71F, // Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
  0xA720, 0xA721, // Sk   [2] MODIFIER LETTER STRESS AND HIGH TONE..MODIFIER LETTER STRESS AND LOW TONE
  0xA788, 0xA788, // Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
  0xA789, 0xA78A, // Sk   [2] MODIFIER LETTER COLON..MODIFIER LETTER SHORT EQUALS SIGN
  0xA830, 0xA835, // No   [6] NORTH INDIC FRACTION ONE QUARTER..NORTH INDIC FRACTION THREE SIXTEENTHS
  0xA836, 0xA837, // So   [2] NORTH INDIC QUARTER MARK..NORTH INDIC PLACEHOLDER MARK
  0xA838, 0xA838, // Sc       NORTH INDIC RUPEE MARK
  0xA839, 0xA839, // So       NORTH INDIC QUANTITY MARK
  0xA92E, 0xA92E, // Po       KAYAH LI SIGN CWI
  0xA9CF, 0xA9CF, // Lm       JAVANESE PANGRANGKEP
  0xAB5B, 0xAB5B, // Sk       MODIFIER BREVE WITH INVERTED BREVE
  0xAB6A, 0xAB6B, // Sk   [2] MODIFIER LETTER LEFT TACK..MODIFIER LETTER RIGHT TACK
  0xFD3E, 0xFD3E, // Pe       ORNATE LEFT PARENTHESIS
  0xFD3F, 0xFD3F, // Ps       ORNATE RIGHT PARENTHESIS
  0xFE10, 0xFE16, // Po   [7] PRESENTATION FORM FOR VERTICAL COMMA..PRESENTATION FORM FOR VERTICAL QUESTION MARK
  0xFE17, 0xFE17, // Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
  0xFE18, 0xFE18, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
  0xFE19, 0xFE19, // Po       PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
  0xFE30, 0xFE30, // Po       PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
  0xFE31, 0xFE32, // Pd   [2] PRESENTATION FORM FOR VERTICAL EM DASH..PRESENTATION FORM FOR VERTICAL EN DASH
  0xFE33, 0xFE34, // Pc   [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
  0xFE35, 0xFE35, // Ps       PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
  0xFE36, 0xFE36, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
  0xFE37, 0xFE37, // Ps       PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
  0xFE38, 0xFE38, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
  0xFE39, 0xFE39, // Ps       PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
  0xFE3A, 0xFE3A, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
  0xFE3B, 0xFE3B, // Ps       PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
  0xFE3C, 0xFE3C, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
  0xFE3D, 0xFE3D, // Ps       PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
  0xFE3E, 0xFE3E, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
  0xFE3F, 0xFE3F, // Ps       PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
  0xFE40, 0xFE40, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
  0xFE41, 0xFE41, // Ps       PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
  0xFE42, 0xFE42, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
  0xFE43, 0xFE43, // Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
  0xFE44, 0xFE44, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
  0xFE45, 0xFE46, // Po   [2] SESAME DOT..WHITE SESAME DOT
  0xFE47, 0xFE47, // Ps       PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
  0xFE48, 0xFE48, // Pe       PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
  0xFE49, 0xFE4C, // Po   [4] DASHED OVERLINE..DOUBLE WAVY OVERLINE
  0xFE4D, 0xFE4F, // Pc   [3] DASHED LOW LINE..WAVY LOW LINE
  0xFE50, 0xFE52, // Po   [3] SMALL COMMA..SMALL FULL STOP
  0xFE54, 0xFE57, // Po   [4] SMALL SEMICOLON..SMALL EXCLAMATION MARK
  0xFE58, 0xFE58, // Pd       SMALL EM DASH
  0xFE59, 0xFE59, // Ps       SMALL LEFT PARENTHESIS
  0xFE5A, 0xFE5A, // Pe       SMALL RIGHT PARENTHESIS
  0xFE5B, 0xFE5B, // Ps       SMALL LEFT CURLY BRACKET
  0xFE5C, 0xFE5C, // Pe       SMALL RIGHT CURLY BRACKET
  0xFE5D, 0xFE5D, // Ps       SMALL LEFT TORTOISE SHELL BRACKET
  0xFE5E, 0xFE5E, // Pe       SMALL RIGHT TORTOISE SHELL BRACKET
  0xFE5F, 0xFE61, // Po   [3] SMALL NUMBER SIGN..SMALL ASTERISK
  0xFE62, 0xFE62, // Sm       SMALL PLUS SIGN
  0xFE63, 0xFE63, // Pd       SMALL HYPHEN-MINUS
  0xFE64, 0xFE66, // Sm   [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
  0xFE68, 0xFE68, // Po       SMALL REVERSE SOLIDUS
  0xFE69, 0xFE69, // Sc       SMALL DOLLAR SIGN
  0xFE6A, 0xFE6B, // Po   [2] SMALL PERCENT SIGN..SMALL COMMERCIAL AT
  0xFEFF, 0xFEFF, // Cf       ZERO WIDTH NO-BREAK SPACE
  0xFF01, 0xFF03, // Po   [3] FULLWIDTH EXCLAMATION MARK..FULLWIDTH NUMBER SIGN
  0xFF04, 0xFF04, // Sc       FULLWIDTH DOLLAR SIGN
  0xFF05, 0xFF07, // Po   [3] FULLWIDTH PERCENT SIGN..FULLWIDTH APOSTROPHE
  0xFF08, 0xFF08, // Ps       FULLWIDTH LEFT PARENTHESIS
  0xFF09, 0xFF09, // Pe       FULLWIDTH RIGHT PARENTHESIS
  0xFF0A, 0xFF0A, // Po       FULLWIDTH ASTERISK
  0xFF0B, 0xFF0B, // Sm       FULLWIDTH PLUS SIGN
  0xFF0C, 0xFF0C, // Po       FULLWIDTH COMMA
  0xFF0D, 0xFF0D, // Pd       FULLWIDTH HYPHEN-MINUS
  0xFF0E, 0xFF0F, // Po   [2] FULLWIDTH FULL STOP..FULLWIDTH SOLIDUS
  0xFF10, 0xFF19, // Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
  0xFF1A, 0xFF1B, // Po   [2] FULLWIDTH COLON..FULLWIDTH SEMICOLON
  0xFF1C, 0xFF1E, // Sm   [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
  0xFF1F, 0xFF20, // Po   [2] FULLWIDTH QUESTION MARK..FULLWIDTH COMMERCIAL AT
  0xFF3B, 0xFF3B, // Ps       FULLWIDTH LEFT SQUARE BRACKET
  0xFF3C, 0xFF3C, // Po       FULLWIDTH REVERSE SOLIDUS
  0xFF3D, 0xFF3D, // Pe       FULLWIDTH RIGHT SQUARE BRACKET
  0xFF3E, 0xFF3E, // Sk       FULLWIDTH CIRCUMFLEX ACCENT
  0xFF3F, 0xFF3F, // Pc       FULLWIDTH LOW LINE
  0xFF40, 0xFF40, // Sk       FULLWIDTH GRAVE ACCENT
  0xFF5B, 0xFF5B, // Ps       FULLWIDTH LEFT CURLY BRACKET
  0xFF5C, 0xFF5C, // Sm       FULLWIDTH VERTICAL LINE
  0xFF5D, 0xFF5D, // Pe       FULLWIDTH RIGHT CURLY BRACKET
  0xFF5E, 0xFF5E, // Sm       FULLWIDTH TILDE
  0xFF5F, 0xFF5F, // Ps       FULLWIDTH LEFT WHITE PARENTHESIS
  0xFF60, 0xFF60, // Pe       FULLWIDTH RIGHT WHITE PARENTHESIS
  0xFF61, 0xFF61, // Po       HALFWIDTH IDEOGRAPHIC FULL STOP
  0xFF62, 0xFF62, // Ps       HALFWIDTH LEFT CORNER BRACKET
  0xFF63, 0xFF63, // Pe       HALFWIDTH RIGHT CORNER BRACKET
  0xFF64, 0xFF65, // Po   [2] HALFWIDTH IDEOGRAPHIC COMMA..HALFWIDTH KATAKANA MIDDLE DOT
  0xFF70, 0xFF70, // Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
  0xFF9E, 0xFF9F, // Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
  0xFFE0, 0xFFE1, // Sc   [2] FULLWIDTH CENT SIGN..FULLWIDTH POUND SIGN
  0xFFE2, 0xFFE2, // Sm       FULLWIDTH NOT SIGN
  0xFFE3, 0xFFE3, // Sk       FULLWIDTH MACRON
  0xFFE4, 0xFFE4, // So       FULLWIDTH BROKEN BAR
  0xFFE5, 0xFFE6, // Sc   [2] FULLWIDTH YEN SIGN..FULLWIDTH WON SIGN
  0xFFE8, 0xFFE8, // So       HALFWIDTH FORMS LIGHT VERTICAL
  0xFFE9, 0xFFEC, // Sm   [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
  0xFFED, 0xFFEE, // So   [2] HALFWIDTH BLACK SQUARE..HALFWIDTH WHITE CIRCLE
  0xFFF9, 0xFFFB, // Cf   [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
  0xFFFC, 0xFFFD, // So   [2] OBJECT REPLACEMENT CHARACTER..REPLACEMENT CHARACTER
  0x10100, 0x10102, // Po   [3] AEGEAN WORD SEPARATOR LINE..AEGEAN CHECK MARK
  0x10107, 0x10133, // No  [45] AEGEAN NUMBER ONE..AEGEAN NUMBER NINETY THOUSAND
  0x10137, 0x1013F, // So   [9] AEGEAN WEIGHT BASE UNIT..AEGEAN MEASURE THIRD SUBUNIT
  0x10190, 0x1019C, // So  [13] ROMAN SEXTANS SIGN..ASCIA SYMBOL
  0x101D0, 0x101FC, // So  [45] PHAISTOS DISC SIGN PEDESTRIAN..PHAISTOS DISC SIGN WAVY BAND
  0x102E1, 0x102FB, // No  [27] COPTIC EPACT DIGIT ONE..COPTIC EPACT NUMBER NINE HUNDRED
  0x1BCA0, 0x1BCA3, // Cf   [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
  0x1CC00, 0x1CCEF, // So [240] UP-POINTING GO-KART..OUTLINED LATIN CAPITAL LETTER Z
  0x1CCF0, 0x1CCF9, // Nd  [10] OUTLINED DIGIT ZERO..OUTLINED DIGIT NINE
  0x1CCFA, 0x1CCFC, // So   [3] SNAKE SYMBOL..NOSE SYMBOL
  0x1CD00, 0x1CEB3, // So [436] BLOCK OCTANT-3..BLACK RIGHT TRIANGLE CARET
  0x1CEBA, 0x1CED0, // So  [23] FRAGILE SYMBOL..LEUKOTHEA
  0x1CEE0, 0x1CEEF, // So  [16] GEOMANTIC FIGURE POPULUS..GEOMANTIC FIGURE VIA
  0x1CEF0, 0x1CEF0, // Sm       MEDIUM SMALL WHITE CIRCLE WITH HORIZONTAL BAR
  0x1CF50, 0x1CFC3, // So [116] ZNAMENNY NEUME KRYUK..ZNAMENNY NEUME PAUK
  0x1D000, 0x1D0F5, // So [246] BYZANTINE MUSICAL SYMBOL PSILI..BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
  0x1D100, 0x1D126, // So  [39] MUSICAL SYMBOL SINGLE BARLINE..MUSICAL SYMBOL DRUM CLEF-2
  0x1D129, 0x1D164, // So  [60] MUSICAL SYMBOL MULTIPLE MEASURE REST..MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
  0x1D165, 0x1D166, // Mc   [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
  0x1D16A, 0x1D16C, // So   [3] MUSICAL SYMBOL FINGERED TREMOLO-1..MUSICAL SYMBOL FINGERED TREMOLO-3
  0x1D16D, 0x1D172, // Mc   [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
  0x1D173, 0x1D17A, // Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
  0x1D183, 0x1D184, // So   [2] MUSICAL SYMBOL ARPEGGIATO UP..MUSICAL SYMBOL ARPEGGIATO DOWN
  0x1D18C, 0x1D1A9, // So  [30] MUSICAL SYMBOL RINFORZANDO..MUSICAL SYMBOL DEGREE SLASH
  0x1D1AE, 0x1D1EA, // So  [61] MUSICAL SYMBOL PEDAL MARK..MUSICAL SYMBOL KORON
  0x1D2C0, 0x1D2D3, // No  [20] KAKTOVIK NUMERAL ZERO..KAKTOVIK NUMERAL NINETEEN
  0x1D2E0, 0x1D2F3, // No  [20] MAYAN NUMERAL ZERO..MAYAN NUMERAL NINETEEN
  0x1D300, 0x1D356, // So  [87] MONOGRAM FOR EARTH..TETRAGRAM FOR FOSTERING
  0x1D360, 0x1D378, // No  [25] COUNTING ROD UNIT DIGIT ONE..TALLY MARK FIVE
  0x1D400, 0x1D454, // L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
  0x1D456, 0x1D49C, // L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
  0x1D49E, 0x1D49F, // L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
  0x1D4A2, 0x1D4A2, // L&       MATHEMATICAL SCRIPT CAPITAL G
  0x1D4A5, 0x1D4A6, // L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
  0x1D4A9, 0x1D4AC, // L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
  0x1D4AE, 0x1D4B9, // L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
  0x1D4BB, 0x1D4BB, // L&       MATHEMATICAL SCRIPT SMALL F
  0x1D4BD, 0x1D4C3, // L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
  0x1D4C5, 0x1D505, // L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
  0x1D507, 0x1D50A, // L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
  0x1D50D, 0x1D514, // L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
  0x1D516, 0x1D51C, // L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
  0x1D51E, 0x1D539, // L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
  0x1D53B, 0x1D53E, // L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
  0x1D540, 0x1D544, // L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
  0x1D546, 0x1D546, // L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
  0x1D54A, 0x1D550, // L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
  0x1D552, 0x1D6A5, // L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
  0x1D6A8, 0x1D6C0, // L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
  0x1D6C1, 0x1D6C1, // Sm       MATHEMATICAL BOLD NABLA
  0x1D6C2, 0x1D6DA, // L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
  0x1D6DB, 0x1D6DB, // Sm       MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
  0x1D6DC, 0x1D6FA, // L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
  0x1D6FB, 0x1D6FB, // Sm       MATHEMATICAL ITALIC NABLA
  0x1D6FC, 0x1D714, // L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
  0x1D715, 0x1D715, // Sm       MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
  0x1D716, 0x1D734, // L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
  0x1D735, 0x1D735, // Sm       MATHEMATICAL BOLD ITALIC NABLA
  0x1D736, 0x1D74E, // L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
  0x1D74F, 0x1D74F, // Sm       MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
  0x1D750, 0x1D76E, // L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
  0x1D76F, 0x1D76F, // Sm       MATHEMATICAL SANS-SERIF BOLD NABLA
  0x1D770, 0x1D788, // L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
  0x1D789, 0x1D789, // Sm       MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
  0x1D78A, 0x1D7A8, // L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
  0x1D7A9, 0x1D7A9, // Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
  0x1D7AA, 0x1D7C2, // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
  0x1D7C3, 0x1D7C3, // Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
  0x1D7C4, 0x1D7CB, // L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
  0x1D7CE, 0x1D7FF, // Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
  0x1EC71, 0x1ECAB, // No  [59] INDIC SIYAQ NUMBER ONE..INDIC SIYAQ NUMBER PREFIXED NINE
  0x1ECAC, 0x1ECAC, // So       INDIC SIYAQ PLACEHOLDER
  0x1ECAD, 0x1ECAF, // No   [3] INDIC SIYAQ FRACTION ONE QUARTER..INDIC SIYAQ FRACTION THREE QUARTERS
  0x1ECB0, 0x1ECB0, // Sc       INDIC SIYAQ RUPEE MARK
  0x1ECB1, 0x1ECB4, // No   [4] INDIC SIYAQ NUMBER ALTERNATE ONE..INDIC SIYAQ ALTERNATE LAKH MARK
  0x1ED01, 0x1ED2D, // No  [45] OTTOMAN SIYAQ NUMBER ONE..OTTOMAN SIYAQ NUMBER NINETY THOUSAND
  0x1ED2E, 0x1ED2E, // So       OTTOMAN SIYAQ MARRATAN
  0x1ED2F, 0x1ED3D, // No  [15] OTTOMAN SIYAQ ALTERNATE NUMBER TWO..OTTOMAN SIYAQ FRACTION ONE SIXTH
  0x1F000, 0x1F02B, // So  [44] MAHJONG TILE EAST WIND..MAHJONG TILE BACK
  0x1F030, 0x1F093, // So [100] DOMINO TILE HORIZONTAL BACK..DOMINO TILE VERTICAL-06-06
  0x1F0A0, 0x1F0AE, // So  [15] PLAYING CARD BACK..PLAYING CARD KING OF SPADES
  0x1F0B1, 0x1F0BF, // So  [15] PLAYING CARD ACE OF HEARTS..PLAYING CARD RED JOKER
  0x1F0C1, 0x1F0CF, // So  [15] PLAYING CARD ACE OF DIAMONDS..PLAYING CARD BLACK JOKER
  0x1F0D1, 0x1F0F5, // So  [37] PLAYING CARD ACE OF CLUBS..PLAYING CARD TRUMP-21
  0x1F100, 0x1F10C, // No  [13] DIGIT ZERO FULL STOP..DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO
  0x1F10D, 0x1F1AD, // So [161] CIRCLED ZERO WITH SLASH..MASK WORK SYMBOL
  0x1F1E6, 0x1F1FF, // So  [26] REGIONAL INDICATOR SYMBOL LETTER A..REGIONAL INDICATOR SYMBOL LETTER Z
  0x1F201, 0x1F202, // So   [2] SQUARED KATAKANA KOKO..SQUARED KATAKANA SA
  0x1F210, 0x1F23B, // So  [44] SQUARED CJK UNIFIED IDEOGRAPH-624B..SQUARED CJK UNIFIED IDEOGRAPH-914D
  0x1F240, 0x1F248, // So   [9] TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C..TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
  0x1F250, 0x1F251, // So   [2] CIRCLED IDEOGRAPH ADVANTAGE..CIRCLED IDEOGRAPH ACCEPT
  0x1F260, 0x1F265, // So   [6] ROUNDED SYMBOL FOR FU..ROUNDED SYMBOL FOR CAI
  0x1F300, 0x1F3FA, // So [251] CYCLONE..AMPHORA
  0x1F3FB, 0x1F3FF, // Sk   [5] EMOJI MODIFIER FITZPATRICK TYPE-1-2..EMOJI MODIFIER FITZPATRICK TYPE-6
  0x1F400, 0x1F6D8, // So [729] RAT..LANDSLIDE
  0x1F6DC, 0x1F6EC, // So  [17] WIRELESS..AIRPLANE ARRIVING
  0x1F6F0, 0x1F6FC, // So  [13] SATELLITE..ROLLER SKATE
  0x1F700, 0x1F7D9, // So [218] ALCHEMICAL SYMBOL FOR QUINTESSENCE..NINE POINTED WHITE STAR
  0x1F7E0, 0x1F7EB, // So  [12] LARGE ORANGE CIRCLE..LARGE BROWN SQUARE
  0x1F7F0, 0x1F7F0, // So       HEAVY EQUALS SIGN
  0x1F800, 0x1F80B, // So  [12] LEFTWARDS ARROW WITH SMALL TRIANGLE ARROWHEAD..DOWNWARDS ARROW WITH LARGE TRIANGLE ARROWHEAD
  0x1F810, 0x1F847, // So  [56] LEFTWARDS ARROW WITH SMALL EQUILATERAL ARROWHEAD..DOWNWARDS HEAVY ARROW
  0x1F850, 0x1F859, // So  [10] LEFTWARDS SANS-SERIF ARROW..UP DOWN SANS-SERIF ARROW
  0x1F860, 0x1F887, // So  [40] WIDE-HEADED LEFTWARDS LIGHT BARB ARROW..WIDE-HEADED SOUTH WEST VERY HEAVY BARB ARROW
  0x1F890, 0x1F8AD, // So  [30] LEFTWARDS TRIANGLE ARROWHEAD..WHITE ARROW SHAFT WIDTH TWO THIRDS
  0x1F8B0, 0x1F8BB, // So  [12] ARROW POINTING UPWARDS THEN NORTH WEST..SOUTH WEST ARROW FROM BAR
  0x1F8C0, 0x1F8C1, // So   [2] LEFTWARDS ARROW FROM DOWNWARDS ARROW..RIGHTWARDS ARROW FROM DOWNWARDS ARROW
  0x1F8D0, 0x1F8D8, // Sm   [9] LONG RIGHTWARDS ARROW OVER LONG LEFTWARDS ARROW..LONG LEFT RIGHT ARROW WITH DEPENDENT LOBE
  0x1F900, 0x1FA57, // So [344] CIRCLED CROSS FORMEE WITH FOUR DOTS..BLACK CHESS ALFIL
  0x1FA60, 0x1FA6D, // So  [14] XIANGQI RED GENERAL..XIANGQI BLACK SOLDIER
  0x1FA70, 0x1FA7C, // So  [13] BALLET SHOES..CRUTCH
  0x1FA80, 0x1FA8A, // So  [11] YO-YO..TROMBONE
  0x1FA8E, 0x1FAC6, // So  [57] TREASURE CHEST..FINGERPRINT
  0x1FAC8, 0x1FAC8, // So       HAIRY CREATURE
  0x1FACD, 0x1FADC, // So  [16] ORCA..ROOT VEGETABLE
  0x1FADF, 0x1FAEA, // So  [12] SPLATTER..DISTORTED FACE
  0x1FAEF, 0x1FAF8, // So  [10] FIGHT CLOUD..RIGHTWARDS PUSHING HAND
  0x1FB00, 0x1FB92, // So [147] BLOCK SEXTANT-1..UPPER HALF INVERSE MEDIUM SHADE AND LOWER HALF BLOCK
  0x1FB94, 0x1FBEF, // So  [92] LEFT HALF INVERSE MEDIUM SHADE AND RIGHT HALF BLOCK..TOP LEFT JUSTIFIED LOWER RIGHT QUARTER BLACK CIRCLE
  0x1FBF0, 0x1FBF9, // Nd  [10] SEGMENTED DIGIT ZERO..SEGMENTED DIGIT NINE
  0x1FBFA, 0x1FBFA, // So       ALARM BELL SYMBOL
  0xE0001, 0xE0001, // Cf       LANGUAGE TAG
  0xE0020, 0xE007F, // Cf  [96] TAG SPACE..CANCEL TAG
)
internal val hiraganaRanges = intArrayOf(
  0x3041, 0x3096, // Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
  0x309D, 0x309E, // Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
  0x309F, 0x309F, // Lo       HIRAGANA DIGRAPH YORI
  0x1B001, 0x1B11F, // Lo [287] HIRAGANA LETTER ARCHAIC YE..HIRAGANA LETTER ARCHAIC WU
  0x1B132, 0x1B132, // Lo       HIRAGANA LETTER SMALL KO
  0x1B150, 0x1B152, // Lo   [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
  0x1F200, 0x1F200, // So       SQUARE HIRAGANA HOKA
)
internal val katakanaRanges = intArrayOf(
  0x30A1, 0x30FA, // Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
  0x30FD, 0x30FE, // Lm   [2] KATAKANA ITERATION MARK..KATAKANA VOICED ITERATION MARK
  0x30FF, 0x30FF, // Lo       KATAKANA DIGRAPH KOTO
  0x31F0, 0x31FF, // Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
  0x32D0, 0x32FE, // So  [47] CIRCLED KATAKANA A..CIRCLED KATAKANA WO
  0x3300, 0x3357, // So  [88] SQUARE APAATO..SQUARE WATTO
  0xFF66, 0xFF6F, // Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
  0xFF71, 0xFF9D, // Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
  0x1AFF0, 0x1AFF3, // Lm   [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
  0x1AFF5, 0x1AFFB, // Lm   [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
  0x1AFFD, 0x1AFFE, // Lm   [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
  0x1B000, 0x1B000, // Lo       KATAKANA LETTER ARCHAIC E
  0x1B120, 0x1B122, // Lo   [3] KATAKANA LETTER ARCHAIC YI..KATAKANA LETTER ARCHAIC WU
  0x1B155, 0x1B155, // Lo       KATAKANA LETTER SMALL KO
  0x1B164, 0x1B167, // Lo   [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
)
/**
 * Codepoints are derived from https://www.unicode.org/Public/UCD/latest/ucd/PropList.txt
 * PropList-17.0.0.txt
 * Date: 2025-06-30, 06:19:01 GMT
 * © 2025 Unicode®, Inc.
 * Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * For terms of use and license, see https://www.unicode.org/terms_of_use.html
 * 
 * Unicode Character Database
 * For documentation, see https://www.unicode.org/reports/tr44/
 */
internal val ideographicRanges = intArrayOf(
  0x3006, 0x3006, // Lo       IDEOGRAPHIC CLOSING MARK
  0x3007, 0x3007, // Nl       IDEOGRAPHIC NUMBER ZERO
  0x3021, 0x3029, // Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
  0x3038, 0x303A, // Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
  0x3400, 0x4DBF, // Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
  0x4E00, 0x9FFF, // Lo [20992] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFF
  0xF900, 0xFA6D, // Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
  0xFA70, 0xFAD9, // Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
  0x16FE4, 0x16FE4, // Mn       KHITAN SMALL SCRIPT FILLER
  0x16FF2, 0x16FF3, // Lm   [2] CHINESE SMALL SIMPLIFIED ER..CHINESE SMALL TRADITIONAL ER
  0x16FF4, 0x16FF6, // Nl   [3] YANGQIN SIGN SLOW ONE BEAT..YANGQIN SIGN SLOW TWO BEATS
  0x17000, 0x18CD5, // Lo [7382] TANGUT IDEOGRAPH-17000..KHITAN SMALL SCRIPT CHARACTER-18CD5
  0x18CFF, 0x18D1E, // Lo  [32] KHITAN SMALL SCRIPT CHARACTER-18CFF..TANGUT IDEOGRAPH-18D1E
  0x18D80, 0x18DF2, // Lo [115] TANGUT COMPONENT-769..TANGUT COMPONENT-883
  0x1B170, 0x1B2FB, // Lo [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
  0x20000, 0x2A6DF, // Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
  0x2A700, 0x2B81D, // Lo [4382] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B81D
  0x2B820, 0x2CEAD, // Lo [5774] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEAD
  0x2CEB0, 0x2EBE0, // Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
  0x2EBF0, 0x2EE5D, // Lo [622] CJK UNIFIED IDEOGRAPH-2EBF0..CJK UNIFIED IDEOGRAPH-2EE5D
  0x2F800, 0x2FA1D, // Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
  0x30000, 0x3134A, // Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
  0x31350, 0x33479, // Lo [8490] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-33479
)
internal val whitespaceRanges = intArrayOf(
  0x9, 0xD, // Cc   [5] <control-0009>..<control-000D>
  0x20, 0x20, // Zs       SPACE
  0x85, 0x85, // Cc       <control-0085>
  0xA0, 0xA0, // Zs       NO-BREAK SPACE
  0x1680, 0x1680, // Zs       OGHAM SPACE MARK
  0x2000, 0x200A, // Zs  [11] EN QUAD..HAIR SPACE
  0x2028, 0x2028, // Zl       LINE SEPARATOR
  0x2029, 0x2029, // Zp       PARAGRAPH SEPARATOR
  0x202F, 0x202F, // Zs       NARROW NO-BREAK SPACE
  0x205F, 0x205F, // Zs       MEDIUM MATHEMATICAL SPACE
  0x3000, 0x3000, // Zs       IDEOGRAPHIC SPACE
)
