/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.text;

import fleet.util.text.NaturalComparatorKt;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J8\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J0\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0016H\u0002\u00a8\u0006\u001e"}, d2={"Lfleet/util/text/NaturalComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "s1", "s2", "naturalCompare", "length1", "length2", "ignoreCase", "", "likeFileNames", "compareCharRange", "offset1", "offset2", "end1", "compareChars", "ch1", "", "ch2", "skipDigits", "s", "start", "end", "skipChar", "c", "fleet.util.core"})
public final class NaturalComparator
implements Comparator<String> {
    @NotNull
    public static final NaturalComparator INSTANCE = new NaturalComparator();

    private NaturalComparator() {
    }

    @Override
    public int compare(@Nullable String s1, @Nullable String s2) {
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return this.naturalCompare(s1, s2, s1.length(), s2.length(), true, false);
    }

    private final int naturalCompare(String s1, String s2, int length1, int length2, boolean ignoreCase, boolean likeFileNames) {
        int j;
        int i = 0;
        for (j = 0; i < length1 && j < length2; ++i, ++j) {
            int diff;
            char ch1 = s1.charAt(i);
            char ch2 = s2.charAt(j);
            if ((Character.isDigit(ch1) || ch1 == ' ') && (Character.isDigit(ch2) || ch2 == ' ')) {
                int end2;
                int start1 = this.skipChar(s1, this.skipChar(s1, i, length1, ' '), length1, '0');
                int start2 = this.skipChar(s2, this.skipChar(s2, j, length2, ' '), length2, '0');
                int end1 = this.skipDigits(s1, start1, length1);
                int lengthDiff = end1 - start1 - ((end2 = this.skipDigits(s2, start2, length2)) - start2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                int numberDiff = this.compareCharRange(s1, s2, start1, start2, end1);
                if (numberDiff != 0) {
                    return numberDiff;
                }
                int fullLengthDiff = end1 - i - (end2 - j);
                if (fullLengthDiff != 0) {
                    return fullLengthDiff;
                }
                int leadingDiff = this.compareCharRange(s1, s2, i, j, start1);
                if (leadingDiff != 0) {
                    return leadingDiff;
                }
                i = end1 - 1;
                j = end2 - 1;
                continue;
            }
            if (likeFileNames) {
                if (ch1 == ch2) continue;
                int n = ch1 == '-' && ch2 != '_' ? this.compareChars('_', ch2, ignoreCase) : (diff = ch2 == '-' && ch1 != '_' ? this.compareChars(ch1, '_', ignoreCase) : this.compareChars(ch1, ch2, ignoreCase));
                if (diff == 0) continue;
                return diff;
            }
            diff = this.compareChars(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return i < length1 ? 1 : (j < length2 ? -1 : (length1 != length2 ? length1 - length2 : (ignoreCase ? this.naturalCompare(s1, s2, length1, length2, false, likeFileNames) : 0)));
    }

    private final int compareCharRange(String s1, String s2, int offset1, int offset2, int end1) {
        int i = offset1;
        int j = offset2;
        while (i < end1) {
            int diff = s1.charAt(i) - s2.charAt(j);
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    private final int compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ch1 == ' ' && Intrinsics.compare((int)ch2, (int)32) > 0 && Intrinsics.compare((int)ch2, (int)48) < 0) {
            return 1;
        }
        if (ch2 == ' ' && Intrinsics.compare((int)ch1, (int)32) > 0 && Intrinsics.compare((int)ch1, (int)48) < 0) {
            return -1;
        }
        return ignoreCase ? NaturalComparatorKt.access$compareToIgnoreCase(ch1, ch2) : Intrinsics.compare((int)ch1, (int)ch2);
    }

    private final int skipDigits(String s, int start, int end) {
        int start2;
        for (start2 = start; start2 < end && Character.isDigit(s.charAt(start2)); ++start2) {
        }
        return start2;
    }

    private final int skipChar(String s, int start, int end, char c) {
        int start2;
        for (start2 = start; start2 < end && s.charAt(start2) == c; ++start2) {
        }
        return start2;
    }
}

