/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.settings;

import com.intellij.DynamicBundle;
import com.intellij.grazie.spellcheck.settings.CustomDictionariesPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public final class SpellCheckerSettingsPane
implements Disposable {
    private JPanel root;
    private JPanel linkContainer;
    private JPanel myPanelForAcceptedWords;
    private JPanel myPanelForCustomDictionaries;
    private JBCheckBox myUseSingleDictionary;
    private ComboBox<String> myDictionariesComboBox;
    private final CustomDictionariesPanel myDictionariesPanel;
    private final OptionalChooserComponent<String> myProvidedDictionariesChooserComponent;
    private final Set<String> runtimeDictionaries;
    private final List<Pair<String, Boolean>> providedDictionaries;
    private final WordsPanel wordsPanel;
    private final SpellCheckerManager manager;
    private final SpellCheckerSettings settings;

    public SpellCheckerSettingsPane(final SpellCheckerSettings settings, Project project) {
        this.$$$setupUI$$$();
        this.runtimeDictionaries = new HashSet<String>();
        this.providedDictionaries = new ArrayList<Pair<String, Boolean>>();
        this.settings = settings;
        this.manager = SpellCheckerManager.getInstance((Project)project);
        HyperlinkLabel link2 = new HyperlinkLabel(SpellCheckerBundle.message((String)"link.to.inspection.settings", (Object[])new Object[0]));
        link2.addHyperlinkListener(e -> {
            ErrorsConfigurable errorsConfigurable;
            Settings allSettings;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext())) != null && (errorsConfigurable = (ErrorsConfigurable)allSettings.find(ErrorsConfigurable.class)) != null) {
                allSettings.select((Configurable)errorsConfigurable).doWhenDone(() -> errorsConfigurable.selectInspectionTool("SpellCheckingInspection"));
            }
        });
        this.myUseSingleDictionary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellCheckerSettingsPane.this.myDictionariesComboBox.setEnabled(SpellCheckerSettingsPane.this.myUseSingleDictionary.isSelected());
            }
        });
        DictionaryLayersProvider.getAllLayers((Project)project).forEach(it -> this.myDictionariesComboBox.addItem((Object)it.getName()));
        this.linkContainer.setLayout(new BorderLayout());
        this.linkContainer.add((Component)link2);
        this.fillProvidedDictionaries();
        this.myDictionariesPanel = new CustomDictionariesPanel(settings, project, this.manager);
        this.myPanelForCustomDictionaries.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SpellCheckerBundle.message((String)"add.dictionary.description", (Object[])new Object[]{SpellCheckerSettingsPane.getSupportedDictionariesDescription()}), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myPanelForAcceptedWords.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SpellCheckerBundle.message((String)"settings.tab.accepted.words", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myPanelForCustomDictionaries.setLayout(new BorderLayout());
        this.myPanelForCustomDictionaries.add((Component)this.myDictionariesPanel, "Center");
        this.myProvidedDictionariesChooserComponent = new OptionalChooserComponent<String>(this.providedDictionaries){

            public JCheckBox createCheckBox(String path, boolean checked) {
                return new JCheckBox(FileUtil.toSystemDependentName((String)path), checked);
            }

            public void apply() {
                super.apply();
                HashSet<String> runtimeDisabledDictionaries = new HashSet<String>();
                for (Pair<String, Boolean> pair : SpellCheckerSettingsPane.this.providedDictionaries) {
                    if (((Boolean)pair.second).booleanValue() || !SpellCheckerSettingsPane.this.runtimeDictionaries.contains(pair.first)) continue;
                    runtimeDisabledDictionaries.add((String)pair.first);
                }
                settings.setRuntimeDisabledDictionariesNames(runtimeDisabledDictionaries);
            }

            public void reset() {
                super.reset();
                SpellCheckerSettingsPane.this.fillProvidedDictionaries();
            }
        };
        this.myProvidedDictionariesChooserComponent.getEmptyText().setText(SpellCheckerBundle.message((String)"no.dictionaries", (Object[])new Object[0]));
        this.wordsPanel = new WordsPanel(this.manager);
        this.myPanelForAcceptedWords.setLayout(new BorderLayout());
        this.myPanelForAcceptedWords.add((Component)((Object)this.wordsPanel), "Center");
    }

    private static String getSupportedDictionariesDescription() {
        String supported = CustomDictionaryProvider.EP_NAME.getExtensionList().stream().map(ext -> ext.getDictionaryType()).collect(Collectors.joining(", "));
        return supported.isEmpty() ? supported : ", " + supported;
    }

    public JComponent getPane() {
        return this.root;
    }

    public boolean isModified() {
        return this.wordsPanel.isModified() || this.myProvidedDictionariesChooserComponent.isModified() || this.myDictionariesPanel.isModified() || this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected() || this.settings.isUseSingleDictionaryToSave() && !StringUtil.equals((CharSequence)this.settings.getDictionaryToSave(), (CharSequence)((String)this.myDictionariesComboBox.getSelectedItem()));
    }

    public void apply() throws ConfigurationException {
        if (this.wordsPanel.isModified()) {
            this.manager.updateUserDictionary(this.wordsPanel.getWords());
        }
        if (this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected()) {
            this.settings.setUseSingleDictionaryToSave(this.myUseSingleDictionary.isSelected());
        }
        if (this.myUseSingleDictionary.isSelected() && this.settings.getDictionaryToSave() != this.myDictionariesComboBox.getSelectedItem()) {
            this.settings.setDictionaryToSave((String)this.myDictionariesComboBox.getSelectedItem());
        }
        SpellCheckerManager.Companion.restartInspections((Object)this);
        if (!this.myProvidedDictionariesChooserComponent.isModified() && !this.myDictionariesPanel.isModified()) {
            return;
        }
        this.myProvidedDictionariesChooserComponent.apply();
        this.myDictionariesPanel.apply();
    }

    public void reset() {
        this.myUseSingleDictionary.setSelected(this.settings.isUseSingleDictionaryToSave());
        this.myDictionariesComboBox.setSelectedItem((Object)this.settings.getDictionaryToSave());
        this.myDictionariesComboBox.setEnabled(this.myUseSingleDictionary.isSelected());
        this.myDictionariesPanel.reset();
        this.myProvidedDictionariesChooserComponent.reset();
    }

    private void fillProvidedDictionaries() {
        this.providedDictionaries.clear();
        for (String dictionary : SpellCheckerManager.getBundledDictionaries()) {
            this.providedDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)true));
        }
        this.runtimeDictionaries.clear();
        for (String dictionary : ContainerUtil.map((Collection)SpellCheckerManager.getRuntimeDictionaries(), it -> it.getName())) {
            this.runtimeDictionaries.add(dictionary);
            this.providedDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary) ? 1 : 0)));
        }
    }

    public void dispose() {
        if (this.wordsPanel != null) {
            Disposer.dispose((Disposable)this.wordsPanel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.root = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        this.myPanelForCustomDictionaries = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseSingleDictionary = jBCheckBox = new JBCheckBox();
        jBCheckBox.setName("");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpellCheckerBundle", SpellCheckerSettingsPane.class).getString("use.single.dictionary"));
        jPanel8.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myDictionariesComboBox = comboBox = new ComboBox();
        jPanel8.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 2, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPanelForAcceptedWords = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.linkContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 38), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class WordsPanel
    extends AddDeleteListPanel<String>
    implements Disposable {
        private final SpellCheckerManager manager;

        private WordsPanel(SpellCheckerManager manager) {
            super(null, ContainerUtil.sorted((Collection)manager.getUserDictionaryWords()));
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message((String)"no.words", (Object[])new Object[0]));
        }

        protected void customizeDecorator(ToolbarDecorator decorator) {
            decorator.setRemoveAction(button -> {
                SpellcheckerActionStatistics.removeWordFromAcceptedWords((Project)this.manager.getProject());
                ListUtil.removeSelectedItems((JList)this.myList);
            });
        }

        protected String findItemToAdd() {
            SpellcheckerActionStatistics.addWordToAcceptedWords((Project)this.manager.getProject());
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message((String)"enter.simple.word", (Object[])new Object[0]), (String)SpellCheckerBundle.message((String)"add.new.word", (Object[])new Object[0]), null);
            if (word == null) {
                return null;
            }
            if (!this.manager.hasProblem(word = word.trim())) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message((String)"entered.word.0.is.correct.you.no.need.to.add.this.in.list", (Object[])new Object[]{word}), (String)SpellCheckerBundle.message((String)"add.new.word", (Object[])new Object[0]));
                return null;
            }
            return word;
        }

        public void dispose() {
            this.myListModel.removeAllElements();
        }

        @NotNull
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            ArrayList<String> arrayList = words;
            if (arrayList == null) {
                WordsPanel.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set words = this.manager.getUserDictionaryWords();
            if (newWords.size() != words.size()) {
                return true;
            }
            HashSet<String> newHashWords = new HashSet<String>(newWords);
            return !newHashWords.equals(words);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/spellcheck/settings/SpellCheckerSettingsPane$WordsPanel", "getWords"));
        }
    }
}

