/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractFileProcessor {
    private final Project myProject;
    private final Module myModule;
    private PsiDirectory directory = null;
    private PsiFile file = null;
    private PsiFile[] files = null;
    private boolean subdirs = false;
    private final String message;
    private final String title;
    private static final Logger logger = Logger.getInstance((String)AbstractFileProcessor.class.getName());

    protected abstract Runnable preprocessFile(PsiFile var1, boolean var2) throws IncorrectOperationException;

    protected AbstractFileProcessor(Project project, String title, String message) {
        this.myProject = project;
        this.myModule = null;
        this.directory = null;
        this.subdirs = true;
        this.title = title;
        this.message = message;
    }

    protected AbstractFileProcessor(Project project, Module module, String title, String message) {
        this.myProject = project;
        this.myModule = module;
        this.directory = null;
        this.subdirs = true;
        this.title = title;
        this.message = message;
    }

    protected AbstractFileProcessor(Project project, PsiDirectory dir, boolean subdirs, String title, String message) {
        this.myProject = project;
        this.myModule = null;
        this.directory = dir;
        this.subdirs = subdirs;
        this.message = message;
        this.title = title;
    }

    protected AbstractFileProcessor(Project project, PsiFile file, String title, String message) {
        this.myProject = project;
        this.myModule = null;
        this.file = file;
        this.message = message;
        this.title = title;
    }

    protected AbstractFileProcessor(Project project, PsiFile[] files, String title, String message, Runnable runnable) {
        this.myProject = project;
        this.myModule = null;
        this.files = files;
        this.message = message;
        this.title = title;
    }

    public void run() {
        if (this.directory != null) {
            this.process(this.directory, this.subdirs);
        } else if (this.files != null) {
            this.process(this.files);
        } else if (this.file != null) {
            this.process(this.file);
        } else if (this.myModule != null) {
            this.process(this.myModule);
        } else if (this.myProject != null) {
            this.process(this.myProject);
        }
    }

    private void process(final PsiFile file) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        final Runnable[] resultRunnable = new Runnable[1];
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    resultRunnable[0] = AbstractFileProcessor.this.preprocessFile(file, true);
                }
                catch (IncorrectOperationException incorrectoperationexception) {
                    logger.error((Throwable)incorrectoperationexception);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        });
    }

    private Runnable prepareFiles(List<PsiFile> files) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String msg = null;
        double fraction = 0.0;
        if (indicator != null) {
            msg = indicator.getText();
            fraction = indicator.getFraction();
            indicator.setText(this.message);
        }
        final Runnable[] runnables = new Runnable[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            PsiFile pfile = files.get(i);
            if (pfile == null) {
                logger.debug("Unexpected null file at " + i);
                continue;
            }
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return null;
                }
                indicator.setFraction((double)i / (double)files.size());
            }
            if (pfile.isWritable()) {
                try {
                    runnables[i] = this.preprocessFile(pfile, true);
                }
                catch (IncorrectOperationException incorrectoperationexception) {
                    logger.error((Throwable)incorrectoperationexception);
                }
            }
            files.set(i, null);
        }
        if (indicator != null) {
            indicator.setText(msg);
            indicator.setFraction(fraction);
        }
        return new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                String msg = null;
                double fraction = 0.0;
                if (indicator != null) {
                    msg = indicator.getText();
                    fraction = indicator.getFraction();
                    indicator.setText(AbstractFileProcessor.this.message);
                }
                for (int j = 0; j < runnables.length; ++j) {
                    Runnable runnable;
                    if (indicator != null) {
                        if (indicator.isCanceled()) {
                            return;
                        }
                        indicator.setFraction((double)j / (double)runnables.length);
                    }
                    if ((runnable = runnables[j]) != null) {
                        runnable.run();
                    }
                    runnables[j] = null;
                }
                if (indicator != null) {
                    indicator.setText(msg);
                    indicator.setFraction(fraction);
                }
            }
        };
    }

    private void process(final PsiFile[] files) {
        final Runnable[] resultRunnable = new Runnable[1];
        this.execute(new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractFileProcessor.this.prepareFiles(new ArrayList<PsiFile>(Arrays.asList(files)));
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        });
    }

    private void process(final PsiDirectory dir, final boolean subdirs) {
        final ArrayList<PsiFile> pfiles = new ArrayList<PsiFile>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                AbstractFileProcessor.findFiles(pfiles, dir, subdirs);
            }
        }, this.title, true, this.myProject);
        this.handleFiles(pfiles);
    }

    private void process(final Project project) {
        final ArrayList<PsiFile> pfiles = new ArrayList<PsiFile>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                AbstractFileProcessor.findFiles(project, (List<PsiFile>)pfiles);
            }
        }, this.title, true, project);
        this.handleFiles(pfiles);
    }

    private void process(final Module module) {
        final ArrayList<PsiFile> pfiles = new ArrayList<PsiFile>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                AbstractFileProcessor.findFiles(module, (List<PsiFile>)pfiles);
            }
        }, this.title, true, this.myProject);
        this.handleFiles(pfiles);
    }

    private static void findFiles(Project project, List<PsiFile> files) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            AbstractFileProcessor.findFiles(module, files);
        }
    }

    protected static void findFiles(final Module module, final List<PsiFile> files) {
        VirtualFile[] roots;
        ModuleFileIndex idx = ModuleRootManager.getInstance((Module)module).getFileIndex();
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            idx.iterateContentUnderDirectory(root, new ContentIterator(){

                public boolean processFile(VirtualFile dir) {
                    PsiDirectory psiDir;
                    if (dir.isDirectory() && (psiDir = PsiManager.getInstance((Project)module.getProject()).findDirectory(dir)) != null) {
                        AbstractFileProcessor.findFiles(files, psiDir, false);
                    }
                    return true;
                }
            });
        }
    }

    private void handleFiles(final List<PsiFile> files) {
        ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>();
        for (PsiFile psiFile : files) {
            vFiles.add(psiFile.getVirtualFile());
        }
        if (!ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(VfsUtil.toVirtualFileArray(vFiles)).hasReadonlyFiles() && !files.isEmpty()) {
            final Runnable[] resultRunnable = new Runnable[1];
            this.execute(new Runnable(){

                @Override
                public void run() {
                    resultRunnable[0] = AbstractFileProcessor.this.prepareFiles(files);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    if (resultRunnable[0] != null) {
                        resultRunnable[0].run();
                    }
                }
            });
        }
    }

    private static void findFiles(List<PsiFile> files, PsiDirectory directory, boolean subdirs) {
        PsiFile[] locals;
        Project project = directory.getProject();
        for (PsiFile local : locals = directory.getFiles()) {
            CopyrightProfile opts = CopyrightManager.getInstance(project).getCopyrightOptions(local);
            if (opts == null || !FileTypeUtil.isSupportedFile(local)) continue;
            files.add(local);
        }
        if (subdirs) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = directory.getSubdirectories()) {
                AbstractFileProcessor.findFiles(files, dir, subdirs);
            }
        }
    }

    private void execute(final Runnable readAction, final Runnable writeAction) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                readAction.run();
            }
        }, this.title, true, this.myProject);
        new WriteCommandAction(this.myProject, this.title, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                writeAction.run();
            }
        }.execute();
    }
}

