/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.IDEARemoteTestRunnerClient;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.SuiteGenerator;
import org.testng.xml.XmlSuite;

public class SearchingForTestsTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)("#" + SearchingForTestsTask.class.getName()));
    private final Map<PsiClass, Collection<PsiMethod>> myClasses;
    private Socket mySocket;
    private final TestData myData;
    private final Project myProject;
    private final ServerSocket myServerSocket;
    private final TestNGConfiguration myConfig;
    private final File myTempFile;
    private final IDEARemoteTestRunnerClient myClient;

    public SearchingForTestsTask(ServerSocket serverSocket, TestNGConfiguration config, File tempFile, IDEARemoteTestRunnerClient client) {
        super(config.getProject(), "Searching For Tests ...", true);
        this.myClient = client;
        this.myData = config.getPersistantData();
        this.myProject = config.getProject();
        this.myServerSocket = serverSocket;
        this.myConfig = config;
        this.myTempFile = tempFile;
        this.myClasses = new HashMap<PsiClass, Collection<PsiMethod>>();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/theoryinpractice/testng/configuration/SearchingForTestsTask", "run"));
        }
        try {
            this.mySocket = this.myServerSocket.accept();
            try {
                final CantRunException[] ex = new CantRunException[1];
                DumbService.getInstance((Project)this.myProject).repeatUntilPassesInSmartMode(new Runnable(){

                    @Override
                    public void run() {
                        SearchingForTestsTask.this.myClasses.clear();
                        try {
                            SearchingForTestsTask.this.fillTestObjects(SearchingForTestsTask.this.myClasses);
                        }
                        catch (CantRunException e) {
                            ex[0] = e;
                        }
                    }
                });
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
            catch (CantRunException e) {
                this.logCantRunException(e);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public void onSuccess() {
        this.writeTempFile();
        this.finish();
        if (!Registry.is((String)"testng_sm_runner")) {
            this.myClient.startListening(this.myConfig);
        }
    }

    public void onCancel() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        FilterOutputStream os = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            os = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)os).writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                this.myServerSocket.close();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    private void writeTempFile() {
        if (this.myClasses.size() > 0) {
            this.composeTestSuiteFromClasses();
        } else if (TestType.SUITE.getType().equals(this.myData.TEST_OBJECT)) {
            try {
                this.composeTestSuiteFromXml();
            }
            catch (CantRunException e) {
                this.logCantRunException(e);
            }
        }
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])"end".getBytes(), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void logCantRunException(CantRunException e) {
        try {
            String message = "CantRunException" + e.getMessage() + "\n";
            FileUtil.writeToFile((File)this.myTempFile, (byte[])message.getBytes());
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    private void composeTestSuiteFromClasses() {
        String groupName;
        HashMap map = new HashMap();
        boolean findTestMethodsForClass = this.shouldSearchForTestMethods();
        for (final Map.Entry<PsiClass, Collection<PsiMethod>> entry : this.myClasses.entrySet()) {
            Collection<PsiMethod> depMethods = entry.getValue();
            HashSet<String> methods = new HashSet<String>(depMethods.size());
            for (PsiMethod method : depMethods) {
                methods.add(method.getName());
            }
            if (findTestMethodsForClass && depMethods.isEmpty()) {
                for (PsiMethod method : entry.getKey().getMethods()) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) continue;
                    methods.add(method.getName());
                }
            }
            map.put(ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return ClassUtil.getJVMClassName((PsiClass)((PsiClass)entry.getKey()));
                }
            }), methods);
        }
        HashSet<String> groupNames = null;
        if (TestType.GROUP.getType().equals(this.myData.TEST_OBJECT) && (groupName = this.myData.getGroupName()) != null && groupName.length() > 0) {
            groupNames = new HashSet<String>(1);
            groupNames.add(groupName);
        }
        Map<String, String> testParams = this.buildTestParameters();
        int logLevel = 1;
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(this.myConfig.getPersistantData().VM_PARAMETERS.getBytes()));
            String verbose = properties.getProperty("-Dtestng.verbose");
            if (verbose != null) {
                logLevel = Integer.parseInt(verbose);
            }
        }
        catch (Exception e) {
            logLevel = 1;
        }
        LaunchSuite suite = SuiteGenerator.createSuite((String)this.myProject.getName(), null, map, groupNames, testParams, (String)"jdk", (int)logLevel);
        File xmlFile = suite.save(new File(PathManager.getSystemPath()));
        String path = xmlFile.getAbsolutePath() + "\n";
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean shouldSearchForTestMethods() {
        boolean dependantMethods = false;
        for (Collection<PsiMethod> methods : this.myClasses.values()) {
            if (methods.isEmpty()) continue;
            dependantMethods = true;
            break;
        }
        return dependantMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void composeTestSuiteFromXml() throws CantRunException {
        Map<String, String> buildTestParams = this.buildTestParameters();
        try {
            if (buildTestParams.isEmpty()) {
                String path = new File(this.myData.getSuiteName()).getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
                return;
            }
            Parser parser = new Parser(this.myData.getSuiteName());
            parser.setLoadClasses(false);
            Collection suites = parser.parse();
            for (XmlSuite suite : suites) {
                Map params = suite.getParameters();
                params.putAll(buildTestParams);
                String fileId = FileUtil.sanitizeFileName((String)(this.myProject.getName() + '_' + suite.getName() + '_' + Integer.toHexString(suite.getName().hashCode()) + ".xml"));
                File suiteFile = new File(PathManager.getSystemPath(), fileId);
                FileWriter fileWriter = new FileWriter(suiteFile);
                try {
                    fileWriter.write(suite.toXml());
                }
                finally {
                    fileWriter.close();
                }
                String path = suiteFile.getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
            }
        }
        catch (Exception e) {
            throw new CantRunException("Unable to parse suite: " + e.getMessage());
        }
    }

    protected void fillTestObjects(Map<PsiClass, Collection<PsiMethod>> classes) throws CantRunException {
        final TestData data = this.myConfig.getPersistantData();
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            final String packageName = data.getPackageName();
            PsiPackage psiPackage = (PsiPackage)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiPackage>(){

                @Nullable
                public PsiPackage compute() {
                    return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
                }
            });
            if (psiPackage == null) {
                throw CantRunException.packageNotFound((String)packageName);
            }
            TestSearchScope scope = this.myConfig.getPersistantData().getScope();
            TestClassFilter projectFilter = new TestClassFilter(scope.getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope(), this.myProject, true, true);
            TestClassFilter filter = projectFilter.intersectionWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            this.calculateDependencies(null, classes, TestNGUtil.getAllTestClasses(filter, false));
            if (classes.size() == 0) {
                throw new CantRunException("No tests found in the package \"" + packageName + '\"');
            }
        } else if (data.TEST_OBJECT.equals(TestType.CLASS.getType())) {
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                @Nullable
                public PsiClass compute() {
                    return ClassUtil.findPsiClass((PsiManager)psiManager, (String)data.getMainClassName().replace('/', '.'), null, (boolean)true, (GlobalSearchScope)SearchingForTestsTask.this.getSearchScope());
                }
            });
            if (psiClass == null) {
                throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
            }
            if (null == ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return psiClass.getQualifiedName();
                }
            })) {
                throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
            }
            this.calculateDependencies(null, classes, psiClass);
        } else if (data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                @Nullable
                public PsiClass compute() {
                    return ClassUtil.findPsiClass((PsiManager)psiManager, (String)data.getMainClassName().replace('/', '.'), null, (boolean)true, (GlobalSearchScope)SearchingForTestsTask.this.getSearchScope());
                }
            });
            if (psiClass == null) {
                throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
            }
            if (null == ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return psiClass.getQualifiedName();
                }
            })) {
                throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
            }
            this.collectTestMethods(classes, psiClass, data.getMethodName());
        } else if (data.TEST_OBJECT.equals(TestType.GROUP.getType())) {
            PsiClass[] testClasses = TestNGUtil.getAllTestClasses(new TestClassFilter(data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope(), this.myProject, true, true), false);
            if (testClasses != null) {
                for (PsiClass c : testClasses) {
                    classes.put(c, new HashSet());
                }
            }
        } else if (data.TEST_OBJECT.equals(TestType.PATTERN.getType())) {
            for (String pattern : data.getPatterns()) {
                PsiClass psiClass;
                String className;
                String methodName;
                if (pattern.contains(",")) {
                    methodName = StringUtil.getShortName((String)pattern, (char)',');
                    className = StringUtil.getPackageName((String)pattern, (char)',');
                } else {
                    className = pattern;
                    methodName = null;
                }
                if ((psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                    @Nullable
                    public PsiClass compute() {
                        return ClassUtil.findPsiClass((PsiManager)psiManager, (String)className.replace('/', '.'), null, (boolean)true, (GlobalSearchScope)SearchingForTestsTask.this.getSearchScope());
                    }
                })) == null) continue;
                Boolean hasTest = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
                    }
                });
                if (hasTest.booleanValue()) {
                    if (StringUtil.isEmpty((String)methodName)) {
                        this.calculateDependencies(null, classes, psiClass);
                        continue;
                    }
                    this.collectTestMethods(classes, psiClass, methodName);
                    continue;
                }
                throw new CantRunException("No tests found in class " + className);
            }
            if (classes.size() != data.getPatterns().size()) {
                TestSearchScope scope = this.myConfig.getPersistantData().getScope();
                final ArrayList<Pattern> compilePatterns = new ArrayList<Pattern>();
                for (String p : data.getPatterns()) {
                    Pattern compilePattern;
                    try {
                        compilePattern = Pattern.compile(p);
                    }
                    catch (PatternSyntaxException e) {
                        continue;
                    }
                    if (compilePattern == null) continue;
                    compilePatterns.add(compilePattern);
                }
                TestClassFilter projectFilter = new TestClassFilter(scope.getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope(), this.myProject, true, true){

                    @Override
                    public boolean isAccepted(PsiClass psiClass) {
                        if (super.isAccepted(psiClass)) {
                            String qualifiedName = psiClass.getQualifiedName();
                            LOG.assertTrue(qualifiedName != null);
                            for (Pattern pattern : compilePatterns) {
                                if (!pattern.matcher(qualifiedName).matches()) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                this.calculateDependencies(null, classes, TestNGUtil.getAllTestClasses(projectFilter, false));
                if (classes.size() == 0) {
                    throw new CantRunException("No tests found in for patterns \"" + StringUtil.join(data.getPatterns(), (String)" || ") + '\"');
                }
            }
        }
    }

    private void collectTestMethods(Map<PsiClass, Collection<PsiMethod>> classes, final PsiClass psiClass, final String methodName) {
        Object[] methods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return psiClass.findMethodsByName(methodName, true);
            }
        });
        this.calculateDependencies((PsiMethod[])methods, classes, psiClass);
        Collection<PsiMethod> psiMethods = classes.get(psiClass);
        if (psiMethods == null) {
            psiMethods = new LinkedHashSet<PsiMethod>();
            classes.put(psiClass, psiMethods);
        }
        ContainerUtil.addAll(psiMethods, (Object[])methods);
    }

    private Map<String, String> buildTestParameters() {
        HashMap<String, String> testParams = new HashMap<String, String>();
        testParams.putAll(SearchingForTestsTask.convertPropertiesFileToMap(this.myData.PROPERTIES_FILE));
        testParams.putAll(this.myData.TEST_PROPERTIES);
        return testParams;
    }

    private static Map<String, String> convertPropertiesFileToMap(String properties_file) {
        File propertiesFile;
        HashMap<String, String> params = new HashMap<String, String>();
        if (properties_file != null && (propertiesFile = new File(properties_file)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    params.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return params;
    }

    private void calculateDependencies(PsiMethod[] methods, Map<PsiClass, Collection<PsiMethod>> results, PsiClass ... classes) {
        this.calculateDependencies(methods, results, new LinkedHashSet<PsiMember>(), classes);
    }

    private void calculateDependencies(PsiMethod[] methods, final Map<PsiClass, Collection<PsiMethod>> results, final Set<PsiMember> alreadyMarkedToBeChecked, final PsiClass ... classes) {
        block7: {
            if (classes == null || classes.length <= 0) break block7;
            final HashSet<String> groupDependencies = new HashSet<String>();
            TestNGUtil.collectAnnotationValues(groupDependencies, "dependsOnGroups", methods, classes);
            final LinkedHashSet<PsiMember> membersToCheckNow = new LinkedHashSet<PsiMember>();
            if (!groupDependencies.isEmpty()) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Project project = classes[0].getProject();
                        PsiClass testAnnotation = JavaPsiFacade.getInstance((Project)project).findClass(TestNGUtil.TEST_ANNOTATION_FQN, GlobalSearchScope.allScope((Project)project));
                        LOG.assertTrue(testAnnotation != null);
                        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)SearchingForTestsTask.this.getSearchScope())) {
                            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{TestNGUtil.TEST_ANNOTATION_FQN});
                            if (!TestNGUtil.isAnnotatedWithParameter(annotation, "groups", groupDependencies) || !SearchingForTestsTask.appendMember(psiMember, alreadyMarkedToBeChecked, results)) continue;
                            membersToCheckNow.add(psiMember);
                        }
                    }
                });
            }
            SearchingForTestsTask.collectDependsOnMethods(results, alreadyMarkedToBeChecked, membersToCheckNow, methods, classes);
            if (methods == null) {
                for (PsiClass c : classes) {
                    results.put(c, new LinkedHashSet());
                }
            } else {
                for (PsiMember psiMember : membersToCheckNow) {
                    PsiClass psiClass;
                    PsiMethod[] meths = null;
                    if (psiMember instanceof PsiMethod) {
                        psiClass = psiMember.getContainingClass();
                        meths = new PsiMethod[]{(PsiMethod)psiMember};
                    } else {
                        psiClass = (PsiClass)psiMember;
                    }
                    this.calculateDependencies(meths, results, alreadyMarkedToBeChecked, psiClass);
                }
            }
        }
    }

    private static void collectDependsOnMethods(final Map<PsiClass, Collection<PsiMethod>> results, final Set<PsiMember> alreadyMarkedToBeChecked, final Set<PsiMember> membersToCheckNow, PsiMethod[] methods, PsiClass ... classes) {
        PsiClass[] psiClasses;
        if (methods != null && methods.length > 0) {
            HashSet<PsiClass> containingClasses = new HashSet<PsiClass>();
            for (PsiMethod method : methods) {
                containingClasses.add(method.getContainingClass());
            }
            psiClasses = containingClasses.toArray(new PsiClass[containingClasses.size()]);
        } else {
            psiClasses = classes;
        }
        for (final PsiClass containingClass : psiClasses) {
            final HashSet<String> testMethodDependencies = new HashSet<String>();
            TestNGUtil.collectAnnotationValues(testMethodDependencies, "dependsOnMethods", methods, containingClass);
            if (testMethodDependencies.isEmpty()) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    Project project = containingClass.getProject();
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    for (String dependency : testMethodDependencies) {
                        String className = StringUtil.getPackageName((String)dependency);
                        String methodName = StringUtil.getShortName((String)dependency);
                        if (StringUtil.isEmpty((String)className)) {
                            SearchingForTestsTask.checkClassMethods(methodName, containingClass, alreadyMarkedToBeChecked, membersToCheckNow, results);
                            continue;
                        }
                        PsiClass aClass = psiFacade.findClass(className, containingClass.getResolveScope());
                        if (aClass == null) continue;
                        SearchingForTestsTask.checkClassMethods(methodName, aClass, alreadyMarkedToBeChecked, membersToCheckNow, results);
                    }
                }
            });
        }
    }

    private static void checkClassMethods(String methodName, PsiClass containingClass, Set<PsiMember> alreadyMarkedToBeChecked, Set<PsiMember> membersToCheckNow, Map<PsiClass, Collection<PsiMethod>> results) {
        PsiMethod[] psiMethods;
        for (PsiMethod method : psiMethods = containingClass.findMethodsByName(methodName, true)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TestNGUtil.TEST_ANNOTATION_FQN, (boolean)false) || !SearchingForTestsTask.appendMember((PsiMember)method, alreadyMarkedToBeChecked, results)) continue;
            membersToCheckNow.add((PsiMember)method);
        }
    }

    private static boolean appendMember(PsiMember psiMember, Set<PsiMember> underConsideration, Map<PsiClass, Collection<PsiMethod>> results) {
        boolean result = false;
        PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        Collection<PsiMethod> psiMethods = results.get(psiClass);
        if (psiMethods == null) {
            psiMethods = new LinkedHashSet<PsiMethod>();
            results.put(psiClass, psiMethods);
            if (psiMember instanceof PsiClass) {
                result = underConsideration.add(psiMember);
            }
        }
        if (psiMember instanceof PsiMethod) {
            boolean add = psiMethods.add((PsiMethod)psiMember);
            if (add) {
                return underConsideration.add(psiMember);
            }
            return false;
        }
        return result;
    }

    @NotNull
    private GlobalSearchScope getSearchScope() {
        TestData data = this.myConfig.getPersistantData();
        Module module = ((JavaRunConfigurationModule)this.myConfig.getConfigurationModule()).getModule();
        GlobalSearchScope globalSearchScope = data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? this.myConfig.getPersistantData().getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig).getGlobalSearchScope() : (module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)this.myConfig.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/SearchingForTestsTask", "getSearchScope"));
        }
        return globalSearchScope;
    }
}

