/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatementUpDownMover {
    public static final ExtensionPointName<StatementUpDownMover> STATEMENT_UP_DOWN_MOVER_EP = ExtensionPointName.create((String)"com.intellij.statementUpDownMover");

    public abstract boolean checkAvailable(@NotNull Editor var1, @NotNull PsiFile var2, @NotNull MoveInfo var3, boolean var4);

    public void beforeMove(@NotNull Editor editor, @NotNull MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "beforeMove"));
        }
    }

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "afterMove"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "afterMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "afterMove"));
        }
    }

    public static int getLineStartSafeOffset(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getLineStartSafeOffset"));
        }
        if (line == document.getLineCount()) {
            return document.getTextLength();
        }
        return document.getLineStartOffset(line);
    }

    @NotNull
    protected static LineRange getLineRangeFromSelection(@NotNull Editor editor) {
        LineRange range;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getLineRangeFromSelection"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int startLine = editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).line;
            LogicalPosition endPos = editor.offsetToLogicalPosition(selectionModel.getSelectionEnd());
            int endLine = endPos.column == 0 ? endPos.line : endPos.line + 1;
            range = new LineRange(startLine, endLine);
        } else {
            int startLine = editor.getCaretModel().getLogicalPosition().line;
            int endLine = startLine + 1;
            range = new LineRange(startLine, endLine);
        }
        LineRange lineRange = range;
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getLineRangeFromSelection"));
        }
        return lineRange;
    }

    @Nullable
    protected static Pair<PsiElement, PsiElement> getElementRange(@NotNull Editor editor, @NotNull PsiFile file, @NotNull LineRange range) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getElementRange"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getElementRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "getElementRange"));
        }
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement startingElement = StatementUpDownMover.firstNonWhiteElement(startOffset, file, true);
        if (startingElement == null) {
            return null;
        }
        int endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)) - 1;
        PsiElement endingElement = StatementUpDownMover.firstNonWhiteElement(endOffset, file, false);
        if (endingElement == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor(startingElement, endingElement, false) || startingElement.getTextRange().getEndOffset() <= endingElement.getTextRange().getStartOffset()) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        if (PsiTreeUtil.isAncestor(endingElement, startingElement, false)) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        return null;
    }

    @Nullable
    protected static PsiElement firstNonWhiteElement(int offset, @NotNull PsiFile file, boolean lookRight) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover", "firstNonWhiteElement"));
        }
        ASTNode leafElement = file.getNode().findLeafElementAt(offset);
        return leafElement == null ? null : StatementUpDownMover.firstNonWhiteElement(leafElement.getPsi(), lookRight);
    }

    @Nullable
    protected static PsiElement firstNonWhiteElement(PsiElement element, boolean lookRight) {
        if (element instanceof PsiWhiteSpace) {
            element = lookRight ? element.getNextSibling() : element.getPrevSibling();
        }
        return element;
    }

    public static class MoveInfo {
        @NotNull
        public LineRange toMove;
        public LineRange toMove2;
        public RangeMarker range1;
        public RangeMarker range2;
        public boolean indentSource;
        public boolean indentTarget = true;

        public final boolean prohibitMove() {
            this.toMove2 = null;
            return true;
        }
    }
}

