/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEnvironmentVariableUtil {
    private static final Logger LOG = Logger.getInstance(PathEnvironmentVariableUtil.class);
    private static final String PATH_ENV_VAR_NAME = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, false);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, false, filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, boolean logDetails) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, logDetails, null);
    }

    @Nullable
    private static File findInPath(@NotNull String fileBaseName, boolean logDetails, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, true, logDetails, filter);
        return exeFiles.size() > 0 ? exeFiles.get(0) : null;
    }

    private static File findInOriginalPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInOriginalPath"));
        }
        String originalPath = SystemInfo.isMac ? System.getenv(PATH_ENV_VAR_NAME) : EnvironmentUtil.getValue((String)PATH_ENV_VAR_NAME);
        List<File> exeFiles = PathEnvironmentVariableUtil.doFindExeFilesInPath(originalPath, fileBaseName, true, false, null);
        return exeFiles.size() > 0 ? exeFiles.get(0) : null;
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, false, false, filter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    private static List<File> findExeFilesInPath(@NotNull String fileBaseName, boolean stopAfterFirstMatch, boolean logDetails, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        String systemPath = EnvironmentUtil.getValue((String)PATH_ENV_VAR_NAME);
        List<File> list = PathEnvironmentVariableUtil.doFindExeFilesInPath(systemPath, fileBaseName, stopAfterFirstMatch, logDetails, filter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    private static List<File> doFindExeFilesInPath(@Nullable String pathEnvVarValue, @NotNull String fileBaseName, boolean stopAfterFirstMatch, boolean logDetails, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "doFindExeFilesInPath"));
        }
        if (logDetails) {
            LOG.info("Finding files in PATH (base name=" + fileBaseName + ", PATH=" + StringUtil.notNullize((String)pathEnvVarValue) + ").");
        }
        if (pathEnvVarValue == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "doFindExeFilesInPath"));
            }
            return list;
        }
        SmartList result = new SmartList();
        List paths = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        for (String path : paths) {
            File exeFile;
            File dir = new File(path);
            if (logDetails) {
                File file = new File(dir, fileBaseName);
                LOG.info("path:" + path + ", path.isAbsolute:" + dir.isAbsolute() + ", path.isDirectory:" + dir.isDirectory() + ", file.isFile:" + file.isFile() + ", file.canExecute:" + file.canExecute());
            }
            if (!dir.isAbsolute() || !dir.isDirectory() || !(exeFile = new File(dir, fileBaseName)).isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
            result.add(exeFile);
            if (!stopAfterFirstMatch) continue;
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "doFindExeFilesInPath"));
            }
            return smartList;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "doFindExeFilesInPath"));
        }
        return smartList;
    }

    @NotNull
    public static String findAbsolutePathOnMac(@NotNull String exePath) {
        File resolvedExeFile;
        File originalResolvedExeFile;
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAbsolutePathOnMac"));
        }
        if (SystemInfo.isMac && !exePath.contains(File.separator) && (originalResolvedExeFile = PathEnvironmentVariableUtil.findInOriginalPath(exePath)) == null && (resolvedExeFile = PathEnvironmentVariableUtil.findInPath(exePath)) != null) {
            exePath = resolvedExeFile.getAbsolutePath();
        }
        String string = exePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAbsolutePathOnMac"));
        }
        return string;
    }
}

