/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.facet.frameworks.SettingsConnectionService");
    protected static final String SERVICE_URL_ATTR_NAME = "url";
    private static final String myAgentID = "IntelliJ IDEA";
    private Map<String, String> myAttributesMap;
    private final String mySettingsUrl;
    @Nullable
    private final String myDefaultServiceUrl;

    @NotNull
    protected String[] getAttributeNames() {
        String[] stringArray = new String[]{SERVICE_URL_ATTR_NAME};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/SettingsConnectionService", "getAttributeNames"));
        }
        return stringArray;
    }

    protected SettingsConnectionService(@NotNull String settingsUrl, @Nullable String defaultServiceUrl) {
        if (settingsUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsUrl", "com/intellij/facet/frameworks/SettingsConnectionService", "<init>"));
        }
        this.mySettingsUrl = settingsUrl;
        this.myDefaultServiceUrl = defaultServiceUrl;
    }

    public String getSettingsUrl() {
        return this.mySettingsUrl;
    }

    @Nullable
    public String getDefaultServiceUrl() {
        return this.myDefaultServiceUrl;
    }

    @Nullable
    private Map<String, String> readSettings(String ... attributes) {
        LinkedHashMap settings = ContainerUtil.newLinkedHashMap();
        try {
            String url = this.getSettingsUrl();
            String text = FileUtil.loadTextAndClose((InputStream)SettingsConnectionService.getStream(new URL(url)));
            if (text.startsWith("<html>") || text.startsWith("<!DOCTYPE html>")) {
                LOG.info("HTML text obtained from " + url + ": " + StringUtil.first((String)text, (int)300, (boolean)true));
                return settings;
            }
            try {
                Document document = JDOMUtil.loadDocument((CharSequence)text);
                Element root = document.getRootElement();
                for (String s : attributes) {
                    String attributeValue = root.getAttributeValue(s);
                    if (!StringUtil.isNotEmpty((String)attributeValue)) continue;
                    settings.put(s, attributeValue);
                }
            }
            catch (JDOMException e) {
                LOG.error("", (Throwable)e, new String[]{text});
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return settings;
    }

    private static InputStream getStream(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.setRequestProperty("User-agent", myAgentID);
        }
        return connection.getInputStream();
    }

    @Nullable
    public String getServiceUrl() {
        String serviceUrl = this.getSettingValue(SERVICE_URL_ATTR_NAME);
        return serviceUrl == null ? this.getDefaultServiceUrl() : serviceUrl;
    }

    @Nullable
    protected String getSettingValue(@NotNull String attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/facet/frameworks/SettingsConnectionService", "getSettingValue"));
        }
        if (this.myAttributesMap == null) {
            this.myAttributesMap = this.readSettings(this.getAttributeNames());
        }
        return this.myAttributesMap != null ? this.myAttributesMap.get(attributeValue) : null;
    }
}

