/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String myOriginalReason;
    @NotNull
    private final String[] myQuickFixes;

    public ExternalSystemException() {
        this(null, null, new String[0]);
    }

    public ExternalSystemException(@Nullable String message) {
        this(message, null, new String[0]);
    }

    public ExternalSystemException(@Nullable Throwable cause) {
        this("", cause, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalSystemException(@Nullable String message, @Nullable Throwable cause, String ... quickFixes) {
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/openapi/externalSystem/model/ExternalSystemException", "<init>"));
        }
        super(ExternalSystemException.extractMessage(message, cause));
        this.myQuickFixes = quickFixes;
        if (cause == null) {
            this.myOriginalReason = "";
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            cause.printStackTrace(printWriter);
        }
        finally {
            printWriter.close();
        }
        this.myOriginalReason = stringWriter.toString();
    }

    @NotNull
    public String getOriginalReason() {
        String string = this.myOriginalReason;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/ExternalSystemException", "getOriginalReason"));
        }
        return string;
    }

    @NotNull
    public String[] getQuickFixes() {
        if (this.myQuickFixes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/ExternalSystemException", "getQuickFixes"));
        }
        return this.myQuickFixes;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    @Nullable
    private static String extractMessage(@Nullable String message, @Nullable Throwable cause) {
        StringBuilder buffer = new StringBuilder();
        if (message != null) {
            buffer.append(message);
        }
        boolean first = true;
        for (Throwable t = cause; t != null; t = t.getCause()) {
            String m = t.getLocalizedMessage();
            if (m == null) continue;
            if (first) {
                first = false;
            } else if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(m);
        }
        return buffer.toString();
    }
}

