/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ColorPanel
extends JComponent {
    private static final Dimension SIZE = new Dimension(25, 15);
    private boolean isFiringEvent = false;
    private boolean isEditable = true;
    private final List<ActionListener> myListeners = new CopyOnWriteArrayList<ActionListener>();
    @Nullable
    private Color myColor = null;

    public ColorPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ColorPanel.this.isEnabled() || !ColorPanel.this.isEditable) {
                    return;
                }
                Color color = ColorChooser.chooseColor(ColorPanel.this, UIBundle.message((String)"color.panel.select.color.dialog.description", (Object[])new Object[0]), ColorPanel.this.myColor);
                if (color != null) {
                    ColorPanel.this.setSelectedColor(color);
                    ColorPanel.this.fireActionEvent();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            if (this.myColor != null && this.isEnabled()) {
                g2d.setColor(this.myColor);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setColor(ColorUtil.darker((Color)this.myColor, (int)2));
                g2d.draw(new Rectangle2D.Double(0.5, 0.5, this.getWidth() - 1, this.getHeight() - 1));
            }
            g2d.setColor(UIUtil.getBorderColor());
            g2d.draw(new Rectangle2D.Double(1.5, 1.5, this.getWidth() - 3, this.getHeight() - 3));
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    @Override
    public String getToolTipText() {
        if (this.myColor == null || !this.isEnabled()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder("0x").append(ColorUtil.toHex((Color)this.myColor).toUpperCase());
        if (this.isEnabled() && this.isEditable) {
            buffer.append(" (Click to customize)");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent() {
        if (!this.isEditable) {
            return;
        }
        if (!this.isFiringEvent) {
            try {
                this.isFiringEvent = true;
                ActionEvent event = new ActionEvent(this, 1001, "colorPanelChanged");
                for (ActionListener listener : this.myListeners) {
                    listener.actionPerformed(event);
                }
            }
            finally {
                this.isFiringEvent = false;
            }
        }
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.myListeners.remove(actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.myListeners.add(actionlistener);
    }

    @Nullable
    public Color getSelectedColor() {
        return this.myColor;
    }

    public void setSelectedColor(@Nullable Color color) {
        this.myColor = color;
        this.repaint();
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

