/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.CommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public abstract class BaseTerminalModule
extends LineCommandAdapter
implements CommandRuntimeModule,
InteractiveCommandListener {
    private static final Logger LOG = Logger.getInstance(BaseTerminalModule.class);
    @NotNull
    protected final CommandRuntime myRuntime;
    @NotNull
    protected final CommandExecutor myExecutor;
    protected boolean mySkipOneLine;

    protected BaseTerminalModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "org/jetbrains/idea/svn/commandLine/BaseTerminalModule", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/BaseTerminalModule", "<init>"));
        }
        this.myRuntime = runtime;
        this.myExecutor = executor;
    }

    @Override
    public void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/BaseTerminalModule", "onStart"));
        }
    }

    @Override
    public boolean handlePrompt(String line, Key outputType) {
        boolean result = this.doHandlePrompt(line, outputType);
        if (!result && this.mySkipOneLine) {
            LOG.debug("Skipped " + outputType + " line: " + line);
            this.mySkipOneLine = false;
            result = true;
        }
        return result;
    }

    protected abstract boolean doHandlePrompt(String var1, Key var2);

    protected boolean sendData(@NotNull String data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/commandLine/BaseTerminalModule", "sendData"));
        }
        try {
            this.mySkipOneLine = true;
            this.myExecutor.write(data + LineSeparator.CRLF.getSeparatorString());
            return true;
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            return false;
        }
    }

    protected void cancelAuthentication() {
        this.myExecutor.destroyProcess("Authentication canceled for repository: " + this.myExecutor.getCommand().getRepositoryUrl());
    }
}

