/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdConfigurationPath;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.sdk.wizard.SdkComponentInstallPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.SingleStepPath;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdEditWizard
extends DynamicWizard {
    @Nullable
    private final AvdInfo myAvdInfo;
    private final boolean myForceCreate;

    public AvdEditWizard(@Nullable Project project, @Nullable Module module, @Nullable AvdInfo avdInfo, boolean forceCreate) {
        super(project, module, "AvdEditWizard");
        this.myAvdInfo = avdInfo;
        this.myForceCreate = forceCreate;
        this.setTitle("Virtual Device Configuration");
    }

    @Override
    public void init() {
        if (this.myAvdInfo != null) {
            this.fillExistingInfo(this.myAvdInfo);
        } else {
            this.initDefaultInfo();
        }
        this.addPath(new AvdConfigurationPath(this.getDisposable()));
        this.addPath(new SdkComponentInstallPath(this.getDisposable()));
        this.addPath(new SingleStepPath(new ConfigureAvdOptionsStep(this.getDisposable())));
        super.init();
    }

    private void initDefaultInfo() {
        ScopedStateStore state = this.getState();
        state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdWizardConstants.DEFAULT_SCALE);
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, "full");
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, "none");
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, "none");
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdWizardConstants.DEFAULT_INTERNAL_STORAGE);
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
    }

    private void fillExistingInfo(@NotNull AvdInfo avdInfo) {
        File skinFile;
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/avdmanager/AvdEditWizard", "fillExistingInfo"));
        }
        ScopedStateStore state = this.getState();
        List<Device> devices = DeviceManagerConnection.getDevices();
        Device selectedDevice = null;
        String manufacturer = avdInfo.getDeviceManufacturer();
        String deviceId = (String)avdInfo.getProperties().get("hw.device.name");
        for (Device device : devices) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        state.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, selectedDevice);
        IAndroidTarget target = avdInfo.getTarget();
        if (target != null) {
            ISystemImage selectedImage = target.getSystemImage(avdInfo.getTag(), avdInfo.getAbiType());
            AvdWizardConstants.SystemImageDescription systemImageDescription = new AvdWizardConstants.SystemImageDescription(target, selectedImage);
            state.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImageDescription);
        }
        Map properties = avdInfo.getProperties();
        state.put(AvdWizardConstants.RAM_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.RAM_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.VM_HEAP_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.VM_HEAP_STORAGE_KEY.name)));
        state.put(AvdWizardConstants.INTERNAL_STORAGE_KEY, AvdEditWizard.getStorageFromIni((String)properties.get(AvdWizardConstants.INTERNAL_STORAGE_KEY.name)));
        String sdCardLocation = null;
        if (properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name) != null) {
            sdCardLocation = (String)properties.get(AvdWizardConstants.EXISTING_SD_LOCATION.name);
        } else if (properties.get(AvdWizardConstants.SD_CARD_STORAGE_KEY.name) != null) {
            sdCardLocation = FileUtil.join((String[])new String[]{avdInfo.getDataFolderPath(), "sdcard.img"});
        }
        state.put(AvdWizardConstants.EXISTING_SD_LOCATION, sdCardLocation);
        if (sdCardLocation != null) {
            state.put(AvdWizardConstants.USE_EXISTING_SD_CARD, true);
        }
        state.put(AvdWizardConstants.SCALE_SELECTION_KEY, AvdScaleFactor.findByValue((String)properties.get(AvdWizardConstants.SCALE_SELECTION_KEY.name)));
        state.put(AvdWizardConstants.USE_HOST_GPU_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_HOST_GPU_KEY.name)));
        state.put(AvdWizardConstants.USE_SNAPSHOT_KEY, AvdEditWizard.fromIniString((String)properties.get(AvdWizardConstants.USE_SNAPSHOT_KEY.name)));
        state.put(AvdWizardConstants.FRONT_CAMERA_KEY, properties.get(AvdWizardConstants.FRONT_CAMERA_KEY.name));
        state.put(AvdWizardConstants.BACK_CAMERA_KEY, properties.get(AvdWizardConstants.BACK_CAMERA_KEY.name));
        state.put(AvdWizardConstants.NETWORK_LATENCY_KEY, properties.get(AvdWizardConstants.NETWORK_LATENCY_KEY.name));
        state.put(AvdWizardConstants.NETWORK_SPEED_KEY, properties.get(AvdWizardConstants.NETWORK_SPEED_KEY.name));
        String skinPath = (String)properties.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY.name);
        if (skinPath != null && (skinFile = new File(skinPath)).isDirectory()) {
            state.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile);
        }
        state.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, true);
    }

    @Nullable
    private static Storage getStorageFromIni(String iniString) {
        if (iniString == null) {
            return null;
        }
        String numString = iniString.substring(0, iniString.length() - 1);
        char unitChar = iniString.charAt(iniString.length() - 1);
        Storage.Unit selectedUnit = Storage.Unit.B;
        for (Storage.Unit u : Storage.Unit.values()) {
            if (u.toString().charAt(0) != unitChar) continue;
            selectedUnit = u;
            break;
        }
        try {
            long numLong = Long.parseLong(numString);
            return new Storage(numLong, selectedUnit);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void performFinishingActions() {
        int newApiLevel;
        int oldApiLevel;
        IAndroidTarget target;
        ScopedStateStore state = this.getState();
        Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        assert (device != null);
        AvdWizardConstants.SystemImageDescription systemImageDescription = state.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        assert (systemImageDescription != null);
        ScreenOrientation orientation = state.get(AvdWizardConstants.DEFAULT_ORIENTATION_KEY);
        assert (orientation != null);
        Map hardwareProperties = DeviceManager.getHardwareProperties((Device)device);
        Map userEditedProperties = state.flatten();
        String sdCard = null;
        Boolean useExistingSdCard = state.get(AvdWizardConstants.USE_EXISTING_SD_CARD);
        if (useExistingSdCard != null && useExistingSdCard.booleanValue()) {
            userEditedProperties.remove(AvdWizardConstants.SD_CARD_STORAGE_KEY.name);
            sdCard = state.get(AvdWizardConstants.EXISTING_SD_LOCATION);
            assert (sdCard != null);
        } else {
            userEditedProperties.remove(AvdWizardConstants.EXISTING_SD_LOCATION.name);
            Storage storage = state.get(AvdWizardConstants.SD_CARD_STORAGE_KEY);
            if (storage != null) {
                sdCard = AvdEditWizard.toIniString(storage);
            }
        }
        userEditedProperties = Maps.filterEntries(userEditedProperties, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return !input.getKey().startsWith("AvdManager.WizardOnly.") && input.getValue() != null;
            }
        });
        hardwareProperties.putAll(Maps.transformEntries((Map)userEditedProperties, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Object, String>(){

            public String transformEntry(String key, Object value) {
                if (value instanceof Storage) {
                    return AvdEditWizard.toIniString((Storage)value);
                }
                if (value instanceof Boolean) {
                    return AvdEditWizard.toIniString((Boolean)value);
                }
                if (value instanceof AvdScaleFactor) {
                    return AvdEditWizard.toIniString((AvdScaleFactor)((Object)value));
                }
                if (value instanceof File) {
                    return AvdEditWizard.toIniString((File)value);
                }
                if (value instanceof Double) {
                    return AvdEditWizard.toIniString((Double)value);
                }
                return value.toString();
            }
        }));
        File skinFile = state.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        hardwareProperties.put("skin.dynamic", AvdEditWizard.toIniString(false));
        hardwareProperties.put("hw.keyboard", AvdEditWizard.toIniString(false));
        boolean isCircular = DeviceDefinitionPreview.isCircular(device);
        String avdName = AvdEditWizard.calculateAvdName(this.myAvdInfo, device, this.myForceCreate);
        if (this.myAvdInfo != null && !this.myForceCreate && (target = this.myAvdInfo.getTarget()) != null && (oldApiLevel = target.getVersion().getApiLevel()) > (newApiLevel = systemImageDescription.target.getVersion().getApiLevel())) {
            String message = String.format(Locale.getDefault(), "You are about to downgrade %1$s from API level %2$d to API level %3$d. This requires a wipe of the userdata partition of the AVD. Do you wish to continue with the data wipe?", avdName, oldApiLevel, newApiLevel);
            int result = JOptionPane.showConfirmDialog(null, message, "Confirm Data Wipe", 0);
            if (result == 0) {
                AvdManagerConnection.wipeUserData(this.myAvdInfo);
            } else {
                return;
            }
        }
        AvdManagerConnection.createOrUpdateAvd(this.myAvdInfo, avdName, device, systemImageDescription, orientation, isCircular, sdCard, skinFile, hardwareProperties, false);
    }

    @NotNull
    private static String toIniString(@NotNull Double value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = String.format(Locale.US, "%f", value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull File value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull AvdScaleFactor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = value.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String calculateAvdName(@Nullable AvdInfo avdInfo, @NotNull Device device, boolean forceCreate) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        if (avdInfo != null && !forceCreate) {
            String string = avdInfo.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
            }
            return string;
        }
        String deviceName = device.getDisplayName().replace(' ', '_');
        String manufacturer = device.getManufacturer().replace(' ', '_');
        String candidateBase = String.format("AVD_for_%1$s_by_%2$s", deviceName, manufacturer);
        String candidate = candidateBase = candidateBase.replaceAll("[^0-9a-zA-Z_-]+", " ").trim().replaceAll("[ _]+", "_");
        int i = 1;
        while (AvdManagerConnection.avdExists(candidate)) {
            candidate = String.format("%1$s_%2$d", candidateBase, i);
        }
        String string = candidate;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "calculateAvdName"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull Storage storage) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        Storage.Unit unit = storage.getAppropriateUnits();
        String string = String.format("%1$d%2$c", storage.getSizeAsUnit(unit), Character.valueOf(unit.toString().charAt(0)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    @NotNull
    private static String toIniString(@NotNull Boolean b) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        String string = b != false ? "yes" : "no";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdEditWizard", "toIniString"));
        }
        return string;
    }

    private static boolean fromIniString(@Nullable String s) {
        return "yes".equals(s);
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create/Edit an Android Virtual Device";
    }
}

