/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.utils.SparseArray;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.FrameworkResourceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolverCache {
    private static final Logger LOG = Logger.getInstance(ResourceResolverCache.class);
    private final ConfigurationManager myManager;
    private final Map<String, ResourceResolver> myResolverMap;
    private final Map<String, Map<ResourceType, Map<String, ResourceValue>>> myAppResourceMap;
    private final Map<String, Map<ResourceType, Map<String, ResourceValue>>> myFrameworkResourceMap;
    private long myCachedGeneration;
    private SparseArray<FrameworkResources> myFrameworkResources = new SparseArray();

    public ResourceResolverCache(ConfigurationManager manager) {
        this.myManager = manager;
        this.myResolverMap = Maps.newHashMap();
        this.myAppResourceMap = Maps.newHashMap();
        this.myFrameworkResourceMap = Maps.newHashMap();
    }

    public static ResourceResolverCache create(ConfigurationManager manager) {
        return new ResourceResolverCache(manager);
    }

    @NotNull
    public ResourceResolver getResourceResolver(@Nullable IAndroidTarget target, @NotNull String themeStyle, final @NotNull FolderConfiguration fullConfiguration) {
        if (themeStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeStyle", "com/android/tools/idea/configurations/ResourceResolverCache", "getResourceResolver"));
        }
        if (fullConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullConfiguration", "com/android/tools/idea/configurations/ResourceResolverCache", "getResourceResolver"));
        }
        final AppResourceRepository resources = AppResourceRepository.getAppResources(this.myManager.getModule(), true);
        assert (resources != null);
        if (this.myCachedGeneration != ((LocalResourceRepository)resources).getModificationCount()) {
            this.myResolverMap.clear();
            this.myAppResourceMap.clear();
        }
        String configurationKey = fullConfiguration.getUniqueKey();
        String resolverKey = themeStyle + configurationKey;
        ResourceResolver resolver = this.myResolverMap.get(resolverKey);
        if (resolver == null) {
            Map<ResourceType, Map<String, ResourceValue>> frameworkResources;
            if (target == null) {
                target = this.myManager.getTarget();
            }
            if (target == null) {
                frameworkResources = Collections.emptyMap();
            } else {
                ResourceRepository frameworkRes = this.getFrameworkResources(fullConfiguration, target);
                if (frameworkRes == null) {
                    frameworkResources = Collections.emptyMap();
                } else {
                    frameworkResources = this.myFrameworkResourceMap.get(configurationKey);
                    if (frameworkResources == null) {
                        IAndroidTarget realTarget;
                        frameworkResources = frameworkRes.getConfiguredResources(fullConfiguration);
                        if (target instanceof CompatibilityRenderTarget && target.getVersion().getApiLevel() == 8 && (realTarget = ((CompatibilityRenderTarget)target).getRealTarget()) != null) {
                            ResourceResolverCache.replaceDrawableBitmaps(frameworkResources, target, realTarget);
                        }
                        this.myFrameworkResourceMap.put(configurationKey, frameworkResources);
                    }
                }
            }
            Map configuredAppRes = this.myAppResourceMap.get(configurationKey);
            if (configuredAppRes == null) {
                Application application = ApplicationManager.getApplication();
                configuredAppRes = (Map)application.runReadAction((Computable)new Computable<Map<ResourceType, Map<String, ResourceValue>>>(){

                    public Map<ResourceType, Map<String, ResourceValue>> compute() {
                        return resources.getConfiguredResources(fullConfiguration);
                    }
                });
                this.myAppResourceMap.put(configurationKey, configuredAppRes);
            }
            assert (themeStyle.startsWith("@style/") || themeStyle.startsWith("@android:style/")) : themeStyle;
            boolean isProjectTheme = ResourceHelper.isProjectStyle(themeStyle);
            String themeName = ResourceHelper.styleToTheme(themeStyle);
            resolver = ResourceResolver.create((Map)configuredAppRes, (Map)frameworkResources, (String)themeName, (boolean)isProjectTheme);
            if (target instanceof CompatibilityRenderTarget) {
                int apiLevel = target.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver.setDeviceDefaults("Theme.Material.Light", "Theme.Material");
                } else if (apiLevel >= 14) {
                    resolver.setDeviceDefaults("Theme.Holo.Light", "Theme.Holo");
                } else {
                    resolver.setDeviceDefaults("Theme.Light", "Theme");
                }
            }
            this.myResolverMap.put(resolverKey, resolver);
            this.myCachedGeneration = ((LocalResourceRepository)resources).getModificationCount();
        }
        ResourceResolver resourceResolver = resolver;
        if (resourceResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ResourceResolverCache", "getResourceResolver"));
        }
        return resourceResolver;
    }

    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull FolderConfiguration configuration, @NotNull IAndroidTarget target) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/ResourceResolverCache", "getFrameworkResources"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/configurations/ResourceResolverCache", "getFrameworkResources"));
        }
        int apiLevel = target.getVersion().getFeatureLevel();
        FrameworkResources resources = (FrameworkResources)this.myFrameworkResources.get(apiLevel);
        boolean needLocales = configuration.getLanguageQualifier() != null && !configuration.getLanguageQualifier().hasFakeValue() || this.myManager.getLocale() != Locale.ANY;
        boolean reset = false;
        if (resources instanceof FrameworkResourceLoader.IdeFrameworkResources && needLocales && ((FrameworkResourceLoader.IdeFrameworkResources)resources).getSkippedLocales()) {
            reset = true;
        }
        if (resources == null || reset) {
            FrameworkResourceLoader.requestLocales(needLocales);
            resources = ResourceResolverCache.getFrameworkResources(target, this.myManager.getModule(), reset);
            this.myFrameworkResources.put(apiLevel, (Object)resources);
        }
        return resources;
    }

    @Nullable
    private static FrameworkResources getFrameworkResources(@NotNull IAndroidTarget target, @NotNull Module module, boolean forceReload) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/configurations/ResourceResolverCache", "getFrameworkResources"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/configurations/ResourceResolverCache", "getFrameworkResources"));
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return null;
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            return null;
        }
        AndroidPlatform platform = data.getAndroidPlatform();
        if (platform == null) {
            return null;
        }
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        try {
            if (forceReload) {
                targetData.resetFrameworkResources();
            }
            return targetData.getFrameworkResources();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void replaceDrawableBitmaps(@NotNull Map<ResourceType, Map<String, ResourceValue>> frameworkResources, @NotNull IAndroidTarget from, @NotNull IAndroidTarget realTarget) {
        if (frameworkResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkResources", "com/android/tools/idea/configurations/ResourceResolverCache", "replaceDrawableBitmaps"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/configurations/ResourceResolverCache", "replaceDrawableBitmaps"));
        }
        if (realTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realTarget", "com/android/tools/idea/configurations/ResourceResolverCache", "replaceDrawableBitmaps"));
        }
        Map<String, ResourceValue> map = frameworkResources.get(ResourceType.DRAWABLE);
        String oldPrefix = from.getPath(11);
        String newPrefix = realTarget.getPath(11);
        if (map == null || map.isEmpty() || oldPrefix == null || newPrefix == null || oldPrefix.equals(newPrefix)) {
            return;
        }
        Collection<ResourceValue> values = map.values();
        HashMap densityDirMap = Maps.newHashMap();
        boolean ONLY_REPLACE_BITMAPS = true;
        Density[] densities = Density.values();
        for (ResourceValue value : values) {
            File newFile;
            String v = value.getValue();
            if (v == null || !v.endsWith(".png") || !v.startsWith(oldPrefix)) continue;
            String relative = v.substring(oldPrefix.length());
            if (v.endsWith(".png")) {
                DensityQualifier densityQualifier;
                FolderConfiguration configuration;
                int index = relative.indexOf(File.separatorChar);
                if (index == -1) {
                    index = relative.indexOf(47);
                }
                if (index == -1) continue;
                String parent = relative.substring(0, index);
                String replace = (String)densityDirMap.get(parent);
                if (replace == null && (configuration = FolderConfiguration.getConfigForFolder((String)parent)) != null && (densityQualifier = configuration.getDensityQualifier()) != null) {
                    Density density = densityQualifier.getValue();
                    if (!new File(newPrefix, parent).exists()) {
                        String oldQualifier = "-" + density.getResourceValue();
                        String matched = null;
                        for (Density d : densities) {
                            String newQualifier;
                            String newName;
                            File dir;
                            if (d.ordinal() <= density.ordinal() || !(dir = new File(newPrefix, newName = parent.replace(oldQualifier, newQualifier = "-" + d.getResourceValue()))).exists()) continue;
                            matched = newName;
                            break;
                        }
                        if (matched == null) continue;
                        replace = matched;
                        densityDirMap.put(parent, replace);
                    }
                }
                relative = replace + relative.substring(index);
            }
            if (!(newFile = new File(newPrefix, relative)).exists()) continue;
            value.setValue(newFile.getPath());
        }
    }

    public void reset() {
        this.myCachedGeneration = 0L;
        this.myAppResourceMap.clear();
        this.myResolverMap.clear();
    }
}

