/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.utils.SdkUtils;
import com.google.common.io.Closeables;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.tooling.BuildLauncher;
import org.jetbrains.annotations.NotNull;

class GradleOutputForwarder {
    private static final int SIZE = 2048;
    @NotNull
    private final ByteArrayOutputStream myStdErr;
    @NotNull
    private final ByteArrayOutputStream myOutput;
    @NotNull
    private final GradleConsoleView myConsoleView;
    private ConsoleViewContentType myPreviousContentType;

    GradleOutputForwarder(@NotNull GradleConsoleView consoleView) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder", "<init>"));
        }
        this.myConsoleView = consoleView;
        this.myStdErr = new ByteArrayOutputStream(2048);
        this.myOutput = new ByteArrayOutputStream(4096);
    }

    void attachTo(@NotNull BuildLauncher launcher) {
        if (launcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcher", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder", "attachTo"));
        }
        ConsoleAwareOutputStream stdout = new ConsoleAwareOutputStream(this, ConsoleViewContentType.NORMAL_OUTPUT);
        ConsoleAwareOutputStream stderr = new ConsoleAwareOutputStream(this, ConsoleViewContentType.ERROR_OUTPUT);
        launcher.setStandardOutput((OutputStream)stdout);
        launcher.setStandardError((OutputStream)stderr);
    }

    void close() {
        try {
            Closeables.close((Closeable)this.myOutput, (boolean)true);
            Closeables.close((Closeable)this.myStdErr, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    String getStdErr() {
        String string = this.myStdErr.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder", "getStdErr"));
        }
        return string;
    }

    void write(@NotNull ConsoleViewContentType contentType, @NotNull byte[] b, int off, int len) {
        String text;
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder", "write"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder", "write"));
        }
        boolean addNewLine = false;
        if (contentType != this.myPreviousContentType) {
            addNewLine = this.myPreviousContentType != null;
            this.myPreviousContentType = contentType;
        }
        String lineSeparator = SdkUtils.getLineSeparator();
        boolean newLineAdded = false;
        if (addNewLine) {
            byte[] bytes = lineSeparator.getBytes();
            this.myOutput.write(bytes, 0, bytes.length);
            this.myConsoleView.print(lineSeparator, contentType);
            newLineAdded = true;
        }
        if (lineSeparator.equals(text = new String(b, off, len)) && newLineAdded) {
            return;
        }
        this.myOutput.write(b, off, len);
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myStdErr.write(b, off, len);
        }
        this.myConsoleView.print(text, contentType);
    }

    public String toString() {
        return this.myOutput.toString();
    }

    private static class ConsoleAwareOutputStream
    extends OutputStream {
        @NotNull
        private final GradleOutputForwarder myOutput;
        @NotNull
        private final ConsoleViewContentType myContentType;

        ConsoleAwareOutputStream(@NotNull GradleOutputForwarder output, @NotNull ConsoleViewContentType contentType) {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder$ConsoleAwareOutputStream", "<init>"));
            }
            if (contentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/android/tools/idea/gradle/invoker/GradleOutputForwarder$ConsoleAwareOutputStream", "<init>"));
            }
            this.myOutput = output;
            this.myContentType = contentType;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.myOutput.write(this.myContentType, b, off, len);
        }
    }
}

