/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTextSpellcheckingStrategy
extends SpellcheckingStrategy {
    private PsiFile myLastPsiFile;
    private boolean myLastIgnore;

    public boolean isMyContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/spellchecker/AndroidTextSpellcheckingStrategy", "isMyContext"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        return this.isIgnored(file);
    }

    private boolean isIgnored(@Nullable PsiFile psiFile) {
        String name;
        if (psiFile == null) {
            return false;
        }
        if (psiFile == this.myLastPsiFile) {
            return this.myLastIgnore;
        }
        this.myLastPsiFile = psiFile;
        FileType fileType = psiFile.getFileType();
        if (fileType == FileTypes.PLAIN_TEXT) {
            String name2 = psiFile.getName();
            if (Comparing.equal((String)name2, (String)"R.txt", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)"gradlew", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)"gradlew.bat", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name2, (String)".gitignore", (boolean)SystemInfo.isFileSystemCaseSensitive)) {
                this.myLastIgnore = true;
                return true;
            }
        } else if (fileType == StdFileTypes.PROPERTIES && (Comparing.equal((String)(name = psiFile.getName()), (String)"gradle-wrapper.properties", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name, (String)"local.properties", (boolean)SystemInfo.isFileSystemCaseSensitive) || Comparing.equal((String)name, (String)"gradle.properties", (boolean)SystemInfo.isFileSystemCaseSensitive))) {
            this.myLastIgnore = true;
            return true;
        }
        return false;
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/spellchecker/AndroidTextSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

