/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class PathManager {
    @NonNls
    public static final String PROPERTIES_FILE = "idea.properties.file";
    @NonNls
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    @NonNls
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    @NonNls
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    @NonNls
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    @NonNls
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    @NonNls
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    @NonNls
    public static final String DEFAULT_OPTIONS_FILE_NAME = "other";
    @NonNls
    private static final String LIB_FOLDER = "lib";
    @NonNls
    private static final String PLUGINS_FOLDER = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";
    @NonNls
    private static final String LOG_DIRECTORY = "log";
    @NonNls
    private static final String CONFIG_FOLDER = "config";
    @NonNls
    private static final String OPTIONS_FOLDER = "options";
    @NonNls
    private static final String SYSTEM_FOLDER = "system";
    @NonNls
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    @NonNls
    private static String ourHomePath;
    @NonNls
    private static String ourSystemPath;
    @NonNls
    private static String ourConfigPath;
    @NonNls
    private static String ourPluginsPath;
    @NonNls
    private static String ourLogPath;
    @NonNls
    public static final String PLUGINS_DIRECTORY = "plugins";

    @NotNull
    public static String getHomePath() {
        if (ourHomePath != null) {
            String string = ourHomePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
            }
            return string;
        }
        String fromProperty = System.getProperty(PROPERTY_HOME_PATH);
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
        }
        if (SystemInfo.isWindows) {
            try {
                ourHomePath = new File(ourHomePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = ourHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
        }
        return string;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getHomePathFor"));
        }
        String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        do {
            if ((parent = root.getParent()) != null) continue;
            return null;
        } while (!PathManager.isIdeaHome(root = new File(parent).getAbsoluteFile()));
        return root.getAbsolutePath();
    }

    private static boolean isIdeaHome(File root) {
        return new File(root, FileUtil.toSystemDependentName("bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("community/bin/idea.properties")).exists();
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + BIN_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getBinPath"));
        }
        return string;
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + File.separator + LIB_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLibPath"));
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + "plugins";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPreInstalledPluginsPath"));
        }
        return string;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
            }
            return string;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + CONFIG_FOLDER);
        String string = ourConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", CONFIG_FOLDER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        return string;
    }

    public static void ensureConfigFolderExists() {
        PathManager.checkAndCreate(PathManager.getConfigPath(), true);
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + File.separator + OPTIONS_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getOptionsPath"));
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        File file = new File(PathManager.getOptionsPath(), fileName + ".xml");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        return file;
    }

    @NotNull
    public static File getOptionsFile(@NotNull NamedJDOMExternalizable externalizable) {
        if (externalizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizable", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        File file = PathManager.getOptionsFile(externalizable.getExternalFileName());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
            }
            return string;
        }
        ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Application Support" + File.separator + PATHS_SELECTOR : PathManager.getConfigPath() + File.separatorChar + "plugins");
        String string = ourPluginsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
            }
            return string;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : (PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Caches", SYSTEM_FOLDER) : PathManager.getHomePath() + File.separator + SYSTEM_FOLDER);
        PathManager.checkAndCreate(ourSystemPath, true);
        String string = ourSystemPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + File.separator + "tmp";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getTempPath"));
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRoot = System.getProperty("index_root_path", PathManager.getSystemPath() + "/index");
        PathManager.checkAndCreate(indexRoot, true);
        File file = new File(indexRoot);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getIndexRoot"));
        }
        return file;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLogPath"));
            }
            return string;
        }
        ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Logs" + File.separator + PATHS_SELECTOR : PathManager.getSystemPath() + File.separatorChar + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLogPath"));
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + File.separator + "plugins";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginTempPath"));
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, @NonNls String path) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/application/PathManager", "getResourceRoot"));
        }
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    @NonNls
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null) {
            resultPath = (String)paths.first;
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resourcePath + " from " + resourceURL);
            return null;
        }
        resultPath = StringUtil.trimEnd(resultPath, File.separator);
        resultPath = URLUtil.unescapePercentSequences(resultPath);
        return resultPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        File propFile = FileUtil.findFirstThatExist(System.getProperty(PROPERTIES_FILE), SystemProperties.getUserHome() + "/idea.properties", PathManager.getHomePath() + "/bin/idea.properties", PathManager.getHomePath() + "/community/bin/idea.properties");
        if (propFile != null) {
            try {
                BufferedReader fis = new BufferedReader(new FileReader(propFile));
                try {
                    Map<String, String> properties = FileUtil.loadProperties(fis);
                    String home = properties.get("idea.home");
                    if (home != null && ourHomePath == null) {
                        ourHomePath = PathManager.getAbsolutePath(PathManager.substituteVars(home));
                    }
                    Properties sysProperties = System.getProperties();
                    for (String key : properties.keySet()) {
                        if (sysProperties.getProperty(key, null) != null) continue;
                        String value = PathManager.substituteVars(properties.get(key));
                        sysProperties.setProperty(key, value);
                    }
                }
                finally {
                    ((Reader)fis).close();
                }
            }
            catch (IOException e) {
                System.err.println("Problem reading from property file: " + propFile.getPath());
            }
        }
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        String ideaHomePath = PathManager.getHomePath();
        return PathManager.substituteVars(s, ideaHomePath);
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        s = StringUtil.replace(s, "${idea.home}", ideaHomePath);
        Properties props = System.getProperties();
        Set<Object> keys = props.keySet();
        for (Object key1 : keys) {
            String key = (String)key1;
            String value = props.getProperty(key);
            s = StringUtil.replace(s, "${" + key + "}", value);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/application/PathManager", "findFileInLibDirectory"));
        }
        File file = new File(PathManager.getLibPath() + File.separator + relativePath);
        File file2 = file.exists() ? file : new File(PathManager.getHomePath(), "community" + File.separator + LIB_FOLDER + File.separator + relativePath);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "findFileInLibDirectory"));
        }
        return file2;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getJarPathForClass"));
        }
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes = new Class[]{PathManager.class, NotNull.class, SystemInfoRt.class, Document.class, Appender.class, THashSet.class, PicoContainer.class, TypeMapper.class, FileUtils.class, PatternMatcher.class};
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(new File(resourceRoot).getAbsolutePath());
        }
        Collection<String> collection = Collections.unmodifiableCollection(classPath);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getUtilClassPath"));
        }
        return collection;
    }

    private static String getAbsolutePath(String path) {
        path = FileUtil.expandUserHome(path);
        return FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
    }

    private static String trimPathQuotes(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static String platformPath(String selector, String macDir, String fallback) {
        if (SystemInfo.isMac) {
            return SystemProperties.getUserHome() + File.separator + macDir + File.separator + selector;
        }
        return SystemProperties.getUserHome() + File.separator + "." + selector + File.separator + fallback;
    }

    private static boolean checkAndCreate(String path, boolean createIfNotExists) {
        File file;
        if (createIfNotExists && !(file = new File(path)).exists()) {
            return file.mkdirs();
        }
        return false;
    }

    public static String getPreinstalledPluginsPath() {
        return PathManager.getPreInstalledPluginsPath();
    }

    public static String getConfigPath(boolean createIfNotExists) {
        PathManager.ensureConfigFolderExists();
        return ourConfigPath;
    }

    public static boolean ensureConfigFolderExists(boolean createIfNotExists) {
        return PathManager.checkAndCreate(PathManager.getConfigPath(), createIfNotExists);
    }

    public static String getOptionsPathWithoutDialog() {
        return PathManager.getOptionsPath();
    }

    public static File getDefaultOptionsFile() {
        return new File(PathManager.getOptionsPath(), "other.xml");
    }
}

