/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.cherrypick.GitCherryPicker;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.GitCommitDetailsProvider;
import git4idea.repo.GitRepository;
import icons.Git4ideaIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCherryPickAction
extends DumbAwareAction {
    private static final String NAME = "Cherry-Pick";
    private static final Logger LOG = Logger.getInstance(GitCherryPickAction.class);
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final Git myGit = (Git)ServiceManager.getService(Git.class);
    @NotNull
    private final Set<Hash> myIdsInProgress;

    public GitCherryPickAction() {
        super(NAME, null, Git4ideaIcons.CherryPick);
        this.myPlatformFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myIdsInProgress = ContainerUtil.newHashSet();
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        final List<? extends VcsFullCommitDetails> commits = this.getSelectedCommits(e);
        if (project == null || commits == null || commits.isEmpty()) {
            LOG.info(String.format("Cherry-pick action should be disabled. Project: %s, commits: %s", project, commits));
            return;
        }
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            this.myIdsInProgress.add((Hash)vcsFullCommitDetails.getId());
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myPlatformFacade.getChangeListManager(project).blockModalNotifications();
        new Task.Backgroundable(project, "Cherry-picking", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/cherrypick/GitCherryPickAction$1", "run"));
                }
                try {
                    Map commitsInRoots = GitCherryPickAction.sortCommits(GitCherryPickAction.this.groupCommitsByRoots(project, commits));
                    new GitCherryPicker(project, GitCherryPickAction.this.myGit, GitCherryPickAction.this.myPlatformFacade, GitCherryPickAction.isAutoCommit(project)).cherryPick(commitsInRoots);
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCherryPickAction.this.myPlatformFacade.getChangeListManager(project).unblockModalNotifications();
                            for (VcsFullCommitDetails commit : commits) {
                                GitCherryPickAction.this.myIdsInProgress.remove(commit.getId());
                            }
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.queue();
    }

    @NotNull
    private static Map<GitRepository, List<VcsFullCommitDetails>> sortCommits(Map<GitRepository, List<VcsFullCommitDetails>> groupedCommits) {
        for (List<VcsFullCommitDetails> gitCommits : groupedCommits.values()) {
            Collections.reverse(gitCommits);
        }
        Map<GitRepository, List<VcsFullCommitDetails>> map = groupedCommits;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPickAction", "sortCommits"));
        }
        return map;
    }

    @NotNull
    private Map<GitRepository, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        HashMap groupedCommits = ContainerUtil.newHashMap();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(project).getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOG.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = (List)groupedCommits.get(repository);
            if (commitsInRoot == null) {
                commitsInRoot = ContainerUtil.newArrayList();
                groupedCommits.put(repository, commitsInRoot);
            }
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap hashMap = groupedCommits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        return hashMap;
    }

    private static boolean isAutoCommit(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "isAutoCommit"));
        }
        return GitVcsSettings.getInstance(project).isAutoCommitOnCherryPick();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        VcsLog log = GitCherryPickAction.getVcsLog(e);
        Project project = GitCherryPickAction.getEventProject((AnActionEvent)e);
        if (project == null || log == null || !DvcsUtil.logHasRootForVcs((VcsLog)log, (VcsKey)GitVcs.getKey())) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabled(this.enabled(e));
            e.getPresentation().setText(GitCherryPickAction.isAutoCommit(project) ? NAME : "Cherry-Pick...");
        }
    }

    private boolean enabled(AnActionEvent e) {
        List<? extends VcsFullCommitDetails> commits = this.getSelectedCommits(e);
        Project project = e.getProject();
        if (commits == null || commits.isEmpty() || project == null) {
            return false;
        }
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            if (this.myIdsInProgress.contains(vcsFullCommitDetails.getId())) {
                return false;
            }
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(project).getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                return false;
            }
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            Collection<String> containingBranches = GitCherryPickAction.getContainingBranches(e, vcsFullCommitDetails, repository);
            if (currentBranch == null || containingBranches == null || !containingBranches.contains(currentBranch.getName())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private List<? extends VcsFullCommitDetails> getSelectedCommits(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        List commits = (List)e.getData(GitVcs.SELECTED_COMMITS);
        if (commits != null) {
            return GitCherryPickAction.convertHeavyCommitToFullDetails(commits, project);
        }
        VcsLog log = GitCherryPickAction.getVcsLog(e);
        if (log == null) {
            return null;
        }
        List selectedCommits = log.getSelectedCommits();
        ArrayList selectedDetails = ContainerUtil.newArrayList();
        for (Hash commit : selectedCommits) {
            VcsFullCommitDetails details = log.getDetailsIfAvailable(commit);
            if (details == null) {
                return null;
            }
            GitRepository root = (GitRepository)this.myPlatformFacade.getRepositoryManager(project).getRepositoryForRoot(details.getRoot());
            if (root == null) {
                return null;
            }
            selectedDetails.add(details);
        }
        return selectedDetails;
    }

    private static List<? extends VcsFullCommitDetails> convertHeavyCommitToFullDetails(List<GitHeavyCommit> commits, final Project project) {
        return ContainerUtil.map(commits, (Function)new Function<GitHeavyCommit, VcsFullCommitDetails>(){

            public VcsFullCommitDetails fun(GitHeavyCommit commit) {
                final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
                List parents = ContainerUtil.map(commit.getParentsHashes(), (Function)new Function<String, Hash>(){

                    public Hash fun(String hashValue) {
                        return factory.createHash(hashValue);
                    }
                });
                final List<Change> changes = commit.getChanges();
                return factory.createFullDetails(factory.createHash(commit.getHash().getValue()), parents, commit.getAuthorTime(), commit.getRoot(), commit.getSubject(), commit.getAuthor(), commit.getAuthorEmail(), commit.getDescription(), commit.getCommitter(), commit.getCommitterEmail(), commit.getDate().getTime(), (ThrowableComputable)new ThrowableComputable<Collection<Change>, Exception>(){

                    public Collection<Change> compute() throws Exception {
                        return changes;
                    }
                });
            }
        });
    }

    private static VcsLog getVcsLog(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/cherrypick/GitCherryPickAction", "getVcsLog"));
        }
        return (VcsLog)event.getData(VcsLogDataKeys.VSC_LOG);
    }

    @Nullable
    private static Collection<String> getContainingBranches(AnActionEvent event, VcsFullCommitDetails commit, GitRepository repository) {
        GitCommitDetailsProvider detailsProvider = (GitCommitDetailsProvider)event.getData(GitVcs.COMMIT_DETAILS_PROVIDER);
        if (detailsProvider != null) {
            return detailsProvider.getContainingBranches(repository.getRoot(), AbstractHash.create(((Hash)commit.getId()).toShortString()));
        }
        if (event.getProject() == null) {
            return null;
        }
        VcsLog log = GitCherryPickAction.getVcsLog(event);
        if (log == null) {
            return null;
        }
        return log.getContainingBranches((Hash)commit.getId());
    }
}

