/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AreaMap;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import git4idea.GitUtil;
import git4idea.history.browser.GitHeavyCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesFilter {
    public static void filtersToParameters(Collection<Filter> filters, List<String> parameters, Collection<VirtualFile> paths) {
        for (Filter filter : filters) {
            filter.getCommandParametersFilter().applyToCommandLine(parameters);
            filter.getCommandParametersFilter().applyToPaths(paths);
        }
    }

    public static List<MemoryFilter> combineFilters(Collection<Filter> filters) {
        Merger[] mergers = new Merger[]{new UsersMerger()};
        if (filters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MemoryFilter> result = new ArrayList<MemoryFilter>();
        for (Filter filter : filters) {
            boolean taken = false;
            for (Merger combiner : mergers) {
                if (!combiner.accept(filter.getMemoryFilter())) continue;
                taken = true;
                break;
            }
            if (taken) continue;
            result.add(filter.getMemoryFilter());
        }
        for (Merger combiner : mergers) {
            MemoryFilter combined = combiner.getResult();
            if (combined == null) continue;
            result.add(combined);
        }
        return result;
    }

    private static String formatDate(Date date) {
        return GitUtil.gitTime(date);
    }

    public static class Comment
    implements Filter {
        private final String myRegexp;
        private Pattern myPattern;
        private CommandParametersFilter myCommandParametersFilter;
        private MemoryFilter myMemoryFilter;

        public Comment(String regexp) {
            this.myRegexp = regexp;
            this.myPattern = Pattern.compile(this.myRegexp);
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--grep=" + Comment.this.myRegexp);
                    sink.add("--regexp-ignore-case");
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return Comment.this.myPattern.matcher(commit.getDescription()).matches() || Comment.this.myPattern.matcher(commit.getCommitter()).matches() || Comment.this.myPattern.matcher(commit.getAuthor()).matches();
                }
            };
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$Comment", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Comment comment = (Comment)o;
            return !(this.myRegexp != null ? !this.myRegexp.equals(comment.myRegexp) : comment.myRegexp != null);
        }

        public int hashCode() {
            return this.myRegexp != null ? this.myRegexp.hashCode() : 0;
        }
    }

    public static class StructureFilter
    implements Filter {
        private final AreaMap<String, VirtualFile> myMap = AreaMap.create((PairProcessor)new PairProcessor<String, String>(){

            public boolean process(String candidate, String key) {
                return key.startsWith(candidate);
            }
        });
        private MemoryFilter myMemoryFilter = new MemoryFilter(){

            @Override
            public boolean applyInMemory(GitHeavyCommit commit) {
                if (StructureFilter.this.myMap.isEmpty()) {
                    return true;
                }
                List<FilePath> pathList = commit.getPathsList();
                final Ref found = new Ref();
                for (FilePath filePath : pathList) {
                    StructureFilter.this.myMap.getSimiliar((Object)FilePathsHelper.convertWithLastSeparator((FilePath)filePath), (PairProcessor)new PairProcessor<String, VirtualFile>(){

                        public boolean process(String s, VirtualFile virtualFile) {
                            found.set((Object)true);
                            return true;
                        }
                    });
                    if (!Boolean.TRUE.equals(found.get())) continue;
                    break;
                }
                return Boolean.TRUE.equals(found.get());
            }
        };

        public void addFiles(Collection<VirtualFile> files) {
            for (VirtualFile file : files) {
                this.myMap.put((Object)FilePathsHelper.convertWithLastSeparator((VirtualFile)file), (Object)file);
            }
        }

        public boolean containsFile(VirtualFile vf) {
            return this.myMap.contains((Object)FilePathsHelper.convertWithLastSeparator((VirtualFile)vf));
        }

        public void removePath(VirtualFile vf) {
            this.myMap.removeByValue((Object)vf);
        }

        public boolean isEmpty() {
            return this.myMap.isEmpty();
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                    paths.addAll(StructureFilter.this.myMap.values());
                }
            };
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$StructureFilter", "getMemoryFilter"));
            }
            return memoryFilter;
        }
    }

    public static class AfterDate
    implements Filter {
        private final Date myDate;
        private CommandParametersFilter myCommandParametersFilter;
        private MemoryFilter myMemoryFilter;

        public AfterDate(Date date) {
            this.myDate = new Date(date.getTime() - 1L);
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--after=" + ChangesFilter.formatDate(AfterDate.this.myDate));
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return commit.getDate().after(AfterDate.this.myDate);
                }
            };
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$AfterDate", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AfterDate afterDate = (AfterDate)o;
            return !(this.myDate != null ? !this.myDate.equals(afterDate.myDate) : afterDate.myDate != null);
        }

        public int hashCode() {
            return this.myDate != null ? this.myDate.hashCode() : 0;
        }
    }

    public static class BeforeDate
    implements Filter {
        private final Date myDate;
        private CommandParametersFilter myCommandParametersFilter;
        private MemoryFilter myMemoryFilter;

        public BeforeDate(Date date) {
            this.myDate = new Date(date.getTime() + 1L);
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--before=" + ChangesFilter.formatDate(BeforeDate.this.myDate));
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return commit.getDate().before(BeforeDate.this.myDate);
                }
            };
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$BeforeDate", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeforeDate that = (BeforeDate)o;
            return !(this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null);
        }

        public int hashCode() {
            return this.myDate != null ? this.myDate.hashCode() : 0;
        }
    }

    public static class Committer
    implements Filter {
        private final String myRegexp;
        private Pattern myPattern;
        private MemoryFilter myMemoryFilter;
        private CommandParametersFilter myCommandParametersFilter;

        public Committer(String regexp) {
            this.myRegexp = regexp;
            this.myPattern = Pattern.compile(this.myRegexp);
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--committer=" + Committer.this.myRegexp);
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return Committer.this.myPattern.matcher(commit.getCommitter()).matches();
                }
            };
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$Committer", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Committer committer = (Committer)o;
            return !(this.myRegexp != null ? !this.myRegexp.equals(committer.myRegexp) : committer.myRegexp != null);
        }

        public int hashCode() {
            return this.myRegexp != null ? this.myRegexp.hashCode() : 0;
        }
    }

    public static class Author
    implements Filter {
        private final String myRegexp;
        private Pattern myPattern;
        private CommandParametersFilter myCommandParametersFilter;
        private MemoryFilter myMemoryFilter;

        public Author(String regexp) {
            this.myRegexp = regexp;
            this.myPattern = Pattern.compile(this.myRegexp);
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--author=" + Author.this.myRegexp);
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return Author.this.myPattern.matcher(commit.getAuthor()).matches();
                }
            };
        }

        @Override
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$Author", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Author author = (Author)o;
            return !(this.myRegexp != null ? !this.myRegexp.equals(author.myRegexp) : author.myRegexp != null);
        }

        public int hashCode() {
            return this.myRegexp != null ? this.myRegexp.hashCode() : 0;
        }
    }

    public static class AfterTime
    implements Filter {
        private final long myTs;
        private final CommandParametersFilter myCommandParametersFilter;
        private final MemoryFilter myMemoryFilter;

        public AfterTime(long ts) {
            this.myTs = ts;
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--after='" + new Date(AfterTime.this.myTs - 86400000L).toString() + "'");
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return commit.getDate().getTime() >= AfterTime.this.myTs;
                }
            };
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$AfterTime", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        @Override
        @Nullable
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }
    }

    public static class BeforeTime
    implements Filter {
        private final long myTs;
        private final CommandParametersFilter myCommandParametersFilter;
        private final MemoryFilter myMemoryFilter;

        public BeforeTime(long ts) {
            this.myTs = ts;
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    sink.add("--before='" + new Date(BeforeTime.this.myTs + 86400000L).toString() + "'");
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                }
            };
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    return commit.getDate().getTime() <= BeforeTime.this.myTs;
                }
            };
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$BeforeTime", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        @Override
        @Nullable
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }
    }

    public static interface Filter {
        @NotNull
        public MemoryFilter getMemoryFilter();

        @Nullable
        public CommandParametersFilter getCommandParametersFilter();
    }

    public static interface CommandParametersFilter {
        public void applyToCommandLine(List<String> var1);

        public void applyToPaths(Collection<VirtualFile> var1);
    }

    public static interface MemoryFilter {
        public boolean applyInMemory(GitHeavyCommit var1);
    }

    private static class CompositeUserMemoryFilter
    implements MemoryFilter {
        private final Set<String> myUsers = new HashSet<String>();

        private CompositeUserMemoryFilter() {
        }

        public void addUser(String name) {
            this.myUsers.add(name);
        }

        @Override
        public boolean applyInMemory(GitHeavyCommit commit) {
            return this.myUsers.contains(commit.getCommitter()) || this.myUsers.contains(commit.getAuthor());
        }
    }

    public static class And
    implements Filter {
        private final Filter[] myFilters;
        private MemoryFilter myMemoryFilter;
        private CommandParametersFilter myCommandParametersFilter;

        public And(Filter ... filters) {
            this.myFilters = filters;
            this.myMemoryFilter = new MemoryFilter(){

                @Override
                public boolean applyInMemory(GitHeavyCommit commit) {
                    for (Filter filter : And.this.myFilters) {
                        if (filter.getMemoryFilter().applyInMemory(commit)) continue;
                        return false;
                    }
                    return true;
                }
            };
            this.myCommandParametersFilter = new CommandParametersFilter(){

                @Override
                public void applyToCommandLine(List<String> sink) {
                    for (Filter filter : And.this.myFilters) {
                        CommandParametersFilter commandParametersFilter = filter.getCommandParametersFilter();
                        if (commandParametersFilter == null) continue;
                        commandParametersFilter.applyToCommandLine(sink);
                    }
                }

                @Override
                public void applyToPaths(Collection<VirtualFile> paths) {
                    for (Filter filter : And.this.myFilters) {
                        CommandParametersFilter commandParametersFilter = filter.getCommandParametersFilter();
                        if (commandParametersFilter == null) continue;
                        commandParametersFilter.applyToPaths(paths);
                    }
                }
            };
        }

        @Override
        @NotNull
        public MemoryFilter getMemoryFilter() {
            MemoryFilter memoryFilter = this.myMemoryFilter;
            if (memoryFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/browser/ChangesFilter$And", "getMemoryFilter"));
            }
            return memoryFilter;
        }

        @Override
        @Nullable
        public CommandParametersFilter getCommandParametersFilter() {
            return this.myCommandParametersFilter;
        }
    }

    public static class UsersMerger
    extends Merger {
        @Override
        protected boolean acceptImpl(MemoryFilter filter) {
            return filter instanceof Author || filter instanceof Committer;
        }

        @Override
        protected MemoryFilter merge(Collection<MemoryFilter> filters) {
            CompositeUserMemoryFilter result = new CompositeUserMemoryFilter();
            for (MemoryFilter filter : filters) {
                if (filter instanceof Author) {
                    result.addUser(((Author)((Object)filter)).myRegexp);
                    continue;
                }
                if (!(filter instanceof Committer)) continue;
                result.addUser(((Committer)((Object)filter)).myRegexp);
            }
            return result;
        }
    }

    public static abstract class Merger {
        private final Collection<MemoryFilter> myFilters = new ArrayList<MemoryFilter>();
        private MemoryFilter myResult;

        protected Merger() {
        }

        protected abstract boolean acceptImpl(MemoryFilter var1);

        protected abstract MemoryFilter merge(Collection<MemoryFilter> var1);

        public boolean accept(MemoryFilter filter) {
            if (this.acceptImpl(filter)) {
                this.myFilters.add(filter);
                return true;
            }
            return false;
        }

        @Nullable
        public MemoryFilter getResult() {
            if (this.myFilters.isEmpty()) {
                return null;
            }
            return this.merge(this.myFilters);
        }
    }
}

