/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AsynchConsumer;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.ChangesFilter;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.LowLevelAccess;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitHashPlusParents;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LowLevelAccessImpl
implements LowLevelAccess {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.browser.LowLevelAccessImpl");
    private final Project myProject;
    private final VirtualFile myRoot;

    public LowLevelAccessImpl(Project project, VirtualFile root) {
        this.myProject = project;
        this.myRoot = root;
    }

    @Override
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @Override
    public void loadHashesWithParents(@NotNull Collection<String> startingPoints, @NotNull Collection<ChangesFilter.Filter> filters, AsynchConsumer<CommitHashPlusParents> consumer, Getter<Boolean> isCanceled, int useMaxCnt, boolean topoOrder) throws VcsException {
        if (startingPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingPoints", "git4idea/history/browser/LowLevelAccessImpl", "loadHashesWithParents"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "git4idea/history/browser/LowLevelAccessImpl", "loadHashesWithParents"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        HashSet<VirtualFile> paths = new HashSet<VirtualFile>();
        ChangesFilter.filtersToParameters(filters, parameters, paths);
        if (!startingPoints.isEmpty()) {
            for (String startingPoint : startingPoints) {
                parameters.add(startingPoint);
            }
        } else {
            parameters.add("HEAD");
            parameters.add("--branches");
            parameters.add("--remotes");
            parameters.add("--tags");
        }
        if (useMaxCnt > 0) {
            parameters.add("--max-count=" + useMaxCnt);
        }
        if (topoOrder) {
            parameters.add("--topo-order");
        } else {
            parameters.add("--date-order");
        }
        GitHistoryUtils.hashesWithParents(this.myProject, (FilePath)new FilePathImpl(this.myRoot), consumer, isCanceled, paths, ArrayUtil.toStringArray(parameters));
    }

    @Override
    public List<GitHeavyCommit> getCommitDetails(Collection<String> commitIds, SymbolicRefsI refs) throws VcsException {
        return GitHistoryUtils.commitsDetails(this.myProject, (FilePath)new FilePathImpl(this.myRoot), refs, commitIds);
    }

    @Override
    public CachedRefs getRefs() throws VcsException {
        CachedRefs refs = new CachedRefs();
        GitRepository repository = LowLevelAccessImpl.getRepositoryWise(this.myProject, this.myRoot);
        GitBranchesCollection branches = repository.getBranches();
        refs.setCollection(branches);
        GitLocalBranch current = repository.getCurrentBranch();
        refs.setCurrentBranch(current);
        if (current != null) {
            Collection<GitBranchTrackInfo> infos = repository.getBranchTrackInfos();
            for (GitBranchTrackInfo info : infos) {
                if (!info.getLocalBranch().equals(current)) continue;
                String fullName = info.getRemoteBranch().getFullName();
                fullName = fullName.startsWith("refs/remotes/") ? fullName.substring("refs/remotes/".length()) : fullName;
                refs.setTrackedRemoteName(fullName);
                break;
            }
        }
        refs.setUsername(GitConfigUtil.getValue(this.myProject, this.myRoot, "user.name"));
        String head = repository.getCurrentRevision();
        if (head != null) {
            refs.setHeadHash(AbstractHash.create(head));
        }
        return refs;
    }

    private static GitRepository getRepositoryWise(Project project, VirtualFile root) throws VcsException {
        GitRepository repository;
        GitRepository gitRepository = repository = project == null || project.isDefault() ? null : (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository == null) {
            File child = new File(root.getPath(), ".git");
            if (!child.exists()) {
                throw new VcsException("No git repository in " + root.getPath());
            }
            repository = GitRepositoryImpl.getLightInstance(root, project, (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class), (Disposable)project);
            repository.update();
            repository.getBranches();
        }
        return repository;
    }

    @Override
    public void loadCommits(@NotNull Collection<String> startingPoints, @NotNull Collection<String> endPoints, @NotNull Collection<ChangesFilter.Filter> filters, @NotNull AsynchConsumer<GitHeavyCommit> consumer, int useMaxCnt, Getter<Boolean> isCanceled, SymbolicRefsI refs, boolean topoOrder) throws VcsException {
        if (startingPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingPoints", "git4idea/history/browser/LowLevelAccessImpl", "loadCommits"));
        }
        if (endPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPoints", "git4idea/history/browser/LowLevelAccessImpl", "loadCommits"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "git4idea/history/browser/LowLevelAccessImpl", "loadCommits"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/browser/LowLevelAccessImpl", "loadCommits"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        if (useMaxCnt > 0) {
            parameters.add("--max-count=" + useMaxCnt);
        }
        HashSet<VirtualFile> paths = new HashSet<VirtualFile>();
        ChangesFilter.filtersToParameters(filters, parameters, paths);
        if (!startingPoints.isEmpty()) {
            for (String startingPoint : startingPoints) {
                parameters.add(startingPoint);
            }
        } else {
            parameters.add("HEAD");
            parameters.add("--branches");
            parameters.add("--remotes");
            parameters.add("--tags");
        }
        if (topoOrder) {
            parameters.add("--topo-order");
        } else {
            parameters.add("--date-order");
        }
        for (String endPoint : endPoints) {
            parameters.add("^" + endPoint);
        }
        GitHistoryUtils.historyWithLinks(this.myProject, (FilePath)new FilePathImpl(this.myRoot), refs, consumer, isCanceled, paths, true, ArrayUtil.toStringArray(parameters));
    }

    public List<String> getBranchesWithCommit(SHAHash hash) throws VcsException {
        return this.getBranchesWithCommit(hash.getValue());
    }

    public List<String> getBranchesWithCommit(String hash) throws VcsException {
        return new ArrayList<String>(GitBranchUtil.getBranches(this.myProject, this.myRoot, true, true, hash));
    }

    @Override
    public Collection<String> getTagsWithCommit(SHAHash hash) throws VcsException {
        ArrayList<String> result = new ArrayList<String>();
        GitTag.listAsStrings(this.myProject, this.myRoot, result, hash.getValue());
        return result;
    }
}

