/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.List;
import javax.swing.JList;

public class SelectGitBranchesPopup {
    private SelectGitBranchesPopup() {
    }

    public static void showMe(final Consumer<Object[]> selectedBranchConsumer, List<String> branchesAndTags, boolean tags, DataContext dc) {
        JBList list = new JBList();
        list.setCellRenderer(new BranchListCellRenderer(tags));
        list.setListData(ArrayUtil.toObjectArray(branchesAndTags));
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select " + (tags ? "tags" : "branches")).setResizable(true).setDimensionServiceKey("Git.Select branches/tags").setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                selectedBranchConsumer.consume((Object)this.val$list.getSelectedValues());
            }
        }).createPopup().showInBestPositionFor(dc);
    }

    private static class BranchListCellRenderer
    extends ColoredListCellRenderer {
        private final boolean myTags;

        private BranchListCellRenderer(boolean tags) {
            this.myTags = tags;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

