/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.MultiMap;
import git4idea.history.browser.LowLevelAccess;
import git4idea.history.browser.SHAHash;
import java.util.Collection;
import java.util.Set;

public class TagBridge {
    final Set<SHAHash> myParentsInterestedIn;
    private final LowLevelAccess myAccess;
    final MultiMap<SHAHash, String> myTagsForHashes;
    final MultiMap<String, SHAHash> myHashesForTags;

    public TagBridge(Set<SHAHash> parentsInterestedIn, LowLevelAccess access) {
        this.myParentsInterestedIn = parentsInterestedIn;
        this.myAccess = access;
        this.myTagsForHashes = new MultiMap();
        this.myHashesForTags = new MultiMap();
    }

    public void load() throws VcsException {
        for (SHAHash hash : this.myParentsInterestedIn) {
            Collection<String> refs = this.myAccess.getBranchesWithCommit(hash);
            refs.addAll(this.myAccess.getTagsWithCommit(hash));
            this.myTagsForHashes.put((Object)hash, refs);
            for (String ref : refs) {
                this.myHashesForTags.putValue((Object)ref, (Object)hash);
            }
        }
    }

    public MultiMap<String, SHAHash> getHashesForTags() {
        return this.myHashesForTags;
    }

    public MultiMap<SHAHash, String> getTagsForHashes() {
        return this.myTagsForHashes;
    }
}

