/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import git4idea.GitBranch;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.wholeTree.BasePopupAction;
import java.util.TreeSet;

public class BranchSelectorAction
extends BasePopupAction {
    private SymbolicRefs mySymbolicRefs;
    private final Consumer<String> myConsumer;

    public BranchSelectorAction(Project project, Consumer<String> consumer) {
        super(project, "Branch:", "Branch");
        this.myConsumer = consumer;
        this.myLabel.setText(this.getText("All"));
    }

    private String getText(String branch) {
        return this.minusRefs(branch);
    }

    private String minusRefs(String branch) {
        if (branch.startsWith("refs/heads/")) {
            return branch.substring("refs/heads/".length());
        }
        return branch.startsWith("refs/") ? branch.substring("refs/".length()) : branch;
    }

    public void setSymbolicRefs(SymbolicRefs symbolicRefs) {
        this.mySymbolicRefs = symbolicRefs;
    }

    @Override
    protected void createActions(Consumer<AnAction> actionConsumer) {
        TreeSet<String> remotes;
        String currentName;
        actionConsumer.consume((Object)new SelectBranchAction("All", null));
        if (this.mySymbolicRefs == null) {
            return;
        }
        GitBranch current = this.mySymbolicRefs.getCurrent();
        if (current != null) {
            actionConsumer.consume((Object)new SelectBranchAction("*" + this.minusRefs(current.getFullName()), current.getFullName()));
        }
        TreeSet<String> locals = this.mySymbolicRefs.getLocalBranches();
        String string = currentName = current == null ? null : current.getName();
        if (locals != null && !locals.isEmpty()) {
            DefaultActionGroup local = new DefaultActionGroup("Local", true);
            actionConsumer.consume((Object)local);
            for (String s : locals) {
                String presentation = s.equals(currentName) ? "*" + s : s;
                local.add((AnAction)new SelectBranchAction(presentation, s));
            }
        }
        if ((remotes = this.mySymbolicRefs.getRemoteBranches()) != null && !remotes.isEmpty()) {
            DefaultActionGroup remote = new DefaultActionGroup("Remote", true);
            actionConsumer.consume((Object)remote);
            for (String s : remotes) {
                String presentation = s.equals(currentName) ? "*" + s : s;
                remote.add((AnAction)new SelectBranchAction(presentation, "refs/remotes/" + s));
            }
        }
    }

    public void setPreset(String selectedBranch) {
        if (selectedBranch == null) {
            this.myLabel.setText(this.getText("All"));
        } else if (selectedBranch.startsWith("refs/")) {
            this.myLabel.setText(selectedBranch.substring("refs/".length()));
        } else {
            this.myLabel.setText(selectedBranch);
        }
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.doAction(null);
    }

    private class SelectBranchAction
    extends DumbAwareAction {
        private final String myValue;

        private SelectBranchAction(String text, String value) {
            super(text);
            this.myValue = value;
        }

        public void actionPerformed(AnActionEvent e) {
            BranchSelectorAction.this.myConsumer.consume((Object)this.myValue);
            BranchSelectorAction.this.myLabel.setText(this.myValue == null ? this.getTemplatePresentation().getText() : BranchSelectorAction.this.getText(this.myValue));
        }
    }
}

