/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@State(name="GitLogSettings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class GitLogSettings
implements PersistentStateComponent<MyState> {
    private MyState myState = new MyState();

    public boolean setIfChanged(ArrayList<String> local, ArrayList<String> remote) {
        if (Comparing.haveEqualElements(this.myState.myContainedLocalBranches, local) && Comparing.haveEqualElements(this.myState.myContainedRemoteBranches, remote)) {
            return false;
        }
        this.setLocal(local);
        this.setRemote(remote);
        return true;
    }

    public MyState getState() {
        return this.myState;
    }

    public void loadState(MyState state) {
        this.myState = state;
    }

    public MyDateState getDateState() {
        return this.myState.myDateState;
    }

    public boolean isTopoOrder() {
        return this.myState.myTopoOrder;
    }

    public void setTopoOrder(boolean value) {
        this.myState.myTopoOrder = value;
    }

    public Set<String> getActiveRoots() {
        return this.myState.myActiveRoots;
    }

    public void setActiveRoots(Set<String> set) {
        this.myState.myActiveRoots.clear();
        this.myState.myActiveRoots.addAll(set);
    }

    public boolean isShowTree() {
        return this.myState.myShowTree;
    }

    public void setShowTree(boolean value) {
        this.myState.myShowTree = value;
    }

    public void setSelectedUser(String selected) {
        this.myState.mySelectedUser = selected;
    }

    public void setSelectedUserIsMe(boolean value) {
        this.myState.mySelectedUserIsMe = value;
    }

    public boolean isSelectedUserMe() {
        return this.myState.mySelectedUserIsMe;
    }

    public void setSelectedBranch(String branch) {
        this.myState.mySelectedBranch = branch;
    }

    public void setSelectedPaths(Collection<VirtualFile> paths) {
        if (paths == null) {
            this.myState.myStructureFilterPaths = null;
            return;
        }
        this.myState.myStructureFilterPaths = new ArrayList<String>();
        for (VirtualFile path : paths) {
            this.myState.myStructureFilterPaths.add(path.getPath());
        }
    }

    public String getSelectedBranch() {
        return this.myState.mySelectedBranch;
    }

    public String getSelectedUser() {
        return this.myState.mySelectedUser;
    }

    public List<String> getSelectedPaths() {
        return this.myState.myStructureFilterPaths;
    }

    public static GitLogSettings getInstance(Project project) {
        return (GitLogSettings)ServiceManager.getService((Project)project, GitLogSettings.class);
    }

    public Set<String> getLocalBranchesCopy() {
        return this.myState.myContainedLocalBranches == null ? Collections.emptySet() : new HashSet(this.myState.myContainedLocalBranches);
    }

    public Set<String> getRemoteBranchesCopy() {
        return this.myState.myContainedRemoteBranches == null ? Collections.emptySet() : new HashSet(this.myState.myContainedRemoteBranches);
    }

    public void iterateBranches(PairConsumer<String, Boolean> consumer) {
        for (String item : this.myState.myContainedLocalBranches) {
            consumer.consume((Object)item, (Object)true);
        }
        for (String item : this.myState.myContainedRemoteBranches) {
            consumer.consume((Object)item, (Object)false);
        }
    }

    public void setLocal(List<String> local) {
        Collections.sort(local);
        this.myState.myContainedLocalBranches = local;
    }

    public void setRemote(List<String> branches) {
        Collections.sort(branches);
        this.myState.myContainedRemoteBranches = branches;
    }

    public boolean isHighlight() {
        return this.myState.myHighlight;
    }

    public void setHighlight(boolean value) {
        this.myState.myHighlight = value;
    }

    public boolean isShowDetails() {
        return this.myState.myShowDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.myState.myShowDetails = showDetails;
    }

    public static class MyDateState {
        public boolean mySelectedTime = false;
        public long myTimeBefore = -1L;
        public long myTimeAfter = -1L;
        public String myPresetFilter = null;
    }

    public static class MyState {
        public List<String> myContainedLocalBranches = new ArrayList<String>();
        public List<String> myContainedRemoteBranches = new ArrayList<String>();
        public Set<String> myActiveRoots = new HashSet();
        public String mySelectedBranch = null;
        public List<String> myStructureFilterPaths = new ArrayList<String>();
        public String mySelectedUser = null;
        public boolean mySelectedUserIsMe;
        public boolean myHighlight = true;
        public boolean myShowTree = true;
        public boolean myTopoOrder = false;
        public boolean myShowDetails = true;
        public MyDateState myDateState = new MyDateState();
    }
}

