/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TableScrollingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.Speedometer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GitTableScrollChangeListener
implements ChangeListener {
    private final Speedometer mySpeedometer;
    private Timer myTimer;
    private long myRefreshMark;
    private final DetailsCache myDetailsCache;
    private final BigTableTableModel myTableModel;
    private final Runnable myCheckSelection;

    public GitTableScrollChangeListener(final JBTable table, DetailsCache detailsCache, BigTableTableModel tableModel, Runnable checkSelection, final Runnable fastListener) {
        this.myDetailsCache = detailsCache;
        this.myTableModel = tableModel;
        this.myCheckSelection = checkSelection;
        this.mySpeedometer = new Speedometer();
        this.myRefreshMark = 0L;
        this.myTimer = UIUtil.createNamedTimer((String)"Git table scroll timer", (int)100, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean shouldPing;
                if (fastListener != null) {
                    fastListener.run();
                }
                boolean bl = shouldPing = System.currentTimeMillis() - GitTableScrollChangeListener.this.myRefreshMark > 300L;
                if (GitTableScrollChangeListener.this.mySpeedometer.getSpeed() < 0.1 && GitTableScrollChangeListener.this.mySpeedometer.hasData() || shouldPing) {
                    GitTableScrollChangeListener.this.myRefreshMark = System.currentTimeMillis();
                    if (GitTableScrollChangeListener.this.myCheckSelection != null) {
                        GitTableScrollChangeListener.this.myCheckSelection.run();
                    }
                    GitTableScrollChangeListener.this.mySpeedometer.clear();
                    Couple visibleRows = TableScrollingUtil.getVisibleRows((JTable)table);
                    if ((Integer)visibleRows.getSecond() < 0) {
                        if ((Integer)visibleRows.getFirst() < 0) {
                            return;
                        }
                        visibleRows = Couple.of((Object)visibleRows.getFirst(), (Object)(GitTableScrollChangeListener.this.myTableModel.getRowCount() - 1));
                    }
                    int difference = (Integer)visibleRows.getSecond() - (Integer)visibleRows.getFirst();
                    int start = Math.max(0, (Integer)visibleRows.getFirst() - difference);
                    int end = Math.min(GitTableScrollChangeListener.this.myTableModel.getRowCount() - 1, (Integer)visibleRows.getSecond() + difference);
                    MultiMap<VirtualFile, AbstractHash> missing = GitTableScrollChangeListener.this.myTableModel.getMissing(start, end);
                    if (!missing.isEmpty()) {
                        GitTableScrollChangeListener.this.myDetailsCache.acceptQuestion(missing);
                    }
                }
            }
        });
    }

    public void start() {
        this.myTimer.start();
    }

    public void stop() {
        this.myTimer.stop();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.mySpeedometer.event();
    }
}

