/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.Convertor;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.GatheringContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import git4idea.history.wholeTree.ByRootLoader;
import git4idea.history.wholeTree.CommitHashPlusParents;
import git4idea.history.wholeTree.GitCommitsSequentially;
import git4idea.history.wholeTree.LoaderAndRefresher;
import git4idea.history.wholeTree.StepType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LoadAlgorithm {
    private static final long ourTestTimeThreshold = 10000L;
    private final Project myProject;
    private final List<LoaderAndRefresher<CommitHashPlusParents>> myLoaders;
    private final List<ByRootLoader> myShortLoaders;
    private Continuation myContinuation;
    private final GitCommitsSequentially myGitCommitsSequentially;

    public LoadAlgorithm(Project project, List<LoaderAndRefresher<CommitHashPlusParents>> loaders, List<ByRootLoader> shortLoaders, GitCommitsSequentially gitCommitsSequentially) {
        this.myProject = project;
        this.myLoaders = loaders;
        this.myShortLoaders = shortLoaders;
        this.myGitCommitsSequentially = gitCommitsSequentially;
    }

    public void setContinuation(Continuation continuation) {
        this.myContinuation = continuation;
    }

    public void fillContinuation() {
        GatheringContinuationContext initContext = new GatheringContinuationContext();
        for (LoaderAndRefresher<CommitHashPlusParents> loader : this.myLoaders) {
            LoaderFactory factory = new LoaderFactory(loader);
            State state = new State(factory);
            state.scheduleSelf((ContinuationContext)initContext);
        }
        for (ByRootLoader shortLoader : this.myShortLoaders) {
            initContext.next(new TaskDescriptor[]{shortLoader});
        }
        this.myContinuation.add(initContext.getList());
    }

    public void stop() {
        for (LoaderAndRefresher<CommitHashPlusParents> loader : this.myLoaders) {
            loader.interrupt();
        }
    }

    public Continuation getContinuation() {
        return this.myContinuation;
    }

    public void resume() {
        this.myContinuation.clearQueue();
        for (LoaderAndRefresher<CommitHashPlusParents> loader : this.myLoaders) {
            LoaderFactory factory = new LoaderFactory(loader);
            this.myContinuation.add(Collections.singletonList(factory.convert(new State(factory))));
        }
        this.myContinuation.resumeOnNewIndicator(this.myProject, true, ProgressManager.getInstance().getProgressIndicator().getText());
    }

    private void flushIntoUiCalledFromBackground(ContinuationContext context, LoaderAndRefresher<CommitHashPlusParents> uiRefresh) {
        StepType stepType = uiRefresh.flushIntoUI();
        if (StepType.STOP.equals((Object)stepType)) {
            context.cancelEverything();
        } else if (StepType.PAUSE.equals((Object)stepType)) {
            context.cancelCurrent();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.cancel();
            }
        }
    }

    private static class State {
        private boolean myLoadFull;
        private long myContinuationTs = -1L;
        @Nullable
        private LoadType myValue;
        private final Convertor<State, LoadTaskDescriptor> myLoaderFactory;

        private State(Convertor<State, LoadTaskDescriptor> loaderFactory) {
            this.myLoaderFactory = loaderFactory;
            this.myValue = LoadType.SHORT;
            this.myLoadFull = false;
        }

        public void scheduleSelf(ContinuationContext context) {
            if (this.myValue == null) {
                return;
            }
            if (this.myValue.isStartEarly()) {
                context.next(new TaskDescriptor[]{(TaskDescriptor)this.myLoaderFactory.convert((Object)this)});
            } else {
                context.last(new TaskDescriptor[]{(TaskDescriptor)this.myLoaderFactory.convert((Object)this)});
            }
        }

        public long getContinuationTs() {
            return this.myContinuationTs;
        }

        public void setContinuationTs(long continuationTs) {
            this.myContinuationTs = continuationTs;
        }

        public void takeDecision(boolean loadFull) {
            this.myLoadFull = loadFull;
        }

        public void transition() {
            this.myValue = LoadType.TEST.equals((Object)this.myValue) ? (this.myLoadFull ? LoadType.FULL_START : LoadType.FULL_PREVIEW) : (LoadType.FULL_PREVIEW.equals((Object)this.myValue) ? LoadType.SHORT_START : (LoadType.FULL_START.equals((Object)this.myValue) ? LoadType.FULL : (LoadType.SHORT_START.equals((Object)this.myValue) ? LoadType.SHORT : (LoadType.SHORT.equals((Object)this.myValue) ? LoadType.SHORT : (LoadType.FULL.equals((Object)this.myValue) ? LoadType.FULL : null)))));
        }
    }

    private class LoaderFactory
    implements Convertor<State, LoadTaskDescriptor> {
        private final LoaderAndRefresher<CommitHashPlusParents> myLoader;

        private LoaderFactory(LoaderAndRefresher<CommitHashPlusParents> loader) {
            this.myLoader = loader;
        }

        public LoadTaskDescriptor convert(State state) {
            if (LoadType.TEST.equals((Object)state.myValue)) {
                return new TestLoadTaskDescriptor(state, this.myLoader);
            }
            return new LoadTaskDescriptor(state, this.myLoader);
        }
    }

    public static class Result<T> {
        private final long myTime;
        private final boolean myIsComplete;
        private final T myLast;

        public Result(boolean isComplete, long time, T t) {
            this.myIsComplete = isComplete;
            this.myTime = time;
            this.myLast = t;
        }

        public boolean isIsComplete() {
            return this.myIsComplete;
        }

        public long getTime() {
            return this.myTime;
        }

        public T getLast() {
            return this.myLast;
        }
    }

    public static enum LoadType {
        TEST(true, false),
        FULL_START(false, true),
        FULL(false, true),
        FULL_PREVIEW(true, true),
        SHORT_START(false, true),
        SHORT(false, true);

        private final boolean myStartEarly;
        private final boolean myUsesContinuation;

        private LoadType(boolean startEarly, boolean startsContinuation) {
            this.myStartEarly = startEarly;
            this.myUsesContinuation = startsContinuation;
        }

        public boolean isStartEarly() {
            return this.myStartEarly;
        }

        public boolean isUsesContinuation() {
            return this.myUsesContinuation;
        }
    }

    private class TestLoadTaskDescriptor
    extends LoadTaskDescriptor {
        private TestLoadTaskDescriptor(State state, LoaderAndRefresher<CommitHashPlusParents> loader) {
            super(state, loader);
        }

        @Override
        protected void processResult(Result result) {
            assert (LoadType.TEST.equals((Object)this.myState.myValue));
            this.myState.takeDecision(false);
        }
    }

    private class LoadTaskDescriptor
    extends TaskDescriptor {
        protected final State myState;
        private final LoaderAndRefresher<CommitHashPlusParents> myLoader;

        protected LoadTaskDescriptor(State state, LoaderAndRefresher<CommitHashPlusParents> loader) {
            super("Load git tree skeleton", Where.POOLED);
            this.myState = state;
            this.myLoader = loader;
        }

        protected void processResult(Result result) {
        }

        public void run(ContinuationContext context) {
            ProgressManager.progress((String)this.getName());
            Result<CommitHashPlusParents> result = this.myLoader.load(this.myState.myValue, this.myState.getContinuationTs());
            this.processResult(result);
            this.myState.setContinuationTs(result.getLast() == null ? -1L : result.getLast().getTime());
            if (!result.isIsComplete()) {
                this.myState.transition();
                if (!this.myLoader.isInterrupted()) {
                    this.myState.scheduleSelf(context);
                }
            }
            LoadAlgorithm.this.flushIntoUiCalledFromBackground(context, this.myLoader);
        }
    }
}

