/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ui.AdjustComponentWhenShown;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVersion;
import git4idea.history.wholeTree.GitCommitsSequentially;
import git4idea.history.wholeTree.GitLog;
import git4idea.history.wholeTree.LogFactoryService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectRepositoryAndShowLogAction
extends AnAction {
    public static final String ourTitle = "Show Git Repository Log";
    public static final int MAX_REPOS = 10;

    public SelectRepositoryAndShowLogAction() {
        super("Show Git Repository Log...");
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final Project finalProject = project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFiles.length == 0) {
            return;
        }
        if (virtualFiles.length > 10) {
            VcsBalloonProblemNotifier.showOverVersionControlView((Project)project, (String)"Too many roots (more than 10) selected.", (MessageType)MessageType.ERROR);
            return;
        }
        SmartList wrongRoots = new SmartList();
        SmartList correctRoots = new SmartList();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) {
                wrongRoots.add(vf);
                continue;
            }
            correctRoots.add(vf);
        }
        if (!wrongRoots.isEmpty()) {
            VcsBalloonProblemNotifier.showOverVersionControlView((Project)project, (String)("These files are not Git repository roots:\n" + StringUtil.join((Collection)wrongRoots, (Function)new Function<VirtualFile, String>(){

                public String fun(VirtualFile virtualFile) {
                    return virtualFile.getPath();
                }
            }, (String)"\n")), (MessageType)MessageType.ERROR);
        }
        if (wrongRoots.size() != virtualFiles.length) {
            if (project == null || project.isDefault()) {
                ProgressManager.getInstance().run((Task)new MyPrepareToShowForDefaultProject(null, (List)correctRoots));
                return;
            }
            final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
            final Runnable showContent = new Runnable((List)correctRoots){
                final /* synthetic */ List val$correctRoots;
                {
                    this.val$correctRoots = list;
                }

                @Override
                public void run() {
                    Content[] contents;
                    ContentManager cm = window.getContentManager();
                    if (SelectRepositoryAndShowLogAction.this.checkForProjectScope(cm, finalProject, this.val$correctRoots)) {
                        return;
                    }
                    int cnt = 0;
                    for (Content content : contents = cm.getContents()) {
                        JComponent component = content.getComponent();
                        if (!(component instanceof MyContentComponent)) continue;
                        cnt = Math.max(cnt, ((MyContentComponent)component).getCount());
                        List<VirtualFile> roots = ((MyContentComponent)component).getRoots();
                        if (!Comparing.equal(roots, (Object)this.val$correctRoots)) continue;
                        cm.setSelectedContent(content);
                        SelectRepositoryAndShowLogAction.alreadyOpened(finalProject);
                        return;
                    }
                    LogFactoryService logFactoryService = LogFactoryService.getInstance(finalProject);
                    GitLog gitLog = logFactoryService.createComponent(false);
                    gitLog.rootsChanged(this.val$correctRoots);
                    ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
                    MyContentComponent contentComponent = new MyContentComponent((LayoutManager)new BorderLayout(), ++cnt);
                    contentComponent.setRoots(this.val$correctRoots);
                    contentComponent.add((Component)gitLog.getVisualComponent(), "Center");
                    Content content = contentFactory.createContent((JComponent)contentComponent, "Log (" + cnt + ")", false);
                    content.setDescription("Log for " + StringUtil.join((Collection)this.val$correctRoots, (Function)new Function<VirtualFile, String>(){

                        public String fun(VirtualFile file) {
                            return file.getPath();
                        }
                    }, (String)"\n"));
                    content.setCloseable(true);
                    Disposer.register((Disposable)content, (Disposable)gitLog);
                    cm.addContent(content);
                    cm.setSelectedContent(content);
                }
            };
            ProgressManager.getInstance().run((Task)new MyCheckVersion(project){

                public void onSuccess() {
                    if (this.myVersion == null) {
                        return;
                    }
                    if (!window.isVisible()) {
                        window.activate(showContent, true);
                    } else {
                        showContent.run();
                    }
                }
            });
        }
    }

    private static void alreadyOpened(Project project) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)"Already opened", (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
    }

    private boolean checkForProjectScope(ContentManager cm, Project project, List<VirtualFile> correctRoots) {
        VirtualFile[] rootsUnderVcs = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(project));
        if (Comparing.equal(correctRoots, Arrays.asList(rootsUnderVcs))) {
            Content[] contents;
            for (Content content : contents = cm.getContents()) {
                if (!"Log".equals(content.getDisplayName())) continue;
                cm.setSelectedContent(content);
                SelectRepositoryAndShowLogAction.alreadyOpened(project);
                return true;
            }
        }
        return false;
    }

    private static class MyDialog
    extends DialogWrapper {
        private GitLog myGitLog;
        private final Project myProject;
        private final List<VirtualFile> myVirtualFiles;

        private MyDialog(Project project, List<VirtualFile> virtualFiles) {
            super(project, true);
            this.myProject = project;
            this.myVirtualFiles = virtualFiles;
            this.myGitLog = new LogFactoryService(this.myProject, (GitCommitsSequentially)ServiceManager.getService(GitCommitsSequentially.class)).createComponent(false);
            this.myGitLog.rootsChanged(this.myVirtualFiles);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myGitLog);
            new AdjustComponentWhenShown(){

                protected boolean init() {
                    MyDialog.this.myGitLog.setModalityState(ModalityState.current());
                    return true;
                }
            }.install((Component)this.myGitLog.getVisualComponent());
            this.setTitle("Git Log");
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myGitLog.getVisualComponent();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/SelectRepositoryAndShowLogAction$MyDialog", "createActions"));
            }
            return actionArray;
        }
    }

    private static class MyCheckVersion
    extends Task.Backgroundable {
        protected GitVersion myVersion;

        private MyCheckVersion(@Nullable Project project) {
            super(project, SelectRepositoryAndShowLogAction.ourTitle, true, BackgroundFromStartOption.getInstance());
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/wholeTree/SelectRepositoryAndShowLogAction$MyCheckVersion", "run"));
            }
            GitVcs vcs = GitVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            this.myVersion = vcs.getVersion();
            if (this.myVersion.isNull()) {
                vcs.checkVersion();
                this.myVersion = vcs.getVersion();
            }
        }
    }

    private static class MyPrepareToShowForDefaultProject
    extends Task.Backgroundable {
        private Project myProject;
        private final List<VirtualFile> myCorrectRoots;
        private MyCheckVersion myVersion;

        private MyPrepareToShowForDefaultProject(@Nullable Project project, List<VirtualFile> correctRoots) {
            super(project, SelectRepositoryAndShowLogAction.ourTitle, true, BackgroundFromStartOption.getInstance());
            this.myCorrectRoots = correctRoots;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/wholeTree/SelectRepositoryAndShowLogAction$MyPrepareToShowForDefaultProject", "run"));
            }
            this.myProject = ProjectManager.getInstance().getDefaultProject();
            this.myVersion = new MyCheckVersion(this.myProject);
            this.myVersion.run(indicator);
        }

        public void onSuccess() {
            if (this.myVersion.myVersion.isNull()) {
                return;
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            new MyDialog(this.myProject, this.myCorrectRoots).show();
        }
    }

    private static class MyContentComponent
    extends JPanel {
        private List<VirtualFile> myRoots;
        private int myCount;

        private MyContentComponent(LayoutManager layout, boolean isDoubleBuffered, int count) {
            super(layout, isDoubleBuffered);
            this.myCount = count;
        }

        private MyContentComponent(LayoutManager layout, int count) {
            super(layout);
            this.myCount = count;
        }

        private MyContentComponent(boolean isDoubleBuffered, int count) {
            super(isDoubleBuffered);
            this.myCount = count;
        }

        public int getCount() {
            return this.myCount;
        }

        private MyContentComponent(int count) {
            this.myCount = count;
        }

        public void setRoots(List<VirtualFile> roots) {
            this.myRoots = roots;
        }

        public List<VirtualFile> getRoots() {
            return this.myRoots;
        }
    }
}

