/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.ui.VcsStructureChooser;
import git4idea.history.wholeTree.BasePopupAction;
import git4idea.history.wholeTree.StructureFilterI;
import java.util.Collection;
import java.util.Map;

public class StructureFilterAction
extends BasePopupAction {
    public static final String ALL = "All";
    public static final String STRUCTURE = "Structure:";
    public static final String FILTER = "(filter)";
    private final DumbAwareAction myAll;
    private final DumbAwareAction mySelect;
    private final StructureFilterI myStructureFilterI;

    public StructureFilterAction(Project project, final StructureFilterI structureFilterI) {
        super(project, STRUCTURE, "Structure");
        this.myStructureFilterI = structureFilterI;
        this.myAll = new DumbAwareAction(ALL){

            public void actionPerformed(AnActionEvent e) {
                StructureFilterAction.this.myLabel.setText(StructureFilterAction.ALL);
                StructureFilterAction.this.myPanel.setToolTipText("Structure: All");
                structureFilterI.allSelected();
            }
        };
        this.mySelect = new DumbAwareAction("Select..."){

            public void actionPerformed(AnActionEvent e) {
                VcsStructureChooser vcsStructureChooser = new VcsStructureChooser(StructureFilterAction.this.myProject, "Select folders to filter by", structureFilterI.getSelected(), structureFilterI.getRoots());
                vcsStructureChooser.show();
                if (vcsStructureChooser.getExitCode() == 1) {
                    return;
                }
                Collection files = vcsStructureChooser.getSelectedFiles();
                Map modulesSet = vcsStructureChooser.getModulesSet();
                String text = StructureFilterAction.this.getText(files, modulesSet);
                String toolTip = StructureFilterAction.this.getTooltip(files, modulesSet);
                StructureFilterAction.this.myPanel.setToolTipText(StructureFilterAction.this.wrapTooltip(toolTip));
                StructureFilterAction.this.myLabel.setText(text);
                structureFilterI.select(files);
            }
        };
        this.myLabel.setText(ALL);
    }

    private String wrapTooltip(String toolTip) {
        return "<html><b>Structure:</b><br>" + toolTip + "</html>";
    }

    private String getTooltip(Collection<VirtualFile> files, Map<VirtualFile, String> modulesSet) {
        StringBuilder sb = new StringBuilder();
        for (VirtualFile file : files) {
            sb.append("<br><b>");
            String module = modulesSet.get(file);
            String name = module == null ? file.getName() : module;
            sb.append(name).append("</b> (").append(file.getPath()).append(")");
        }
        String toolTip = sb.toString();
        return toolTip;
    }

    private String getText(Collection<VirtualFile> files, Map<VirtualFile, String> modulesSet) {
        VirtualFile file;
        String module;
        String text = files.size() == 1 ? ((module = modulesSet.get(file = files.iterator().next())) == null ? file.getName() : module) : FILTER;
        text = text.length() > 20 ? FILTER : text;
        return text;
    }

    @Override
    protected void createActions(Consumer<AnAction> actionConsumer) {
        actionConsumer.consume((Object)this.myAll);
        actionConsumer.consume((Object)this.mySelect);
    }

    public void setPreset() {
        Collection<VirtualFile> selected = this.myStructureFilterI.getSelected();
        if (this.myStructureFilterI.isAllSelected()) {
            this.myLabel.setText(ALL);
            this.myPanel.setToolTipText("Structure: All");
        } else {
            VcsStructureChooser vcsStructureChooser = new VcsStructureChooser(this.myProject, "Select folders to filter by", this.myStructureFilterI.getSelected(), this.myStructureFilterI.getRoots());
            Map modulesSet = vcsStructureChooser.getModulesSet();
            String text = this.getText(selected, modulesSet);
            String toolTip = this.getTooltip(selected, modulesSet);
            this.myPanel.setToolTipText(this.wrapTooltip(toolTip));
            this.myLabel.setText(text);
            Disposer.dispose((Disposable)vcsStructureChooser.getDisposable());
        }
    }
}

