/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.Consumer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import git4idea.history.NewGitUsersComponent;
import git4idea.history.wholeTree.BasePopupAction;
import git4idea.history.wholeTree.UserFilterI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class UsersFilterAction
extends BasePopupAction {
    public static final String ALL = "All";
    public static final String USER = "User:";
    private final UserFilterI myUserFilterI;
    private final DumbAwareAction mySelectCurrent;
    private AnAction myAllAction;
    private AnAction mySelectMe;
    private AnAction mySelect;
    private String myCurrentText;
    private final NewGitUsersComponent myUsers;
    private EditorTextField myEditorField;
    private JBPopup myPopup;
    private ComponentPopupBuilder myComponentPopupBuilder;
    private AnAction mySelectOkAction;
    private TextFieldCompletionProvider myTextFieldCompletionProvider;
    private String myPreselectedUser;
    private DumbAwareAction myPresetUserAction;

    public UsersFilterAction(Project project, UserFilterI userFilterI) {
        super(project, USER, "User");
        this.myUserFilterI = userFilterI;
        this.myCurrentText = "";
        this.myUsers = NewGitUsersComponent.getInstance(this.myProject);
        this.myAllAction = new DumbAwareAction(ALL){

            public void actionPerformed(AnActionEvent e) {
                UsersFilterAction.this.myLabel.setText(UsersFilterAction.ALL);
                UsersFilterAction.this.myUserFilterI.allSelected();
                UsersFilterAction.this.myCurrentText = "";
                UsersFilterAction.this.myPanel.setToolTipText("User: All");
                UsersFilterAction.this.myPreselectedUser = null;
            }
        };
        this.mySelectMe = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                String meText = UsersFilterAction.this.getMeText();
                UsersFilterAction.this.myLabel.setText(meText);
                UsersFilterAction.this.myPanel.setToolTipText("User: " + meText);
                UsersFilterAction.this.myUserFilterI.meSelected();
                UsersFilterAction.this.myCurrentText = "";
                UsersFilterAction.this.myPreselectedUser = null;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setVisible(UsersFilterAction.this.myUserFilterI.isMeKnown());
                e.getPresentation().setText(UsersFilterAction.this.getMeText());
            }
        };
        this.mySelectCurrent = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                String user = UsersFilterAction.this.myUserFilterI.getUserIfOne();
                if (user != null) {
                    String newText = StringUtil.shortenTextWithEllipsis((String)user, (int)20, (int)0);
                    UsersFilterAction.this.myLabel.setText(newText);
                    UsersFilterAction.this.myPanel.setToolTipText("User: " + user);
                    UsersFilterAction.this.myUserFilterI.filter(user);
                    UsersFilterAction.this.myCurrentText = user;
                    UsersFilterAction.this.myPreselectedUser = null;
                }
            }

            public void update(AnActionEvent e) {
                String user = UsersFilterAction.this.myUserFilterI.getUserIfOne();
                boolean enabled = user != null && !user.equals(UsersFilterAction.this.myUserFilterI.getMe()) && !user.equals(UsersFilterAction.this.myCurrentText);
                e.getPresentation().setEnabledAndVisible(enabled);
                if (enabled) {
                    e.getPresentation().setText(StringUtil.shortenTextWithEllipsis((String)user, (int)20, (int)0));
                }
            }
        };
        this.myPresetUserAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                UsersFilterAction.this.myLabel.setText(UsersFilterAction.this.myPreselectedUser);
                UsersFilterAction.this.myPanel.setToolTipText("User: " + UsersFilterAction.this.myPreselectedUser);
                UsersFilterAction.this.myUserFilterI.filter(UsersFilterAction.this.myPreselectedUser);
                UsersFilterAction.this.myCurrentText = UsersFilterAction.this.myPreselectedUser;
                UsersFilterAction.this.myPreselectedUser = null;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setVisible(!StringUtil.isEmptyOrSpaces((String)UsersFilterAction.this.myPreselectedUser) && !Comparing.equal((String)UsersFilterAction.this.myPreselectedUser, (String)UsersFilterAction.this.myUserFilterI.getMe()));
                e.getPresentation().setText(UsersFilterAction.this.myPreselectedUser);
            }
        };
        this.createPopup(project);
        this.mySelect = new DumbAwareAction("Select.."){

            public void actionPerformed(AnActionEvent e) {
                if (UsersFilterAction.this.myPopup != null) {
                    UsersFilterAction.this.mySelectOkAction.unregisterCustomShortcutSet(UsersFilterAction.this.myPopup.getContent());
                }
                UsersFilterAction.this.myComponentPopupBuilder.setMayBeParent(true);
                UsersFilterAction.this.myPopup = UsersFilterAction.this.myComponentPopupBuilder.createPopup();
                UsersFilterAction.this.myTextFieldCompletionProvider.apply(UsersFilterAction.this.myEditorField);
                UsersFilterAction.this.myEditorField.setText(UsersFilterAction.this.myCurrentText);
                JComponent content = UsersFilterAction.this.myPopup.getContent();
                UsersFilterAction.this.mySelectOkAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, content);
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, UsersFilterAction.this.myLabel);
                UsersFilterAction.this.myPopup.setMinimumSize(new Dimension(200, 90));
                UsersFilterAction.this.myPopup.showInScreenCoordinates((Component)UsersFilterAction.this.myLabel, point);
                UsersFilterAction.this.myPreselectedUser = null;
            }
        };
        this.myLabel.setText(ALL);
    }

    private void createPopup(Project project) {
        JPanel panel = new JPanel(new BorderLayout());
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project, EditorTextFieldProvider.class);
        HashSet<Object> features = new HashSet<Object>();
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(SpellCheckingEditorCustomization.DISABLED);
        this.myEditorField = service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        this.myEditorField.setBorder((Border)new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.myEditorField.getBorder()));
        this.myEditorField.setText("s");
        this.myEditorField.setText(this.myCurrentText);
        this.myEditorField.setOneLineMode(false);
        panel.add((Component)this.myEditorField, "Center");
        this.myTextFieldCompletionProvider = new TextFieldCompletionProviderDumbAware(true){

            @NotNull
            protected String getPrefix(@NotNull String currentTextPrefix) {
                if (currentTextPrefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "git4idea/history/wholeTree/UsersFilterAction$6", "getPrefix"));
                }
                int text = currentTextPrefix.lastIndexOf(44);
                String string = text == -1 ? currentTextPrefix : currentTextPrefix.substring(text + 1).trim();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/UsersFilterAction$6", "getPrefix"));
                }
                return string;
            }

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "git4idea/history/wholeTree/UsersFilterAction$6", "addCompletionVariants"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "git4idea/history/wholeTree/UsersFilterAction$6", "addCompletionVariants"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/history/wholeTree/UsersFilterAction$6", "addCompletionVariants"));
                }
                List<String> list = UsersFilterAction.this.myUsers.get();
                if (list != null) {
                    for (String completionVariant : list) {
                        LookupElementBuilder element = LookupElementBuilder.create((String)completionVariant);
                        result.addElement((LookupElement)element.withLookupString(completionVariant.toLowerCase()));
                    }
                }
            }
        };
        this.myComponentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)this.myEditorField).setCancelOnClickOutside(true).setAdText(KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setTitle("Specify user names, comma separated").setMovable(true).setRequestFocus(true).setResizable(true);
        this.mySelectOkAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                UsersFilterAction.this.myPopup.closeOk(e.getInputEvent());
                String newText = UsersFilterAction.this.myEditorField.getText();
                if (Comparing.equal((String)newText.trim(), (String)UsersFilterAction.this.myCurrentText.trim())) {
                    return;
                }
                UsersFilterAction.this.myCurrentText = newText;
                UsersFilterAction.this.setText(UsersFilterAction.this.myCurrentText.trim());
                UsersFilterAction.this.myPanel.setToolTipText("User: " + UsersFilterAction.this.myCurrentText);
                UsersFilterAction.this.myUserFilterI.filter(UsersFilterAction.this.myCurrentText);
            }
        };
    }

    private void setText(String text) {
        String[] pieces = text.split(",");
        if (pieces.length == 0) {
            this.myLabel.setText(ALL);
        } else if (pieces.length == 1) {
            this.myLabel.setText(StringUtil.shortenTextWithEllipsis((String)pieces[0].trim(), (int)20, (int)0));
        } else {
            this.myLabel.setText(StringUtil.shortenTextWithEllipsis((String)pieces[0].trim(), (int)20, (int)0) + "+");
        }
    }

    public void setSelectedPresets(String selected, boolean meSelected) {
        String string = this.myCurrentText = selected == null ? "" : selected;
        if (selected == null) {
            this.myLabel.setText(ALL);
        } else if (meSelected) {
            this.myLabel.setText(this.getMeText(selected));
            this.myPanel.setToolTipText("User: " + selected);
        } else {
            this.setText(selected);
            this.myPanel.setToolTipText("User: " + selected);
        }
    }

    private String getMeText() {
        return this.getMeText(this.myUserFilterI.getMe());
    }

    private String getMeText(String name) {
        return "me ( " + StringUtil.shortenTextWithEllipsis((String)name, (int)20, (int)0) + " )";
    }

    @Override
    protected void createActions(Consumer<AnAction> actionConsumer) {
        actionConsumer.consume((Object)this.myPresetUserAction);
        actionConsumer.consume((Object)this.myAllAction);
        actionConsumer.consume((Object)this.mySelectMe);
        actionConsumer.consume((Object)this.mySelect);
        actionConsumer.consume((Object)this.mySelectCurrent);
    }

    public void setPreselectedUser(String preselectedUser) {
        this.myPreselectedUser = StringUtil.shortenTextWithEllipsis((String)preselectedUser, (int)20, (int)0);
    }
}

