/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import git4idea.history.wholeTree.WireEventI;
import org.jetbrains.annotations.Nullable;

public class WireEvent
implements WireEventI {
    private final int myCommitIdx;
    @Nullable
    private int[] myCommitsEnds;
    @Nullable
    private int[] myWireEnds;
    private int[] myFutureWireStarts;
    private int[] myCommitsStarts;

    public WireEvent(int commitIdx, int[] commitsEnds) {
        this.myCommitIdx = commitIdx;
        this.myCommitsEnds = commitsEnds;
        this.myCommitsStarts = ArrayUtil.EMPTY_INT_ARRAY;
        this.myWireEnds = null;
        this.myFutureWireStarts = ArrayUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public int getCommitIdx() {
        return this.myCommitIdx;
    }

    public void addStart(int idx, int wireNumber) {
        assert (this.myFutureWireStarts.length > 0 || idx == -1);
        this.myCommitsStarts = ArrayUtil.append((int[])this.myCommitsStarts, (int)idx);
        if (idx != -1) {
            if (this.myFutureWireStarts.length == 1) {
                assert (this.myFutureWireStarts[0] == wireNumber);
                this.myFutureWireStarts = ArrayUtil.EMPTY_INT_ARRAY;
            } else {
                int[] newArr = new int[this.myFutureWireStarts.length - 1];
                int j = 0;
                for (int i = 0; i < this.myFutureWireStarts.length; ++i) {
                    int futureWireStart = this.myFutureWireStarts[i];
                    if (futureWireStart == wireNumber) continue;
                    newArr[j] = futureWireStart;
                    ++j;
                }
                this.myFutureWireStarts = newArr;
            }
        }
    }

    @Override
    public int getWaitStartsNumber() {
        return this.myFutureWireStarts.length;
    }

    @Override
    public int[] getFutureWireStarts() {
        return this.myFutureWireStarts;
    }

    public void setWaitStartsNumber(Integer[] waitStarts) {
        this.myFutureWireStarts = new int[waitStarts.length];
        for (int i = 0; i < waitStarts.length; ++i) {
            Integer waitStart = waitStarts[i];
            this.myFutureWireStarts[i] = waitStart;
        }
    }

    public void addWireEnd(int idx) {
        this.myWireEnds = this.myWireEnds == null ? new int[]{idx} : ArrayUtil.append((int[])this.myWireEnds, (int)idx);
    }

    public void setWireEnds(@Nullable int[] wireEnds) {
        this.myWireEnds = wireEnds;
    }

    @Override
    @Nullable
    public int[] getWireEnds() {
        return this.myWireEnds;
    }

    public void setCommitEnds(int[] ends) {
        this.myCommitsEnds = ends;
    }

    @Override
    @Nullable
    public int[] getCommitsEnds() {
        return this.myCommitsEnds;
    }

    @Override
    public int[] getCommitsStarts() {
        return this.myCommitsStarts;
    }

    @Override
    public boolean isEnd() {
        return this.myCommitsStarts.length == 1 && this.myCommitsStarts[0] == -1;
    }

    @Override
    public boolean isStart() {
        return this.myCommitsEnds != null && this.myCommitsEnds.length == 1 && this.myCommitsEnds[0] == -1;
    }

    public String toString() {
        return "WireEvent{myCommitIdx=" + this.myCommitIdx + ", myCommitsEnds=" + (this.myCommitsEnds == null ? "null" : StringUtil.join((int[])this.myCommitsEnds, (String)", ")) + ", myWireEnds=" + (this.myWireEnds == null ? "null" : StringUtil.join((int[])this.myWireEnds, (String)", ")) + ", myCommitsStarts=" + (this.myCommitsStarts == null ? "null" : StringUtil.join((int[])this.myCommitsStarts, (String)", ")) + '}';
    }
}

