/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEnvironmentForm
implements PanelWithAnchor {
    private JPanel panel;
    private LabeledComponent<TextFieldWithBrowseButton> mavenHomeComponent;
    private LabeledComponent<TextFieldWithBrowseButton> settingsFileComponent;
    private LabeledComponent<TextFieldWithBrowseButton> localRepositoryComponent;
    private JCheckBox mavenHomeOverrideCheckBox;
    private JCheckBox settingsOverrideCheckBox;
    private JCheckBox localRepositoryOverrideCheckBox;
    private JBLabel myFakeLabel;
    private JComponent anchor;
    private final PathOverrider mavenHomeOverrider;
    private final PathOverrider userSettingsFileOverrider;
    private final PathOverrider localRepositoryOverrider;
    private boolean isUpdating = false;
    private final Alarm myUpdateAlarm;

    public MavenEnvironmentForm() {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MavenEnvironmentForm.this.isUpdating) {
                            return;
                        }
                        if (!MavenEnvironmentForm.this.panel.isShowing()) {
                            return;
                        }
                        MavenEnvironmentForm.this.myUpdateAlarm.cancelAllRequests();
                        MavenEnvironmentForm.this.myUpdateAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                MavenEnvironmentForm.this.isUpdating = true;
                                MavenEnvironmentForm.this.mavenHomeOverrider.updateDefault();
                                MavenEnvironmentForm.this.userSettingsFileOverrider.updateDefault();
                                MavenEnvironmentForm.this.localRepositoryOverrider.updateDefault();
                                MavenEnvironmentForm.this.isUpdating = false;
                            }
                        }, 100);
                    }
                });
            }
        };
        this.mavenHomeOverrider = new PathOverrider(this.mavenHomeComponent, this.mavenHomeOverrideCheckBox, (DocumentListener)listener, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveMavenHomeDirectory("");
            }
        });
        this.userSettingsFileOverrider = new PathOverrider(this.settingsFileComponent, this.settingsOverrideCheckBox, (DocumentListener)listener, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveUserSettingsFile("");
            }
        });
        this.localRepositoryOverrider = new PathOverrider(this.localRepositoryComponent, this.localRepositoryOverrideCheckBox, (DocumentListener)listener, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveLocalRepository("", ((TextFieldWithBrowseButton)MavenEnvironmentForm.this.mavenHomeComponent.getComponent()).getText(), ((TextFieldWithBrowseButton)MavenEnvironmentForm.this.settingsFileComponent.getComponent()).getText());
            }
        });
        this.setAnchor((JComponent)this.mavenHomeComponent.getLabel());
    }

    public boolean isModified(MavenGeneralSettings data) {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(data);
    }

    public void setData(MavenGeneralSettings data) {
        data.setMavenHome(this.mavenHomeOverrider.getResult());
        data.setUserSettingsFile(this.userSettingsFileOverrider.getResult());
        data.setLocalRepository(this.localRepositoryOverrider.getResult());
    }

    public void getData(MavenGeneralSettings data) {
        this.mavenHomeOverrider.reset(data.getMavenHome());
        this.userSettingsFileOverrider.reset(data.getUserSettingsFile());
        this.localRepositoryOverrider.reset(data.getLocalRepository());
    }

    @NotNull
    public String getMavenHome() {
        String string = this.mavenHomeOverrider.getResult();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenEnvironmentForm", "getMavenHome"));
        }
        return string;
    }

    public JComponent createComponent() {
        ((TextFieldWithBrowseButton)this.mavenHomeComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.home.directory", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ((TextFieldWithBrowseButton)this.settingsFileComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.settings.file", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ((TextFieldWithBrowseButton)this.localRepositoryComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.local.repository", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return this.panel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mavenHomeComponent.setAnchor(anchor);
        this.settingsFileComponent.setAnchor(anchor);
        this.localRepositoryComponent.setAnchor(anchor);
        this.myFakeLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox2;
        LabeledComponent labeledComponent2;
        JCheckBox jCheckBox3;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.settingsFileComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setText("User &settings file");
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.settingsOverrideCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Override");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.localRepositoryComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setText("Local &repository");
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.localRepositoryOverrideCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Override");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mavenHomeComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setText("Maven &home directory");
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("M2_HOME is used by default");
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 9, 0, 4, 0, null, null, null));
        this.mavenHomeOverrideCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Override");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFakeLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class PathOverrider {
        private final TextFieldWithBrowseButton component;
        private final JCheckBox checkBox;
        private final PathProvider pathProvider;
        private Boolean isOverridden;
        private String overrideText;

        public PathOverrider(LabeledComponent<TextFieldWithBrowseButton> component, JCheckBox checkBox, DocumentListener docListener, PathProvider pathProvider) {
            this.component = (TextFieldWithBrowseButton)component.getComponent();
            this.component.getTextField().getDocument().addDocumentListener(docListener);
            this.checkBox = checkBox;
            this.pathProvider = pathProvider;
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathOverrider.this.update();
                }
            });
        }

        private void update() {
            boolean override = this.checkBox.isSelected();
            if (Comparing.equal((Object)this.isOverridden, (Object)override)) {
                return;
            }
            this.isOverridden = override;
            this.component.setEditable(override);
            this.component.setEnabled(override && this.checkBox.isEnabled());
            if (override) {
                if (this.overrideText != null) {
                    this.component.setText(this.overrideText);
                }
            } else {
                if (!StringUtil.isEmptyOrSpaces((String)this.component.getText())) {
                    this.overrideText = this.component.getText();
                }
                this.component.setText(this.pathProvider.getPath());
            }
        }

        private void updateDefault() {
            if (!this.checkBox.isSelected()) {
                this.component.setText(this.pathProvider.getPath());
            }
        }

        public void reset(String text) {
            this.isOverridden = null;
            this.checkBox.setSelected(!StringUtil.isEmptyOrSpaces((String)text));
            this.overrideText = StringUtil.isEmptyOrSpaces((String)text) ? null : text;
            this.update();
        }

        public String getResult() {
            return this.checkBox.isSelected() ? this.component.getText().trim() : "";
        }
    }

    private static abstract class PathProvider {
        private PathProvider() {
        }

        public String getPath() {
            File file = this.getFile();
            return file == null ? "" : file.getPath();
        }

        @Nullable
        protected abstract File getFile();
    }
}

