/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenIndexerWrapper
extends RemoteObjectWrapper<MavenServerIndexer> {
    private final TIntObjectHashMap<IndexData> myDataMap = new TIntObjectHashMap();

    public MavenIndexerWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    @Override
    protected synchronized void onError() {
        super.onError();
        for (int each : this.myDataMap.keys()) {
            ((IndexData)this.myDataMap.get(each)).remoteId = -1;
        }
    }

    public synchronized int createIndex(@NotNull String indexId, @NotNull String repositoryId, @Nullable File file, @Nullable String url, @NotNull File indexDir) throws MavenServerIndexerException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "org/jetbrains/idea/maven/server/MavenIndexerWrapper", "createIndex"));
        }
        if (repositoryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryId", "org/jetbrains/idea/maven/server/MavenIndexerWrapper", "createIndex"));
        }
        if (indexDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexDir", "org/jetbrains/idea/maven/server/MavenIndexerWrapper", "createIndex"));
        }
        IndexData data = new IndexData(indexId, repositoryId, file, url, indexDir);
        final int localId = System.identityHashCode(data);
        this.myDataMap.put(localId, (Object)data);
        this.perform(new RemoteObjectWrapper.IndexRetriable<Object>(){

            @Override
            public Object execute() throws RemoteException, MavenServerIndexerException {
                return MavenIndexerWrapper.this.getRemoteId(localId);
            }
        });
        return localId;
    }

    public synchronized void releaseIndex(int localId) throws MavenServerIndexerException {
        IndexData data = (IndexData)this.myDataMap.remove(localId);
        if (data == null) {
            MavenLog.LOG.warn("index " + localId + " not found");
            return;
        }
        if (data.remoteId == -1) {
            return;
        }
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(data.remoteId);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public int getIndexCount() {
        return this.perform(new RemoteObjectWrapper.Retriable<Integer>(){

            @Override
            public Integer execute() throws RemoteException {
                return ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).getIndexCount();
            }
        });
    }

    public void updateIndex(final int localId, final MavenGeneralSettings settings, final MavenProgressIndicator indicator) throws MavenProcessCanceledException, MavenServerIndexerException {
        this.perform(new RemoteObjectWrapper.IndexRetriableCancelable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws RemoteException, MavenServerIndexerException, MavenServerProcessCanceledException {
                MavenServerProgressIndicator indicatorWrapper = MavenServerManager.wrapAndExport(indicator);
                try {
                    ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).updateIndex(MavenIndexerWrapper.this.getRemoteId(localId), MavenServerManager.convertSettings(settings), indicatorWrapper);
                }
                finally {
                    UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
                }
                return null;
            }
        });
    }

    public void processArtifacts(final int indexId, final MavenIndicesProcessor processor) throws MavenServerIndexerException {
        this.perform(new RemoteObjectWrapper.IndexRetriable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws RemoteException, MavenServerIndexerException {
                MavenServerIndicesProcessor processorWrapper = MavenServerManager.wrapAndExport(processor);
                try {
                    ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).processArtifacts(MavenIndexerWrapper.this.getRemoteId(indexId), processorWrapper);
                }
                finally {
                    UnicastRemoteObject.unexportObject((Remote)processorWrapper, true);
                }
                return null;
            }
        });
    }

    public MavenId addArtifact(final int localId, final File artifactFile) throws MavenServerIndexerException {
        return this.perform(new RemoteObjectWrapper.IndexRetriable<MavenId>(){

            @Override
            public MavenId execute() throws RemoteException, MavenServerIndexerException {
                return ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).addArtifact(MavenIndexerWrapper.this.getRemoteId(localId), artifactFile);
            }
        });
    }

    public Set<MavenArtifactInfo> search(final int localId, final Query query, final int maxResult) throws MavenServerIndexerException {
        return this.perform(new RemoteObjectWrapper.IndexRetriable<Set<MavenArtifactInfo>>(){

            @Override
            public Set<MavenArtifactInfo> execute() throws RemoteException, MavenServerIndexerException {
                return ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).search(MavenIndexerWrapper.this.getRemoteId(localId), query, maxResult);
            }
        });
    }

    private synchronized int getRemoteId(int localId) throws RemoteException, MavenServerIndexerException {
        IndexData result = (IndexData)this.myDataMap.get(localId);
        MavenLog.LOG.assertTrue(result != null, (Object)("index " + localId + " not found"));
        if (result.remoteId == -1) {
            result.remoteId = ((MavenServerIndexer)this.getOrCreateWrappee()).createIndex(result.indexId, result.repositoryId, result.file, result.url, result.indexDir);
        }
        return result.remoteId;
    }

    public Collection<MavenArchetype> getArchetypes() {
        return this.perform(new RemoteObjectWrapper.Retriable<Collection<MavenArchetype>>(){

            @Override
            public Collection<MavenArchetype> execute() throws RemoteException {
                return ((MavenServerIndexer)MavenIndexerWrapper.this.getOrCreateWrappee()).getArchetypes();
            }
        });
    }

    public void releaseInTests() {
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private static class IndexData {
        private int remoteId = -1;
        @NotNull
        private final String indexId;
        @NotNull
        private final String repositoryId;
        @Nullable
        private final File file;
        @Nullable
        private final String url;
        @NotNull
        private final File indexDir;

        public IndexData(String indexId, String repositoryId, File file, String url, File indexDir) {
            this.indexId = indexId;
            this.repositoryId = repositoryId;
            this.file = file;
            this.url = url;
            this.indexDir = indexDir;
        }
    }
}

