/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.aapt;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.util.text.StringSearcher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ReadOnlyDocument {
    @NotNull
    private final String myContents;
    @NotNull
    private final List<Integer> myOffsets;
    private File myFile;
    private long myLastModified;

    ReadOnlyDocument(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/output/parser/aapt/ReadOnlyDocument", "<init>"));
        }
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        if (xml.startsWith("\ufeff")) {
            xml = xml.substring(1);
        }
        this.myContents = xml;
        this.myFile = file;
        this.myLastModified = file.lastModified();
        this.myOffsets = Lists.newArrayListWithExpectedSize((int)(this.myContents.length() / 30));
        this.myOffsets.add(0);
        for (int i = 0; i < this.myContents.length(); ++i) {
            char c = this.myContents.charAt(i);
            if (c != '\n') continue;
            this.myOffsets.add(i + 1);
        }
    }

    public boolean isStale() {
        long now = this.myFile.lastModified();
        return now == 0L || this.myLastModified < now;
    }

    int lineOffset(int lineNumber) {
        int index = lineNumber - 1;
        if (index < 0 || index >= this.myOffsets.size()) {
            return -1;
        }
        return this.myOffsets.get(index);
    }

    int lineNumber(int offset) {
        for (int i = 0; i < this.myOffsets.size(); ++i) {
            int savedOffset = this.myOffsets.get(i);
            if (offset > savedOffset) continue;
            return i;
        }
        return -1;
    }

    int findText(String text, int offset) {
        StringSearcher searcher = new StringSearcher(text, true, true);
        return searcher.scan((CharSequence)this.myContents, offset, this.myContents.length());
    }

    int findTextBackwards(String text, int offset) {
        StringSearcher searcher = new StringSearcher(text, true, false);
        return searcher.scan((CharSequence)this.myContents, 0, offset);
    }

    char charAt(int offset) {
        return this.myContents.charAt(offset);
    }

    String subsequence(int start, int end) {
        return this.myContents.substring(start, end == -1 ? this.myContents.length() : end);
    }

    String getContents() {
        return this.myContents;
    }

    int length() {
        return this.myContents.length();
    }
}

