/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class UrlExternalResource
extends AbstractExternalResource {
    private final URL url;
    private final URLConnection connection;
    private final DefaultExternalResourceMetaData metaData;

    public UrlExternalResource(URL url) throws IOException {
        URI uri;
        this.url = url;
        this.connection = url.openConnection();
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.metaData = new DefaultExternalResourceMetaData(uri, this.connection.getLastModified(), (long)this.connection.getContentLength(), null, null);
    }

    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public boolean isLocal() {
        return this.url.getProtocol().equalsIgnoreCase("file");
    }

    public long getContentLength() {
        return this.connection.getContentLength();
    }

    public long getLastModified() {
        return this.connection.getLastModified();
    }

    public InputStream openStream() throws IOException {
        return this.connection.getInputStream();
    }
}

