/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.JavaCodeStyleMainPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, originalSettings, "Java"){

            @Override
            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new JavaCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.java";
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JavaCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return codeStyleAbstractConfigurable;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isIdeaUltimate() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public String getConfigurableDisplayName() {
        return "Java";
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new JavaCodeStyleSettings(settings);
    }
}

